/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.swing;

import gov.noaa.pmel.swing.JStretchPanel;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;

public abstract class Rubberband {
    public static boolean rubberbandIsActive = false;
    protected Point anchorPt = new Point(0, 0);
    protected Point stretchedPt = new Point(0, 0);
    protected Point lastPt = new Point(0, 0);
    protected Point endPt = new Point(0, 0);
    protected Component component;
    protected boolean firstStretch = true;
    protected boolean active = false;
    protected boolean constrainVertical = false;

    public abstract void drawLast(Graphics var1);

    public abstract void drawNext(Graphics var1);

    public Rubberband() {
    }

    public Rubberband(Component c) {
        this.setComponent(c);
    }

    public void setActive(boolean b) {
        this.active = b;
    }

    public void setConstrainVertical(boolean b) {
        this.constrainVertical = b;
    }

    public void setComponent(Component c) {
        this.component = c;
        this.component.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent event) {
                if (Rubberband.this.isActive()) {
                    Rubberband.this.anchor(event.getPoint());
                }
            }

            @Override
            public void mouseClicked(MouseEvent event) {
                if (Rubberband.this.isActive()) {
                    Rubberband.this.end(event.getPoint());
                    rubberbandIsActive = false;
                }
            }

            @Override
            public void mouseReleased(MouseEvent event) {
                if (Rubberband.this.isActive()) {
                    Rubberband.this.end(event.getPoint());
                    rubberbandIsActive = false;
                }
            }
        });
        this.component.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent event) {
                if (Rubberband.this.isActive()) {
                    Rubberband.this.stretch(event.getPoint());
                }
            }
        });
    }

    public boolean isActive() {
        return this.active;
    }

    public Point getAnchor() {
        return this.anchorPt;
    }

    public Point getStretched() {
        return this.stretchedPt;
    }

    public Point getLast() {
        return this.lastPt;
    }

    public Point getEnd() {
        return this.endPt;
    }

    public void anchor(Point p) {
        int left = ((JStretchPanel)this.component).getMinX();
        int right = ((JStretchPanel)this.component).getMaxX();
        int top = ((JStretchPanel)this.component).getMinY();
        int bottom = ((JStretchPanel)this.component).getMaxY();
        this.anchorPt.x = p.x < left ? left + 1 : (p.x > right ? right - 1 : p.x);
        this.anchorPt.y = p.y < top ? top + 1 : (p.y > bottom ? bottom - 1 : p.y);
        this.firstStretch = true;
        this.stretchedPt.x = this.lastPt.x = this.anchorPt.x;
        this.stretchedPt.y = this.lastPt.y = this.anchorPt.y;
    }

    public void stretch(Point p) {
        Graphics g;
        int left = ((JStretchPanel)this.component).getMinX();
        int right = ((JStretchPanel)this.component).getMaxX();
        int top = ((JStretchPanel)this.component).getMinY();
        int bottom = ((JStretchPanel)this.component).getMaxY();
        this.lastPt.x = this.stretchedPt.x;
        this.lastPt.y = this.stretchedPt.y;
        this.stretchedPt.x = p.x < left ? left + 1 : (p.x > right ? right - 1 : p.x);
        this.stretchedPt.y = p.y < top ? top + 1 : (p.y > bottom ? bottom - 1 : p.y);
        if (this.constrainVertical) {
            this.stretchedPt.x = this.anchorPt.x;
        }
        if ((g = this.component.getGraphics()) != null) {
            if (this.firstStretch) {
                this.firstStretch = false;
            } else {
                this.drawLast(g);
            }
            this.drawNext(g);
            g.dispose();
        }
    }

    public void end(Point p) {
        Graphics g;
        int left = ((JStretchPanel)this.component).getMinX();
        int right = ((JStretchPanel)this.component).getMaxX();
        int top = ((JStretchPanel)this.component).getMinY();
        int bottom = ((JStretchPanel)this.component).getMaxY();
        this.lastPt.x = p.x < left ? (this.endPt.x = left + 1) : (p.x > right ? (this.endPt.x = right - 1) : (this.endPt.x = p.x));
        this.lastPt.y = p.y < top ? (this.endPt.y = top + 1) : (p.y > bottom ? (this.endPt.y = bottom - 1) : (this.endPt.y = p.y));
        if (this.constrainVertical) {
            this.lastPt.x = this.endPt.x = this.anchorPt.x;
        }
        if ((g = this.component.getGraphics()) != null) {
            this.drawLast(g);
            g.dispose();
        }
    }

    public Rectangle getBounds() {
        return new Rectangle(this.stretchedPt.x < this.anchorPt.x ? this.stretchedPt.x : this.anchorPt.x, this.stretchedPt.y < this.anchorPt.y ? this.stretchedPt.y : this.anchorPt.y, Math.abs(this.stretchedPt.x - this.anchorPt.x), Math.abs(this.stretchedPt.y - this.anchorPt.y));
    }

    public Rectangle lastBounds() {
        return new Rectangle(this.lastPt.x < this.anchorPt.x ? this.lastPt.x : this.anchorPt.x, this.lastPt.y < this.anchorPt.y ? this.lastPt.y : this.anchorPt.y, Math.abs(this.lastPt.x - this.anchorPt.x), Math.abs(this.lastPt.y - this.anchorPt.y));
    }

    public boolean splineActive() {
        return false;
    }

    public void reset() {
        this.stretchedPt.x = -1;
        this.stretchedPt.y = -1;
    }

    public abstract int getUpperLeftX();

    public abstract int getUpperLeftY();

    public abstract int getLowerRightX();

    public abstract int getLowerRightY();

    public abstract int getLowerLeftX();

    public abstract int getLowerLeftY();

    public abstract int getUpperRightX();

    public abstract int getUpperRightY();

    public abstract void resetRect();

    public abstract boolean isPoint();
}

