/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.swing;

import gov.noaa.pmel.swing.JStretchPanel;
import gov.noaa.pmel.swing.Rubberband;
import gov.noaa.pmel.swing.RubberbandRenderer;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.GeneralPath;

public class SectionSpline
extends Rubberband {
    boolean mIstarted = false;
    int mStartWidth;
    GeneralPath aShape = new GeneralPath();

    public void drawSpline(int x, int y, int x2, int y2) {
        float dx = x - x2;
        float dy = y - y2;
        int width = ((JStretchPanel)this.component).ComputeSectionPixelWidth(this.lastPt);
        if (dx == 0.0f && dy == 0.0f) {
            return;
        }
        float dist = (float)Math.pow(dx * dx + dy * dy, 0.5);
        float p1x = (float)x + (float)this.mStartWidth * (-dy / dist);
        float p1y = (float)y + (float)this.mStartWidth * (dx / dist);
        float p2x = (float)x - (float)this.mStartWidth * (-dy / dist);
        float p2y = (float)y - (float)this.mStartWidth * (dx / dist);
        float p3x = (float)x2 + (float)width * (-dy / dist);
        float p3y = (float)y2 + (float)width * (dx / dist);
        float p4x = (float)x2 - (float)width * (-dy / dist);
        float p4y = (float)y2 - (float)width * (dx / dist);
        this.aShape.reset();
        this.aShape.moveTo(p1x, p1y);
        this.aShape.lineTo(p2x, p2y);
        this.aShape.lineTo(p4x, p4y);
        this.aShape.lineTo(p3x, p3y);
        this.aShape.lineTo(p1x, p1y);
        this.aShape.moveTo(x, y);
        this.aShape.lineTo(x2, y2);
        ((RubberbandRenderer)((Object)this.component)).setRubberbandDisplayObject(this.aShape, false);
    }

    @Override
    public void drawLast(Graphics g) {
        this.drawSpline(this.anchorPt.x, this.anchorPt.y, this.lastPt.x, this.lastPt.y);
    }

    @Override
    public void drawNext(Graphics g) {
        this.drawSpline(this.anchorPt.x, this.anchorPt.y, this.stretchedPt.x, this.stretchedPt.y);
    }

    public SectionSpline() {
    }

    public SectionSpline(Component c) {
        this.setComponent(c);
    }

    @Override
    public void setComponent(Component c) {
        this.component = c;
        this.component.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                if (SectionSpline.this.isActive()) {
                    SectionSpline.this.anchor(me.getPoint());
                    SectionSpline.this.mStartWidth = ((JStretchPanel)SectionSpline.this.component).ComputeSectionPixelWidth(SectionSpline.this.anchorPt);
                    if (!SectionSpline.this.mIstarted) {
                        ((RubberbandRenderer)((Object)SectionSpline.this.component)).getSplinePoints().removeAllElements();
                        ((RubberbandRenderer)((Object)SectionSpline.this.component)).getSplinePoints().addElement(new Point(SectionSpline.this.anchorPt));
                        SectionSpline.this.mIstarted = true;
                    } else {
                        if (me.getClickCount() == 2 && SectionSpline.this.mIstarted) {
                            ((JStretchPanel)SectionSpline.this.component).addSplinePoint(new Point(SectionSpline.this.anchorPt));
                            SectionSpline.this.mIstarted = false;
                            me.consume();
                            ((JStretchPanel)SectionSpline.this.component).processSectionSpline(me.isShiftDown());
                        } else {
                            ((RubberbandRenderer)((Object)SectionSpline.this.component)).addSplinePoint(new Point(SectionSpline.this.anchorPt));
                            ((RubberbandRenderer)((Object)SectionSpline.this.component)).setRubberbandDisplayObject(null, false);
                        }
                        SectionSpline.this.end(me.getPoint());
                    }
                }
            }
        });
        this.component.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent event) {
                if (SectionSpline.this.isActive() && SectionSpline.this.mIstarted) {
                    SectionSpline.this.stretch(event.getPoint());
                }
            }
        });
    }

    @Override
    public boolean splineActive() {
        return this.mIstarted;
    }

    @Override
    public int getUpperLeftX() {
        Rectangle newBounds = this.lastBounds();
        return newBounds.x;
    }

    @Override
    public int getLowerRightX() {
        Rectangle newBounds = this.lastBounds();
        return newBounds.x + newBounds.width;
    }

    @Override
    public int getUpperLeftY() {
        Rectangle newBounds = this.lastBounds();
        return newBounds.y;
    }

    @Override
    public int getLowerRightY() {
        Rectangle newBounds = this.lastBounds();
        return newBounds.y + newBounds.height;
    }

    @Override
    public int getUpperRightX() {
        return -99;
    }

    @Override
    public int getUpperRightY() {
        return -99;
    }

    @Override
    public int getLowerLeftX() {
        return -99;
    }

    @Override
    public int getLowerLeftY() {
        return -99;
    }

    @Override
    public void resetRect() {
    }

    @Override
    public boolean isPoint() {
        return false;
    }
}

