/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.swing;

import gov.noaa.pmel.swing.DragHandle;
import java.awt.Graphics;
import java.awt.Point;

public class SelectionRegion {
    public static int selOffset = 0;
    public DragHandle mXAxisLeft;
    public DragHandle mXAxisCtr;
    public DragHandle mXAxisRight;
    public DragHandle mYAxisUpper;
    public DragHandle mYAxisCtr;
    public DragHandle mYAxisLower;
    protected Graphics mStoredGraphics;
    protected int mSelHMin;
    protected int mSelHMax;
    protected int mSelHCtr;
    protected int mSelVMin;
    protected int mSelVMax;
    protected int mSelVCtr;
    protected int mXAxisOrig;
    protected int mXAxisLen;
    protected int mYAxisOrig;
    protected int mYAxisLen;
    protected int mLeftLimit;
    protected int mRightLimit;
    protected int mUpperLimit;
    protected int mLowerLimit;
    protected double mSelHMinVal;
    protected double mSelHMaxVal;
    protected double mSelHCtrVal;
    protected double mSelVMinVal;
    protected double mSelVMaxVal;
    protected double mSelVCtrVal;
    protected boolean xLowerOutOfRange = false;
    protected boolean xUpperOutOfRange = false;
    protected boolean yLowerOutOfRange = false;
    protected boolean yUpperOutOfRange = false;

    public SelectionRegion(DragHandle xAxisLeft, DragHandle xAxisCtr, DragHandle xAxisRight, DragHandle yAxisUpper, DragHandle yAxisCtr, DragHandle yAxisLower) {
        this.mXAxisLeft = xAxisLeft;
        this.mXAxisCtr = xAxisCtr;
        this.mXAxisRight = xAxisRight;
        this.mYAxisUpper = yAxisUpper;
        this.mYAxisCtr = yAxisCtr;
        this.mYAxisLower = yAxisLower;
        selOffset = 0;
        this.resetRgnBounds();
    }

    public void resetRgnBounds() {
        if (this.mXAxisLeft == null) {
            return;
        }
        Point aPos = this.mXAxisLeft.getCurrLocation();
        int newHMin = aPos.x;
        aPos = this.mXAxisRight.getCurrLocation();
        int newHMax = aPos.x;
        aPos = this.mYAxisUpper.getCurrLocation();
        int newVMin = aPos.y;
        aPos = this.mYAxisLower.getCurrLocation();
        int newVMax = aPos.y;
        aPos = this.mXAxisCtr.getCurrLocation();
        int newHCtr = aPos.x;
        aPos = this.mYAxisCtr.getCurrLocation();
        int newVCtr = aPos.y;
        this.mSelHMinVal = this.mXAxisLeft.getValue();
        this.mSelHMaxVal = this.mXAxisRight.getValue();
        this.mSelHCtrVal = this.mXAxisCtr.getValue();
        this.mSelVMaxVal = this.mYAxisUpper.getValue();
        this.mSelVMinVal = this.mYAxisLower.getValue();
        this.mSelVCtrVal = this.mYAxisCtr.getValue();
        this.mXAxisOrig = this.mXAxisLeft.getAxisOrigin();
        this.mXAxisLen = this.mXAxisLeft.getAxisRange();
        this.mSelHMin = newHMin;
        this.mSelHMax = newHMax;
        this.mSelHCtr = newHCtr;
        this.mYAxisOrig = this.mYAxisUpper.getAxisOrigin();
        this.mYAxisLen = this.mYAxisUpper.getAxisRange();
        this.mSelVMin = newVMin;
        this.mSelVMax = newVMax;
        this.mSelVCtr = newVCtr;
    }

    public void setXAxisRange(double min, double max, double ctr) {
        this.mXAxisLeft.setValue(min);
        this.mXAxisLeft.setDontBroadcast(true);
        this.mXAxisLeft.setXLocation(this.mXAxisLeft.getNewLocation());
        this.mXAxisCtr.setValue(ctr);
        this.mXAxisCtr.setDontBroadcast(true);
        this.mXAxisCtr.setXLocation(this.mXAxisCtr.getNewLocation());
        this.mXAxisRight.setValue(max);
        this.mXAxisRight.setDontBroadcast(true);
        this.mXAxisRight.setXLocation(this.mXAxisRight.getNewLocation());
        this.mSelHMinVal = min;
        this.mSelHMaxVal = max;
        this.mSelHCtrVal = ctr;
        this.resetRgnBounds();
    }

    public void setYAxisRange(double min, double max, double ctr) {
        this.mYAxisLower.setValue(min);
        this.mYAxisLower.setDontBroadcast(true);
        this.mYAxisLower.setYLocation(this.mYAxisLower.getNewLocation());
        this.mYAxisCtr.setValue(ctr);
        this.mYAxisCtr.setDontBroadcast(true);
        this.mYAxisCtr.setYLocation(this.mYAxisCtr.getNewLocation());
        this.mYAxisUpper.setValue(max);
        this.mYAxisUpper.setDontBroadcast(true);
        this.mYAxisUpper.setYLocation(this.mYAxisUpper.getNewLocation());
        this.mSelVMinVal = min;
        this.mSelVMaxVal = max;
        this.mSelVCtrVal = ctr;
        this.resetRgnBounds();
    }

    public int getXAxisOrig() {
        return this.mXAxisOrig;
    }

    public int getXAxisLen() {
        return this.mXAxisLen;
    }

    public int getYAxisOrig() {
        return this.mYAxisOrig;
    }

    public int getYAxisLen() {
        return this.mYAxisLen;
    }

    public int getSelXMin() {
        return this.mSelHMin;
    }

    public int getSelXMax() {
        return this.mSelHMax;
    }

    public int getSelXCtr() {
        return this.mSelHCtr;
    }

    public int getSelYMin() {
        return this.mSelVMin;
    }

    public int getSelYMax() {
        return this.mSelVMax;
    }

    public int getSelYCtr() {
        return this.mSelVCtr;
    }

    public double getXMin() {
        return this.mSelHMinVal;
    }

    public double getXMax() {
        return this.mSelHMaxVal;
    }

    public double getXCtr() {
        return this.mSelHCtrVal;
    }

    public double getYMin() {
        return this.mSelVMinVal;
    }

    public double getYMax() {
        return this.mSelVMaxVal;
    }

    public double getYCtr() {
        return this.mSelVCtrVal;
    }
}

