/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JColorChooser;
import javax.swing.JPanel;

public class Swatch
extends JPanel
implements MouseListener {
    protected Color mColor;
    protected Color mNewColor;
    protected int mHeight;
    protected int mWidth;
    protected Component mParent = this.getParent();
    protected JPanel mThis;
    protected Graphics thisG;
    protected boolean mEditable = true;

    public Swatch(Color inColor) {
        this(inColor, 10, 10);
        this.setToolTipText("Click to assign custom color.");
    }

    public void setEditable(boolean mode) {
        this.mEditable = mode;
    }

    public Swatch(Color inColor, int width, int height) {
        this.mColor = inColor;
        this.mHeight = height + 3;
        this.mWidth = width + 3;
        this.addMouseListener(this);
        this.mThis = this;
        this.setToolTipText("Click to assign custom color.");
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.mEditable) {
            g.setColor(this.getBackground().darker());
            g.fillRect(3, 3, this.mWidth - 1, this.mHeight - 1);
            g.setColor(this.mColor);
            g.fillRect(1, 1, this.mWidth - 4, this.mHeight - 4);
        } else {
            g.setColor(this.mColor);
            g.fillRect(2, 2, this.mWidth - 3, this.mHeight - 3);
        }
        this.thisG = g;
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.mWidth, this.mHeight);
    }

    @Override
    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public Color getColor() {
        return this.mColor;
    }

    public void setColor(Color inColor) {
        this.mColor = inColor;
        Graphics g = this.mThis.getGraphics();
        if (g != null) {
            this.paintComponent(g);
            g.dispose();
        }
    }

    public void setColorSilent(Color inColor) {
        this.mColor = inColor;
    }

    @Override
    public void mouseClicked(MouseEvent me) {
        if (!this.mEditable) {
            return;
        }
        Color oldColor = this.mColor;
        this.mColor = JColorChooser.showDialog(this.mParent, "Choose a new color:", this.mColor);
        if (this.mColor == null) {
            this.mColor = oldColor;
        } else {
            Graphics g = this.mThis.getGraphics();
            if (g != null) {
                this.paintComponent(g);
                g.dispose();
            }
        }
    }

    @Override
    public void mousePressed(MouseEvent me) {
    }

    @Override
    public void mouseReleased(MouseEvent me) {
    }

    @Override
    public void mouseEntered(MouseEvent me) {
    }

    @Override
    public void mouseExited(MouseEvent me) {
    }
}

