/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.swing.beans;

import gov.noaa.pmel.swing.JDateTimeGetter;
import gov.noaa.pmel.util.WeakPropertyChangeListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyEditorSupport;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.JFrame;

public class DateTimeEditor
extends PropertyEditorSupport
implements PropertyChangeListener {
    protected Date date;
    SimpleDateFormat sdt = new SimpleDateFormat(" dd MMM yyyy HH:mm ");
    JDateTimeGetter dtg = new JDateTimeGetter();

    public DateTimeEditor() {
        this.dtg.addPropertyChangeListener(new WeakPropertyChangeListener(this, this.dtg));
        this.date = new Date();
    }

    @Override
    public Object getValue() {
        this.date = this.dtg.getDate();
        return this.date;
    }

    @Override
    public void setValue(Object o) {
        this.date = (Date)o;
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public boolean isPaintable() {
        return true;
    }

    @Override
    public void paintValue(Graphics g, Rectangle box) {
        String s = this.sdt.format(this.date);
        FontMetrics fm = g.getFontMetrics(g.getFont());
        Color old = g.getColor();
        g.setColor(Color.black);
        g.drawString(s, box.x + 6, box.y + box.height - fm.getMaxDescent());
        g.setColor(old);
    }

    @Override
    public Component getCustomEditor() {
        return this.dtg;
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getPropertyName().equals("DateTime")) {
            this.setValue(event.getNewValue());
            System.out.println("Firing property change .....");
            this.firePropertyChange();
        }
    }

    @Override
    public String getJavaInitializationString() {
        return "new java.util.Date()";
    }

    class Launcher
    implements ActionListener {
        Launcher() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JFrame jf = new JFrame();
            jf.setVisible(true);
            jf.setSize(220, 323);
            jf.getContentPane().add(DateTimeEditor.this.dtg);
            jf.invalidate();
            jf.validate();
        }
    }
}

