/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.swing.map;

import gov.noaa.pmel.swing.map.LatInvalidException;
import java.util.StringTokenizer;

public class Latitude {
    public static final double MAX_LATITUDE = 90.0;
    public static final double MIN_LATITUDE = -90.0;
    private double lat;

    public Latitude(double l) {
        this.lat = Math.min(90.0, Math.max(-90.0, l));
    }

    public Latitude(String s) throws LatInvalidException {
        int Hemi = 1;
        String lats = new String(s);
        lats = lats.trim();
        lats = lats.toUpperCase();
        if (lats.endsWith("N")) {
            Hemi = 1;
            lats = lats.substring(0, lats.length() - 1).trim();
        } else if (lats.endsWith("S")) {
            Hemi = -1;
            lats = lats.substring(0, lats.length() - 1).trim();
        }
        StringTokenizer check = new StringTokenizer(lats, " +-.0123456789", false);
        if (check.countTokens() > 0) {
            throw new LatInvalidException();
        }
        StringTokenizer st = new StringTokenizer(lats, " ", false);
        switch (st.countTokens()) {
            case 1: {
                try {
                    this.lat = Double.valueOf(lats);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new LatInvalidException();
                }
            }
            case 2: {
                String deg = st.nextToken();
                check = new StringTokenizer(deg, "+-0123456789", false);
                if (check.countTokens() > 0) {
                    throw new LatInvalidException();
                }
                String mins = st.nextToken();
                check = new StringTokenizer(mins, ".0123456789", false);
                if (check.countTokens() > 0) {
                    throw new LatInvalidException();
                }
                try {
                    this.lat = Double.valueOf(deg);
                    this.lat += Double.valueOf(mins) / 60.0;
                    break;
                }
                catch (NumberFormatException e) {
                    throw new LatInvalidException();
                }
            }
            default: {
                throw new LatInvalidException();
            }
        }
        this.lat *= (double)Hemi;
        this.lat = Math.min(90.0, Math.max(-90.0, this.lat));
    }

    public Latitude(Latitude lat) {
        this.lat = lat.LatValue();
    }

    public double LatValue() {
        return this.lat;
    }

    public boolean equals(Object o) {
        boolean rval = false;
        if (o instanceof Latitude && this.lat == ((Latitude)o).LatValue()) {
            rval = true;
        }
        return rval;
    }

    public String toString() {
        return new Double(this.lat).toString();
    }

    public String toString(String fs) {
        int x = (int)(this.lat * 10.0);
        String ns = x < 0 ? "S" : "N";
        float fx = (float)Math.abs(x) / 10.0f;
        return fx + ns;
    }
}

