/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.swing.map;

import gov.noaa.pmel.swing.map.LonInvalidException;
import java.util.StringTokenizer;

public class Longitude {
    public static final double MAX_LONGITUDE = 180.0;
    public static final double MIN_LONGITUDE = -180.0;
    private double lon;

    public Longitude(double l) {
        this.lon = this.normalize(l);
    }

    public Longitude(String s) throws LonInvalidException {
        int Hemi = 1;
        String lons = new String(s);
        lons = lons.trim();
        lons = lons.toUpperCase();
        if (lons.endsWith("E")) {
            Hemi = 1;
            lons = lons.substring(0, lons.length() - 1).trim();
        } else if (lons.endsWith("W")) {
            Hemi = -1;
            lons = lons.substring(0, lons.length() - 1).trim();
        }
        StringTokenizer check = new StringTokenizer(lons, " +-.0123456789", false);
        if (check.countTokens() > 0) {
            throw new LonInvalidException();
        }
        StringTokenizer st = new StringTokenizer(lons, " ", false);
        switch (st.countTokens()) {
            case 1: {
                try {
                    this.lon = Double.valueOf(lons);
                    break;
                }
                catch (NumberFormatException e) {
                    throw new LonInvalidException();
                }
            }
            case 2: {
                String deg = st.nextToken();
                check = new StringTokenizer(deg, "+-0123456789", false);
                if (check.countTokens() > 0) {
                    throw new LonInvalidException();
                }
                String mins = st.nextToken();
                check = new StringTokenizer(mins, ".0123456789", false);
                if (check.countTokens() > 0) {
                    throw new LonInvalidException();
                }
                try {
                    this.lon = Double.valueOf(deg);
                    this.lon += Double.valueOf(mins) / 60.0;
                    break;
                }
                catch (NumberFormatException e) {
                    throw new LonInvalidException();
                }
            }
            default: {
                throw new LonInvalidException();
            }
        }
        this.lon = this.normalize(this.lon) * (double)Hemi;
    }

    public Longitude(Longitude lon) {
        this.lon = lon.LonValue();
    }

    public double LonValue() {
        return this.lon;
    }

    public boolean equals(Object o) {
        boolean rval = false;
        if (o instanceof Longitude && this.lon == ((Longitude)o).LonValue()) {
            rval = true;
        }
        return rval;
    }

    public String toString() {
        return new Double(this.lon).toString();
    }

    public String toString(String fs) {
        int x = (int)(this.lon * 10.0);
        String ew = x < 0 ? "W" : "E";
        float fx = (float)Math.abs(x) / 10.0f;
        return fx + ew;
    }

    private double normalize(double d) {
        double val = d % 360.0;
        if (val > 180.0) {
            val -= 360.0;
        } else if (val < -180.0) {
            val += 360.0;
        }
        return val;
    }
}

