/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.swing.map;

import gov.noaa.pmel.swing.map.GeoPoint;
import gov.noaa.pmel.swing.map.Latitude;
import gov.noaa.pmel.swing.map.Longitude;
import java.awt.Point;
import java.awt.Rectangle;

public class MapImageScale {
    private Point topLeft;
    private Point bottomRight;
    private GeoPoint northWest;
    private GeoPoint southEast;

    public MapImageScale(Point topLeft, Point bottomRight, GeoPoint northWest, GeoPoint southEast) {
        this.topLeft = new Point(topLeft.x, topLeft.y);
        this.bottomRight = new Point(bottomRight.x, bottomRight.y);
        this.northWest = new GeoPoint(northWest);
        this.southEast = new GeoPoint(southEast);
    }

    public GeoPoint toGeoPoint(Point p) {
        double westernmost;
        double easternmost = this.southEast.Lon().LonValue();
        if (easternmost <= (westernmost = this.northWest.Lon().LonValue())) {
            easternmost += 360.0;
        }
        double gx = this.northWest.Lon().LonValue() + (double)(p.x - this.topLeft.x) * (easternmost - westernmost) / (double)(this.bottomRight.x - this.topLeft.x);
        double gy = this.northWest.Lat().LatValue() + (double)(p.y - this.topLeft.y) * (this.southEast.Lat().LatValue() - this.northWest.Lat().LatValue()) / (double)(this.bottomRight.y - this.topLeft.y);
        Longitude lon = new Longitude(gx);
        Latitude lat = new Latitude(gy);
        return new GeoPoint(lon, lat);
    }

    public GeoPoint toGeoPoint(int x, int y) {
        return this.toGeoPoint(new Point(x, y));
    }

    public String printIt(GeoPoint gp) {
        return new Integer((int)gp.Lat().LatValue()).toString();
    }

    public Point toPoint(GeoPoint gp) {
        int delta_ew;
        double easternmost = this.southEast.Lon().LonValue();
        double westernmost = this.northWest.Lon().LonValue();
        double gplonval = gp.Lon().LonValue();
        if (easternmost <= westernmost) {
            easternmost += 360.0;
            if (gplonval < 0.0) {
                gplonval += 360.0;
            }
        }
        int x = (delta_ew = (int)(easternmost - westernmost)) == 0 ? this.topLeft.x : this.topLeft.x + (int)((gplonval - westernmost) * (double)(this.bottomRight.x - this.topLeft.x) / (double)delta_ew);
        int delta_ns = (int)(this.southEast.Lat().LatValue() - this.northWest.Lat().LatValue());
        int y = delta_ns == 0 ? this.topLeft.y : this.topLeft.y + (int)((gp.Lat().LatValue() - this.northWest.Lat().LatValue()) * (double)(this.bottomRight.y - this.topLeft.y) / (double)delta_ns);
        return new Point(x, y);
    }

    public Point toPoint(double lonv, double latv) {
        return this.toPoint(new GeoPoint(lonv, latv));
    }

    public Point toPoint(Longitude lon, Latitude lat) {
        return this.toPoint(new GeoPoint(lon, lat));
    }

    public Rectangle getMapRectangle() {
        return new Rectangle(this.topLeft.x, this.topLeft.y, this.bottomRight.x - this.topLeft.x, this.bottomRight.y - this.topLeft.y);
    }
}

