/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.swing.spin;

import gov.noaa.pmel.swing.spin.DefaultSpinRangeModel;
import gov.noaa.pmel.swing.spin.SpinModel;
import gov.noaa.pmel.swing.spin.SpinRangeModel;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DefaultSpinModel
implements SpinModel,
ChangeListener {
    protected int activeField;
    protected Vector fieldIDs = new Vector();
    protected Hashtable table = new Hashtable();
    protected Vector listeners = new Vector();
    DefaultSpinRangeModel singleModel;

    public DefaultSpinModel() {
    }

    public DefaultSpinModel(double value, double extent, double min, double max, boolean wrap) {
        DefaultSpinRangeModel model = new DefaultSpinRangeModel(value, extent, min, max, wrap);
        this.setRange(0, model);
        this.setActiveField(0);
        this.singleModel = model;
    }

    public DefaultSpinModel(double iValue, double iExtent, double iMin, double iMax, boolean iWrap, double fValue, double fExtent, double fMin, double fMax, boolean fWrap) {
        DefaultSpinRangeModel iModel = new DefaultSpinRangeModel(iValue, iExtent, iMin, iMax, iWrap);
        this.setRange(0, iModel);
        DefaultSpinRangeModel fModel = new DefaultSpinRangeModel(fValue, fExtent, fMin, fMax, fWrap);
        this.setRange(1, fModel);
        this.setActiveField(0);
    }

    public DefaultSpinRangeModel getModel() {
        return this.singleModel;
    }

    @Override
    public int getFieldCount() {
        return this.fieldIDs.size();
    }

    @Override
    public int getActiveField() {
        return this.activeField;
    }

    @Override
    public void setActiveField(int fieldID) {
        this.activeField = fieldID;
        this.fireStateChanged();
    }

    @Override
    public void setNextField() {
        int[] array = this.getFieldIDs();
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != this.activeField) continue;
            this.setActiveField(array[Math.min(i + 1, array.length - 1)]);
            return;
        }
    }

    @Override
    public void setPrevField() {
        int[] array = this.getFieldIDs();
        for (int i = 0; i < array.length; ++i) {
            if (array[i] != this.activeField) continue;
            this.setActiveField(array[Math.max(i - 1, 0)]);
            return;
        }
    }

    @Override
    public void setRange(int id, SpinRangeModel range) {
        Integer key = new Integer(id);
        if (!this.table.containsKey(key)) {
            this.fieldIDs.addElement(key);
            range.addChangeListener(this);
        }
        this.table.put(key, range);
    }

    @Override
    public SpinRangeModel getRange(int id) {
        Integer key = new Integer(id);
        return (SpinRangeModel)this.table.get(key);
    }

    @Override
    public int[] getFieldIDs() {
        int size = this.fieldIDs.size();
        int[] array = new int[size];
        for (int i = 0; i < size; ++i) {
            array[i] = (Integer)this.fieldIDs.elementAt(i);
        }
        return array;
    }

    @Override
    public void setFieldIDs(int[] fields) {
        this.fieldIDs.removeAllElements();
        for (int i = 0; i < fields.length; ++i) {
            this.fieldIDs.addElement(new Integer(fields[i]));
        }
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this.fireStateChanged();
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.listeners.addElement(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.listeners.removeElement(listener);
    }

    public void fireStateChanged() {
        Vector list = (Vector)this.listeners.clone();
        ChangeEvent event = new ChangeEvent(this);
        for (int i = 0; i < list.size(); ++i) {
            ChangeListener listener = (ChangeListener)list.elementAt(i);
            listener.stateChanged(event);
        }
    }
}

