/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.swing.spin;

import gov.noaa.pmel.swing.spin.SpinRangeModel;
import java.util.Vector;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class DefaultSpinRangeModel
implements SpinRangeModel {
    protected Vector listeners = new Vector();
    private double value = 0.0;
    private double extent = 1.0;
    private double min = 0.0;
    private double max = 100.0;
    private boolean wrap = true;
    private boolean isAdjusting = false;

    public DefaultSpinRangeModel() {
    }

    public DefaultSpinRangeModel(double value, double extent, double min, double max, boolean wrap) {
        this.value = value;
        this.extent = extent;
        this.min = min;
        this.max = max;
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public double getExtent() {
        return this.extent;
    }

    @Override
    public double getMinimum() {
        return this.min;
    }

    @Override
    public double getMaximum() {
        return this.max;
    }

    @Override
    public boolean getWrap() {
        return this.wrap;
    }

    @Override
    public void setValue(double value) {
        this.value = value;
    }

    @Override
    public void setExtent(double extent) {
        this.extent = extent;
    }

    @Override
    public void setMinimum(double min) {
        this.min = min;
    }

    @Override
    public void setMaximum(double max) {
        this.max = max;
    }

    @Override
    public void setWrap(boolean wrap) {
        this.wrap = wrap;
    }

    @Override
    public void setValueIsAdjusting(boolean adjusting) {
        this.isAdjusting = adjusting;
        if (!this.isAdjusting) {
            this.fireStateChanged();
        }
    }

    @Override
    public boolean getValueIsAdjusting() {
        return this.isAdjusting;
    }

    @Override
    public void addChangeListener(ChangeListener listener) {
        this.listeners.addElement(listener);
    }

    @Override
    public void removeChangeListener(ChangeListener listener) {
        this.listeners.removeElement(listener);
    }

    public void fireStateChanged() {
        Vector list = (Vector)this.listeners.clone();
        ChangeEvent event = new ChangeEvent(this);
        for (int i = 0; i < list.size(); ++i) {
            ChangeListener listener = (ChangeListener)list.elementAt(i);
            listener.stateChanged(event);
        }
    }

    public String toString() {
        String modelString = "value=" + this.getValue() + ", extent=" + this.getExtent() + ", min=" + this.getMinimum() + ", max=" + this.getMaximum() + ", adj=" + this.getValueIsAdjusting();
        return this.getClass().getName() + "[" + modelString + "]";
    }
}

