/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.swing.spin;

import gov.noaa.pmel.swing.spin.JBasicArrowButton;
import gov.noaa.pmel.swing.spin.SpinModel;
import gov.noaa.pmel.swing.spin.SpinRangeModel;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.SwingConstants;

public class JSpinner
extends JPanel
implements ActionListener,
KeyListener,
SwingConstants {
    protected Vector listeners = new Vector();
    protected JBasicArrowButton north;
    protected JBasicArrowButton south;
    SpinModel model;

    public JSpinner(SpinModel model) {
        this.model = model;
        this.setLayout(new GridLayout(2, 1));
        this.setPreferredSize(new Dimension(16, 16));
        this.north = new JBasicArrowButton(1);
        this.north.addActionListener(this);
        this.add(this.north);
        this.south = new JBasicArrowButton(5);
        this.south.addActionListener(this);
        this.south.setFocusPainted(true);
        this.add(this.south);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.north) {
            this.increment();
        }
        if (event.getSource() == this.south) {
            this.decrement();
        }
    }

    @Override
    public void keyTyped(KeyEvent event) {
    }

    @Override
    public void keyReleased(KeyEvent event) {
    }

    @Override
    public void keyPressed(KeyEvent event) {
        int code = event.getKeyCode();
        if (code == 38) {
            this.increment();
        }
        if (code == 40) {
            this.decrement();
        }
        if (code == 37) {
            this.model.setPrevField();
        }
        if (code == 39) {
            this.model.setNextField();
        }
    }

    protected void increment() {
        int fieldID = this.model.getActiveField();
        SpinRangeModel range = this.model.getRange(fieldID);
        range.setValueIsAdjusting(true);
        double value = range.getValue() + range.getExtent();
        if (value > range.getMaximum()) {
            value = range.getWrap() ? range.getMinimum() : range.getMaximum();
        }
        range.setValue(value);
        this.model.setRange(fieldID, range);
        range.setValueIsAdjusting(false);
    }

    public void decrement() {
        int fieldID = this.model.getActiveField();
        SpinRangeModel range = this.model.getRange(fieldID);
        range.setValueIsAdjusting(true);
        double value = range.getValue() - range.getExtent();
        if (value < range.getMinimum()) {
            value = range.getWrap() ? range.getMaximum() : range.getMinimum();
        }
        range.setValue(value);
        this.model.setRange(fieldID, range);
        range.setValueIsAdjusting(false);
    }
}

