/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.swing.spin;

import gov.noaa.pmel.swing.spin.DefaultSpinModel;
import gov.noaa.pmel.swing.spin.JSpinner;
import gov.noaa.pmel.swing.spin.LargeSpinRenderer;
import gov.noaa.pmel.swing.spin.LocaleUtil;
import gov.noaa.pmel.swing.spin.SpinField;
import gov.noaa.pmel.swing.spin.SpinModel;
import gov.noaa.pmel.swing.spin.SpinRangeModel;
import gov.noaa.pmel.swing.spin.SpinRenderer;
import java.awt.BorderLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.Format;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class JSpinnerField
extends JPanel
implements ChangeListener,
MouseListener,
FocusListener {
    protected SpinModel model;
    protected SpinField spinField;
    protected SpinRenderer renderer;
    protected Format formatter;
    protected boolean wrap = true;
    protected boolean hasFocus = false;

    public JSpinnerField() {
    }

    public JSpinnerField(int value, int extent, int min, int max, boolean wrap) {
        this.init(new DefaultSpinModel(value, extent, min, max, wrap), new LargeSpinRenderer(), NumberFormat.getInstance(), wrap);
        this.refreshSpinView();
    }

    public JSpinnerField(SpinModel model, SpinRenderer renderer, Format formatter, boolean wrap) {
        this.init(model, renderer, formatter, wrap);
        this.refreshSpinView();
    }

    protected void init(SpinModel model, SpinRenderer renderer, Format formatter, boolean wrap) {
        this.model = model;
        this.renderer = renderer;
        this.formatter = formatter;
        this.wrap = wrap;
        this.spinField = new SpinField(this);
        this.setLayout(new BorderLayout());
        this.add("Center", this.spinField);
        this.setBorder(this.spinField.getBorder());
        this.spinField.setBorder(null);
        JSpinner spinner = new JSpinner(model);
        this.addKeyListener(spinner);
        this.addMouseListener(this);
        this.addFocusListener(this);
        model.addChangeListener(this);
        this.add("East", spinner);
    }

    @Override
    public void setLocale(Locale locale) {
        this.formatter = NumberFormat.getInstance(locale);
        this.updateFieldOrder();
    }

    public void updateFieldOrder() {
        if (this.spinField.getValue() == null) {
            return;
        }
        int[] fieldIDs = this.model.getFieldIDs();
        LocaleUtil.sortFieldOrder(this.formatter, this.spinField.getValue(), fieldIDs);
        this.model.setFieldIDs(fieldIDs);
    }

    public SpinRenderer getRenderer() {
        return this.renderer;
    }

    public String getText() {
        return ((JTextField)((Object)this.renderer)).getText();
    }

    protected void refreshSpinView() {
        int fieldID = this.model.getActiveField();
        SpinRangeModel range = this.model.getRange(fieldID);
        this.spinField.setValue(new Double(range.getValue()));
    }

    @Override
    public void stateChanged(ChangeEvent event) {
        this.requestFocus();
        this.refreshSpinView();
        this.repaint();
    }

    @Override
    public void mouseClicked(MouseEvent event) {
        int fieldID = LocaleUtil.findMouseInField(this.getGraphics().getFontMetrics(), event.getX(), this.formatter, this.spinField.getValue(), this.model.getFieldIDs());
        this.model.setActiveField(fieldID);
        this.requestFocus();
        this.refreshSpinView();
    }

    @Override
    public void mousePressed(MouseEvent event) {
    }

    @Override
    public void mouseReleased(MouseEvent event) {
    }

    @Override
    public void mouseEntered(MouseEvent event) {
    }

    @Override
    public void mouseExited(MouseEvent event) {
    }

    @Override
    public void focusGained(FocusEvent event) {
        this.hasFocus = true;
        this.repaint();
    }

    @Override
    public void focusLost(FocusEvent event) {
        this.hasFocus = false;
        this.repaint();
    }

    @Override
    public boolean isFocusTraversable() {
        return true;
    }
}

