/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.swing.spin;

import gov.noaa.pmel.swing.spin.DefaultSpinModel;
import gov.noaa.pmel.swing.spin.DefaultSpinRangeModel;
import gov.noaa.pmel.swing.spin.SpinRangeModel;
import gov.noaa.pmel.util.Latitude;

class LatSpinModel
extends DefaultSpinModel {
    Latitude latitude = new Latitude();

    public LatSpinModel() {
        this.setRange(0, new DefaultSpinRangeModel(0.0, 1.0, 0.0, 90.0, true));
        this.setRange(1, new DefaultSpinRangeModel(0.0, 1.0, 0.0, 60.0, true));
        this.setRange(2, new DefaultSpinRangeModel(0.0, 1.0, 0.0, 60.0, true));
        this.setRange(3, new DefaultSpinRangeModel(0.0, 2.0, -1.0, 1.0, true));
        this.setActiveField(0);
    }

    @Override
    public void setRange(int fieldID, SpinRangeModel range) {
        super.setRange(fieldID, range);
        if (fieldID == 0) {
            this.latitude.setDegrees((int)range.getValue());
            this.latitude.degMinSecToDecimal();
        }
        if (fieldID == 1) {
            this.latitude.setMinutes((int)range.getValue());
            this.latitude.degMinSecToDecimal();
        }
        if (fieldID == 2) {
            this.latitude.setSeconds((int)range.getValue());
            this.latitude.degMinSecToDecimal();
        }
        if (fieldID == 3) {
            this.latitude.setSign((int)range.getValue());
            this.latitude.degMinSecToDecimal();
        }
    }

    public void setLatitude(float latitude) {
        this.latitude.setDecimalValue(latitude);
        this.getRange(0);
        this.getRange(1);
        this.getRange(2);
        this.getRange(3);
    }

    public float getLatitude() {
        return this.latitude.getDecimalValue();
    }

    @Override
    public SpinRangeModel getRange(int fieldID) {
        SpinRangeModel range = super.getRange(fieldID);
        if (fieldID == 0) {
            range.setExtent(1.0);
            range.setValue(this.latitude.getDegrees());
            range.setMinimum(0.0);
            range.setMaximum(90.0);
        }
        if (fieldID == 1) {
            range.setExtent(1.0);
            range.setValue(this.latitude.getMinutes());
            range.setMinimum(0.0);
            range.setMaximum(59.0);
        }
        if (fieldID == 2) {
            range.setExtent(1.0);
            range.setValue(this.latitude.getSeconds());
            range.setMinimum(0.0);
            range.setMaximum(59.0);
        }
        if (fieldID == 3) {
            range.setExtent(2.0);
            range.setValue(this.latitude.getSign());
            range.setMinimum(-1.0);
            range.setMaximum(1.0);
        }
        return range;
    }

    public static void main(String[] args) {
        LatSpinModel lsm = new LatSpinModel();
        System.out.println("Field count is: " + lsm.getFieldCount());
    }
}

