/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.swing.spin;

import gov.noaa.pmel.swing.spin.JSpinnerField;
import gov.noaa.pmel.swing.spin.LocaleUtil;
import gov.noaa.pmel.swing.spin.SpinRenderer;
import java.awt.Component;
import java.awt.Font;
import java.text.FieldPosition;
import java.text.Format;
import javax.swing.JTextField;

class LatSpinRenderer
extends JTextField
implements SpinRenderer {
    public LatSpinRenderer() {
        this.setOpaque(true);
        this.setEditable(false);
        this.setFont(new Font("Dialog", 0, 24));
    }

    @Override
    public Component getSpinCellRendererComponent(JSpinnerField spin, Object value, boolean hasFocus, Format formatter, int selectedFieldID) {
        String text = formatter.format(value);
        this.setText(text);
        FieldPosition pos = LocaleUtil.getFieldPosition(formatter, value, selectedFieldID);
        if (pos.getBeginIndex() == pos.getEndIndex()) {
            pos.setBeginIndex(0);
            pos.setEndIndex(text.length());
        }
        if (hasFocus) {
            this.select(pos.getBeginIndex(), pos.getEndIndex());
        } else {
            this.select(0, 0);
        }
        return this;
    }
}

