/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.swing.spin;

import gov.noaa.pmel.text.LatitudeFormat;
import gov.noaa.pmel.text.LongitudeFormat;
import java.awt.FontMetrics;
import java.text.FieldPosition;
import java.text.Format;

public class LocaleUtil {
    public static void sortFieldOrder(Format formatter, Object obj, int[] fieldIDs) {
        int size = fieldIDs.length;
        int[] order = new int[size];
        for (int i = 0; i < size; ++i) {
            order[i] = LocaleUtil.getFieldPosition(formatter, obj, fieldIDs[i]).getBeginIndex();
        }
        LocaleUtil.sort(fieldIDs, order);
    }

    public static int findMouseInField(FontMetrics metrics, int x, Format formatter, Object obj, int[] fieldIDs) {
        String text = formatter.format(obj);
        int size = fieldIDs.length;
        for (int i = 0; i < size; ++i) {
            FieldPosition pos = LocaleUtil.getFieldPosition(formatter, obj, fieldIDs[i]);
            int left = metrics.stringWidth(text.substring(0, pos.getBeginIndex()));
            int right = metrics.stringWidth(text.substring(0, pos.getEndIndex()));
            if (x < left || x > right) continue;
            return fieldIDs[i];
        }
        return fieldIDs[0];
    }

    public static FieldPosition getFieldPosition(Format formatter, Object obj, int field) {
        FieldPosition pos = new FieldPosition(field);
        if (formatter instanceof LongitudeFormat) {
            pos = ((LongitudeFormat)formatter).getFieldPosition(field);
        }
        if (formatter instanceof LatitudeFormat) {
            pos = ((LatitudeFormat)formatter).getFieldPosition(field);
        }
        return pos;
    }

    private static void sort(int[] fieldIDs, int[] order) {
        LocaleUtil.sort(fieldIDs, order, 0, fieldIDs.length - 1);
    }

    private static void sort(int[] fieldIDs, int[] order, int first, int last) {
        if (first >= last) {
            return;
        }
        int lo = first;
        int hi = last;
        int mid = order[(first + last) / 2];
        while (true) {
            if (mid > order[lo]) {
                ++lo;
                continue;
            }
            while (mid < order[hi]) {
                --hi;
            }
            if (lo <= hi) {
                int tmp = order[lo];
                int temp = fieldIDs[lo];
                order[lo] = order[hi];
                fieldIDs[lo] = fieldIDs[hi];
                ++lo;
                order[hi] = tmp;
                fieldIDs[hi] = temp;
                --hi;
            }
            if (lo > hi) break;
        }
        LocaleUtil.sort(fieldIDs, order, first, hi);
        LocaleUtil.sort(fieldIDs, order, lo, last);
    }

    public static void main(String[] args) {
        int[] order = new int[]{2, 8, 12, 6, 10, 4};
        int[] fieldIDs = new int[]{1, 4, 6, 3, 5, 2};
        LocaleUtil.sort(fieldIDs, order);
        for (int i = 0; i < fieldIDs.length; ++i) {
            System.out.print(fieldIDs[i] + "; ");
        }
    }
}

