/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.swing.spin;

import gov.noaa.pmel.swing.spin.DefaultSpinModel;
import gov.noaa.pmel.swing.spin.DefaultSpinRangeModel;
import gov.noaa.pmel.swing.spin.SpinRangeModel;
import gov.noaa.pmel.util.Longitude;

class LonSpinModel
extends DefaultSpinModel {
    Longitude longitude = new Longitude();

    public LonSpinModel() {
        this.setRange(0, new DefaultSpinRangeModel(0.0, 1.0, 0.0, 180.0, true));
        this.setRange(1, new DefaultSpinRangeModel(0.0, 1.0, 0.0, 60.0, true));
        this.setRange(2, new DefaultSpinRangeModel(0.0, 1.0, 0.0, 60.0, true));
        this.setRange(3, new DefaultSpinRangeModel(0.0, 2.0, -1.0, 1.0, true));
        this.setActiveField(0);
    }

    @Override
    public void setRange(int fieldID, SpinRangeModel range) {
        super.setRange(fieldID, range);
        if (fieldID == 0) {
            this.longitude.setDegrees((int)range.getValue());
            this.longitude.degMinSecToDecimal();
        }
        if (fieldID == 1) {
            this.longitude.setMinutes((int)range.getValue());
            this.longitude.degMinSecToDecimal();
        }
        if (fieldID == 2) {
            this.longitude.setSeconds((int)range.getValue());
            this.longitude.degMinSecToDecimal();
        }
        if (fieldID == 3) {
            this.longitude.setSign((int)range.getValue());
            this.longitude.degMinSecToDecimal();
        }
    }

    public void setLongitude(float longitude) {
        this.longitude.setDecimalValue(longitude);
        this.getRange(0);
        this.getRange(1);
        this.getRange(2);
        this.getRange(3);
    }

    public float getLongitude() {
        return this.longitude.getDecimalValue();
    }

    @Override
    public SpinRangeModel getRange(int fieldID) {
        SpinRangeModel range = super.getRange(fieldID);
        if (fieldID == 0) {
            range.setExtent(1.0);
            range.setValue(this.longitude.getDegrees());
            range.setMinimum(0.0);
            range.setMaximum(180.0);
        }
        if (fieldID == 1) {
            range.setExtent(1.0);
            range.setValue(this.longitude.getMinutes());
            range.setMinimum(0.0);
            range.setMaximum(59.0);
        }
        if (fieldID == 2) {
            range.setExtent(1.0);
            range.setValue(this.longitude.getSeconds());
            range.setMinimum(0.0);
            range.setMaximum(59.0);
        }
        if (fieldID == 3) {
            range.setExtent(2.0);
            range.setValue(this.longitude.getSign());
            range.setMinimum(-1.0);
            range.setMaximum(1.0);
        }
        return range;
    }

    public static void main(String[] args) {
        LonSpinModel lsm = new LonSpinModel();
        System.out.println("Field count is: " + lsm.getFieldCount());
    }
}

