/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.text;

import gov.noaa.pmel.util.GeographicValue;
import java.text.DecimalFormat;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.StringTokenizer;

public class GeographicFormat
extends Format {
    DecimalFormat df1 = new DecimalFormat("###");
    DecimalFormat df2 = new DecimalFormat("00");
    DecimalFormat dfFormat;
    boolean degreesMinutes = true;
    int precision = 3;
    boolean isLon = true;
    static final int LAT = 0;
    static final int LON = 1;
    public static final int DEGREES_FIELD = 0;
    public static final int MINUTES_FIELD = 1;
    public static final int SECONDS_FIELD = 2;
    public static final int SUFFIX_FIELD = 3;

    public GeographicFormat(String formatString, int whichType) {
        this.precision = 0;
        boolean bl = this.isLon = whichType == 1;
        if (-1 != formatString.indexOf("ggg")) {
            this.degreesMinutes = true;
            this.precision = 1;
            if (-1 != formatString.indexOf("mmm")) {
                ++this.precision;
            }
            if (-1 != formatString.indexOf("sss")) {
                ++this.precision;
            }
        } else {
            this.degreesMinutes = false;
            String fmtstr = new String(formatString);
            if (this.isLon) {
                fmtstr = fmtstr.replace('E', 'A');
            }
            this.dfFormat = new DecimalFormat(fmtstr);
        }
    }

    public GeographicFormat(int whichType) {
        this.isLon = whichType == 1;
    }

    public GeographicFormat() {
    }

    public FieldPosition getFieldPosition(int fld) {
        FieldPosition fp = new FieldPosition(fld);
        if (fld == 0) {
            fp.setBeginIndex(0);
            fp.setEndIndex(3);
        } else if (fld == 1) {
            fp.setBeginIndex(4);
            fp.setEndIndex(6);
        } else if (fld == 2) {
            fp.setBeginIndex(7);
            fp.setEndIndex(9);
        } else if (fld == 3) {
            fp.setBeginIndex(10);
            fp.setEndIndex(11);
        }
        return fp;
    }

    @Override
    public StringBuffer format(Object number, StringBuffer toAppendTo, FieldPosition pos) {
        String ss;
        if (this.degreesMinutes) {
            GeographicValue ll = new GeographicValue(((Double)number).floatValue());
            ss = this.buildString(ll.getDegrees(), ll.getMinutes(), ll.getSeconds(), ll.getSign());
        } else {
            ss = this.dfFormat.format(((Double)number).floatValue());
            if (this.isLon) {
                ss = ss.replace('A', 'E');
            }
        }
        return toAppendTo.append(ss);
    }

    public final String format(float number) {
        String ss;
        if (this.degreesMinutes) {
            GeographicValue ll = new GeographicValue(number);
            ss = this.buildString(ll.getDegrees(), ll.getMinutes(), ll.getSeconds(), ll.getSign());
        } else {
            ss = this.dfFormat.format(number);
            if (this.isLon) {
                ss = ss.replace('A', 'E');
            }
        }
        return ss;
    }

    public String buildString(long deg, long min, float sec, int sign) {
        String degreesFormatted = this.df1.format(deg);
        String minutesFormatted = this.df2.format(min);
        String secondsFormatted = this.df2.format(sec);
        String prfx = this.isLon ? (sign == -1 ? "W" : "E") : (sign == -1 ? "S" : "N");
        StringBuffer str = new StringBuffer();
        if (this.precision == 1) {
            str.append(degreesFormatted);
            str.append("                    ");
            str.insert(4, prfx);
            str.setLength(5);
        } else if (this.precision == 2) {
            str.append(degreesFormatted);
            str.append("                    ");
            str.insert(4, minutesFormatted);
            str.insert(6, "`");
            str.insert(7, prfx);
            str.setLength(8);
        } else if (this.precision == 3) {
            str.append(degreesFormatted);
            str.append("                    ");
            str.insert(4, minutesFormatted);
            str.insert(6, "`");
            str.insert(7, secondsFormatted);
            str.insert(9, "\"");
            str.insert(10, prfx);
            str.setLength(11);
        }
        return str.toString();
    }

    public float parse(String st) {
        return ((Float)this.parseObject(st, new ParsePosition(0))).floatValue();
    }

    @Override
    public Object parseObject(String st, ParsePosition pp) {
        String small;
        String cap;
        String tokenSet;
        if (!this.isLon) {
            tokenSet = " `NSns\"";
            cap = "S";
            small = "s";
        } else {
            tokenSet = " `EWew\"";
            cap = "W";
            small = "w";
        }
        if (this.degreesMinutes) {
            if (pp.getIndex() == 0) {
                StringTokenizer parser = new StringTokenizer(st, tokenSet, true);
                try {
                    while (parser.hasMoreTokens()) {
                        String tk;
                        if (this.precision == 1) {
                            tk = parser.nextToken();
                            while (tk.equals(" ") || tk.equals("`") || tk.equals("\"")) {
                                tk = parser.nextToken();
                            }
                            float d1 = this.df1.parse(tk, new ParsePosition(0)).floatValue();
                            tk = parser.nextToken();
                            while (tk.equals(" ") || tk.equals("`") || tk.equals("\"")) {
                                tk = parser.nextToken();
                            }
                            if (tk.equals(cap) || tk.equals(small)) {
                                d1 = -d1;
                            }
                            return new Float(d1);
                        }
                        if (this.precision == 2) {
                            tk = parser.nextToken();
                            while (tk.equals(" ") || tk.equals("`") || tk.equals("\"")) {
                                tk = parser.nextToken();
                            }
                            float d1 = this.df1.parse(tk, new ParsePosition(0)).floatValue();
                            tk = parser.nextToken();
                            while (tk.equals(" ") || tk.equals("`") || tk.equals("\"")) {
                                tk = parser.nextToken();
                            }
                            float dm = this.df2.parse(tk, new ParsePosition(0)).floatValue();
                            d1 += dm / 60.0f;
                            tk = parser.nextToken();
                            while (tk.equals(" ") || tk.equals("`") || tk.equals("\"")) {
                                tk = parser.nextToken();
                            }
                            if (tk.equals(cap) || tk.equals(small)) {
                                d1 = -d1;
                            }
                            return new Float(d1);
                        }
                        if (this.precision == 3) {
                            tk = parser.nextToken();
                            while (tk.equals(" ") || tk.equals("`") || tk.equals("\"")) {
                                tk = parser.nextToken();
                            }
                            float d1 = this.df1.parse(tk, new ParsePosition(0)).floatValue();
                            tk = parser.nextToken();
                            while (tk.equals(" ") || tk.equals("`") || tk.equals("\"")) {
                                tk = parser.nextToken();
                            }
                            float dm = this.df2.parse(tk, new ParsePosition(0)).floatValue();
                            tk = parser.nextToken();
                            while (tk.equals(" ") || tk.equals("`") || tk.equals("\"")) {
                                tk = parser.nextToken();
                            }
                            float ds = this.df2.parse(tk, new ParsePosition(0)).floatValue();
                            d1 += (dm += ds / 60.0f) / 60.0f;
                            tk = parser.nextToken();
                            while (tk.equals(" ") || tk.equals("`") || tk.equals("\"")) {
                                tk = parser.nextToken();
                            }
                            if (tk.equals(cap) || tk.equals(small)) {
                                d1 = -d1;
                            }
                            return new Float(d1);
                        }
                        tk = parser.nextToken();
                    }
                }
                catch (Exception ex) {
                    System.out.println(" Exception #1: ");
                }
            }
        } else {
            try {
                String s1;
                if (!this.isLon) {
                    s1 = st;
                    s1 = s1.replace('n', 'N');
                    s1 = s1.replace('s', 'S');
                } else {
                    s1 = st.replace('E', 'A');
                    s1 = s1.replace('e', 'A');
                    s1 = s1.replace('w', 'W');
                }
                return new Float(this.dfFormat.parse(s1).floatValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new Float(0.0f);
    }

    public static void main(String[] args) {
        System.out.println("Geographic format string empty");
        GeographicFormat lf = new GeographicFormat();
        float f1 = -45.5f;
        String s1 = lf.format(f1);
        System.out.println(" float to format: " + f1 + " " + lf.format(f1));
        System.out.println(" string to parse: " + s1 + " parsed: " + lf.parse(s1) + "\n");
        System.out.println("-----------------\n");
        f1 = 45.5f;
        s1 = lf.format(f1);
        System.out.println(" float to format: " + f1 + " " + lf.format(f1));
        System.out.println(" string to parse: " + s1 + " parsed: " + lf.parse(s1) + "\n");
        System.out.println("-----------------\n");
    }
}

