/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.util;

import gov.noaa.pmel.util.GeoDate;
import java.io.Serializable;
import java.util.Date;

public class GeoDateArray
implements Serializable {
    private long[] date_;

    public GeoDateArray(GeoDate[] dates) {
        this.date_ = new long[dates.length];
        for (int i = 0; i < dates.length; ++i) {
            this.date_[i] = dates[i] != null && !dates[i].isMissing() ? dates[i].getTime() : Long.MAX_VALUE;
        }
    }

    public GeoDateArray(Date[] dates) {
        this.date_ = new long[dates.length];
        for (int i = 0; i < dates.length; ++i) {
            this.date_[i] = dates[i] != null ? dates[i].getTime() : Long.MAX_VALUE;
        }
    }

    public GeoDateArray(long[] dates) {
        this.date_ = dates;
    }

    public long[] getTime() {
        return this.date_;
    }

    public long getTime(int index) {
        if (index < 0 || index >= this.date_.length) {
            return Long.MAX_VALUE;
        }
        return this.date_[index];
    }

    public GeoDate getGeoDate(int index) {
        if (index < 0 || index >= this.date_.length) {
            return null;
        }
        return new GeoDate(this.date_[index]);
    }

    public GeoDate[] getGeoDate() {
        GeoDate[] gd = new GeoDate[this.date_.length];
        for (int i = 0; i < this.date_.length; ++i) {
            gd[i] = new GeoDate(this.date_[i]);
        }
        return gd;
    }

    public double getOffset(int index, GeoDate ref) {
        if (index < 0 || index >= this.date_.length) {
            return Double.NaN;
        }
        return (double)(this.date_[index] - ref.getTime()) / 8.64E7;
    }

    public double[] getOffset(GeoDate ref) {
        long refgd = ref.getTime();
        double[] off = new double[this.date_.length];
        for (int i = 0; i < this.date_.length; ++i) {
            off[i] = (double)(this.date_[i] - refgd) / 8.64E7;
        }
        return off;
    }

    public long getOffsetTime(int index, GeoDate ref) {
        if (index < 0 || index >= this.date_.length) {
            return Long.MAX_VALUE;
        }
        return this.date_[index] - ref.getTime();
    }

    public long[] getOffsetTime(GeoDate ref) {
        long refgd = ref.getTime();
        long[] off = new long[this.date_.length];
        for (int i = 0; i < this.date_.length; ++i) {
            off[i] = this.date_[i] - refgd;
        }
        return off;
    }

    public void addOffset(long offset) {
        int i = 0;
        while (i < this.date_.length) {
            int n = i++;
            this.date_[n] = this.date_[n] + offset;
        }
    }

    public void addOffset(int index, long offset) {
        if (index < 0 || index >= this.date_.length) {
            return;
        }
        int n = index;
        this.date_[n] = this.date_[n] + offset;
    }

    public int getLength() {
        return this.date_.length;
    }
}

