/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.util;

public class GeographicValue {
    protected int degrees;
    protected int minutes;
    protected int seconds;
    protected int sign;
    protected float decimalValue;

    public GeographicValue() {
        this.decimalValue = 0.0f;
        this.decimalToDegMinSec();
    }

    public GeographicValue(float decVal) {
        this.decimalValue = decVal;
        this.decimalToDegMinSec();
    }

    public void decimalToDegMinSec() {
        this.sign = 1;
        if (this.decimalValue < 0.0f) {
            this.sign = -1;
        }
        float num1 = Math.abs(this.decimalValue);
        this.degrees = new Double(num1).intValue();
        float f1 = Math.abs(num1 - (float)this.degrees);
        float f2 = f1 * 60.0f;
        float num2 = Math.abs(f2);
        this.minutes = new Double(Math.floor(new Double(num2))).intValue();
        float f3 = Math.abs(num2 - (float)this.minutes);
        double dd = f3 * 60.0f;
        this.seconds = new Long(Math.round(dd)).intValue();
        if (this.seconds == 60) {
            this.seconds = 0;
            ++this.minutes;
        }
    }

    public void degMinSecToDecimal() {
        float minVal = this.minutes;
        float degVal = this.degrees;
        float secVal = this.seconds;
        if (this.seconds == 0) {
            secVal = 0.1f;
        }
        degVal += (minVal += secVal / 60.0f) / 60.0f;
        this.decimalValue = degVal *= (float)this.sign;
    }

    public void setDegrees(int degrees) {
        this.degrees = degrees;
    }

    public void setMinutes(int minutes) {
        this.minutes = minutes;
    }

    public void setSeconds(int seconds) {
        this.seconds = seconds;
    }

    public void setSign(int sign) {
        this.sign = sign;
    }

    public void setDecimalValue(float decimalValue) {
        this.decimalValue = decimalValue;
        this.decimalToDegMinSec();
    }

    public int getDegrees() {
        return this.degrees;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public int getSign() {
        return this.sign;
    }

    public float getDecimalValue() {
        return this.decimalValue;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append(" ----------------------------:  \n degrees: " + this.degrees + " \n minutes: " + this.minutes + " \n seconds: " + this.seconds + " \n decimalValue: " + this.decimalValue);
        return str.toString();
    }

    public static void main(String[] args) {
        GeographicValue l1 = new GeographicValue(-154.70027f);
        System.out.println(" toString: " + l1.toString());
    }
}

