/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.util;

import gov.noaa.pmel.util.ColorMap;
import java.awt.Color;

public class IndexedColorMap {
    String mParamName;
    double mMinVal;
    double mMaxVal;
    double[] mVals = null;
    Color[] mColors = null;
    int mNumColors;
    ColorMap mColorMap;

    public IndexedColorMap(ColorMap inCM, int numColors) {
        int i;
        this.mNumColors = numColors;
        this.mColorMap = inCM;
        this.mVals = new double[this.mNumColors];
        this.mColors = new Color[this.mNumColors];
        this.mMinVal = this.mColorMap.getMinValue();
        this.mMaxVal = this.mColorMap.getMaxValue();
        this.mParamName = new String(this.mColorMap.getParamName());
        double delta = (this.mMaxVal - this.mMinVal) / (double)this.mNumColors;
        for (i = 0; i < this.mNumColors; ++i) {
            this.mVals[i] = this.mMinVal + (double)i * delta;
        }
        this.mVals[this.mNumColors - 1] = this.mMaxVal;
        for (i = 0; i < this.mNumColors; ++i) {
            this.mColors[i] = this.mColorMap.getColor(this.mVals[i]);
        }
    }

    public IndexedColorMap(IndexedColorMap inMap) {
    }

    public Color getColor(double inVal) {
        return new Color(1.0f, 1.0f, 1.0f);
    }

    public Color getColor(int index) {
        if (index < 0) {
            return this.mColors[0];
        }
        if (index >= this.mNumColors) {
            return this.mColors[this.mNumColors - 1];
        }
        return this.mColors[index];
    }

    public Color[] getColors() {
        return this.mColors;
    }

    public String getParamName() {
        return this.mParamName;
    }
}

