/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.SortedMap;
import java.util.Vector;
import java.util.concurrent.ConcurrentSkipListMap;

public class OrderedList<E>
implements List<E> {
    public static final int USER_MIN_KEY = 0;
    public static final int USER_MAX_KEY = 1000000;
    private static final int MAX_KEY = 1000000000;
    private static final int MIN_KEY = 0;
    private ConcurrentSkipListMap<Long, E> map_ = new ConcurrentSkipListMap();

    public SortedMap<Long, E> getMap() {
        return this.map_;
    }

    public E removeOrdered(int key) {
        long tkey = key * 1000;
        return this.map_.remove(tkey);
    }

    public void addOrdered(int key, E value) {
        if (key < 0 || key > 1000000) {
            throw new IndexOutOfBoundsException("Key " + key + " is either greater or less than allowed key values.");
        }
        long tkey = key * 1000;
        this.map_.put(tkey, value);
    }

    @Override
    public void addLast(E value) {
        long key = -1L;
        if (this.size() > 0) {
            key = this.map_.lastKey();
            if (key < 1000000000L) {
                key = 1000000000L;
            }
        } else {
            key = 1000000000L;
        }
        this.map_.put(++key, value);
    }

    @Override
    public void addFirst(E value) {
        long key = -1L;
        if (this.size() > 0) {
            key = this.map_.firstKey();
            if (key > 0L) {
                key = 0L;
            }
        } else {
            key = 0L;
        }
        this.map_.put(--key, value);
    }

    public E replaceOrdered(int key, E value) {
        long tkey = key * 1000;
        return this.map_.replace(tkey, value);
    }

    public Collection<E> values() {
        return this.map_.values();
    }

    @Override
    public int size() {
        return this.map_.size();
    }

    @Override
    public boolean isEmpty() {
        return this.map_.isEmpty();
    }

    @Override
    public boolean contains(Object value) {
        return this.map_.containsValue(value);
    }

    @Override
    public Iterator<E> iterator() {
        return this.map_.values().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.map_.values().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.map_.values().toArray(a);
    }

    @Override
    public boolean add(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        int idx = this.indexOf(o);
        Object[] keys = this.map_.keySet().toArray();
        return this.map_.remove((Long)keys[idx]) != null;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        this.map_.clear();
    }

    @Override
    public E get(int index) {
        long key = this.getKeyFromIndex(index);
        return this.map_.get(key);
    }

    @Override
    public E set(int index, E element) {
        long key = this.getKeyFromIndex(index);
        return this.map_.replace(key, element);
    }

    @Override
    public void add(int index, E element) {
        long key0 = this.getKeyFromIndex(index - 1);
        long key1 = this.getKeyFromIndex(index);
        long key = (key0 + key1) / 2L;
        this.map_.put(key, element);
    }

    @Override
    public E remove(int index) {
        long key = this.getKeyFromIndex(index);
        return this.map_.remove(key);
    }

    @Override
    public int indexOf(Object o) {
        Collection<E> vals = this.map_.values();
        int indx = 0;
        for (E v : vals) {
            if (v.equals(o)) {
                return indx;
            }
            ++indx;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        Object[] varr = this.map_.values().toArray();
        for (int i = varr.length - 1; i >= 0; --i) {
            if (!varr[i].equals(o)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public ListIterator<E> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        Vector<E> ve = new Vector<E>(this.map_.values());
        return ve.subList(fromIndex, toIndex);
    }

    private long getKeyFromIndex(int index) {
        Object[] keys = this.map_.keySet().toArray();
        return (Long)keys[index];
    }

    public String toString() {
        return "OrderedList: " + this.map_.toString();
    }
}

