/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.util;

import gov.noaa.pmel.util.Domain;
import gov.noaa.pmel.util.SoTPoint;
import gov.noaa.pmel.util.SoTRange;
import gov.noaa.pmel.util.SoTValue;
import java.io.Serializable;

public class SoTDomain
implements Serializable {
    SoTRange xRange_ = null;
    SoTRange yRange_ = null;
    boolean xReversed_ = false;
    boolean yReversed_ = false;

    public SoTDomain() {
    }

    public SoTDomain(Domain domain) {
        this.xRange_ = domain.isXTime() ? new SoTRange.Time(domain.getTimeRange()) : new SoTRange.Double(domain.getXRange());
        this.yRange_ = domain.isYTime() ? new SoTRange.Time(domain.getTimeRange()) : new SoTRange.Double(domain.getYRange());
        this.xReversed_ = domain.isXReversed();
        this.yReversed_ = domain.isYReversed();
    }

    public SoTDomain(SoTDomain domain) {
        this.xRange_ = domain.getXRange();
        this.yRange_ = domain.getYRange();
        this.xReversed_ = domain.isXReversed();
        this.yReversed_ = domain.isYReversed();
    }

    public SoTDomain(SoTRange xRange, SoTRange yRange) {
        this.xRange_ = xRange;
        this.yRange_ = yRange;
        this.xReversed_ = false;
        this.yReversed_ = false;
    }

    public SoTDomain(SoTRange xRange, SoTRange yRange, boolean xRev, boolean yRev) {
        this.xRange_ = xRange;
        this.yRange_ = yRange;
        this.xReversed_ = xRev;
        this.yReversed_ = yRev;
    }

    public void setXRange(SoTRange xRange) {
        this.xRange_ = xRange;
    }

    public SoTRange getXRange() {
        return this.xRange_;
    }

    public void setYRange(SoTRange yRange) {
        this.yRange_ = yRange;
    }

    public SoTRange getYRange() {
        return this.yRange_;
    }

    public boolean isXTime() {
        return this.xRange_.isTime();
    }

    public boolean isYTime() {
        return this.yRange_.isTime();
    }

    public SoTPoint getCenter() {
        SoTValue xVal = null;
        SoTValue yVal = null;
        xVal = this.isXTime() ? new SoTValue.Time((this.xRange_.getStart().getLongTime() + this.xRange_.getEnd().getLongTime()) / 2L) : new SoTValue.Double((((Number)this.xRange_.getStart().getObjectValue()).doubleValue() + ((Number)this.xRange_.getEnd().getObjectValue()).doubleValue()) / 2.0);
        yVal = this.isYTime() ? new SoTValue.Time((this.yRange_.getStart().getLongTime() + this.yRange_.getEnd().getLongTime()) / 2L) : new SoTValue.Double((((Number)this.yRange_.getStart().getObjectValue()).doubleValue() + ((Number)this.yRange_.getEnd().getObjectValue()).doubleValue()) / 2.0);
        return new SoTPoint(xVal, yVal);
    }

    public boolean equals(SoTDomain d) {
        if (!this.xRange_.equals(d.getXRange())) {
            return false;
        }
        if (!this.yRange_.equals(d.getYRange())) {
            return false;
        }
        if (this.xReversed_ != d.isXReversed()) {
            return false;
        }
        return this.yReversed_ == d.isYReversed();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(100);
        buf.append("x=");
        buf.append(this.xRange_).append(",y=");
        buf.append(this.yRange_);
        buf.append(", xRev=").append(this.xReversed_);
        buf.append(", yRev=").append(this.yReversed_);
        return buf.toString();
    }

    public void setXReversed(boolean rev) {
        this.xReversed_ = rev;
    }

    public boolean isXReversed() {
        return this.xReversed_;
    }

    public void setYReversed(boolean rev) {
        this.yReversed_ = rev;
    }

    public boolean isYReversed() {
        return this.yReversed_;
    }
}

