/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.util;

import gov.noaa.pmel.util.Range;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.SoTValue;
import gov.noaa.pmel.util.TimeRange;
import java.io.Serializable;

public class SoTRange
implements Serializable,
Cloneable {
    SoTRange inner_;

    public SoTRange(SoTValue a, SoTValue b) {
        if (a.getClass() != b.getClass()) {
            throw new RuntimeException("Both arguments to constructor must be same class");
        }
        if (a instanceof SoTValue.Double) {
            this.inner_ = new Double(((SoTValue.Double)a).value_, ((SoTValue.Double)b).value_);
        } else if (a instanceof SoTValue.Float) {
            this.inner_ = new Float(((SoTValue.Float)a).value_, ((SoTValue.Float)b).value_);
        } else if (a instanceof SoTValue.GeoDate) {
            this.inner_ = new GeoDate(((SoTValue.GeoDate)a).date_, ((SoTValue.GeoDate)b).date_);
        } else if (a instanceof SoTValue.Integer) {
            this.inner_ = new Integer(((SoTValue.Integer)a).value_, ((SoTValue.Integer)b).value_);
        } else if (a instanceof SoTValue.Short) {
            this.inner_ = new Short(((SoTValue.Short)a).value_, ((SoTValue.Short)b).value_);
        } else if (a instanceof SoTValue.Time) {
            this.inner_ = new Time(((SoTValue.Time)a).value_, ((SoTValue.Time)b).value_);
        } else {
            throw new RuntimeException("SoTRange constructor for class " + a.getClass().getName() + " not supported");
        }
    }

    public SoTRange(double a, double b) {
        this.inner_ = new Double(a, b);
    }

    protected SoTRange() {
    }

    public boolean isTime() {
        return this.inner_.isTime();
    }

    public String toString() {
        return this.inner_.toString();
    }

    public boolean equals(SoTRange range) {
        if (range == this) {
            return true;
        }
        if (!(range instanceof SoTRange)) {
            return false;
        }
        return this.inner_.equals(range.inner_);
    }

    public void add(SoTRange range) {
        this.inner_.add(range);
    }

    public SoTValue getStart() {
        return this.inner_.getStart();
    }

    public SoTValue getEnd() {
        return this.inner_.getEnd();
    }

    public SoTValue getDelta() {
        return this.inner_.getDelta();
    }

    public Object getStartObject() {
        return this.inner_.getStartObject();
    }

    public Object getEndObject() {
        return this.inner_.getEndObject();
    }

    public Object getDeltaObject() {
        return this.inner_.getDeltaObject();
    }

    public void setStart(SoTValue value) {
        this.inner_.setStart(value);
    }

    public void setEnd(SoTValue value) {
        this.inner_.setEnd(value);
    }

    public void setDelta(SoTValue value) {
        this.inner_.setDelta(value);
    }

    public void flipStartAndEnd() {
        this.inner_.flipStartAndEnd();
    }

    public boolean isStartOrEndMissing() {
        return this.inner_.isStartOrEndMissing();
    }

    public SoTRange copy() {
        return this.inner_.copy();
    }

    public static class Double
    extends SoTRange {
        public double start;
        public double end;
        public double delta;

        public Double() {
            this(java.lang.Double.NaN, java.lang.Double.NaN, java.lang.Double.NaN);
        }

        public Double(double ustart, double uend) {
            this(ustart, uend, java.lang.Double.NaN);
        }

        public Double(double ustart, double uend, double udel) {
            this.start = ustart;
            this.end = uend;
            this.delta = udel;
            this.inner_ = this;
        }

        public Double(Range2D range) {
            this.start = range.start;
            this.end = range.end;
            this.delta = range.delta;
            this.inner_ = this;
        }

        @Override
        public SoTValue getStart() {
            return new SoTValue.Double(this.start);
        }

        @Override
        public void setStart(SoTValue value) {
            this.start = ((SoTValue.Double)value).getValue();
        }

        @Override
        public SoTValue getEnd() {
            return new SoTValue.Double(this.end);
        }

        @Override
        public void setEnd(SoTValue value) {
            this.end = ((SoTValue.Double)value).getValue();
        }

        @Override
        public SoTValue getDelta() {
            return new SoTValue.Double(this.delta);
        }

        @Override
        public void setDelta(SoTValue value) {
            this.delta = ((SoTValue.Double)value).getValue();
        }

        @Override
        public Object getStartObject() {
            return new java.lang.Double(this.start);
        }

        @Override
        public Object getEndObject() {
            return new java.lang.Double(this.end);
        }

        @Override
        public Object getDeltaObject() {
            return new java.lang.Double(this.delta);
        }

        @Override
        public void add(SoTRange range) {
            if (range.isTime()) {
                return;
            }
            if (this.start <= this.end && ((Double)range).start <= ((Double)range).end) {
                this.start = Math.min(this.start, ((Double)range).start);
                this.end = Math.max(this.end, ((Double)range).end);
            } else {
                this.start = Math.max(this.start, ((Double)range).start);
                this.end = Math.min(this.end, ((Double)range).end);
            }
        }

        @Override
        public boolean equals(SoTRange r) {
            if (r.isTime()) {
                return false;
            }
            double rstart = ((Double)r).start;
            double rend = ((Double)r).end;
            double rdelta = ((Double)r).delta;
            if (!java.lang.Double.isNaN(this.start) && !java.lang.Double.isNaN(rstart)) {
                if (java.lang.Double.isNaN(this.start) || java.lang.Double.isNaN(rstart)) {
                    return false;
                }
                if (this.start != rstart) {
                    return false;
                }
            }
            if (!java.lang.Double.isNaN(this.end) && !java.lang.Double.isNaN(rend)) {
                if (java.lang.Double.isNaN(this.end) || java.lang.Double.isNaN(rend)) {
                    return false;
                }
                if (this.end != rend) {
                    return false;
                }
            }
            if (!java.lang.Double.isNaN(this.delta) && !java.lang.Double.isNaN(rdelta)) {
                if (java.lang.Double.isNaN(this.delta) || java.lang.Double.isNaN(rdelta)) {
                    return false;
                }
                if (this.delta != rdelta) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public boolean isTime() {
            return false;
        }

        @Override
        public void flipStartAndEnd() {
            double save = this.end;
            this.end = this.start;
            this.start = save;
        }

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer(50);
            buf.append("[").append(this.start).append(";").append(this.end);
            if (java.lang.Double.isNaN(this.delta)) {
                buf.append("]");
            } else {
                buf.append(";").append(this.delta).append("]");
            }
            return buf.toString();
        }

        @Override
        public SoTRange copy() {
            try {
                return (SoTRange)this.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        @Override
        public boolean isStartOrEndMissing() {
            return java.lang.Double.isNaN(this.start) || java.lang.Double.isNaN(this.end);
        }
    }

    public static class Float
    extends SoTRange {
        public float start;
        public float end;
        public float delta;

        public Float() {
            this(java.lang.Float.NaN, java.lang.Float.NaN, java.lang.Float.NaN);
        }

        public Float(float ustart, float uend) {
            this(ustart, uend, java.lang.Float.NaN);
        }

        public Float(float ustart, float uend, float udel) {
            this.start = ustart;
            this.end = uend;
            this.delta = udel;
            this.inner_ = this;
        }

        @Override
        public SoTValue getStart() {
            return new SoTValue.Float(this.start);
        }

        @Override
        public void setStart(SoTValue value) {
            this.start = ((SoTValue.Float)value).getValue();
        }

        @Override
        public SoTValue getEnd() {
            return new SoTValue.Float(this.end);
        }

        @Override
        public void setEnd(SoTValue value) {
            this.end = ((SoTValue.Float)value).getValue();
        }

        @Override
        public SoTValue getDelta() {
            return new SoTValue.Float(this.delta);
        }

        @Override
        public void setDelta(SoTValue value) {
            this.delta = ((SoTValue.Float)value).getValue();
        }

        @Override
        public Object getStartObject() {
            return new java.lang.Float(this.start);
        }

        @Override
        public Object getEndObject() {
            return new java.lang.Float(this.end);
        }

        @Override
        public Object getDeltaObject() {
            return new java.lang.Float(this.delta);
        }

        @Override
        public void add(SoTRange range) {
            if (range.isTime()) {
                return;
            }
            if (this.start <= this.end && ((Float)range).start <= ((Float)range).end) {
                this.start = Math.min(this.start, ((Float)range).start);
                this.end = Math.max(this.end, ((Float)range).end);
            } else {
                this.start = Math.max(this.start, ((Float)range).start);
                this.end = Math.min(this.end, ((Float)range).end);
            }
        }

        @Override
        public boolean equals(SoTRange r) {
            if (r.isTime()) {
                return false;
            }
            float rstart = ((Float)r).start;
            float rend = ((Float)r).end;
            float rdelta = ((Float)r).delta;
            if (!java.lang.Float.isNaN(this.start) && !java.lang.Float.isNaN(rstart)) {
                if (java.lang.Float.isNaN(this.start) || java.lang.Float.isNaN(rstart)) {
                    return false;
                }
                if (this.start != rstart) {
                    return false;
                }
            }
            if (!java.lang.Float.isNaN(this.end) && !java.lang.Float.isNaN(rend)) {
                if (java.lang.Float.isNaN(this.end) || java.lang.Float.isNaN(rend)) {
                    return false;
                }
                if (this.end != rend) {
                    return false;
                }
            }
            if (!java.lang.Float.isNaN(this.delta) && !java.lang.Float.isNaN(rdelta)) {
                if (java.lang.Float.isNaN(this.delta) || java.lang.Float.isNaN(rdelta)) {
                    return false;
                }
                if (this.delta != rdelta) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public boolean isTime() {
            return false;
        }

        @Override
        public void flipStartAndEnd() {
            float save = this.end;
            this.end = this.start;
            this.start = save;
        }

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer(50);
            buf.append("[").append(this.start).append(";").append(this.end);
            if (java.lang.Float.isNaN(this.delta)) {
                buf.append("]");
            } else {
                buf.append(";").append(this.delta).append("]");
            }
            return buf.toString();
        }

        @Override
        public SoTRange copy() {
            try {
                return (SoTRange)this.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        @Override
        public boolean isStartOrEndMissing() {
            return java.lang.Float.isNaN(this.start) || java.lang.Float.isNaN(this.end);
        }
    }

    public static class GeoDate
    extends SoTRange {
        public gov.noaa.pmel.util.GeoDate start = null;
        public gov.noaa.pmel.util.GeoDate end = null;
        public gov.noaa.pmel.util.GeoDate delta = null;

        public GeoDate() {
        }

        public GeoDate(gov.noaa.pmel.util.GeoDate tstart, gov.noaa.pmel.util.GeoDate tend) {
            this(tstart, tend, null);
        }

        public GeoDate(gov.noaa.pmel.util.GeoDate tstart, gov.noaa.pmel.util.GeoDate tend, gov.noaa.pmel.util.GeoDate tdelta) {
            this.start = tstart;
            this.end = tend;
            this.delta = tdelta;
            this.inner_ = this;
        }

        public GeoDate(TimeRange trange) {
            this.start = new gov.noaa.pmel.util.GeoDate(trange.start.getTime());
            this.end = new gov.noaa.pmel.util.GeoDate(trange.end.getTime());
            this.delta = trange.delta != null ? new gov.noaa.pmel.util.GeoDate(trange.delta.getTime()) : null;
            this.inner_ = this;
        }

        @Override
        public SoTValue getStart() {
            return new SoTValue.GeoDate(this.start);
        }

        @Override
        public void setStart(SoTValue value) {
            this.start = ((SoTValue.GeoDate)value).getValue();
        }

        @Override
        public SoTValue getEnd() {
            return new SoTValue.GeoDate(this.end);
        }

        @Override
        public void setEnd(SoTValue value) {
            this.end = ((SoTValue.GeoDate)value).getValue();
        }

        @Override
        public SoTValue getDelta() {
            return new SoTValue.GeoDate(this.delta);
        }

        @Override
        public void setDelta(SoTValue value) {
            this.delta = ((SoTValue.GeoDate)value).getValue();
        }

        @Override
        public Object getStartObject() {
            return this.start;
        }

        @Override
        public Object getEndObject() {
            return this.end;
        }

        @Override
        public Object getDeltaObject() {
            return this.delta;
        }

        @Override
        public void add(SoTRange tr) {
            if (!tr.isTime()) {
                return;
            }
            GeoDate tRange = (GeoDate)tr;
            if (tRange.start.before(this.start)) {
                this.start = tRange.start;
            }
            if (tRange.end.after(this.end)) {
                this.end = tRange.end;
            }
        }

        @Override
        public boolean equals(SoTRange tr) {
            if (!tr.isTime()) {
                return false;
            }
            GeoDate tRange = (GeoDate)tr;
            if (this.start != null && tRange.start != null) {
                if (!this.start.equals(tRange.start)) {
                    return false;
                }
            } else {
                return false;
            }
            if (this.end != null && tRange.end != null) {
                if (!this.end.equals(tRange.end)) {
                    return false;
                }
            } else {
                return false;
            }
            if (this.delta != null && tRange.delta != null) {
                return this.delta.equals(tRange.delta);
            }
            return this.delta == null && tRange.delta == null;
        }

        @Override
        public boolean isTime() {
            return true;
        }

        @Override
        public void flipStartAndEnd() {
            gov.noaa.pmel.util.GeoDate save = this.end;
            this.end = this.start;
            this.start = save;
        }

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer(50);
            buf.append("[").append(this.start).append(";").append(this.end);
            if (this.delta == null) {
                buf.append("]");
            } else {
                buf.append(";").append(this.delta).append("]");
            }
            return buf.toString();
        }

        @Override
        public SoTRange copy() {
            gov.noaa.pmel.util.GeoDate cStart = null;
            gov.noaa.pmel.util.GeoDate cEnd = null;
            gov.noaa.pmel.util.GeoDate cDelta = null;
            if (this.start != null) {
                cStart = new gov.noaa.pmel.util.GeoDate(this.start.getTime());
            }
            if (this.end != null) {
                cEnd = new gov.noaa.pmel.util.GeoDate(this.end.getTime());
            }
            if (this.delta != null) {
                cDelta = new gov.noaa.pmel.util.GeoDate(this.delta.getTime());
            }
            GeoDate cRange = new GeoDate(cStart, cEnd, cDelta);
            return cRange;
        }

        @Override
        public boolean isStartOrEndMissing() {
            if (this.start == null || this.end == null) {
                return true;
            }
            return this.start.isMissing() || this.end.isMissing();
        }
    }

    public static class Integer
    extends SoTRange {
        public int start;
        public int end;
        public int delta;

        public Integer() {
            this(java.lang.Integer.MAX_VALUE, java.lang.Integer.MAX_VALUE, java.lang.Integer.MAX_VALUE);
        }

        public Integer(int ustart, int uend) {
            this(ustart, uend, java.lang.Integer.MAX_VALUE);
        }

        public Integer(int ustart, int uend, int udel) {
            this.start = ustart;
            this.end = uend;
            this.delta = udel;
            this.inner_ = this;
        }

        public Integer(Range range) {
            this.start = range.start;
            this.end = range.end;
            this.delta = java.lang.Integer.MAX_VALUE;
            this.inner_ = this;
        }

        @Override
        public SoTValue getStart() {
            return new SoTValue.Integer(this.start);
        }

        @Override
        public void setStart(SoTValue value) {
            this.start = ((SoTValue.Integer)value).getValue();
        }

        @Override
        public SoTValue getEnd() {
            return new SoTValue.Integer(this.end);
        }

        @Override
        public void setEnd(SoTValue value) {
            this.end = ((SoTValue.Integer)value).getValue();
        }

        @Override
        public SoTValue getDelta() {
            return new SoTValue.Integer(this.delta);
        }

        @Override
        public void setDelta(SoTValue value) {
            this.delta = ((SoTValue.Integer)value).getValue();
        }

        @Override
        public Object getStartObject() {
            return new java.lang.Integer(this.start);
        }

        @Override
        public Object getEndObject() {
            return new java.lang.Integer(this.end);
        }

        @Override
        public Object getDeltaObject() {
            return new java.lang.Integer(this.delta);
        }

        @Override
        public void add(SoTRange range) {
            if (range.isTime()) {
                return;
            }
            if (this.start <= this.end && ((Integer)range).start <= ((Integer)range).end) {
                this.start = Math.min(this.start, ((Integer)range).start);
                this.end = Math.max(this.end, ((Integer)range).end);
            } else {
                this.start = Math.max(this.start, ((Integer)range).start);
                this.end = Math.min(this.end, ((Integer)range).end);
            }
        }

        @Override
        public boolean equals(SoTRange r) {
            if (r.isTime()) {
                return false;
            }
            int rstart = ((Integer)r).start;
            int rend = ((Integer)r).end;
            int rdelta = ((Integer)r).delta;
            if (this.start != java.lang.Integer.MAX_VALUE && rstart != java.lang.Integer.MAX_VALUE) {
                if (this.start == java.lang.Integer.MAX_VALUE || rstart == java.lang.Integer.MAX_VALUE) {
                    return false;
                }
                if (this.start != rstart) {
                    return false;
                }
            }
            if (this.end != java.lang.Integer.MAX_VALUE && rend != java.lang.Integer.MAX_VALUE) {
                if (this.end == java.lang.Integer.MAX_VALUE || rend == java.lang.Integer.MAX_VALUE) {
                    return false;
                }
                if (this.end != rend) {
                    return false;
                }
            }
            if (this.delta != java.lang.Integer.MAX_VALUE && rdelta != java.lang.Integer.MAX_VALUE) {
                if (this.delta == java.lang.Integer.MAX_VALUE || rdelta == java.lang.Integer.MAX_VALUE) {
                    return false;
                }
                if (this.delta != rdelta) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public boolean isTime() {
            return false;
        }

        @Override
        public void flipStartAndEnd() {
            int save = this.end;
            this.end = this.start;
            this.start = save;
        }

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer(50);
            buf.append("[").append(this.start).append(";").append(this.end);
            if (this.delta == java.lang.Integer.MAX_VALUE) {
                buf.append("]");
            } else {
                buf.append(";").append(this.delta).append("]");
            }
            return buf.toString();
        }

        @Override
        public SoTRange copy() {
            try {
                return (SoTRange)this.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        @Override
        public boolean isStartOrEndMissing() {
            return this.start == java.lang.Integer.MAX_VALUE || this.end == java.lang.Integer.MAX_VALUE;
        }
    }

    public static class Short
    extends SoTRange {
        public short start;
        public short end;
        public short delta;

        public Short() {
            this(java.lang.Short.MAX_VALUE, java.lang.Short.MAX_VALUE, java.lang.Short.MAX_VALUE);
        }

        public Short(short ustart, short uend) {
            this(ustart, uend, java.lang.Short.MAX_VALUE);
        }

        public Short(short ustart, short uend, short udel) {
            this.start = ustart;
            this.end = uend;
            this.delta = udel;
            this.inner_ = this;
        }

        @Override
        public SoTValue getStart() {
            return new SoTValue.Short(this.start);
        }

        @Override
        public void setStart(SoTValue value) {
            this.start = ((SoTValue.Short)value).getValue();
        }

        @Override
        public SoTValue getEnd() {
            return new SoTValue.Short(this.end);
        }

        @Override
        public void setEnd(SoTValue value) {
            this.end = ((SoTValue.Short)value).getValue();
        }

        @Override
        public SoTValue getDelta() {
            return new SoTValue.Short(this.delta);
        }

        @Override
        public void setDelta(SoTValue value) {
            this.delta = ((SoTValue.Short)value).getValue();
        }

        @Override
        public Object getStartObject() {
            return new java.lang.Short(this.start);
        }

        @Override
        public Object getEndObject() {
            return new java.lang.Short(this.end);
        }

        @Override
        public Object getDeltaObject() {
            return new java.lang.Short(this.delta);
        }

        @Override
        public void add(SoTRange range) {
            if (range.isTime()) {
                return;
            }
            if (this.start <= this.end && ((Short)range).start <= ((Short)range).end) {
                this.start = (short)Math.min(this.start, ((Short)range).start);
                this.end = (short)Math.max(this.end, ((Short)range).end);
            } else {
                this.start = (short)Math.max(this.start, ((Short)range).start);
                this.end = (short)Math.min(this.end, ((Short)range).end);
            }
        }

        @Override
        public boolean equals(SoTRange r) {
            if (r.isTime()) {
                return false;
            }
            short rstart = ((Short)r).start;
            short rend = ((Short)r).end;
            short rdelta = ((Short)r).delta;
            if (this.start != java.lang.Short.MAX_VALUE && rstart != java.lang.Short.MAX_VALUE) {
                if (this.start == java.lang.Short.MAX_VALUE || rstart == java.lang.Short.MAX_VALUE) {
                    return false;
                }
                if (this.start != rstart) {
                    return false;
                }
            }
            if (this.end != java.lang.Short.MAX_VALUE && rend != java.lang.Short.MAX_VALUE) {
                if (this.end == java.lang.Short.MAX_VALUE || rend == java.lang.Short.MAX_VALUE) {
                    return false;
                }
                if (this.end != rend) {
                    return false;
                }
            }
            if (this.delta != java.lang.Short.MAX_VALUE && rdelta != java.lang.Short.MAX_VALUE) {
                if (this.delta == java.lang.Short.MAX_VALUE || rdelta == java.lang.Short.MAX_VALUE) {
                    return false;
                }
                if (this.delta != rdelta) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public boolean isTime() {
            return false;
        }

        @Override
        public void flipStartAndEnd() {
            short save = this.end;
            this.end = this.start;
            this.start = save;
        }

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer(50);
            buf.append("[").append(this.start).append(";").append(this.end);
            if (this.delta == java.lang.Short.MAX_VALUE) {
                buf.append("]");
            } else {
                buf.append(";").append(this.delta).append("]");
            }
            return buf.toString();
        }

        @Override
        public SoTRange copy() {
            try {
                return (SoTRange)this.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        @Override
        public boolean isStartOrEndMissing() {
            return this.start == java.lang.Short.MAX_VALUE || this.end == java.lang.Short.MAX_VALUE;
        }
    }

    public static class Time
    extends SoTRange {
        public long start;
        public long end;
        public long delta;

        public Time() {
            this(java.lang.Long.MAX_VALUE, java.lang.Long.MAX_VALUE, java.lang.Long.MAX_VALUE);
        }

        public Time(long ustart, long uend) {
            this(ustart, uend, java.lang.Long.MAX_VALUE);
        }

        public Time(gov.noaa.pmel.util.GeoDate ustart, gov.noaa.pmel.util.GeoDate uend) {
            this(ustart.getTime(), uend.getTime(), java.lang.Long.MAX_VALUE);
        }

        public Time(long ustart, long uend, long udel) {
            this.start = ustart;
            this.end = uend;
            this.delta = udel;
            this.inner_ = this;
        }

        public Time(gov.noaa.pmel.util.GeoDate ustart, gov.noaa.pmel.util.GeoDate uend, gov.noaa.pmel.util.GeoDate udel) {
            this(ustart.getTime(), uend.getTime(), udel.getTime());
        }

        public Time(TimeRange trange) {
            this.start = trange.start.getTime();
            this.end = trange.end.getTime();
            this.delta = trange.delta != null ? trange.delta.getTime() : java.lang.Long.MAX_VALUE;
            this.inner_ = this;
        }

        public Time(GeoDate trange) {
            this(trange.start, trange.end, trange.delta);
        }

        public Time(Time trange) {
            this(trange.start, trange.end, trange.delta);
        }

        @Override
        public SoTValue getStart() {
            return new SoTValue.Time(this.start);
        }

        @Override
        public void setStart(SoTValue value) {
            this.start = ((SoTValue.Time)value).getValue();
        }

        @Override
        public SoTValue getEnd() {
            return new SoTValue.Time(this.end);
        }

        @Override
        public void setEnd(SoTValue value) {
            this.end = ((SoTValue.Time)value).getValue();
        }

        @Override
        public SoTValue getDelta() {
            return new SoTValue.Time(this.delta);
        }

        @Override
        public void setDelta(SoTValue value) {
            this.delta = ((SoTValue.Time)value).getValue();
        }

        @Override
        public Object getStartObject() {
            return new java.lang.Long(this.start);
        }

        @Override
        public Object getEndObject() {
            return new java.lang.Long(this.end);
        }

        @Override
        public Object getDeltaObject() {
            return new java.lang.Long(this.delta);
        }

        @Override
        public void add(SoTRange range) {
            if (!range.isTime()) {
                return;
            }
            if (this.start <= this.end && ((Time)range).start <= ((Time)range).end) {
                this.start = Math.min(this.start, ((Time)range).start);
                this.end = Math.max(this.end, ((Time)range).end);
            } else {
                this.start = Math.max(this.start, ((Time)range).start);
                this.end = Math.min(this.end, ((Time)range).end);
            }
        }

        @Override
        public boolean equals(SoTRange r) {
            if (!r.isTime()) {
                return false;
            }
            long rstart = ((Time)r).start;
            long rend = ((Time)r).end;
            long rdelta = ((Time)r).delta;
            if (this.start != java.lang.Long.MAX_VALUE && rstart != java.lang.Long.MAX_VALUE) {
                if (this.start == java.lang.Long.MAX_VALUE || rstart == java.lang.Long.MAX_VALUE) {
                    return false;
                }
                if (this.start != rstart) {
                    return false;
                }
            }
            if (this.end != java.lang.Long.MAX_VALUE && rend != java.lang.Long.MAX_VALUE) {
                if (this.end == java.lang.Long.MAX_VALUE || rend == java.lang.Long.MAX_VALUE) {
                    return false;
                }
                if (this.end != rend) {
                    return false;
                }
            }
            if (this.delta != java.lang.Long.MAX_VALUE && rdelta != java.lang.Long.MAX_VALUE) {
                if (this.delta == java.lang.Long.MAX_VALUE || rdelta == java.lang.Long.MAX_VALUE) {
                    return false;
                }
                if (this.delta != rdelta) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public boolean isTime() {
            return true;
        }

        @Override
        public void flipStartAndEnd() {
            long save = this.end;
            this.end = this.start;
            this.start = save;
        }

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer(50);
            buf.append("[").append(this.start).append(";").append(this.end);
            if (this.delta == java.lang.Long.MAX_VALUE) {
                buf.append("]");
            } else {
                buf.append(";").append(this.delta).append("]");
            }
            return buf.toString();
        }

        @Override
        public SoTRange copy() {
            try {
                return (SoTRange)this.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        @Override
        public boolean isStartOrEndMissing() {
            return this.start == java.lang.Long.MAX_VALUE || this.end == java.lang.Long.MAX_VALUE;
        }
    }

    public static class Long
    extends SoTRange {
        public long start;
        public long end;
        public long delta;

        public Long() {
            this(java.lang.Long.MAX_VALUE, java.lang.Long.MAX_VALUE, java.lang.Long.MAX_VALUE);
        }

        public Long(long ustart, long uend) {
            this(ustart, uend, java.lang.Long.MAX_VALUE);
        }

        public Long(long ustart, long uend, long udel) {
            this.start = ustart;
            this.end = uend;
            this.delta = udel;
        }

        public Long(Range range) {
            this.start = range.start;
            this.end = range.end;
            this.delta = java.lang.Long.MAX_VALUE;
        }

        @Override
        public SoTValue getStart() {
            return new SoTValue.Long(this.start);
        }

        @Override
        public void setStart(SoTValue value) {
            this.start = ((SoTValue.Long)value).getValue();
        }

        @Override
        public SoTValue getEnd() {
            return new SoTValue.Long(this.end);
        }

        @Override
        public void setEnd(SoTValue value) {
            this.end = ((SoTValue.Long)value).getValue();
        }

        @Override
        public SoTValue getDelta() {
            return new SoTValue.Long(this.delta);
        }

        @Override
        public void setDelta(SoTValue value) {
            this.delta = ((SoTValue.Long)value).getValue();
        }

        @Override
        public Object getStartObject() {
            return new java.lang.Long(this.start);
        }

        @Override
        public Object getEndObject() {
            return new java.lang.Long(this.end);
        }

        @Override
        public Object getDeltaObject() {
            return new java.lang.Long(this.delta);
        }

        @Override
        public void add(SoTRange range) {
            if (range.isTime()) {
                return;
            }
            if (this.start <= this.end && ((Long)range).start <= ((Long)range).end) {
                this.start = Math.min(this.start, ((Long)range).start);
                this.end = Math.max(this.end, ((Long)range).end);
            } else {
                this.start = Math.max(this.start, ((Long)range).start);
                this.end = Math.min(this.end, ((Long)range).end);
            }
        }

        @Override
        public boolean equals(SoTRange r) {
            if (r.isTime()) {
                return false;
            }
            long rstart = ((Long)r).start;
            long rend = ((Long)r).end;
            long rdelta = ((Long)r).delta;
            if (this.start != java.lang.Long.MAX_VALUE && rstart != java.lang.Long.MAX_VALUE) {
                if (this.start == java.lang.Long.MAX_VALUE || rstart == java.lang.Long.MAX_VALUE) {
                    return false;
                }
                if (this.start != rstart) {
                    return false;
                }
            }
            if (this.end != java.lang.Long.MAX_VALUE && rend != java.lang.Long.MAX_VALUE) {
                if (this.end == java.lang.Long.MAX_VALUE || rend == java.lang.Long.MAX_VALUE) {
                    return false;
                }
                if (this.end != rend) {
                    return false;
                }
            }
            if (this.delta != java.lang.Long.MAX_VALUE && rdelta != java.lang.Long.MAX_VALUE) {
                if (this.delta == java.lang.Long.MAX_VALUE || rdelta == java.lang.Long.MAX_VALUE) {
                    return false;
                }
                if (this.delta != rdelta) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public boolean isTime() {
            return false;
        }

        @Override
        public void flipStartAndEnd() {
            long save = this.end;
            this.end = this.start;
            this.start = save;
        }

        @Override
        public String toString() {
            StringBuffer buf = new StringBuffer(50);
            buf.append("[").append(this.start).append(";").append(this.end);
            if (this.delta == java.lang.Long.MAX_VALUE) {
                buf.append("]");
            } else {
                buf.append(";").append(this.delta).append("]");
            }
            return buf.toString();
        }

        @Override
        public SoTRange copy() {
            try {
                return (SoTRange)this.clone();
            }
            catch (CloneNotSupportedException e) {
                return null;
            }
        }

        @Override
        public boolean isStartOrEndMissing() {
            return this.start == java.lang.Long.MAX_VALUE || this.end == java.lang.Long.MAX_VALUE;
        }
    }
}

