/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.pmel.util;

import gov.noaa.pmel.util.GeoDate;
import java.io.Serializable;

public class TimeRange
implements Serializable {
    public GeoDate start;
    public GeoDate end;
    public GeoDate delta;

    public TimeRange() {
    }

    public TimeRange(GeoDate tstart, GeoDate tend) {
        this(tstart, tend, null);
    }

    public TimeRange(long start, long end) {
        this(new GeoDate(start), new GeoDate(end));
    }

    public TimeRange(GeoDate tstart, GeoDate tend, GeoDate tdelta) {
        this.start = tstart;
        this.end = tend;
        this.delta = tdelta;
    }

    public TimeRange(long start, long end, long delta) {
        this(new GeoDate(start), new GeoDate(end), new GeoDate(delta));
    }

    public void add(TimeRange trange) {
        if (trange.start.before(this.start)) {
            this.start = trange.start;
        }
        if (trange.end.after(this.end)) {
            this.end = trange.end;
        }
    }

    public boolean equals(TimeRange tr) {
        if (this.start != null && tr.start != null) {
            if (!this.start.equals(tr.start)) {
                return false;
            }
        } else {
            return false;
        }
        if (this.end != null && tr.end != null) {
            if (!this.end.equals(tr.end)) {
                return false;
            }
        } else {
            return false;
        }
        if (this.delta != null && tr.delta != null) {
            return this.delta.equals(tr.delta);
        }
        return false;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer(50);
        buf.append("[").append(this.start).append(";").append(this.end);
        if (this.delta == null) {
            buf.append("]");
        } else {
            buf.append(";").append(this.delta).append("]");
        }
        return buf.toString();
    }
}

