/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.analysis;

import gov.noaa.tsunami.analysis.AnalysisInterface;
import gov.noaa.tsunami.utility.units.Length;
import gov.noaa.tsunami.utility.units.Unit;

public class TravelTime
implements AnalysisInterface {
    public static double getDefaultQuantizationThreshold(double sumAlpha) {
        return TravelTime.getQuantizationThreshold(sumAlpha, 0.001, Length.centimeter);
    }

    public static double getQuantizationThreshold(double sumAlpha, double q, Unit<Length> qunit) {
        return sumAlpha * qunit.convertTo(Length.centimeter, q);
    }

    public static double getMaxAmplitudeThreshold(double max, Unit<Length> units) {
        return Math.abs(units.convertTo(Length.centimeter, max) * 0.05);
    }

    public static double getDeformationThreshold(double maximumDef, double localDef, Unit<Length> dunits, double hmax, Unit<Length> hunits) {
        double localAbsDef = dunits.convertTo(Length.centimeter, Math.abs(localDef));
        double maxAbsDef = dunits.convertTo(Length.centimeter, Math.abs(maximumDef));
        double absHmax = hunits.convertTo(Length.centimeter, Math.abs(hmax));
        if (localDef / maxAbsDef > 0.02) {
            return Math.min(3.0 * localAbsDef, absHmax / 7.0);
        }
        return 3.0 * localAbsDef;
    }

    public static int getTravelTimeIndice(double[] ts, Unit<Length> units, double quantThresh, double maxAmpThresh, double defThresh) {
        double pQT = 0.75 * quantThresh;
        double nQT = 1.25 * quantThresh;
        double pThresh = Math.max(pQT, maxAmpThresh);
        double nThresh = Math.max(nQT, maxAmpThresh);
        pThresh = Math.max(pThresh, defThresh);
        nThresh = Math.max(nThresh, defThresh);
        pThresh = Math.min(30.0, Math.max(0.0, pThresh));
        nThresh = Math.min(30.0, Math.max(0.0, nThresh));
        int ttindice = -1;
        for (int i = 0; i < ts.length; ++i) {
            if (Double.isNaN(ts[i])) continue;
            double hval = units.convertTo(Length.centimeter, ts[i]);
            double thresh = hval > 0.0 ? pThresh : nThresh;
            if (!(Math.abs(hval) >= thresh)) continue;
            ttindice = i;
            break;
        }
        return ttindice;
    }

    public static int getTravelTimeIndice(float[] ts, Unit<Length> units, double quantThresh, double maxAmpThresh, double defThresh) {
        double pQT = 0.75 * quantThresh;
        double nQT = 1.25 * quantThresh;
        double pThresh = Math.max(pQT, maxAmpThresh);
        double nThresh = Math.max(nQT, maxAmpThresh);
        pThresh = Math.max(pThresh, defThresh);
        nThresh = Math.max(nThresh, defThresh);
        pThresh = Math.min(30.0, Math.max(0.0, pThresh));
        nThresh = Math.min(30.0, Math.max(0.0, nThresh));
        int ttindice = -1;
        for (int i = 0; i < ts.length; ++i) {
            if (Float.isNaN(ts[i])) continue;
            double hval = units.convertTo(Length.centimeter, ts[i]);
            double thresh = hval > 0.0 ? pThresh : nThresh;
            if (!(Math.abs(hval) >= thresh)) continue;
            ttindice = i;
            break;
        }
        return ttindice;
    }
}

