/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.tsunami.cmi.AbstractGridTool;
import gov.noaa.tsunami.cmi.BathyGrid;
import gov.noaa.tsunami.cmi.CMIUtil;
import gov.noaa.tsunami.cmi.GridSelectorPanel;
import gov.noaa.tsunami.cmi.SiftShare;
import gov.noaa.tsunami.cmi.SiteInfo;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.NumberFormatter;
import org.jdesktop.layout.GroupLayout;

public class BathyCropTool
extends AbstractGridTool
implements PropertyChangeListener {
    private String gridDir = "";
    private int gridIdent = 1;
    private final DecimalFormat dfx = new DecimalFormat("0.0");
    private final DecimalFormat dfxxxxx = new DecimalFormat("0.00000");
    private BathyGrid bathyGrid;
    private SiteInfo siteInfo;
    private final NumberFormatter nfr1;
    private final NumberFormatter nf1;
    private final NumberFormatter nf5;
    private JButton cancelButton;
    private JButton goButton;
    private GridSelectorPanel gridSelectorPanel1;
    private JComboBox<String> jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JTextArea jTextArea1;
    private JTextField outfileTextField;
    private JFormattedTextField xeastTextField;
    private JFormattedTextField xwestTextField;
    private JFormattedTextField ynorthTextField;
    private JFormattedTextField ysouthTextField;

    public BathyCropTool(Frame parent, SiteInfo siteInfo) {
        super(parent);
        this.setLocationRelativeTo(parent);
        this.nfr1 = new NumberFormatter(this.dfx);
        this.nfr1.setAllowsInvalid(false);
        this.nfr1.setMaximum(Double.valueOf(1.0));
        this.nfr1.setMinimum(Double.valueOf(0.0));
        this.nf1 = new NumberFormatter(this.dfx);
        this.nf1.setAllowsInvalid(false);
        this.nf5 = new NumberFormatter(this.dfxxxxx);
        this.nf5.setAllowsInvalid(false);
        this.initComponents();
        this.getContentPane().setBackground(Color.WHITE);
        this.setSite(siteInfo);
        this.gridSelectorPanel1.addPropertyChangeListener(this);
    }

    private void initComponents() {
        this.goButton = new JButton();
        this.cancelButton = new JButton();
        JSplitPane jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jLabel6 = new JLabel();
        this.jLabel5 = new JLabel();
        this.outfileTextField = new JTextField();
        this.gridSelectorPanel1 = new GridSelectorPanel();
        this.jLabel1 = new JLabel();
        this.ynorthTextField = new JFormattedTextField(this.nf5);
        this.xwestTextField = new JFormattedTextField(this.nf5);
        this.xeastTextField = new JFormattedTextField(this.nf5);
        this.ysouthTextField = new JFormattedTextField(this.nf5);
        this.jComboBox1 = new JComboBox();
        JScrollPane jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.setTitle("Bathymetry Crop Tool");
        this.goButton.setText("Crop");
        this.goButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BathyCropTool.this.goButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Quit");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BathyCropTool.this.cancelButtonActionPerformed(evt);
            }
        });
        jSplitPane1.setOrientation(0);
        jSplitPane1.setOneTouchExpandable(true);
        this.jPanel1.setBackground(Color.white);
        this.jPanel1.setMinimumSize(new Dimension(525, 348));
        this.jLabel6.setText("Output filename:");
        this.jLabel5.setText("Input filename:");
        this.outfileTextField.setHorizontalAlignment(2);
        this.outfileTextField.setText("outfilename");
        this.jLabel1.setText("Extents:");
        this.ynorthTextField.setColumns(8);
        this.ynorthTextField.setHorizontalAlignment(0);
        this.ynorthTextField.setText("90.00000");
        this.xwestTextField.setColumns(8);
        this.xwestTextField.setHorizontalAlignment(0);
        this.xwestTextField.setText("0.00000");
        this.xeastTextField.setColumns(8);
        this.xeastTextField.setHorizontalAlignment(0);
        this.xeastTextField.setText("360.00000");
        this.ysouthTextField.setColumns(8);
        this.ysouthTextField.setHorizontalAlignment(0);
        this.ysouthTextField.setText("90.00000");
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"infileName1"}));
        this.jComboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BathyCropTool.this.jComboBox1ActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(this.gridSelectorPanel1, -2, -1, -2).add(0, 0, Short.MAX_VALUE)).add(jPanel1Layout.createSequentialGroup().add(14, 14, 14).add(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(142, 142, 142).add(jPanel1Layout.createParallelGroup(2).add(jPanel1Layout.createSequentialGroup().add(this.jLabel1).addPreferredGap(0).add(this.xwestTextField, -2, -1, -2).add(3, 3, 3).add(this.xeastTextField, -2, -1, -2)).add(jPanel1Layout.createSequentialGroup().add(this.ynorthTextField, -2, -1, -2).add(51, 51, 51)).add(jPanel1Layout.createSequentialGroup().add(this.ysouthTextField, -2, -1, -2).add(49, 49, 49))).add(74, 74, 74)).add(jPanel1Layout.createSequentialGroup().add(jPanel1Layout.createParallelGroup(1).add(this.jLabel5).add(this.jLabel6)).add(18, 18, 18).add(jPanel1Layout.createParallelGroup(2).add(this.outfileTextField, -1, 381, Short.MAX_VALUE).add(this.jComboBox1, 0, 381, Short.MAX_VALUE)))))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(this.gridSelectorPanel1, -2, -1, -2).add(18, 18, 18).add(this.ynorthTextField, -2, -1, -2).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(3).add(this.jLabel1).add(this.xwestTextField, -2, -1, -2).add(this.xeastTextField, -2, -1, -2)).addPreferredGap(0).add(this.ysouthTextField, -2, -1, -2).add(18, 18, 18).add(jPanel1Layout.createParallelGroup(3).add(this.jComboBox1, -2, -1, -2).add(this.jLabel5)).addPreferredGap(1).add(jPanel1Layout.createParallelGroup(3).add(this.outfileTextField, -2, -1, -2).add(this.jLabel6)).addContainerGap(110, Short.MAX_VALUE)));
        jSplitPane1.setTopComponent(this.jPanel1);
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        jScrollPane1.setViewportView(this.jTextArea1);
        jSplitPane1.setRightComponent(jScrollPane1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(2).add(jSplitPane1).add(layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add(this.goButton).addPreferredGap(0).add(this.cancelButton))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().addContainerGap().add(jSplitPane1, -1, 459, Short.MAX_VALUE).add(18, 18, 18).add(layout.createParallelGroup(3).add(this.cancelButton).add(this.goButton)).addContainerGap()));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void goButtonActionPerformed(ActionEvent evt) {
        try {
            BathyGrid bg = CMIUtil.currentSiteInfo.getBathyGrid(this.gridIdent);
            File outFile = new File(this.gridDir, this.outfileTextField.getText());
            double minLat = Double.parseDouble(this.ysouthTextField.getText());
            double maxLat = Double.parseDouble(this.ynorthTextField.getText());
            double minLon = Double.parseDouble(this.xwestTextField.getText());
            double maxLon = Double.parseDouble(this.xeastTextField.getText());
            this.bathyCrop(minLon, maxLon, minLat, maxLat, bg, outFile);
        }
        catch (IOException ioe) {
            SiftShare.log.log(Level.SEVERE, null, ioe);
        }
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        try {
            BathyGrid bg = new BathyGrid(new File(this.gridDir, this.jComboBox1.getItemAt(this.jComboBox1.getSelectedIndex())));
            this.siteInfo.setBathyGrid(this.gridIdent, bg);
            this.setGrid(this.gridIdent);
        }
        catch (IOException ex) {
            SiftShare.log.log(Level.SEVERE, null, ex);
        }
    }

    private void setSite(SiteInfo siteInfo) {
        this.jTextArea1.setText("");
        this.siteInfo = siteInfo;
        this.setGrid(1);
        this.setFullExtent();
    }

    private void setGrid(int gridIdent) {
        this.gridIdent = gridIdent;
        this.gridSelectorPanel1.setSelectedGrid(gridIdent);
        this.jTextArea1.setText("");
        try {
            this.bathyGrid = this.siteInfo.getBathyGrid(gridIdent);
        }
        catch (IOException ex) {
            SiftShare.log.log(Level.SEVERE, null, ex);
        }
        String inFileName = this.bathyGrid.getFileName();
        this.gridDir = this.bathyGrid.getGridFile().getParent();
        String outFileName = "";
        Vector<String> gridfiles = null;
        int ver = 0;
        int end = inFileName.lastIndexOf(".");
        int start = inFileName.lastIndexOf("_ver");
        if (end == -1) {
            start = inFileName.length();
        }
        if (start == -1) {
            start = end;
        }
        File dir = new File(this.gridDir);
        String sub = inFileName.substring(0, start);
        GridVersionFilenameFilter gvff = new GridVersionFilenameFilter(sub);
        gridfiles = new Vector<String>(Arrays.asList(dir.list(gvff)));
        Collections.sort(gridfiles);
        for (String gridfile : gridfiles) {
            end = gridfile.lastIndexOf(".");
            start = gridfile.lastIndexOf("_ver");
            if (start == -1 || end == -1) continue;
            try {
                ver = Integer.parseInt(gridfile.substring(start + 4, end));
            }
            catch (Exception exception) {}
        }
        outFileName = String.format("%s_ver%02d.corr", sub, ++ver);
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(gridfiles));
        this.jComboBox1.setSelectedItem(inFileName);
        this.outfileTextField.setText(outFileName);
    }

    public void setFullExtent() {
        this.setExtent(this.bathyGrid.getGridBox());
    }

    public void setExtent(Point2D.Double[] extent) {
        this.ynorthTextField.setValue(extent[3].y);
        this.ysouthTextField.setValue(extent[0].y);
        this.xwestTextField.setValue(extent[0].x);
        this.xeastTextField.setValue(extent[1].x);
    }

    @Override
    public void setSelectedExtent(int gridIdent, Point2D.Double[] extent) {
        this.setGrid(gridIdent);
        this.setExtent(extent);
    }

    public void bathyCrop(double minLon, double maxLon, double minLat, double maxLat, BathyGrid bathyGrid, File outFile) {
        int i;
        int endindy;
        int startindy;
        int endindx;
        int startindx;
        double[] lons = bathyGrid.getXArray();
        double[] lats = bathyGrid.getYArray();
        double[] depths = bathyGrid.getZArray();
        for (startindx = 0; startindx < lons.length && !(lons[startindx] > minLon); ++startindx) {
        }
        for (endindx = lons.length - 1; endindx >= 0 && !(lons[endindx] < maxLon); --endindx) {
        }
        for (startindy = 0; startindy < lats.length && !(lats[startindy] > minLat); ++startindy) {
        }
        for (endindy = lats.length - 1; endindy >= 0 && !(lats[endindy] < maxLat); --endindy) {
        }
        SiftShare.log.fine("bathy crop extents: \n" + minLon + " " + maxLon + " " + minLat + " " + maxLat + "\n" + lons[startindx] + " " + lons[endindx] + " " + lats[startindy] + " " + lats[endindy] + "\nbathy crop indices: " + startindx + " " + endindx + " " + startindy + " " + endindy);
        if (endindx <= startindx || endindy <= startindy) {
            SiftShare.log.severe("error copping bathy file.");
            return;
        }
        double[] lons2 = Arrays.copyOfRange(lons, startindx, endindx);
        double[] lats2 = Arrays.copyOfRange(lats, startindy, endindy);
        this.jTextArea1.append("Cropping to extents:\n");
        this.jTextArea1.append(this.dfxxxxx.format(minLon) + "<Lon<" + this.dfxxxxx.format(maxLon) + "\n");
        this.jTextArea1.append(this.dfxxxxx.format(minLat) + "<Lat<" + this.dfxxxxx.format(maxLat) + "\n");
        this.jTextArea1.append("indices of Longitude: " + startindx + " to " + endindx + "\n");
        this.jTextArea1.append("indices of Latitude: " + startindy + " to " + endindy + "\n");
        this.jTextArea1.append("Reducing the number of points from " + lons.length * lats.length + " to " + lons2.length * lats2.length + "\n");
        double[][] d = new double[endindx - startindx + 1][endindy - startindy + 1];
        for (int i2 = startindx; i2 < endindx; ++i2) {
            for (int j = startindy; j < endindy; ++j) {
                d[i2 - startindx][j - startindy] = -1.0 * depths[lats.length * i2 + j];
            }
        }
        double[] h1 = new double[lons2.length - 1];
        double[] h2 = new double[lats2.length - 1];
        for (i = 0; i < lons2.length - 1; ++i) {
            h1[i] = (lons2[i + 1] - lons2[i]) * 111320.0;
        }
        for (i = 0; i < lats2.length - 1; ++i) {
            h2[i] = (lats2[i + 1] - lats2[i]) * 111320.0;
        }
        double tmax = 60.0;
        int imax = 0;
        int jmax = 0;
        for (int i3 = 0; i3 < lons2.length - 1; ++i3) {
            for (int j = 0; j < lats2.length - 1; ++j) {
                double tc2;
                double tc1;
                double tc;
                if (!(d[i3][j] > 0.0) || !((tc = Math.min(tc1 = h1[i3] * Math.cos(Math.PI / 180 * lats[j]) / Math.sqrt(9.8 * d[i3][j]), tc2 = h2[j] / Math.sqrt(9.8 * d[i3][j]))) < tmax)) continue;
                tmax = tc;
                imax = i3;
                jmax = j;
            }
        }
        SiftShare.log.fine("New CFL maximum dt= " + tmax + "\n at depth" + -d[imax][jmax] + " m; i=" + imax + "j=" + jmax);
        int oldimax = bathyGrid.getMaxTimeStepX();
        int oldjmax = bathyGrid.getMaxTimeStepY();
        this.jTextArea1.append("Old CFL maximum dt= " + this.dfx.format(bathyGrid.getMaxTimeStep()) + "\n at Lon[" + oldimax + "]: " + lons[oldimax] + " Lat[" + oldjmax + "]: " + lats[oldjmax] + " depth: " + this.dfx.format(bathyGrid.getMaxTimeStepDepth()) + "\nNew CFL maximum dt= " + this.dfx.format(tmax) + "\nat Lon[" + imax + "]: " + lons2[imax] + " Lat[" + jmax + "]: " + lats2[jmax] + " depth: " + this.dfx.format(-d[imax][jmax]) + "\n");
        int result = JOptionPane.showConfirmDialog(this, "Cropped to extents:\n" + this.dfxxxxx.format(minLon) + "<Lon<" + this.dfxxxxx.format(maxLon) + ", and " + this.dfxxxxx.format(minLat) + "<Lat<" + this.dfxxxxx.format(maxLat) + "\nOld CFL maximum dt= " + this.dfx.format(bathyGrid.getMaxTimeStep()) + "\n at Lon[" + oldimax + "]: " + this.dfxxxxx.format(lons[oldimax]) + " Lat[" + oldjmax + "]: " + this.dfxxxxx.format(lats[oldjmax]) + " depth: " + this.dfx.format(bathyGrid.getMaxTimeStepDepth()) + "\nNew CFL maximum dt= " + this.dfx.format(tmax) + "\nat Lon[" + imax + "]: " + this.dfxxxxx.format(lons2[imax]) + " Lat[" + jmax + "]: " + this.dfxxxxx.format(lats2[jmax]) + " depth: " + this.dfx.format(-d[imax][jmax]) + "\nSave copped bathymetry as new file?", "Save changes?", 0);
        if (result == 0) {
            SiftShare.log.fine("Saving copped bathy file: " + this.gridDir + File.separator + this.outfileTextField.getText());
            try {
                BathyGrid bg = BathyGrid.createNew(new File(this.gridDir, this.outfileTextField.getText()), lons2, lats2, d);
                this.siteInfo.setBathyGrid(this.gridIdent, bg);
                this.setGrid(this.gridIdent);
            }
            catch (IOException ex) {
                SiftShare.log.log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (name.equals("currentSite")) {
            this.setSite((SiteInfo)evt.getNewValue());
        } else if (name.equals("selectedGrid")) {
            this.setGrid(this.gridSelectorPanel1.getSelectedGrid());
            this.setFullExtent();
        }
    }

    public class GridVersionFilenameFilter
    implements FilenameFilter {
        private final String startname;

        public GridVersionFilenameFilter(String startname) {
            this.startname = startname;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.startsWith(this.startname);
        }
    }
}

