/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SGTGrid;
import gov.noaa.pmel.sgt.dm.SimpleGrid;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.tsunami.cmi.GeoGrid2D;
import gov.noaa.tsunami.cmi.SSFilter;
import gov.noaa.tsunami.cmi.SiftShare;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import ucar.ma2.Array;
import ucar.ma2.ArrayFloat;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriter;
import ucar.nc2.Variable;
import ucar.nc2.dt.grid.GeoGrid;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.geotiff.GeoTiffCWM;

public class BathyGrid
extends GeoGrid2D
implements Cloneable {
    public static final int CGRID = 3;
    public static final int BGRID = 2;
    public static final int AGRID = 1;
    public static final int PGRID = 0;
    public static final int INNERMOST_GRID = 3;
    public static final int OUTERMOST_GRID = 1;
    private File gridFile = null;
    private double bathymetryInvert = 1.0;
    private BufferedReader openFile = null;
    private NetcdfFile nc = null;
    private double maxDeltaT;
    private double maxDeltaTDepth;
    private int maxDeltaTX;
    private int maxDeltaTY;
    private boolean maxDeltaTCalculated = false;
    private BathyGrid subsampledCache = null;
    private int subsampledDimension = 0;
    private float nodata;

    public BathyGrid(File gridf) throws IOException {
        this(gridf, true);
    }

    public BathyGrid(File gridf, boolean readGridContent) throws IOException {
        this.gridFile = gridf;
        this.fileName = this.id_ = gridf.getPath();
        this.readGridHeaders();
        if (readGridContent) {
            this.readBathymetryGrid();
        }
    }

    public BathyGrid(BathyGrid g) {
        this.gridFile = new File(g.getGridFile(), "");
        this.grid = (double[])g.getZArray().clone();
        Range2D rd = g.getZRange();
        this.zRange_ = new Range2D(rd.start, rd.end);
        this.lats = (double[])g.getYArray().clone();
        this.lons = (double[])g.getXArray().clone();
        this.xRange_ = BathyGrid.getRange(this.lons);
        this.yRange_ = BathyGrid.getRange(this.lats);
    }

    private BathyGrid(double[] lons, double[] lats, double[] depths, File gridFile) {
        this.lons = lons;
        this.lats = lats;
        this.grid = depths;
        this.nLon = lons.length;
        this.nLat = lats.length;
        this.gridFile = gridFile;
        this.id_ = gridFile.getPath();
        double minDepth = Double.POSITIVE_INFINITY;
        double maxDepth = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < this.grid.length; ++i) {
            if (minDepth > this.grid[i]) {
                minDepth = this.grid[i];
            }
            if (!(maxDepth < this.grid[i])) continue;
            maxDepth = this.grid[i];
        }
        this.normalizeLons();
        this.flipLat();
        this.zRange_ = new Range2D(minDepth, maxDepth);
        this.xRange_ = BathyGrid.getRange(lons);
        this.yRange_ = BathyGrid.getRange(lats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BathyGrid createNew(File file, double[] lons, double[] lats, double[][] depths) throws IOException {
        NumberFormat coordFormat = NumberFormat.getNumberInstance(Locale.US);
        coordFormat.setMaximumFractionDigits(8);
        coordFormat.setGroupingUsed(false);
        NumberFormat depthFormat = NumberFormat.getNumberInstance(Locale.US);
        depthFormat.setMaximumFractionDigits(3);
        depthFormat.setGroupingUsed(false);
        try (FileWriter pw = new FileWriter(file);){
            int j;
            pw.write(" " + lons.length + " " + lats.length + "\n");
            for (int i = 0; i < lons.length; ++i) {
                pw.write(coordFormat.format(lons[i]));
                pw.write(10);
            }
            for (j = lats.length - 1; j >= 0; --j) {
                pw.write(coordFormat.format(lats[j]));
                pw.write(10);
            }
            for (j = lats.length - 1; j >= 0; --j) {
                for (int i = 0; i < lons.length; ++i) {
                    pw.write(32);
                    pw.write(depthFormat.format(depths[i][j]));
                }
                pw.write(10);
            }
        }
        return new BathyGrid(file);
    }

    public List<String> getVersions() {
        ArrayList<String> result = new ArrayList<String>();
        String base = this.gridFile.getName();
        if ((base = this.stripFromEnd(base, ".")).endsWith("ssl")) {
            base = this.stripFromEnd(base, "ssl");
        }
        if (base.endsWith("lr")) {
            base = this.stripFromEnd(base, "lr");
        }
        if (base.endsWith("ud")) {
            base = this.stripFromEnd(base, "ud");
        }
        if (base.endsWith("pos")) {
            base = this.stripFromEnd(base, "pos");
        }
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(this.gridFile.getParentFile().toPath(), base + "*");){
            for (Path entry : stream) {
                result.add(entry.toString());
            }
        }
        catch (IOException | DirectoryIteratorException exception) {
            // empty catch block
        }
        return result;
    }

    public String stripFromEnd(String s, String endString) {
        int end = s.lastIndexOf(endString);
        return end == -1 ? s : s.substring(0, end);
    }

    public BathyGrid ssfilt() throws IOException {
        int numpts = SSFilter.filterBathymetry(this, 2.1, 0.0);
        SiftShare.log.info("SSFilter: Number of points changed: " + numpts);
        double[][] newd = new double[this.lons.length][this.lats.length];
        for (int i = 0; i < this.lons.length; ++i) {
            for (int j = 0; j < this.lats.length; ++j) {
                newd[i][j] = -1.0 * this.grid[this.lats.length * i + j];
            }
        }
        String fileName = this.gridFile.getName();
        int idx = fileName.lastIndexOf(46);
        fileName = idx == -1 ? fileName + "ssl21.most" : fileName.substring(0, idx) + "ssl21.most";
        File file = new File(this.gridFile.getParent(), fileName);
        return BathyGrid.createNew(file, this.lons, this.lats, newd);
    }

    public BathyGrid flipUpDown() throws IOException {
        double[][] ud = new double[this.lons.length][this.lats.length];
        for (int i = 0; i < this.lons.length; ++i) {
            for (int j = 0; j < this.lats.length; ++j) {
                ud[i][this.lats.length - j - 1] = -1.0 * this.grid[this.lats.length * i + j];
            }
        }
        String fileName = this.gridFile.getName();
        int idx = fileName.lastIndexOf(46);
        fileName = idx == -1 ? fileName + "ud.most" : fileName.substring(0, idx) + "ud.most";
        File file = new File(this.gridFile.getParent(), fileName);
        return BathyGrid.createNew(file, this.lons, this.lats, ud);
    }

    public BathyGrid flipLeftRight() throws IOException {
        double[][] ud = new double[this.lons.length][this.lats.length];
        for (int i = 0; i < this.lons.length; ++i) {
            for (int j = 0; j < this.lats.length; ++j) {
                ud[this.lons.length - i - 1][j] = -1.0 * this.grid[this.lats.length * i + j];
            }
        }
        String fileName = this.gridFile.getName();
        int idx = fileName.lastIndexOf(46);
        fileName = idx == -1 ? fileName + "lr.most" : fileName.substring(0, idx) + "lr.most";
        File file = new File(this.gridFile.getParent(), fileName);
        return BathyGrid.createNew(file, this.lons, this.lats, ud);
    }

    public BathyGrid invert() throws IOException {
        double[][] ud = new double[this.lons.length][this.lats.length];
        for (int i = 0; i < this.lons.length; ++i) {
            for (int j = 0; j < this.lats.length; ++j) {
                ud[i][j] = this.grid[this.lats.length * i + j];
            }
        }
        String fileName = this.gridFile.getName();
        int idx = fileName.lastIndexOf(46);
        fileName = idx == -1 ? fileName + "pos.most" : fileName.substring(0, idx) + "pos.most";
        File file = new File(this.gridFile.getParent(), fileName);
        return BathyGrid.createNew(file, this.lons, this.lats, ud);
    }

    public static String getGridLetter(int gridIdentifier) {
        switch (gridIdentifier) {
            case 1: {
                return "A";
            }
            case 2: {
                return "B";
            }
            case 3: {
                return "C";
            }
        }
        return Integer.toString(gridIdentifier);
    }

    public static int parseGridIdentifier(String strGridId) {
        switch (Character.toUpperCase(strGridId.charAt(0))) {
            case 'A': {
                return 1;
            }
            case 'B': {
                return 2;
            }
            case 'C': {
                return 3;
            }
        }
        return -1;
    }

    public String getFileName() {
        return this.gridFile != null ? this.gridFile.getName() : null;
    }

    public String getFilePath() {
        return this.gridFile != null ? this.gridFile.getPath() : null;
    }

    private boolean isBathyLoaded() {
        if (this.grid == null) {
            return false;
        }
        return this.grid.length == this.nLon * this.nLat;
    }

    public void saveAsNetCDF(File ncFile, boolean invert) throws IOException {
        NetcdfFileWriter ncfw = NetcdfFileWriter.createNew(NetcdfFileWriter.Version.netcdf3, ncFile.getPath(), null);
        Dimension lonDim = ncfw.addDimension(null, "lon", this.lons.length);
        Dimension latDim = ncfw.addDimension(null, "lat", this.lats.length);
        ArrayList<Dimension> dimList = new ArrayList<Dimension>();
        dimList.add(lonDim);
        Variable lonVar = ncfw.addVariable(null, "lon", DataType.DOUBLE, dimList);
        dimList.clear();
        dimList.add(latDim);
        Variable latVar = ncfw.addVariable(null, "lat", DataType.DOUBLE, dimList);
        dimList.clear();
        dimList.add(latDim);
        dimList.add(lonDim);
        Variable bathVar = ncfw.addVariable(null, "bathy", DataType.FLOAT, dimList);
        lonVar.addAttribute(new Attribute("long_name", "Longitude"));
        lonVar.addAttribute(new Attribute("units", "degrees_east"));
        latVar.addAttribute(new Attribute("long_name", "Latitude"));
        latVar.addAttribute(new Attribute("units", "degrees_north"));
        bathVar.addAttribute(new Attribute("long_name", "Grid Bathymetry"));
        bathVar.addAttribute(new Attribute("units", "meters"));
        bathVar.addAttribute(new Attribute("_FillValue", Float.valueOf(-1.0E34f)));
        bathVar.addAttribute(new Attribute("missing_value", Float.valueOf(-1.0E34f)));
        ncfw.addGroupAttribute(null, new Attribute("Conventions", "CF1.0"));
        ncfw.addGroupAttribute(null, new Attribute("title", "MOST bathymetry grid"));
        ncfw.create();
        try {
            ncfw.write(lonVar, Array.factory(this.lons));
            ncfw.write(latVar, Array.factory(this.lats));
            int nLon = this.getXSize();
            int nLat = this.getYSize();
            ArrayFloat.D2 depsarr = new ArrayFloat.D2(this.lats.length, this.lons.length);
            if (invert) {
                for (int j = 0; j < nLat; ++j) {
                    for (int i = 0; i < nLon; ++i) {
                        depsarr.set(j, i, (float)(-1.0 * this.bathymetryInvert * this.grid[nLat * i + j]));
                    }
                }
            } else {
                for (int j = 0; j < nLat; ++j) {
                    for (int i = 0; i < nLon; ++i) {
                        depsarr.set(j, i, (float)(this.bathymetryInvert * this.grid[nLat * i + j]));
                    }
                }
            }
            ncfw.write(bathVar, depsarr);
        }
        catch (InvalidRangeException ex) {
            SiftShare.log.log(Level.SEVERE, "Error creating bathy netcdf file", ex);
            throw new IOException(ex);
        }
        ncfw.close();
    }

    public void saveAsGeoTIFF(File gtFile) throws IOException {
        String filename = gtFile.getPath().replaceFirst("[.][^.]+$", "") + ".nc";
        File ncFile = new File(filename);
        this.saveAsNetCDF(ncFile, true);
        GridDataset gridDs = GridDataset.open(filename);
        GeoGrid g = gridDs.findGridByName("bathy");
        GeoTiffCWM gtw = new GeoTiffCWM(gtFile.getCanonicalPath());
        SiftShare.log.info("Saving GeoTIFF... grid: " + g.getInfo() + " to file: " + gtFile.getCanonicalPath());
        try {
            gtw.writeGrid(gridDs, g, g.readYXData(0, 0), false);
        }
        catch (IllegalArgumentException iae) {
            throw new IOException(iae);
        }
        gtw.close();
        gridDs.close();
    }

    private void readGridHeaders() throws IOException {
        try {
            this.nc = NetcdfFile.open(this.gridFile.getPath());
            this.lons = (double[])this.nc.findVariable("lon").read().copyTo1DJavaArray();
            this.lats = (double[])this.nc.findVariable("lat").read().copyTo1DJavaArray();
            this.nLon = this.lons.length;
            this.nLat = this.lats.length;
            this.bathymetryInvert = -1.0;
        }
        catch (Exception ignore) {
            FileReader fr = new FileReader(this.gridFile);
            BufferedReader br = new BufferedReader(fr);
            br.mark(4096);
            String inputLine = br.readLine();
            if (inputLine == null) {
                throw new IOException("no content found in input file");
            }
            br.reset();
            if (inputLine.toLowerCase().startsWith("ncols")) {
                this.readAsciiRasterHeader(br);
            } else {
                this.readMOSTFormatHeader(br);
            }
            this.openFile = br;
        }
        if (this.lons[0] > 390.0 || this.lons[0] < -360.0) {
            throw new IOException("This grid file appears to be in projected coordinates (eg UTM, State Plane). Please use geodetic (latitude/longitude) coordinates.");
        }
        this.flipLat();
        this.normalizeLons();
        this.xRange_ = BathyGrid.getRange(this.lons);
        this.yRange_ = BathyGrid.getRange(this.lats);
        SiftShare.log.log(Level.INFO, "Loaded bathymetry file: {0}\nnLon: {1} nLat: {2}\nxRange: {3} yRange:{4}", new Object[]{this.gridFile.toString(), this.lons.length, this.lats.length, this.xRange_, this.yRange_});
    }

    public BathyGrid subsampleToMaxSize(int maxDimension) {
        BathyGrid newbg;
        if (maxDimension == this.subsampledDimension && this.subsampledCache != null) {
            return this.subsampledCache;
        }
        int skipX = 1;
        int skipY = 1;
        while (this.nLon / skipX > maxDimension) {
            ++skipX;
        }
        while (this.nLat / skipY > maxDimension) {
            ++skipY;
        }
        if (skipX == 1 && skipY == 1) {
            SiftShare.log.fine("no subsample required, nx: " + this.nLon + ", ny: " + this.nLat + ", limit: " + maxDimension);
            return this;
        }
        int numX = (this.nLon - 1) / skipX + 1;
        int numY = (this.nLat - 1) / skipY + 1;
        double[] newdeps = new double[numX * numY];
        double[] zarr = this.getZArray();
        int count = 0;
        for (int i = 0; i < this.nLon; ++i) {
            for (int j = 0; j < this.nLat; ++j) {
                if (i % skipX != 0 || j % skipY != 0) continue;
                newdeps[count] = zarr[this.nLat * i + j];
                ++count;
            }
        }
        double[] newlons = new double[numX];
        count = 0;
        for (int i = 0; i < this.nLon; i += skipX) {
            newlons[count] = this.lons[i];
            ++count;
        }
        double[] newlats = new double[numY];
        count = 0;
        for (int i = 0; i < this.nLat; i += skipY) {
            newlats[count] = this.lats[i];
            ++count;
        }
        SiftShare.log.log(Level.INFO, "subsampled grid from nx: {0}, ny: {1} to nx: {2}, ny: {3} (max: {4})", new Object[]{this.nLon, this.nLat, numX, numY, maxDimension});
        this.subsampledCache = newbg = new BathyGrid(newlons, newlats, newdeps, this.gridFile);
        this.subsampledDimension = maxDimension;
        this.grid = null;
        return newbg;
    }

    public File getGridFile() {
        return this.gridFile;
    }

    private void readBathymetryGrid() throws IOException {
        if (this.isBathyLoaded()) {
            return;
        }
        double minDepth = Double.POSITIVE_INFINITY;
        double maxDepth = Double.NEGATIVE_INFINITY;
        this.grid = new double[this.nLat * this.nLon];
        if (this.openFile == null && this.nc == null) {
            this.readGridHeaders();
        }
        if (this.nc != null) {
            Variable ba = this.getNetcdfVar(new String[]{"bathy", "depth", "Band1", "bathymetry", "original_bathy", "z", "elevation", "altitude"});
            Array data = ba.read();
            if (this.flipLat) {
                for (int j = 0; j < this.nLat; ++j) {
                    for (int i = 0; i < this.nLon; ++i) {
                        this.grid[this.nLat * i + (this.nLat - 1 - j)] = this.bathymetryInvert * data.getDouble(this.nLon * j + i);
                    }
                }
            } else {
                for (int j = 0; j < this.nLat; ++j) {
                    for (int i = 0; i < this.nLon; ++i) {
                        this.grid[this.nLat * i + j] = this.bathymetryInvert * data.getDouble(this.nLon * j + i);
                    }
                }
            }
            if (this.bathymetryInvert < 0.0) {
                maxDepth = -MAMath.getMinimum(data);
                minDepth = -MAMath.getMaximum(data);
            } else {
                maxDepth = MAMath.getMaximum(data);
                minDepth = MAMath.getMinimum(data);
            }
            this.nc.close();
        } else {
            double dv = 0.0;
            if (this.flipLat) {
                SiftShare.log.fine("flipping lats on z");
            }
            for (int j = 0; j < this.nLat; ++j) {
                String line = this.openFile.readLine();
                if (line == null) {
                    throw new IOException("Error reading bathy grid.");
                }
                String[] lineArr = line.trim().split("\\s+");
                if (lineArr.length != this.nLon) {
                    throw new IOException("Error reading bathy grid.");
                }
                try {
                    for (int i = 0; i < this.nLon; ++i) {
                        dv = this.bathymetryInvert * Double.parseDouble(lineArr[i]);
                        if (this.flipLat) {
                            this.grid[this.nLat * i + j] = dv;
                        } else {
                            this.grid[this.nLat * i + (this.nLat - 1 - j)] = dv;
                        }
                        minDepth = dv < minDepth ? dv : minDepth;
                        maxDepth = dv > maxDepth ? dv : maxDepth;
                    }
                    continue;
                }
                catch (NumberFormatException nfe) {
                    throw new IOException("Error reading bathy grid.");
                }
            }
        }
        SiftShare.log.fine("Bathy file: " + this.gridFile.getName() + " first bathy values of first two rows: " + this.grid[0] + ", " + this.grid[this.nLat]);
        this.zRange_ = new Range2D(minDepth, maxDepth);
        if (this.openFile != null) {
            this.openFile.close();
        }
        this.openFile = null;
        this.nc = null;
    }

    private Variable getNetcdfVar(String[] varnames) {
        Variable var = null;
        if (this.nc == null) {
            return null;
        }
        for (int i = 0; i < varnames.length; ++i) {
            var = this.nc.findVariable(varnames[i]);
            if (var == null) continue;
            return var;
        }
        if (var == null) {
            SiftShare.log.warning("Can't find bathy variable name in file");
        }
        return var;
    }

    private void readAsciiRasterHeader(BufferedReader br) throws IOException {
        int i;
        double cellsize;
        double yllcorner;
        double yshift;
        double xllcorner;
        double xshift;
        String inputLine = br.readLine();
        if (inputLine == null) {
            throw new IOException("error reading ASCII raster grid file: unexpected EOF");
        }
        String[] inputArray = inputLine.split("\\s+", 2);
        if (inputArray.length != 2 || !inputArray[0].equalsIgnoreCase("ncols")) {
            throw new IOException("error reading ASCII raster grid file: expected 'ncols' token");
        }
        try {
            this.nLon = Integer.parseInt(inputArray[1]);
        }
        catch (NumberFormatException ex) {
            throw new IOException("error reading ASCII raster grid file: invalid 'ncols' value: " + ex.getMessage());
        }
        inputLine = br.readLine();
        if (inputLine == null) {
            throw new IOException("error reading ASCII raster grid file: unexpected EOF");
        }
        inputArray = inputLine.split("\\s+", 2);
        if (inputArray.length != 2 || !inputArray[0].equalsIgnoreCase("nrows")) {
            throw new IOException("error reading ASCII raster grid file: expected 'nrows' token");
        }
        try {
            this.nLat = Integer.parseInt(inputArray[1]);
        }
        catch (NumberFormatException ex) {
            throw new IOException("error reading ASCII raster grid file: invalid 'nrows' value: " + ex.getMessage());
        }
        inputLine = br.readLine();
        if (inputLine == null) {
            throw new IOException("error reading ASCII raster grid file: unexpected EOF");
        }
        inputArray = inputLine.split("\\s+", 2);
        if (inputArray.length == 2 && inputArray[0].equalsIgnoreCase("xllcorner")) {
            xshift = 0.5;
        } else if (inputArray.length == 2 && inputArray[0].equalsIgnoreCase("xllcenter")) {
            xshift = 0.0;
        } else {
            throw new IOException("error reading ASCII raster grid file: expected 'xllcenter' or 'xllcorner' tokens");
        }
        try {
            xllcorner = Double.parseDouble(inputArray[1]);
        }
        catch (NumberFormatException ex) {
            throw new IOException(String.format("error reading ASCII raster grid file: invalid '%s' value: %s", inputArray[0], ex.getMessage()));
        }
        inputLine = br.readLine();
        if (inputLine == null) {
            throw new IOException("error reading ASCII raster grid file: unexpected EOF");
        }
        inputArray = inputLine.split("\\s+", 2);
        if (inputArray.length == 2 && inputArray[0].equalsIgnoreCase("yllcorner")) {
            yshift = 0.5;
        } else if (inputArray.length == 2 && inputArray[0].equalsIgnoreCase("yllcenter")) {
            yshift = 0.0;
        } else {
            throw new IOException("error reading ASCII raster grid file: expected 'yllcenter' or 'yllcorner' tokens");
        }
        try {
            yllcorner = Double.parseDouble(inputArray[1]);
        }
        catch (NumberFormatException ex) {
            throw new IOException(String.format("error reading ASCII raster grid file: invalid '%s' value: %s", inputArray[0], ex.getMessage()));
        }
        inputLine = br.readLine();
        if (inputLine == null) {
            throw new IOException("error reading ASCII raster grid file: unexpected EOF");
        }
        inputArray = inputLine.split("\\s+");
        if (inputArray.length != 2 || !inputArray[0].equalsIgnoreCase("cellsize")) {
            throw new IOException("error reading ASCII raster grid file: expected 'cellsize' token");
        }
        try {
            cellsize = Float.parseFloat(inputArray[1]);
        }
        catch (NumberFormatException ex) {
            throw new IOException(String.format("error reading ASCII raster grid file: invalid '%s' value: %s", inputArray[0], ex.getMessage()));
        }
        xllcorner += xshift * cellsize;
        yllcorner += yshift * cellsize;
        this.lons = new double[this.nLon];
        this.lats = new double[this.nLat];
        for (i = 0; i < this.nLon; ++i) {
            this.lons[i] = xllcorner + (double)i * cellsize;
        }
        for (i = 0; i < this.nLat; ++i) {
            this.lats[i] = yllcorner + (double)i * cellsize;
        }
        br.mark(16384);
        inputLine = br.readLine();
        if (inputLine == null) {
            throw new IOException("error reading ASCII raster grid file: unexpected EOF");
        }
        inputArray = inputLine.split("\\s+", 2);
        this.nodata = Float.parseFloat(inputArray[1]);
        if (inputArray.length != 2 || !inputArray[0].equalsIgnoreCase("nodata_value")) {
            br.reset();
        }
    }

    private void readMOSTFormatHeader(BufferedReader br) throws IOException {
        this.bathymetryInvert = -1.0;
        String inputLine = br.readLine();
        if (inputLine == null) {
            throw new IOException("error reading MOST grid file: unexpected EOF");
        }
        try {
            String[] inputArray = inputLine.trim().split("\\s+");
            this.nLon = Integer.parseInt(inputArray[0]);
            this.nLat = Integer.parseInt(inputArray[1]);
        }
        catch (NumberFormatException ex) {
            throw new IOException("This does not appear to be a MOST format file");
        }
        this.lons = new double[this.nLon];
        this.lats = new double[this.nLat];
        for (int i = 0; i < this.nLon; ++i) {
            inputLine = br.readLine();
            if (inputLine == null) {
                throw new IOException("error reading MOST grid axes: unexpected EOF");
            }
            try {
                this.lons[i] = Double.parseDouble(inputLine.trim());
                continue;
            }
            catch (NumberFormatException ex) {
                throw new IOException("error parsing MOST grid axes: not in MOST format?");
            }
        }
        for (int j = this.nLat - 1; j >= 0; --j) {
            inputLine = br.readLine();
            if (inputLine == null) {
                throw new IOException("error reading MOST grid axes: unexpected EOF");
            }
            try {
                this.lats[j] = Double.parseDouble(inputLine.trim());
                continue;
            }
            catch (NumberFormatException ex) {
                throw new IOException("error parsing MOST grid axes: not in MOST format?");
            }
        }
    }

    public double[] getLonLatAtMaxDepth() {
        for (int i = 0; i < this.lons.length; ++i) {
            for (int j = 0; j < this.lats.length; ++j) {
                if (this.grid[this.lats.length * i + j] != this.zRange_.end) continue;
                return new double[]{this.lons[i], this.lats[j]};
            }
        }
        return null;
    }

    @Override
    public double[] getZArray() {
        try {
            this.readBathymetryGrid();
        }
        catch (IOException ex) {
            SiftShare.log.log(Level.SEVERE, null, ex);
        }
        return this.grid;
    }

    @Override
    public Range2D getZRange() {
        if (this.zRange_ == null) {
            try {
                this.readBathymetryGrid();
            }
            catch (IOException ex) {
                SiftShare.log.log(Level.SEVERE, null, ex);
            }
        }
        return this.zRange_;
    }

    @Override
    public String getTitle() {
        return this.gridFile.toString();
    }

    @Override
    public SGTData copy() {
        SGTGrid newGrid;
        try {
            newGrid = (SGTGrid)this.clone();
        }
        catch (CloneNotSupportedException e) {
            newGrid = new SimpleGrid();
        }
        return newGrid;
    }

    public double getMaxTimeStep(StringBuffer sb) {
        if (!this.maxDeltaTCalculated) {
            this.computeMaxTimeStep();
        }
        if (sb != null) {
            sb.append(String.format("  maximum delta-T (CFL): %.3f seconds\n  at depth: %.3f meters, grid location i = %d, j= %d\n", this.maxDeltaT, this.maxDeltaTDepth, this.maxDeltaTX, this.maxDeltaTY));
        }
        return this.maxDeltaT;
    }

    public double getMaxTimeStep() {
        return this.getMaxTimeStep(null);
    }

    public double getMaxTimeStepDepth() {
        if (!this.maxDeltaTCalculated) {
            this.computeMaxTimeStep();
        }
        return this.maxDeltaTDepth;
    }

    public int getMaxTimeStepX() {
        if (!this.maxDeltaTCalculated) {
            this.computeMaxTimeStep();
        }
        return this.maxDeltaTX;
    }

    public int getMaxTimeStepY() {
        if (!this.maxDeltaTCalculated) {
            this.computeMaxTimeStep();
        }
        return this.maxDeltaTY;
    }

    private void computeMaxTimeStep() {
        double[] zarr = this.getZArray();
        this.maxDeltaT = 3.4028234663852886E38;
        for (int j = 0; j < this.lats.length - 1; ++j) {
            for (int i = 0; i < this.lons.length - 1; ++i) {
                double deltaTy;
                double deltaT;
                double depth = zarr[this.lats.length * i + j];
                if (!(depth < 0.0)) continue;
                double depfactor = Math.sqrt(-9.8 * depth);
                double deltaTx = Math.abs(this.lons[i + 1] - this.lons[i]) * Math.cos(Math.PI / 180 * this.lats[j]) * 111320.0 / depfactor;
                double d = deltaT = deltaTx < (deltaTy = Math.abs(this.lats[j + 1] - this.lats[j]) * 111320.0 / depfactor) ? deltaTx : deltaTy;
                if (!(deltaT < this.maxDeltaT)) continue;
                this.maxDeltaT = deltaT;
                this.maxDeltaTDepth = depth;
                this.maxDeltaTX = i;
                this.maxDeltaTY = j;
            }
        }
        this.maxDeltaTCalculated = true;
    }

    public int hashCode() {
        int hash = 7;
        hash = 97 * hash + (this.gridFile != null ? this.gridFile.hashCode() : 0);
        return hash;
    }

    public boolean equals(Object other) {
        return other instanceof BathyGrid ? ((BathyGrid)other).getGridFile().equals(this.getGridFile()) : false;
    }
}

