/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.tsunami.cmi.BathyGrid;
import gov.noaa.tsunami.cmi.CMIUtil;
import gov.noaa.tsunami.cmi.GridSelectorPanel;
import gov.noaa.tsunami.cmi.SiftShare;
import gov.noaa.tsunami.cmi.SiteInfo;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class BathyLonsTool
extends JDialog
implements PropertyChangeListener {
    private String gridDir = "";
    private SiteInfo siteInfo = null;
    private int gridIdent = 1;
    private BathyGrid bathyGrid;
    private ButtonGroup buttonGroup1;
    private GridSelectorPanel gridSelectorPanel1;
    private JButton jButton1;
    private JButton jButton2;
    private JComboBox jComboBox1;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JPanel jPanel1;
    private JRadioButton jRadioButton0360;
    private JRadioButton jRadioButton180;
    private JTextField outfileTextField;

    public BathyLonsTool(Frame parent, SiteInfo siteInfo) {
        super(parent, false);
        this.setLocationRelativeTo(parent);
        this.initComponents();
        this.setSite(siteInfo);
        this.gridSelectorPanel1.addPropertyChangeListener(this);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.gridSelectorPanel1 = new GridSelectorPanel();
        this.jLabel3 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jLabel4 = new JLabel();
        this.outfileTextField = new JTextField();
        this.jRadioButton0360 = new JRadioButton();
        this.jLabel5 = new JLabel();
        this.jRadioButton180 = new JRadioButton();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Switch Longitude Convention");
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel3.setText("Input filename:");
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"infileName1"}));
        this.jComboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BathyLonsTool.this.jComboBox1ActionPerformed(evt);
            }
        });
        this.jLabel4.setText("Output filename:");
        this.outfileTextField.setText("outfilename");
        this.buttonGroup1.add(this.jRadioButton0360);
        this.jRadioButton0360.setSelected(true);
        this.jRadioButton0360.setText("0<lons<360");
        this.jLabel5.setText("Force Longitudes: ");
        this.buttonGroup1.add(this.jRadioButton180);
        this.jRadioButton180.setText("-180<lons<180");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(6, 6, 6).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButton0360).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButton180).addContainerGap(-1, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel4)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.outfileTextField).addComponent(this.jComboBox1, 0, 445, Short.MAX_VALUE))).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.gridSelectorPanel1, -2, -1, -2).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.gridSelectorPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButton0360).addComponent(this.jLabel5).addComponent(this.jRadioButton180)).addGap(23, 23, 23).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jComboBox1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.outfileTextField, -2, -1, -2)).addContainerGap(31, Short.MAX_VALUE)));
        this.jButton1.setText("Cancel");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BathyLonsTool.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("Adjust");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BathyLonsTool.this.jButton2ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jButton2)).addContainerGap()));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        try {
            BathyGrid bg = CMIUtil.currentSiteInfo.getBathyGrid(this.gridIdent);
            File outFile = new File(this.gridDir, this.outfileTextField.getText());
            this.bathyAdjust(bg, outFile);
        }
        catch (IOException ioe) {
            SiftShare.log.log(Level.SEVERE, null, ioe);
        }
        this.setVisible(false);
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        try {
            BathyGrid bg = new BathyGrid(new File(this.gridDir, (String)this.jComboBox1.getSelectedItem()));
            this.siteInfo.setBathyGrid(this.gridIdent, bg);
            this.setGrid(this.gridIdent);
        }
        catch (IOException ex) {
            SiftShare.log.log(Level.SEVERE, null, ex);
        }
    }

    private void setSite(SiteInfo siteInfo) {
        this.siteInfo = siteInfo;
        this.setGrid(1);
    }

    private void setGrid(int gridIdent) {
        this.gridIdent = gridIdent;
        this.gridSelectorPanel1.setSelectedGrid(gridIdent);
        try {
            this.bathyGrid = this.siteInfo.getBathyGrid(gridIdent);
        }
        catch (IOException ex) {
            SiftShare.log.log(Level.SEVERE, null, ex);
        }
        String inFileName = this.bathyGrid.getFileName();
        this.gridDir = this.bathyGrid.getGridFile().getParent();
        String outFileName = "";
        Vector<String> gridfiles = null;
        int ver = 0;
        int end = inFileName.lastIndexOf(".");
        int start = inFileName.lastIndexOf("_ver");
        if (end == -1) {
            start = inFileName.length();
        }
        if (start == -1) {
            start = end;
        }
        File dir = new File(this.gridDir);
        String sub = inFileName.substring(0, start);
        GridVersionFilenameFilter gvff = new GridVersionFilenameFilter(sub);
        gridfiles = new Vector<String>(Arrays.asList(dir.list(gvff)));
        Collections.sort(gridfiles);
        for (String gridfile : gridfiles) {
            end = gridfile.lastIndexOf(".");
            start = gridfile.lastIndexOf("_ver");
            if (start == -1 || end == -1) continue;
            try {
                ver = Integer.parseInt(gridfile.substring(start + 4, end));
            }
            catch (Exception exception) {}
        }
        outFileName = String.format("%s_ver%02d.corr", sub, ++ver);
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(gridfiles));
        this.jComboBox1.setSelectedItem(inFileName);
        this.outfileTextField.setText(outFileName);
    }

    public void bathyAdjust(BathyGrid bathyGrid, File outFile) {
        if (this.jRadioButton0360.isSelected()) {
            bathyGrid.forceLons0360();
        } else {
            bathyGrid.forceLonsMinus180to180();
        }
        double[] depths = bathyGrid.getZArray();
        double[] lons = bathyGrid.getXArray();
        double[] lats = bathyGrid.getYArray();
        double[][] d = new double[lons.length][lats.length];
        for (int i = 0; i < lons.length; ++i) {
            for (int j = 0; j < lats.length; ++j) {
                d[i][j] = -1.0 * depths[lats.length * i + j];
            }
        }
        SiftShare.log.fine("Adjusting longitude for file: " + outFile.getPath());
        int result = JOptionPane.showConfirmDialog(this, "Save adjusted longitude as new file?", "Save changes?", 0);
        if (result == 0) {
            SiftShare.log.fine("Saving vertically adjusted bathy file: " + this.gridDir + File.separator + this.outfileTextField.getText());
            try {
                BathyGrid bg = BathyGrid.createNew(new File(this.gridDir, this.outfileTextField.getText()), lons, lats, d);
                this.siteInfo.setBathyGrid(this.gridIdent, bg);
                this.setGrid(this.gridIdent);
            }
            catch (IOException ex) {
                SiftShare.log.log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (name.equals("currentSite")) {
            this.setSite((SiteInfo)evt.getNewValue());
        } else if (name.equals("selectedGrid")) {
            this.setGrid(this.gridSelectorPanel1.getSelectedGrid());
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(BathyLonsTool.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(BathyLonsTool.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(BathyLonsTool.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(BathyLonsTool.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                BathyLonsTool dialog = new BathyLonsTool((Frame)new JFrame(), null);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    public class GridVersionFilenameFilter
    implements FilenameFilter {
        private final String startname;

        public GridVersionFilenameFilter(String startname) {
            this.startname = startname;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.startsWith(this.startname);
        }
    }
}

