/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.tsunami.cmi.AbstractGridTool;
import gov.noaa.tsunami.cmi.BathyGrid;
import gov.noaa.tsunami.cmi.CMIUtil;
import gov.noaa.tsunami.cmi.GridSelectorPanel;
import gov.noaa.tsunami.cmi.SiftShare;
import gov.noaa.tsunami.cmi.SiteInfo;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.NumberFormatter;
import org.jdesktop.layout.GroupLayout;

public class BathySmoothTool
extends AbstractGridTool
implements PropertyChangeListener {
    private String gridDir = "";
    private int gridIdent = 1;
    private final DecimalFormat dfx = new DecimalFormat("0.0");
    private final DecimalFormat dfxxxxx = new DecimalFormat("0.00000");
    private BathyGrid bathyGrid;
    private SiteInfo siteInfo;
    private final NumberFormatter nfr1;
    private final NumberFormatter nf1;
    private final NumberFormatter nf5;
    private JButton cancelButton;
    private JButton goButton;
    private GridSelectorPanel gridSelectorPanel1;
    private JComboBox<String> jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel1;
    private JTextArea jTextArea1;
    private JFormattedTextField maxSlopeTextField;
    private JFormattedTextField maxWaveTextField;
    private JFormattedTextField minDepthTextField;
    private JTextField outfileTextField;
    private JFormattedTextField xeastTextField;
    private JFormattedTextField xwestTextField;
    private JFormattedTextField ynorthTextField;
    private JFormattedTextField ysouthTextField;

    public BathySmoothTool(Frame parent, SiteInfo siteInfo) {
        super(parent);
        this.setLocationRelativeTo(parent);
        this.nfr1 = new NumberFormatter(this.dfx);
        this.nfr1.setAllowsInvalid(false);
        this.nfr1.setMaximum(Double.valueOf(1.0));
        this.nfr1.setMinimum(Double.valueOf(0.0));
        this.nf1 = new NumberFormatter(this.dfx);
        this.nf1.setAllowsInvalid(false);
        this.nf5 = new NumberFormatter(this.dfxxxxx);
        this.nf5.setAllowsInvalid(false);
        this.initComponents();
        this.getContentPane().setBackground(Color.WHITE);
        this.setSite(siteInfo);
        this.gridSelectorPanel1.addPropertyChangeListener(this);
    }

    private void initComponents() {
        this.goButton = new JButton();
        this.cancelButton = new JButton();
        JSplitPane jSplitPane1 = new JSplitPane();
        this.jPanel1 = new JPanel();
        this.jLabel6 = new JLabel();
        this.jLabel5 = new JLabel();
        this.outfileTextField = new JTextField();
        this.jLabel4 = new JLabel();
        this.jLabel3 = new JLabel();
        this.gridSelectorPanel1 = new GridSelectorPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.maxSlopeTextField = new JFormattedTextField(this.nfr1);
        this.minDepthTextField = new JFormattedTextField(this.nf1);
        this.maxWaveTextField = new JFormattedTextField(this.nf1);
        this.ynorthTextField = new JFormattedTextField(this.nf5);
        this.xwestTextField = new JFormattedTextField(this.nf5);
        this.xeastTextField = new JFormattedTextField(this.nf5);
        this.ysouthTextField = new JFormattedTextField(this.nf5);
        this.jComboBox1 = new JComboBox();
        this.jLabel7 = new JLabel();
        JScrollPane jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.setTitle("Bathymetry Correction Tool");
        this.goButton.setText("Go");
        this.goButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BathySmoothTool.this.goButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Quit");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BathySmoothTool.this.cancelButtonActionPerformed(evt);
            }
        });
        jSplitPane1.setOrientation(0);
        jSplitPane1.setOneTouchExpandable(true);
        this.jPanel1.setBackground(Color.white);
        this.jPanel1.setMinimumSize(new Dimension(525, 348));
        this.jLabel6.setText("Output filename:");
        this.jLabel5.setText("Input filename:");
        this.outfileTextField.setHorizontalAlignment(2);
        this.outfileTextField.setText("outfilename");
        this.jLabel4.setText("Max slope:");
        this.jLabel3.setText("Max wave estimate:");
        this.jLabel1.setText("Extents:");
        this.jLabel2.setText("Minimum Depth:");
        this.maxSlopeTextField.setColumns(4);
        this.maxSlopeTextField.setHorizontalAlignment(0);
        this.maxSlopeTextField.setText("0.7");
        this.minDepthTextField.setColumns(4);
        this.minDepthTextField.setHorizontalAlignment(0);
        this.minDepthTextField.setText("0.0");
        this.maxWaveTextField.setColumns(4);
        this.maxWaveTextField.setHorizontalAlignment(0);
        this.maxWaveTextField.setText("0.0");
        this.ynorthTextField.setColumns(8);
        this.ynorthTextField.setHorizontalAlignment(0);
        this.ynorthTextField.setText("90.00000");
        this.xwestTextField.setColumns(8);
        this.xwestTextField.setHorizontalAlignment(0);
        this.xwestTextField.setText("0.00000");
        this.xeastTextField.setColumns(8);
        this.xeastTextField.setHorizontalAlignment(0);
        this.xeastTextField.setText("360.00000");
        this.ysouthTextField.setColumns(8);
        this.ysouthTextField.setHorizontalAlignment(0);
        this.ysouthTextField.setText("90.00000");
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"infileName1"}));
        this.jComboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BathySmoothTool.this.jComboBox1ActionPerformed(evt);
            }
        });
        this.jLabel7.setText("(0<slope<1)");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(158, 158, 158).add(jPanel1Layout.createParallelGroup(2).add(jPanel1Layout.createSequentialGroup().add(this.jLabel1).addPreferredGap(0).add(this.xwestTextField, -2, -1, -2).add(3, 3, 3).add(this.xeastTextField, -2, -1, -2)).add(jPanel1Layout.createSequentialGroup().add(this.ynorthTextField, -2, -1, -2).add(51, 51, 51)).add(jPanel1Layout.createSequentialGroup().add(this.ysouthTextField, -2, -1, -2).add(49, 49, 49)).add(jPanel1Layout.createSequentialGroup().add(jPanel1Layout.createParallelGroup(2).add(jPanel1Layout.createSequentialGroup().add(this.jLabel2).addPreferredGap(0).add(this.minDepthTextField, -2, -1, -2)).add(jPanel1Layout.createSequentialGroup().add(this.jLabel3).addPreferredGap(1).add(this.maxWaveTextField, -2, -1, -2)).add(jPanel1Layout.createSequentialGroup().add(this.jLabel4).addPreferredGap(0).add(this.maxSlopeTextField, -2, -1, -2))).addPreferredGap(1).add(this.jLabel7))).add(76, 76, 76)).add(2, jPanel1Layout.createSequentialGroup().add(23, 23, 23).add(jPanel1Layout.createParallelGroup(1).add(this.jLabel5).add(this.jLabel6)).add(18, 18, 18).add(jPanel1Layout.createParallelGroup(2).add(this.outfileTextField, -1, 358, Short.MAX_VALUE).add(this.jComboBox1, 0, 372, Short.MAX_VALUE)).addContainerGap()).add(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(this.gridSelectorPanel1, -2, -1, -2).addContainerGap(339, Short.MAX_VALUE))));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(jPanel1Layout.createParallelGroup(3).add(this.jLabel3).add(this.maxWaveTextField, -2, -1, -2)).add(4, 4, 4).add(jPanel1Layout.createParallelGroup(3).add(this.minDepthTextField, -2, -1, -2).add(this.jLabel2)).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(3).add(this.maxSlopeTextField, -2, -1, -2).add(this.jLabel4).add(this.jLabel7)).add(29, 29, 29).add(this.ynorthTextField, -2, -1, -2).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(3).add(this.jLabel1).add(this.xwestTextField, -2, -1, -2).add(this.xeastTextField, -2, -1, -2)).addPreferredGap(0).add(this.ysouthTextField, -2, -1, -2).add(18, 18, 18).add(jPanel1Layout.createParallelGroup(3).add(this.jComboBox1, -2, -1, -2).add(this.jLabel5)).addPreferredGap(1).add(jPanel1Layout.createParallelGroup(3).add(this.outfileTextField, -2, -1, -2).add(this.jLabel6)).addContainerGap(38, Short.MAX_VALUE)).add(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(103, 103, 103).add(this.gridSelectorPanel1, -2, -1, -2).addContainerGap(212, Short.MAX_VALUE))));
        jSplitPane1.setTopComponent(this.jPanel1);
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        jScrollPane1.setViewportView(this.jTextArea1);
        jSplitPane1.setRightComponent(jScrollPane1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().add(this.goButton).addPreferredGap(0).add(this.cancelButton)).add(jSplitPane1)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().add(20, 20, 20).add(jSplitPane1, -1, 498, Short.MAX_VALUE).add(18, 18, 18).add(layout.createParallelGroup(3).add(this.cancelButton).add(this.goButton)).addContainerGap()));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void goButtonActionPerformed(ActionEvent evt) {
        try {
            BathyGrid bg = CMIUtil.currentSiteInfo.getBathyGrid(this.gridIdent);
            File outFile = new File(this.gridDir, this.outfileTextField.getText());
            double wavemx = Double.parseDouble(this.maxWaveTextField.getText());
            double grnd = Double.parseDouble(this.minDepthTextField.getText());
            double steep = Double.parseDouble(this.maxSlopeTextField.getText());
            double minLat = Double.parseDouble(this.ysouthTextField.getText());
            double maxLat = Double.parseDouble(this.ynorthTextField.getText());
            double minLon = Double.parseDouble(this.xwestTextField.getText());
            double maxLon = Double.parseDouble(this.xeastTextField.getText());
            this.bathyCorr(wavemx, grnd, steep, minLon, maxLon, minLat, maxLat, bg, outFile);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        try {
            BathyGrid bg = new BathyGrid(new File(this.gridDir, (String)this.jComboBox1.getSelectedItem()));
            this.siteInfo.setBathyGrid(this.gridIdent, bg);
            this.setGrid(this.gridIdent);
        }
        catch (IOException ex) {
            SiftShare.log.log(Level.SEVERE, null, ex);
        }
    }

    private void setSite(SiteInfo siteInfo) {
        this.jTextArea1.setText("");
        this.siteInfo = siteInfo;
        this.setGrid(1);
        this.setFullExtent();
    }

    private void setGrid(int gridIdent) {
        this.gridIdent = gridIdent;
        this.gridSelectorPanel1.setSelectedGrid(gridIdent);
        this.jTextArea1.setText("");
        try {
            this.bathyGrid = this.siteInfo.getBathyGrid(gridIdent);
        }
        catch (IOException ex) {
            SiftShare.log.log(Level.SEVERE, null, ex);
        }
        String inFileName = this.bathyGrid.getFileName();
        this.gridDir = this.bathyGrid.getGridFile().getParent();
        String outFileName = "";
        Vector<String> gridfiles = null;
        int ver = 0;
        int end = inFileName.lastIndexOf(".");
        int start = inFileName.lastIndexOf("_ver");
        if (end == -1) {
            start = inFileName.length();
        }
        if (start == -1) {
            start = end;
        }
        File dir = new File(this.gridDir);
        String sub = inFileName.substring(0, start);
        GridVersionFilenameFilter gvff = new GridVersionFilenameFilter(sub);
        gridfiles = new Vector<String>(Arrays.asList(dir.list(gvff)));
        Collections.sort(gridfiles);
        for (String gridfile : gridfiles) {
            end = gridfile.lastIndexOf(".");
            start = gridfile.lastIndexOf("_ver");
            if (start == -1 || end == -1) continue;
            try {
                ver = Integer.parseInt(gridfile.substring(start + 4, end));
            }
            catch (Exception exception) {}
        }
        outFileName = String.format("%s_ver%02d.corr", sub, ++ver);
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(gridfiles));
        this.jComboBox1.setSelectedItem(inFileName);
        this.outfileTextField.setText(outFileName);
    }

    public void setFullExtent() {
        this.setExtent(this.bathyGrid.getGridBox());
    }

    public void setExtent(Point2D.Double[] extent) {
        this.ynorthTextField.setValue(extent[3].y);
        this.ysouthTextField.setValue(extent[0].y);
        this.xwestTextField.setValue(extent[0].x);
        this.xeastTextField.setValue(extent[1].x);
    }

    @Override
    public void setSelectedExtent(int gridIdent, Point2D.Double[] extent) {
        this.setGrid(gridIdent);
        this.setExtent(extent);
    }

    public void bathyCorr(double wvmax, double grnd, double steep, double minLon, double maxLon, double minLat, double maxLat, BathyGrid bathyGrid, File outFile) {
        int i;
        double angle2;
        double angle1;
        double dm1;
        double dp1;
        int j;
        double[] lons = bathyGrid.getXArray();
        double[] lats = bathyGrid.getYArray();
        double dmax = bathyGrid.getZRange().end;
        double[] depths = bathyGrid.getZArray();
        double[][] d = new double[lons.length][lats.length];
        for (int i2 = 0; i2 < lons.length; ++i2) {
            for (int j2 = 0; j2 < lats.length; ++j2) {
                d[i2][j2] = -1.0 * depths[lats.length * i2 + j2];
            }
        }
        int nend = 0;
        int nstart = 0;
        int mend = 0;
        int mstart = 0;
        while (lons[mstart] < minLon && ++mstart != lons.length) {
        }
        while (lons[mend] < maxLon && ++mend != lons.length) {
        }
        while (lats[nstart] < minLat && ++nstart != lats.length) {
        }
        while (lats[nend] < maxLat && ++nend != lats.length) {
        }
        SiftShare.log.fine("bathcorr on file: " + this.jComboBox1.getSelectedItem());
        this.jTextArea1.append("istart: " + mstart + " iend: " + mend + " jstart: " + nstart + " jend: " + nend + "\n");
        this.jTextArea1.append("\nCorrections along X\n");
        int numX = 0;
        for (int i3 = mstart + 1; i3 < mend - 1; ++i3) {
            for (j = nstart; j < nend; ++j) {
                if (!(d[i3][j] > grnd)) continue;
                dp1 = d[i3 + 1][j];
                dm1 = d[i3 - 1][j];
                if (Math.abs(d[i3][j]) <= wvmax) {
                    angle1 = Math.abs(d[i3][j] - dm1) / Math.sqrt(Math.abs(dmax * 0.1));
                    angle2 = Math.abs(d[i3][j] - dp1) / Math.sqrt(Math.abs(dmax * 0.1));
                } else {
                    angle1 = Math.abs(d[i3][j] - dm1) / Math.sqrt(Math.abs(dmax * d[i3][j]));
                    angle2 = Math.abs(d[i3][j] - dp1) / Math.sqrt(Math.abs(dmax * d[i3][j]));
                }
                if (!(angle1 + angle2 > steep)) continue;
                this.jTextArea1.append(++numX + " point: i=" + i3 + " j=" + j + "\nOriginal : " + -d[i3 - 1][j] + " " + -d[i3][j] + " " + -d[i3 + 1][j] + "\n");
                d[i3][j] = Math.pow(dp1 - dm1, 2.0) / dmax / Math.pow(steep * 0.5, 2.0);
                if (!(d[i3][j] > Math.max(dp1, dm1)) && !(d[i3][j] < Math.min(dp1, dm1))) continue;
                d[i3][j] = 0.5 * (dp1 + dm1);
                this.jTextArea1.append("Corrected: " + -d[i3 - 1][j] + " " + -d[i3][j] + " " + -d[i3 + 1][j] + "\n");
            }
        }
        this.jTextArea1.append("\n\nCorrections along Y\n");
        int numY = 0;
        for (j = mstart; j < mend; ++j) {
            for (int i4 = nstart + 1; i4 < nend - 1; ++i4) {
                if (!(d[j][i4] > grnd)) continue;
                dp1 = d[j][i4 + 1];
                dm1 = d[j][i4 - 1];
                if (Math.abs(d[j][i4]) <= wvmax) {
                    angle1 = Math.abs(d[j][i4] - dm1) / Math.sqrt(Math.abs(dmax * 0.1));
                    angle2 = Math.abs(d[j][i4] - dp1) / Math.sqrt(Math.abs(dmax * 0.1));
                } else {
                    angle1 = Math.abs(d[j][i4] - dm1) / Math.sqrt(Math.abs(dmax * d[j][i4]));
                    angle2 = Math.abs(d[j][i4] - dp1) / Math.sqrt(Math.abs(dmax * d[j][i4]));
                }
                if (!(angle1 + angle2 > steep)) continue;
                this.jTextArea1.append(++numY + " point: i=" + j + " j=" + i4 + "\n");
                this.jTextArea1.append("Original : " + -d[j][i4 - 1] + " " + -d[j][i4] + " " + -d[j][i4 + 1] + "\n");
                d[j][i4] = Math.pow(dp1 - dm1, 2.0) / dmax / Math.pow(steep * 0.5, 2.0);
                if (!(d[j][i4] > Math.max(dp1, dm1)) && !(d[j][i4] < Math.min(dp1, dm1))) continue;
                d[j][i4] = 0.5 * (dp1 + dm1);
                this.jTextArea1.append("Corrected: " + -d[j][i4 - 1] + " " + -d[j][i4] + " " + -d[j][i4 + 1] + "\n");
            }
        }
        int numPts = (mend - mstart) * (nend - nstart);
        SiftShare.log.fine("Number of corrections, in X: " + numX + " in Y: " + numY + " out of: " + numPts);
        this.jTextArea1.append("Number of corrections, in X: " + numX + " out of: " + numPts + " or " + this.dfx.format(100.0 * (double)numX / (double)numPts) + "% changed\n");
        this.jTextArea1.append("Number of corrections, in Y: " + numY + " out of: " + numPts + " or " + this.dfx.format(100.0 * (double)numY / (double)numPts) + "% changed\n");
        double[] h1 = new double[lons.length - 1];
        double[] h2 = new double[lats.length - 1];
        for (i = 0; i < lons.length - 1; ++i) {
            h1[i] = (lons[i + 1] - lons[i]) * 111320.0;
        }
        for (i = 0; i < lats.length - 1; ++i) {
            h2[i] = (lats[i + 1] - lats[i]) * 111320.0;
        }
        double tmax = 60.0;
        int imax = 0;
        int jmax = 0;
        for (int i5 = 0; i5 < lons.length - 1; ++i5) {
            for (int j3 = 0; j3 < lats.length - 1; ++j3) {
                double tc2;
                double tc1;
                double tc;
                if (!(d[i5][j3] > 0.0) || !((tc = Math.min(tc1 = h1[i5] * Math.cos(Math.PI / 180 * lats[j3]) / Math.sqrt(9.8 * d[i5][j3]), tc2 = h2[j3] / Math.sqrt(9.8 * d[i5][j3]))) < tmax)) continue;
                tmax = tc;
                imax = i5;
                jmax = j3;
            }
        }
        SiftShare.log.fine("Maximum dt= " + tmax + "\n at depth" + -d[imax][jmax] + " m; i=" + imax + "j=" + jmax);
        int oldimax = bathyGrid.getMaxTimeStepX();
        int oldjmax = bathyGrid.getMaxTimeStepY();
        this.jTextArea1.append("Old CFL maximum dt= " + this.dfx.format(bathyGrid.getMaxTimeStep()) + "\n at Lon[" + oldimax + "]: " + lons[oldimax] + " Lat[" + oldjmax + "]: " + lats[oldjmax] + " depth: " + this.dfx.format(bathyGrid.getMaxTimeStepDepth()) + "\nNew CFL maximum dt= " + this.dfx.format(tmax) + "\nat Lon[" + imax + "]: " + lons[imax] + " Lat[" + jmax + "]: " + lats[jmax] + " depth: " + this.dfx.format(-d[imax][jmax]) + "\n");
        int result = JOptionPane.showConfirmDialog(this, "Total number of corrected points, in X: " + numX + " in Y: " + numY + "\nPercentage of points changed, in X: " + this.dfx.format(100.0 * (double)numX / (double)numPts) + "%, in Y: " + this.dfx.format(100.0 * (double)numY / (double)numPts) + "%\nOld CFL maximum dt= " + this.dfx.format(bathyGrid.getMaxTimeStep()) + "\n at Lon[" + oldimax + "]: " + this.dfxxxxx.format(lons[oldimax]) + " Lat[" + oldjmax + "]: " + this.dfxxxxx.format(lats[oldjmax]) + " depth: " + this.dfx.format(bathyGrid.getMaxTimeStepDepth()) + "\nNew CFL maximum dt= " + this.dfx.format(tmax) + "\nat Lon[" + imax + "]: " + this.dfxxxxx.format(lons[imax]) + " Lat[" + jmax + "]: " + this.dfxxxxx.format(lats[jmax]) + " depth: " + this.dfx.format(-d[imax][jmax]) + "\nSave corrections as new file?", "Save Corrections?", 0);
        if (result == 0) {
            SiftShare.log.fine("Saving bathcorr file: " + this.gridDir + File.separator + this.outfileTextField.getText());
            try {
                BathyGrid bg = BathyGrid.createNew(new File(this.gridDir, this.outfileTextField.getText()), lons, lats, d);
                this.siteInfo.setBathyGrid(this.gridIdent, bg);
                this.setGrid(this.gridIdent);
            }
            catch (IOException ex) {
                SiftShare.log.log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (name.equals("currentSite")) {
            this.setSite((SiteInfo)evt.getNewValue());
        } else if (name.equals("selectedGrid")) {
            this.setGrid(this.gridSelectorPanel1.getSelectedGrid());
            this.setFullExtent();
        }
    }

    public class GridVersionFilenameFilter
    implements FilenameFilter {
        private final String startname;

        public GridVersionFilenameFilter(String startname) {
            this.startname = startname;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.startsWith(this.startname);
        }
    }
}

