/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.tsunami.cmi.BathyGrid;
import gov.noaa.tsunami.cmi.CMIUtil;
import gov.noaa.tsunami.cmi.GridSelectorPanel;
import gov.noaa.tsunami.cmi.SiftShare;
import gov.noaa.tsunami.cmi.SiteInfo;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class BathySubsample
extends JDialog
implements PropertyChangeListener {
    private String gridDir = "";
    private SiteInfo siteInfo = null;
    private int gridIdent = 1;
    private BathyGrid bathyGrid;
    private GridSelectorPanel gridSelectorPanel1;
    private JButton jButton1;
    private JButton jButton2;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JSpinner jSpinner1;
    private JTextField outfileTextField;

    public BathySubsample(Frame parent, SiteInfo siteInfo) {
        super(parent, false);
        this.setLocationRelativeTo(parent);
        this.initComponents();
        this.setSite(siteInfo);
        this.gridSelectorPanel1.addPropertyChangeListener(this);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.gridSelectorPanel1 = new GridSelectorPanel();
        this.jLabel1 = new JLabel();
        this.jSpinner1 = new JSpinner();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jComboBox1 = new JComboBox();
        this.jLabel4 = new JLabel();
        this.outfileTextField = new JTextField();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.setDefaultCloseOperation(2);
        this.setTitle("Subsample Bathymetry");
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel1.setText("Subsample selected grid by:");
        this.jSpinner1.setModel(new SpinnerNumberModel(2, 2, 100, 1));
        this.jLabel2.setText("data point in x and y");
        this.jLabel3.setText("Input filename:");
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(new String[]{"infileName1"}));
        this.jComboBox1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BathySubsample.this.jComboBox1ActionPerformed(evt);
            }
        });
        this.jLabel4.setText("Output filename:");
        this.outfileTextField.setText("outfilename");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel1).addComponent(this.gridSelectorPanel1, -2, -1, -2)).addGap(18, 18, 18).addComponent(this.jSpinner1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel2).addGap(0, 189, Short.MAX_VALUE)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel3).addComponent(this.jLabel4)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.outfileTextField).addComponent(this.jComboBox1, 0, -1, Short.MAX_VALUE)))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.gridSelectorPanel1, -2, -1, -2).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jSpinner1, -2, -1, -2).addComponent(this.jLabel2)).addGap(18, 18, 18).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.jComboBox1, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.outfileTextField, -2, -1, -2)).addContainerGap(21, Short.MAX_VALUE)));
        this.jButton1.setText("Cancel");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BathySubsample.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText("Adjust");
        this.jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BathySubsample.this.jButton2ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButton2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButton1))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButton1).addComponent(this.jButton2)).addContainerGap()));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.setVisible(false);
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        try {
            BathyGrid bg = CMIUtil.currentSiteInfo.getBathyGrid(this.gridIdent);
            File outFile = new File(this.gridDir, this.outfileTextField.getText());
            int skip = (Integer)this.jSpinner1.getValue();
            this.bathyAdjust(bg, outFile, skip);
        }
        catch (IOException ioe) {
            SiftShare.log.log(Level.SEVERE, null, ioe);
        }
        this.setVisible(false);
    }

    private void jComboBox1ActionPerformed(ActionEvent evt) {
        try {
            BathyGrid bg = new BathyGrid(new File(this.gridDir, (String)this.jComboBox1.getSelectedItem()));
            this.siteInfo.setBathyGrid(this.gridIdent, bg);
            this.setGrid(this.gridIdent);
        }
        catch (IOException ex) {
            SiftShare.log.log(Level.SEVERE, null, ex);
        }
    }

    private void setSite(SiteInfo siteInfo) {
        this.siteInfo = siteInfo;
        this.setGrid(1);
    }

    private void setGrid(int gridIdent) {
        this.gridIdent = gridIdent;
        this.gridSelectorPanel1.setSelectedGrid(gridIdent);
        try {
            this.bathyGrid = this.siteInfo.getBathyGrid(gridIdent);
        }
        catch (IOException ex) {
            SiftShare.log.log(Level.SEVERE, null, ex);
        }
        String inFileName = this.bathyGrid.getFileName();
        this.gridDir = this.bathyGrid.getGridFile().getParent();
        String outFileName = "";
        Vector<String> gridfiles = null;
        int ver = 0;
        int end = inFileName.lastIndexOf(".");
        int start = inFileName.lastIndexOf("_ver");
        if (end == -1) {
            start = inFileName.length();
        }
        if (start == -1) {
            start = end;
        }
        File dir = new File(this.gridDir);
        String sub = inFileName.substring(0, start);
        GridVersionFilenameFilter gvff = new GridVersionFilenameFilter(sub);
        gridfiles = new Vector<String>(Arrays.asList(dir.list(gvff)));
        Collections.sort(gridfiles);
        for (String gridfile : gridfiles) {
            end = gridfile.lastIndexOf(".");
            start = gridfile.lastIndexOf("_ver");
            if (start == -1 || end == -1) continue;
            try {
                ver = Integer.parseInt(gridfile.substring(start + 4, end));
            }
            catch (Exception exception) {}
        }
        outFileName = String.format("%s_ver%02d.corr", sub, ++ver);
        this.jComboBox1.setModel(new DefaultComboBoxModel<String>(gridfiles));
        this.jComboBox1.setSelectedItem(inFileName);
        this.outfileTextField.setText(outFileName);
    }

    public void bathyAdjust(BathyGrid bathyGrid, File outFile, int skip) {
        int i;
        double[] depths = bathyGrid.getZArray();
        double[] lons = bathyGrid.getXArray();
        double[] lats = bathyGrid.getYArray();
        int nLon = lons.length / skip;
        int nLat = lats.length / skip;
        double[][] d = new double[nLon][nLat];
        double[] sublons = new double[nLon];
        double[] sublats = new double[nLat];
        for (i = 0; i < nLon; ++i) {
            sublons[i] = lons[i * skip];
        }
        for (int j = 0; j < nLat; ++j) {
            sublats[j] = lats[j * skip];
        }
        for (i = 0; i < nLon; ++i) {
            for (int j = 0; j < nLat; ++j) {
                d[i][j] = -1.0 * depths[lats.length * i * skip + j * skip];
            }
        }
        SiftShare.log.fine("Subsampled bathymetry for file: " + outFile.getPath() + " every: " + skip + " points.");
        int result = JOptionPane.showConfirmDialog(this, "Save subsampled bathymetry as new file?", "Save changes?", 0);
        if (result == 0) {
            SiftShare.log.fine("Saving subsampled bathy file: " + this.gridDir + File.separator + this.outfileTextField.getText());
            try {
                BathyGrid bg = BathyGrid.createNew(new File(this.gridDir, this.outfileTextField.getText()), sublons, sublats, d);
                this.siteInfo.setBathyGrid(this.gridIdent, bg);
                this.setGrid(this.gridIdent);
            }
            catch (IOException ex) {
                SiftShare.log.log(Level.SEVERE, null, ex);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if (name.equals("currentSite")) {
            this.setSite((SiteInfo)evt.getNewValue());
        } else if (name.equals("selectedGrid")) {
            this.setGrid(this.gridSelectorPanel1.getSelectedGrid());
        }
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(BathySubsample.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(BathySubsample.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(BathySubsample.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(BathySubsample.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                BathySubsample dialog = new BathySubsample((Frame)new JFrame(), null);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    public class GridVersionFilenameFilter
    implements FilenameFilter {
        private final String startname;

        public GridVersionFilenameFilter(String startname) {
            this.startname = startname;
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.startsWith(this.startname);
        }
    }
}

