/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.pmel.util.Point2D;
import gov.noaa.tsunami.cmi.SiftShare;
import gov.noaa.tsunami.cmi.SiteInfo;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StreamTokenizer;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;

public final class CMIUtil {
    protected static boolean DEBUG = false;
    public static final int INITIAL_CONDITION = 0;
    public static final int RUNUP = 1;
    protected static String MOST_EXEC;
    protected static int MOST_REV;
    protected static String MOSTProp_EXEC;
    protected static int MOSTProp_REV;
    protected static String DATABASE_LOC;
    protected static boolean showExitDialog;
    protected static String baseDirName;
    protected static String gridsDirName;
    protected static String workingDirName;
    protected static String etcDirName;
    protected static String publishDirName;
    protected static String propDirName;
    protected static String commitServerAddress;
    protected static String tsunamiCastAddress;
    protected static boolean propGlobal;
    protected static boolean workOffline;
    protected static String databaseInfoFileName;
    protected static SiteInfo currentSiteInfo;
    protected static String logLevel;
    protected static boolean useProxy;
    protected static String proxyServer;
    protected static int proxyPort;
    protected static String proxyUserName;
    protected static String proxyPass;
    protected static int maxNumArrows;
    protected static int graphicsres;
    protected static boolean firstTimeUser;
    static final DecimalFormat dfx;
    static final DecimalFormat dfxx;
    static final DecimalFormat dfxxx;
    static final DecimalFormat dfxxxx;
    static final Comparator<String> UNIT_SOURCE_ORDER;
    private static final Pattern SIMPLE_CHARS;

    protected CMIUtil() {
    }

    public static Frame getParentFrame(Component comp) {
        while (comp != null && !(comp instanceof Frame)) {
            comp = comp.getParent();
        }
        return (Frame)comp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File unpackFile(Object obj, String resourceFileName, File outputDir, String outputFileName) throws IOException {
        File file = new File(outputDir, outputFileName);
        if (file.exists()) {
            return file;
        }
        outputDir.mkdir();
        if (!outputDir.isDirectory()) {
            throw new IOException("can't create directory: " + outputDir.getAbsolutePath());
        }
        AbstractInterruptibleChannel fos = null;
        InputStream is = null;
        try {
            is = obj.getClass().getResourceAsStream(resourceFileName);
            if (is == null) {
                throw new IOException("packed file " + resourceFileName + " not found");
            }
            if (resourceFileName.endsWith("gz")) {
                is = new GZIPInputStream(is);
            }
            fos = new FileOutputStream(file).getChannel();
            ReadableByteChannel inch = Channels.newChannel(is);
            ((FileChannel)fos).transferFrom(inch, 0L, Long.MAX_VALUE);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (fos != null) {
                fos.close();
            }
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File importModelRun(InputStream is) throws IOException {
        File sitedir = null;
        try (ZipInputStream zis = new ZipInputStream(is);){
            ZipEntry ze = null;
            while ((ze = zis.getNextEntry()) != null) {
                SiftShare.log.info("zip entry name: " + ze.getName());
                File ofile = new File(workingDirName, ze.getName());
                if (sitedir == null) {
                    sitedir = new File(ofile.getParent());
                    sitedir.mkdirs();
                }
                FileOutputStream fos = new FileOutputStream(ofile);
                int c = zis.read();
                while (c != -1) {
                    fos.write(c);
                    c = zis.read();
                }
                fos.close();
            }
        }
        return sitedir;
    }

    public static boolean isInternetAvailable(String s, int milli) {
        boolean result = false;
        try {
            URL url = new URL(s);
            URLConnection conn = url.openConnection();
            conn.setConnectTimeout(milli);
            conn.connect();
            result = true;
        }
        catch (MalformedURLException malformedURLException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return result;
    }

    public static boolean cleanMostOutput(SiteInfo siteInfo, boolean removeModelOutput, boolean removeSourceFiles, boolean removeImages) {
        return CMIUtil.cleanMostOutput(siteInfo, removeModelOutput, removeSourceFiles, removeImages, removeModelOutput);
    }

    public static boolean cleanMostOutput(SiteInfo siteInfo, boolean removeModelOutput, boolean removeSourceFiles, boolean removeImages, boolean removeLincoFiles) {
        File[] fs;
        File dir;
        boolean result = true;
        if (removeModelOutput && (dir = siteInfo.getSiteDirectory()).exists()) {
            for (File f : dir.listFiles(new MostFileFilter(siteInfo.getActiveSourceName()))) {
                if (f.delete()) continue;
                result = false;
            }
        }
        if (removeSourceFiles && (dir = siteInfo.getSiteDirectory()).exists()) {
            for (File f : dir.listFiles(new MostICFileFilter())) {
                if (f.delete()) continue;
                result = false;
            }
        }
        if (removeImages && (dir = new File(siteInfo.getSiteDirectory(), "images")).exists()) {
            for (File f : dir.listFiles(new MostImageFileFilter())) {
                if (f.delete()) continue;
                result = false;
            }
        }
        if (removeLincoFiles && (dir = siteInfo.getSiteDirectory()).exists()) {
            for (File f : dir.listFiles(new LincoFileFilter(siteInfo.getActiveSourceName()))) {
                if (f.delete()) continue;
                result = false;
            }
        }
        File ofile = new File(siteInfo.getSiteDirectory(), "output_" + siteInfo.getName() + "_" + siteInfo.getActiveSourceName() + ".lis");
        ofile.delete();
        for (File f : fs = siteInfo.getSiteDirectory().listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.toLowerCase().startsWith("shootmenow");
            }
        })) {
            f.delete();
        }
        ofile = new File(siteInfo.getSiteDirectory(), "deforma.dat");
        ofile.delete();
        ofile = new File(siteInfo.getSiteDirectory(), "deformb.dat");
        ofile.delete();
        ofile = new File(siteInfo.getSiteDirectory(), "deformc.dat");
        ofile.delete();
        return result;
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = CMIUtil.deleteDir(new File(dir, children[i]));
                if (success) continue;
                return false;
            }
        }
        return dir.delete();
    }

    public static boolean deleteFile(File f) {
        boolean result = false;
        if (!f.exists()) {
            return true;
        }
        for (int i = 0; i < 3; ++i) {
            if (!f.delete()) {
                SiftShare.log.warning("\ncouldnt delete file, tries: " + i + "\n");
                System.gc();
                try {
                    Thread.sleep(400L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (!f.delete()) continue;
                return true;
            }
            return true;
        }
        return result;
    }

    private static List<String> getPathList(File f) throws IOException {
        ArrayList<String> l = new ArrayList<String>();
        for (File r = f.getCanonicalFile(); r != null && r.getName().length() >= 0; r = r.getParentFile()) {
            l.add(r.getName());
        }
        return l;
    }

    private static String matchPathLists(List<String> r, List<String> f) {
        int j;
        String s = "";
        int i = r.size() - 1;
        for (j = f.size() - 1; i >= 0 && j >= 0 && r.get(i).equals(f.get(j)); --i, --j) {
        }
        while (i >= 0) {
            s = s + ".." + File.separator;
            --i;
        }
        while (j >= 1) {
            s = s + f.get(j) + File.separator;
            --j;
        }
        s = s + f.get(j);
        return s;
    }

    public static String getRelativePath(File home, File f) throws IOException {
        return CMIUtil.matchPathLists(CMIUtil.getPathList(home), CMIUtil.getPathList(f));
    }

    public static void copyFile(File inFile, File outFile) throws IOException {
        FileInputStream fis = new FileInputStream(inFile);
        FileOutputStream fos = new FileOutputStream(outFile);
        byte[] buf = new byte[1024];
        int read = 0;
        while ((read = fis.read(buf)) != -1) {
            fos.write(buf, 0, read);
        }
        fis.close();
        fos.flush();
        fos.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Point2D.Double[] createGridBox(String path, String gridName) {
        Point2D.Double[] Pt = new Point2D.Double[4];
        double minLat = 0.0;
        double maxLat = 0.0;
        double minLon = 0.0;
        double maxLon = 0.0;
        InputStreamReader fr = null;
        BufferedReader br = null;
        if (CMIUtil.IsValidMOSTFile(new File(path, gridName)) > 0) {
            try {
                fr = new FileReader(path + File.separator + gridName);
                br = new BufferedReader(fr);
                StreamTokenizer st = new StreamTokenizer(br);
                int type = st.nextToken();
                if (type != -2 || type == -1) {
                    Point2D.Double[] doubleArray = null;
                    return doubleArray;
                }
                int xind = (int)st.nval;
                type = st.nextToken();
                if (type != -2 || type == -1) {
                    Point2D.Double[] doubleArray = null;
                    return doubleArray;
                }
                int yind = (int)st.nval;
                st.nextToken();
                minLon = st.nval;
                for (int i = 1; i < xind - 1; ++i) {
                    type = st.nextToken();
                    if (type == -2 && type != -1) continue;
                    Point2D.Double[] doubleArray = null;
                    return doubleArray;
                }
                st.nextToken();
                maxLon = st.nval;
                st.nextToken();
                maxLat = st.nval;
                for (int j = 1; j < yind - 1; ++j) {
                    type = st.nextToken();
                    if (type == -2 && type != -1) continue;
                    Point2D.Double[] doubleArray = null;
                    return doubleArray;
                }
                st.nextToken();
                minLat = st.nval;
                br.close();
                fr.close();
            }
            catch (IOException e) {
                SiftShare.log.log(Level.WARNING, "error reading file: " + path + gridName, e);
            }
            finally {
                try {
                    br.close();
                }
                catch (Exception e) {}
                try {
                    fr.close();
                }
                catch (Exception e) {}
            }
        } else if (CMIUtil.IsValidGridFile(new File(path, gridName)) > 0) {
            try {
                fr = new FileReader(path + File.separator + gridName);
                br = new BufferedReader(fr);
                String inputLine = br.readLine();
                if (inputLine == null) {
                    return Pt;
                }
                String[] inputArray = inputLine.trim().split("\\s+");
                int xind = Integer.parseInt(inputArray[1]);
                inputLine = br.readLine();
                if (inputLine == null) {
                    return Pt;
                }
                inputArray = inputLine.trim().split("\\s+");
                int yind = Integer.parseInt(inputArray[1]);
                inputLine = br.readLine();
                if (inputLine == null) {
                    return Pt;
                }
                inputArray = inputLine.trim().split("\\s+");
                double xllcorner = Double.parseDouble(inputArray[1]);
                inputLine = br.readLine();
                if (inputLine == null) {
                    return Pt;
                }
                inputArray = inputLine.trim().split("\\s+");
                double yllcorner = Double.parseDouble(inputArray[1]);
                inputLine = br.readLine();
                if (inputLine == null) {
                    return Pt;
                }
                inputArray = inputLine.trim().split("\\s+");
                float cellsize = Float.parseFloat(inputArray[1]);
                minLon = xllcorner + 0.5 * (double)cellsize;
                maxLon = xllcorner + 0.5 * (double)cellsize + (double)cellsize * (double)(xind - 1);
                minLat = yllcorner + 0.5 * (double)cellsize;
                maxLat = yllcorner + 0.5 * (double)cellsize + (double)cellsize * (double)(yind - 1);
                br.close();
                fr.close();
            }
            catch (IOException e) {
                SiftShare.log.log(Level.WARNING, "error reading file: " + path + gridName, e);
            }
        }
        Pt[0] = new Point2D.Double(minLon, minLat);
        Pt[1] = new Point2D.Double(maxLon, minLat);
        Pt[2] = new Point2D.Double(maxLon, maxLat);
        Pt[3] = new Point2D.Double(minLon, maxLat);
        return Pt;
    }

    public static int IsValidGridFile(File f) {
        int xind = 0;
        int yind = 0;
        try {
            StreamTokenizer st = new StreamTokenizer(new BufferedReader(new FileReader(f)));
            int type = st.nextToken();
            type = st.nextToken();
            if (type != -2 || type == -1) {
                return 0;
            }
            xind = (int)st.nval;
            type = st.nextToken();
            type = st.nextToken();
            if (type != -2 || type == -1) {
                return 0;
            }
            yind = (int)st.nval;
            type = st.nextToken();
            type = st.nextToken();
            if (st.nval > 360.0 || st.nval < -360.0) {
                return -1;
            }
            type = st.nextToken();
            type = st.nextToken();
            type = st.nextToken();
            type = st.nextToken();
            type = st.nextToken();
            if (type == -3) {
                type = st.nextToken();
            }
            for (int j = 0; j < yind; ++j) {
                for (int i = 0; i < xind; ++i) {
                    st.nextToken();
                    if (type != -1) continue;
                    return 0;
                }
            }
        }
        catch (IOException ignore) {
            xind = 0;
            yind = 0;
        }
        return xind * yind;
    }

    public static int IsValidMOSTFile(File f) {
        int xind = 0;
        int yind = 0;
        try {
            int i;
            StreamTokenizer st = new StreamTokenizer(new BufferedReader(new FileReader(f)));
            int type = st.nextToken();
            if (type != -2 || type == -1) {
                return 0;
            }
            xind = (int)st.nval;
            type = st.nextToken();
            if (type != -2 || type == -1) {
                return 0;
            }
            yind = (int)st.nval;
            for (i = 0; i < xind; ++i) {
                type = st.nextToken();
                if (type == -2 && type != -1) continue;
                return 0;
            }
            for (int j = 0; j < yind; ++j) {
                type = st.nextToken();
                if (type == -2 && type != -1) continue;
                return 0;
            }
            for (i = 0; i < xind; ++i) {
                for (int j = 0; j < yind; ++j) {
                    type = st.nextToken();
                    if (type != -1) continue;
                    return 0;
                }
            }
        }
        catch (IOException ignore) {
            xind = 0;
            yind = 0;
        }
        return xind * yind;
    }

    public static void updateInfoSZ(String directoryName, JFrame mainApp) {
        File dir = new File(directoryName);
        if (!dir.exists()) {
            JOptionPane.showMessageDialog(mainApp, "Directory: " + directoryName + " doesn't exist!", "Error updating Propagation DB", 0);
            return;
        }
        if (!dir.canWrite()) {
            JOptionPane.showMessageDialog(mainApp, "You don't have write permission for directory: " + directoryName, "Error updating Propagation DB", 0);
            return;
        }
        File infoFile = new File(directoryName, "info_sz.dat");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd-HH-mm");
        String currentTime = sdf.format(Calendar.getInstance().getTime());
        if (infoFile.exists()) {
            try {
                CMIUtil.copyFile(infoFile, new File(directoryName, "info_sz.dat" + currentTime));
                FileWriter fw = new FileWriter(infoFile, false);
                fw.write("# Propagation database metadata file\n");
                fw.write("# OpenDAP URL prefix, NONE\n");
                fw.write("# Name, Filename/URL, Long(deg), Lat(deg), Slip(m), Strike(deg), Dip(deg), Depth(km), Length(km), Width(km), Rake(deg)\n");
                fw.close();
            }
            catch (IOException ex) {
                SiftShare.log.log(Level.WARNING, "can't copy info_sz.dat file", ex);
            }
        }
        File[] files = dir.listFiles();
        try {
            for (File f : files) {
                String fileName = f.getCanonicalPath();
                if (!fileName.endsWith("ha.nc") || !new File(fileName.replaceAll("ha.nc", "ua.nc")).exists() || !new File(fileName.replaceAll("ha.nc", "va.nc")).exists()) continue;
                CMIUtil.addInfoSZline(infoFile, fileName);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        CMIUtil.sortInfoSZ(infoFile);
    }

    public static void addInfoSZline(File infoFile, String netCDFFileName) {
        try {
            FileWriter fw = new FileWriter(infoFile, true);
            NetcdfFile ncFile = NetcdfFile.open(netCDFFileName);
            Attribute att = ncFile.findGlobalAttribute("Source_Zone_Code");
            if (att == null) {
                SiftShare.log.log(Level.WARNING, "old-format propagation file missing metadata {0}", netCDFFileName);
                ncFile.close();
                fw.close();
                return;
            }
            String zoneCode = att.getStringValue() + "sz";
            att = ncFile.findGlobalAttribute("Source_Row");
            String row = "null";
            row = att.isString() ? att.getStringValue() : att.getNumericValue().toString();
            att = ncFile.findGlobalAttribute("Source_Latitude");
            if (att == null) {
                SiftShare.log.warning("custom prop file, no seismic info");
                ncFile.close();
                fw.close();
                return;
            }
            String col = ncFile.findGlobalAttribute("Source_Column").getStringValue();
            float lat = ncFile.findGlobalAttribute("Source_Latitude").getNumericValue().floatValue();
            float lon = ncFile.findGlobalAttribute("Source_Longitude").getNumericValue().floatValue();
            float slip = ncFile.findGlobalAttribute("Slip").getNumericValue().floatValue();
            float strike = ncFile.findGlobalAttribute("Strike").getNumericValue().floatValue();
            float dip = ncFile.findGlobalAttribute("Dip").getNumericValue().floatValue();
            float depth = ncFile.findGlobalAttribute("Depth").getNumericValue().floatValue();
            float len = ncFile.findGlobalAttribute("Source_Length").getNumericValue().floatValue();
            float wid = ncFile.findGlobalAttribute("Source_Width").getNumericValue().floatValue();
            float rake = ncFile.findGlobalAttribute("Rake").getNumericValue().floatValue();
            fw.write(zoneCode + col + row + ", " + netCDFFileName + ", " + dfxxxx.format(lon) + ", " + dfxxxx.format(lat) + ", " + dfxx.format(slip) + ", " + dfxx.format(strike) + ", " + dfxx.format(dip) + ", " + dfx.format(depth) + ", " + dfx.format(len) + ", " + dfx.format(wid) + ", " + dfx.format(rake) + "\n");
            fw.close();
            ncFile.close();
        }
        catch (Exception e) {
            SiftShare.log.log(Level.WARNING, "error in addInfoSZline: ", e);
        }
    }

    public static void removeInfoSZline(File infoFile, String netCDFFileName) {
        StringBuilder sb = new StringBuilder();
        try {
            String inputLine;
            FileReader fr = new FileReader(infoFile);
            BufferedReader br = new BufferedReader(fr);
            while ((inputLine = br.readLine()) != null) {
                if (inputLine.indexOf(netCDFFileName) == -1) continue;
                sb.append(inputLine);
            }
            br.close();
            fr.close();
            FileWriter fw = new FileWriter(infoFile, false);
            fw.write(sb.toString());
            fw.close();
        }
        catch (Exception ex) {
            SiftShare.log.log(Level.WARNING, "error in removeInfoSZline: ", ex);
        }
    }

    public static void sortInfoSZ(File infoFile) {
        ArrayList<String> infoList = new ArrayList<String>(200);
        try {
            String inputLine;
            FileReader fr = new FileReader(infoFile);
            BufferedReader br = new BufferedReader(fr);
            while ((inputLine = br.readLine()) != null) {
                infoList.add(inputLine);
            }
            br.close();
            fr.close();
            Collections.sort(infoList, UNIT_SOURCE_ORDER);
            FileWriter fw = new FileWriter(infoFile, false);
            for (String s : infoList) {
                fw.write(s + "\n");
            }
            fw.close();
        }
        catch (Exception ex) {
            SiftShare.log.log(Level.WARNING, "error in removeInfoSZline: ", ex);
        }
    }

    public static void installEscapeCloseOperation(final JDialog dialog) {
        KeyStroke escapeStroke = KeyStroke.getKeyStroke(27, 0);
        String dispatchWindowClosingActionMapKey = "WINDOW_CLOSING";
        AbstractAction dispatchClosing = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent event) {
                dialog.dispatchEvent(new WindowEvent(dialog, 201));
            }
        };
        JRootPane root = dialog.getRootPane();
        root.getInputMap(2).put(escapeStroke, "WINDOW_CLOSING");
        root.getActionMap().put("WINDOW_CLOSING", dispatchClosing);
    }

    public static void setProxyEnabled(boolean isProxy) {
        useProxy = isProxy;
        if (useProxy) {
            SiftShare.log.info("Setting Proxy settings:\nProxyHost: " + proxyServer + "\nProxyPort:" + proxyPort + "\nProxyUser: " + proxyUserName);
        } else {
            SiftShare.log.info("No Proxy settings set (http.proxySet=false)");
        }
        System.setProperty("http.proxySet", isProxy ? "true" : "false");
        System.setProperty("http.proxyHost", isProxy ? proxyServer : "");
        System.setProperty("http.proxyPort", isProxy ? String.valueOf(proxyPort) : "");
        System.setProperty("https.proxyHost", isProxy ? proxyServer : "");
        System.setProperty("https.proxyPort", isProxy ? String.valueOf(proxyPort) : "");
        if (isProxy && !proxyUserName.equals("")) {
            Authenticator.setDefault(new Authenticator(){

                @Override
                public PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(proxyUserName, proxyPass.toCharArray());
                }
            });
        } else {
            Authenticator.setDefault(null);
        }
    }

    public static boolean isProxyEnabled() {
        return useProxy;
    }

    public static void setProxy(String host, int port, String user, String password) {
        if (host == null) {
            host = "";
        }
        if (user == null) {
            user = "";
        }
        if (password == null) {
            password = "";
        }
        proxyServer = host;
        proxyPort = port;
        proxyUserName = user;
        proxyPass = password;
        CMIUtil.setProxyEnabled(CMIUtil.isProxyEnabled());
    }

    public static void runOnDispatchThread(Runnable r) {
        if (SwingUtilities.isEventDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    public static String capitalize(String str) {
        if (str == null || str.length() == 0) {
            return str;
        }
        int strLen = str.length();
        StringBuilder buffer = new StringBuilder(strLen);
        boolean capitalizeNext = true;
        for (int i = 0; i < strLen; ++i) {
            char ch = str.charAt(i);
            if (Character.isWhitespace(ch)) {
                buffer.append(ch);
                capitalizeNext = true;
                continue;
            }
            if (capitalizeNext) {
                buffer.append(Character.toTitleCase(ch));
                capitalizeNext = false;
                continue;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    public static String encodeUnusualChars(String aText) throws UnsupportedEncodingException {
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iter = new StringCharacterIterator(aText);
        char c = iter.first();
        while (c != '\uffff') {
            char[] chars = new char[]{c};
            String character = new String(chars);
            if (CMIUtil.isSimpleCharacter(character)) {
                result.append(c);
            } else {
                CMIUtil.hexEncode(character, "UTF-8", result);
            }
            c = iter.next();
        }
        return result.toString();
    }

    public static boolean isSimpleCharacter(String aCharacter) {
        Matcher matcher = SIMPLE_CHARS.matcher(aCharacter);
        return matcher.matches();
    }

    private static void hexEncode(String aCharacter, String aEncoding, StringBuilder aOut) throws UnsupportedEncodingException {
        String HEX_DIGITS = "0123456789ABCDEF";
        byte[] bytes = aCharacter.getBytes(aEncoding);
        for (int idx = 0; idx < bytes.length; ++idx) {
            aOut.append('%');
            aOut.append(HEX_DIGITS.charAt((bytes[idx] & 0xF0) >> 4));
            aOut.append(HEX_DIGITS.charAt(bytes[idx] & 0xF));
        }
    }

    static {
        commitServerAddress = "https://sift.pmel.noaa.gov/ComMIT";
        tsunamiCastAddress = "https://nctr.pmel.noaa.gov/tweb";
        dfx = new DecimalFormat("0.0");
        dfxx = new DecimalFormat("0.00");
        dfxxx = new DecimalFormat("0.000");
        dfxxxx = new DecimalFormat("0.0000");
        UNIT_SOURCE_ORDER = new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                int numberCmp;
                String hold1 = s1.split(",")[0].trim();
                String hold2 = s2.split(",")[0].trim();
                if (hold1.indexOf("sz") != 2 || hold2.indexOf("sz") != 2) {
                    return 0;
                }
                String letter1 = hold1.substring(4, 5);
                String letter2 = hold2.substring(4, 5);
                String zone1 = hold1.substring(0, 4);
                String zone2 = hold2.substring(0, 4);
                int number1 = Integer.parseInt(hold1.replaceAll(zone1, "").replace(letter1, ""));
                int number2 = Integer.parseInt(hold2.replaceAll(zone2, "").replace(letter2, ""));
                int zoneCmp = zone1.compareTo(zone2);
                if (number1 == number2) {
                    numberCmp = 0;
                } else {
                    int n = numberCmp = number1 > number2 ? 1 : -1;
                }
                return zoneCmp != 0 ? zoneCmp : (numberCmp != 0 ? numberCmp : letter1.compareTo(letter2));
            }
        };
        SIMPLE_CHARS = Pattern.compile("[a-zA-Z0-9]");
    }

    private static class MostImageFileFilter
    implements FileFilter {
        @Override
        public boolean accept(File f) {
            String name = f.getName();
            return name.endsWith(".gif") || name.endsWith(".jpg") || name.endsWith(".png");
        }
    }

    private static class MostICFileFilter
    implements FileFilter {
        @Override
        public boolean accept(File f) {
            String name = f.getName();
            if (name.endsWith("a.nc") && name.indexOf("runup") == -1) {
                return true;
            }
            if (name.equals("info_sz.dat")) {
                return true;
            }
            return name.startsWith("linCo");
        }
    }

    public static class LincoFileFilter
    implements FileFilter {
        private static String source = "";

        public LincoFileFilter(String source) {
            LincoFileFilter.source = source;
        }

        @Override
        public boolean accept(File f) {
            return f.getName().startsWith("linCo_" + source);
        }
    }

    public static class MostFileFilter
    implements FileFilter {
        private static String source = "";

        public MostFileFilter(String source) {
            MostFileFilter.source = source;
        }

        @Override
        public boolean accept(File f) {
            String name = f.getName();
            if (name.endsWith(".nc") && name.contains(source + "_runup")) {
                return true;
            }
            if (name.endsWith(source + "_restart.nc")) {
                return true;
            }
            if (name.endsWith(source + "_sift.nc")) {
                return true;
            }
            return name.endsWith(source + "_siftTS.nc");
        }
    }
}

