/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.tsunami.cmi.CMIUtil;
import gov.noaa.tsunami.cmi.ModelRunComboBoxRenderer;
import gov.noaa.tsunami.cmi.ModelRunner;
import gov.noaa.tsunami.cmi.SiftShare;
import gov.noaa.tsunami.cmi.SiteInfo;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.jdesktop.layout.GroupLayout;

public class ClearModelRunDialog
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private int returnStatus = 0;
    private final ArrayList<SiteInfo> allOpenSites;
    private Collection<SiteInfo> clearSites;
    private ModelRunner mostModelRunner = null;
    private JCheckBox allRunsCheckBox;
    private JCheckBox imagesCheckBox;
    private JComboBox modelRunComboBox;
    private JCheckBox outputFilesCheckBox;
    private JCheckBox sourceFilesCheckBox;
    private JCheckBox sourcesCheckBox;

    public ClearModelRunDialog(Frame parent, ArrayList<SiteInfo> openSites, ModelRunner modelRunner) {
        super(parent, true);
        this.allOpenSites = openSites;
        this.initComponents();
        CMIUtil.installEscapeCloseOperation(this);
        if (modelRunner != null) {
            this.mostModelRunner = modelRunner;
        }
        DefaultComboBoxModel<SiteInfo> cbm = new DefaultComboBoxModel<SiteInfo>();
        for (SiteInfo s : this.allOpenSites) {
            cbm.addElement(s);
        }
        this.modelRunComboBox.setModel(cbm);
    }

    private void initComponents() {
        JButton okButton = new JButton();
        JButton cancelButton = new JButton();
        JLabel jLabel1 = new JLabel();
        this.sourceFilesCheckBox = new JCheckBox();
        this.outputFilesCheckBox = new JCheckBox();
        JLabel jLabel2 = new JLabel();
        this.allRunsCheckBox = new JCheckBox();
        this.modelRunComboBox = new JComboBox();
        this.imagesCheckBox = new JCheckBox();
        this.sourcesCheckBox = new JCheckBox();
        this.setTitle("Clear Model Run Data");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                ClearModelRunDialog.this.formWindowClosing(evt);
            }
        });
        okButton.setText("Clear Model Run Data Now");
        okButton.setActionCommand("Clear Model Results Data Now");
        okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClearModelRunDialog.this.okButtonActionPerformed(evt);
            }
        });
        cancelButton.setText("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClearModelRunDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        jLabel1.setFont(new Font("Dialog", 0, 18));
        jLabel1.setText("Remove the following items:");
        this.sourceFilesCheckBox.setFont(new Font("Dialog", 0, 14));
        this.sourceFilesCheckBox.setText("Model Initial Condition (source) files");
        this.outputFilesCheckBox.setFont(new Font("Dialog", 0, 14));
        this.outputFilesCheckBox.setSelected(true);
        this.outputFilesCheckBox.setText("Model output files");
        jLabel2.setFont(new Font("Dialog", 0, 18));
        jLabel2.setText("Clear Model Results:");
        this.allRunsCheckBox.setFont(new Font("Dialog", 0, 14));
        this.allRunsCheckBox.setText("All open models");
        this.allRunsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ClearModelRunDialog.this.allRunsCheckBoxActionPerformed(evt);
            }
        });
        this.modelRunComboBox.setRenderer(new ModelRunComboBoxRenderer());
        this.imagesCheckBox.setFont(new Font("Dialog", 0, 14));
        this.imagesCheckBox.setSelected(true);
        this.imagesCheckBox.setText("Model animation images");
        this.sourcesCheckBox.setText("All sources for each model");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(this.allRunsCheckBox).add(jLabel2).add(layout.createParallelGroup(2, false).add(1, this.modelRunComboBox, 0, -1, Short.MAX_VALUE).add(1, layout.createSequentialGroup().add(94, 94, 94).add(okButton).addPreferredGap(1).add(cancelButton))).add(this.imagesCheckBox).add(layout.createParallelGroup(2, false).add(1, this.outputFilesCheckBox).add(1, this.sourceFilesCheckBox, -1, -1, Short.MAX_VALUE).add(1, jLabel1)).add(this.sourcesCheckBox)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add(jLabel2).addPreferredGap(0).add(this.modelRunComboBox, -2, -1, -2).addPreferredGap(1).add(this.allRunsCheckBox, -2, 23, -2).addPreferredGap(1).add(jLabel1).addPreferredGap(1).add(this.sourcesCheckBox).addPreferredGap(0).add(this.sourceFilesCheckBox).addPreferredGap(1).add(this.outputFilesCheckBox).addPreferredGap(1).add(this.imagesCheckBox).add(34, 34, 34).add(layout.createParallelGroup(3).add(okButton).add(cancelButton)).addContainerGap()));
        this.pack();
    }

    private void allRunsCheckBoxActionPerformed(ActionEvent evt) {
        if (this.allRunsCheckBox.isSelected()) {
            this.modelRunComboBox.setEnabled(false);
        } else {
            this.modelRunComboBox.setEnabled(true);
        }
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.doClose(1);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void formWindowClosing(WindowEvent evt) {
        this.doClose(0);
    }

    void setSelectedSite(SiteInfo currentSite) {
        this.modelRunComboBox.setSelectedItem(currentSite);
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    public Collection<SiteInfo> getClearSites() {
        return this.clearSites;
    }

    private void doClose(int retStatus) {
        this.returnStatus = retStatus;
        String site = "";
        String sources = "";
        if (this.returnStatus == 1) {
            if (this.allRunsCheckBox.isSelected()) {
                site = "All Model Runs";
                this.clearSites = this.allOpenSites;
            } else {
                SiteInfo si = (SiteInfo)this.modelRunComboBox.getSelectedItem();
                site = si.getName();
                this.clearSites = Collections.singletonList(si);
            }
            sources = this.sourcesCheckBox.isSelected() ? ", all sources\n" : ", active source\n";
            int result = JOptionPane.showConfirmDialog(this, "This action will delete Model Run files for: \n" + site + sources + "\n and cancel any running model\n\nClick \"OK\" to continue...", "CAUTION", 2);
            if (result == 0) {
                SiftShare.log.info("Clearing Model Site data...");
                for (SiteInfo siteInfo : this.clearSites) {
                    if (this.mostModelRunner != null && this.mostModelRunner.getModelSite().equals(siteInfo)) {
                        this.mostModelRunner.stop();
                    }
                    if (this.sourcesCheckBox.isSelected()) {
                        String savesource = siteInfo.getActiveSourceName();
                        for (String sname : siteInfo.getSourceNames()) {
                            siteInfo.setSource(sname);
                            CMIUtil.cleanMostOutput(siteInfo, this.outputFilesCheckBox.isSelected(), this.sourceFilesCheckBox.isSelected(), this.imagesCheckBox.isSelected(), this.sourceFilesCheckBox.isSelected());
                        }
                        siteInfo.setSource(savesource);
                        continue;
                    }
                    CMIUtil.cleanMostOutput(siteInfo, this.outputFilesCheckBox.isSelected(), this.sourceFilesCheckBox.isSelected(), this.imagesCheckBox.isSelected(), this.sourceFilesCheckBox.isSelected());
                }
            }
        }
        this.setVisible(false);
    }
}

