/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.tsunami.cmi.EnumeratedColorMap;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.text.DecimalFormat;
import javax.swing.ImageIcon;
import javax.swing.JPanel;

public class ColorBar
extends JPanel {
    private Image mOffScreen = null;
    private Color mLineColor;
    private int mOrientation = 0;
    private boolean mLabelPanel = true;
    private int mWidth;
    private int mHeight;
    public static final int VERTICAL_ORIENTATION = 0;
    public static final int HORIZONTAL_ORIENTATION = 1;
    public static String DEFAULT_COLORBAR_LABEL_FONT = "serif";
    public static int DEFAULT_COLORBAR_LABEL_SIZE = 12;
    public static int DEFAULT_COLORBAR_LABEL_STYLE = 0;
    public static Color DEFAULT_COLORBAR_LABEL_COLOR = Color.black;
    private EnumeratedColorMap cmap;
    private DecimalFormat df = new DecimalFormat("#");
    private DecimalFormat dfx = new DecimalFormat("0.0");
    private DecimalFormat dfxx = new DecimalFormat("0.00");
    private DecimalFormat dfxxx = new DecimalFormat("0.000");
    private String units = "[cm]";
    private int StringXOffset;
    private int StringYOffset;
    private boolean isCurrents = false;

    public ColorBar(int orientation) {
        this.mOrientation = orientation;
        this.StringXOffset = 35;
        this.StringYOffset = -7;
        if (this.mOrientation == 1) {
            this.mWidth = 550;
            this.mHeight = 50;
        } else {
            this.mWidth = 80;
            this.mHeight = 530;
        }
    }

    public void setColorMap(EnumeratedColorMap c) {
        this.cmap = c;
        this.invalidate();
        this.repaint();
    }

    public void setCurrents(boolean b) {
        this.isCurrents = b;
    }

    @Override
    public void invalidate() {
        try {
            super.invalidate();
            if (this.mOffScreen != null) {
                this.mOffScreen = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void paintComponent(Graphics gin) {
        Graphics2D g = (Graphics2D)gin;
        if (this.mOffScreen == null) {
            this.mOffScreen = this.createImage(this.getSize().width, this.getSize().height);
            Graphics2D og = (Graphics2D)this.mOffScreen.getGraphics();
            super.paintComponent(og);
            if (this.mLineColor != null) {
                this.DrawColorLines(og);
            } else {
                this.DrawColorBar(og);
            }
            g.drawImage(this.mOffScreen, 0, 0, null);
            og.dispose();
        } else {
            g.drawImage(this.mOffScreen, 0, 0, null);
        }
    }

    public void redraw() {
        this.invalidate();
    }

    public void setUnits(String s) {
        this.units = s;
    }

    public void DrawColorLines(Graphics2D g) {
        int numColors = this.cmap.getNumLevels();
        Dimension d = this.getSize();
        int left = 0;
        int right = d.width;
        int top = 100;
        int bottom = d.height - 100;
        int pixelsPerBand = (bottom - top - 2) / numColors;
        int bandTop = 0;
        int bandBottom = 0;
        boolean bandLeft = false;
        boolean bandRight = false;
        g.setFont(new Font(DEFAULT_COLORBAR_LABEL_FONT, DEFAULT_COLORBAR_LABEL_STYLE, DEFAULT_COLORBAR_LABEL_SIZE));
        FontMetrics fm = g.getFontMetrics();
        int labelInc = 1;
        boolean maxWidth = false;
        boolean labelHInc = true;
        boolean offsetLabels = false;
        boolean maxH = false;
        boolean maxLabelH = false;
        boolean drawSelection = false;
        boolean selTop = false;
        boolean selBottom = false;
        for (int i = 0; i < numColors; ++i) {
            bandTop = top + i * pixelsPerBand;
            bandBottom = bandTop + pixelsPerBand;
            if (this.mLineColor instanceof Color) {
                g.setColor(this.mLineColor);
            } else {
                g.setColor(this.cmap.getColor(i));
            }
            int l = left + 10;
            int r = left + 25;
            int h = l + (r - l) / 2;
            g.drawLine(l, bandBottom, h, bandTop);
            g.drawLine(h, bandTop, r, bandBottom);
            g.setColor(Color.black);
            if (i % labelInc != 0) continue;
            double val = this.cmap.getDoubleValue(i);
            String sTemp = this.df.format(val);
            if (val > -100.0 && val < 100.0) {
                sTemp = this.dfx.format(val);
            }
            if (val > -10.0 && val < 10.0) {
                sTemp = this.dfxx.format(val);
            }
            if (val > -1.0 && val < 1.0) {
                sTemp = this.dfxxx.format(val);
            }
            g.drawString(sTemp, left + 35, bandBottom);
        }
    }

    public void DrawColorBar(Graphics2D g) {
        int i;
        int numColors = this.cmap.getNumLevels() - 1;
        Dimension d = this.getSize();
        int left = 0;
        int right = d.width;
        int top = 30;
        int bottom = d.height - 30;
        int pixelsPerBand = (bottom - top - 2) / numColors;
        int bandTop = 0;
        int bandBottom = 0;
        int c = numColors - 1;
        int labelInc = 1;
        if (numColors <= 60) {
            labelInc = 1;
        } else if (numColors > 60 && numColors <= 80) {
            labelInc = 2;
        } else if (numColors > 80 && numColors <= 120) {
            labelInc = 3;
        } else if (numColors > 120 && numColors <= 150) {
            labelInc = 4;
        } else if (numColors > 150 && numColors <= 200) {
            labelInc = 8;
        } else if (numColors > 200) {
            labelInc = 16;
        }
        g.setFont(new Font(DEFAULT_COLORBAR_LABEL_FONT, DEFAULT_COLORBAR_LABEL_STYLE, DEFAULT_COLORBAR_LABEL_SIZE));
        for (i = 0; i < numColors; ++i) {
            bandTop = top + c * pixelsPerBand;
            bandBottom = bandTop + pixelsPerBand;
            if (this.isCurrents) {
                g.setPaint(new GradientPaint(left + 15, bandBottom, this.cmap.getColor(i), left + 15, bandTop, this.cmap.getColor(i + numColors + 1)));
                g.fillRect(left + 10, bandTop, left + 20, bandBottom - bandTop);
            } else {
                g.setColor(this.cmap.getColor(i));
                g.fillRect(left + 10, bandTop, left + 20, bandBottom - bandTop);
            }
            --c;
        }
        c = numColors - 1;
        for (i = 0; i < numColors + 1; ++i) {
            bandTop = top + c * pixelsPerBand;
            bandBottom = bandTop + pixelsPerBand;
            g.setColor(Color.black);
            if (i % labelInc == 0) {
                double val = this.cmap.getDoubleValue(i);
                String sTemp = this.df.format(val);
                if (val > -100.0 && val < 100.0) {
                    sTemp = this.dfx.format(val);
                }
                if (val > -10.0 && val < 10.0) {
                    sTemp = this.dfxx.format(val);
                }
                g.drawString(sTemp, left + 35, bandBottom + this.StringYOffset);
            }
            --c;
        }
        g.drawString(this.units, 30, 20);
    }

    public void setStringXOffset(int offset) {
        this.StringXOffset = offset;
    }

    public void setStringYOffset(int offset) {
        this.StringYOffset = offset;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.mOrientation == 1) {
            return new Dimension(this.mWidth, this.mHeight);
        }
        return new Dimension(this.mWidth, this.mHeight + 25);
    }

    @Override
    public Dimension getMinimumSize() {
        if (this.mOrientation == 1) {
            return new Dimension(this.mWidth, this.mHeight);
        }
        return new Dimension(this.mWidth, this.mHeight + 25);
    }

    @Override
    public Insets getInsets() {
        return new Insets(0, 0, 0, 0);
    }

    public ImageIcon getIcon() {
        Image mOffScreen = this.createImage(this.mWidth, this.mHeight);
        Graphics2D og = (Graphics2D)mOffScreen.getGraphics();
        og.setColor(Color.white);
        og.fillRect(0, 0, 200, 200);
        og.translate(0, -15);
        if (this.mLineColor != null) {
            this.DrawColorLines(og);
        } else {
            this.DrawColorBar(og);
        }
        ImageIcon icon = new ImageIcon(mOffScreen);
        return icon;
    }
}

