/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.pmel.sgt.ColorMap;
import gov.noaa.pmel.sgt.ContourLevels;
import gov.noaa.pmel.sgt.IndexedColorMap;
import gov.noaa.pmel.sgt.LinearTransform;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.tsunami.cmi.EnumeratedColorMap;
import gov.noaa.tsunami.cmi.SiftShare;
import java.awt.Color;
import java.util.ArrayList;

public class ColorMaps {
    public static EnumeratedColorMap createMaxAmpMap() {
        int[] red = new int[]{255, 240, 226, 212, 198, 184, 170, 155, 141, 127, 153, 178, 204, 204, 255, 255, 255, 255, 255};
        int[] green = new int[]{255, 246, 238, 229, 221, 212, 204, 195, 187, 178, 153, 114, 76, 51, 0, 102, 153, 204, 255};
        int[] blue = new int[]{255, 252, 249, 246, 243, 240, 238, 235, 232, 229, 204, 153, 102, 51, 0, 0, 51, 0, 0};
        EnumeratedColorMap cmap = new EnumeratedColorMap(red, green, blue);
        double[] vals = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 20.0, 40.0, 60.0, 80.0, 100.0, 200.0, 300.0, 400.0, 500.0};
        cmap.setEnumeratedValues(vals);
        return cmap;
    }

    public static EnumeratedColorMap createCurrentsMap() {
        int[] red = new int[]{255, 255, 255, 102};
        int[] green = new int[]{255, 255, 0, 0};
        int[] blue = new int[]{255, 0, 0, 153};
        EnumeratedColorMap cmap = new EnumeratedColorMap(red, green, blue);
        double[] vals = new double[]{0.0, 3.0, 6.0, 9.0, 12.0};
        cmap.setEnumeratedValues(vals);
        return cmap;
    }

    public static EnumeratedColorMap createMinAmpMap() {
        int[] red = new int[]{255, 240, 226, 212, 198, 184, 170, 155, 141, 127, 153, 178, 204, 204, 255, 255, 255, 255, 255};
        int[] green = new int[]{255, 246, 238, 229, 221, 212, 204, 195, 187, 178, 153, 114, 76, 51, 0, 102, 153, 204, 255};
        int[] blue = new int[]{255, 252, 249, 246, 243, 240, 238, 235, 232, 229, 204, 153, 102, 51, 0, 0, 51, 0, 0};
        int left = 0;
        for (int right = red.length - 1; left < right; ++left, --right) {
            int temp = red[left];
            red[left] = red[right];
            red[right] = temp;
            temp = green[left];
            green[left] = green[right];
            green[right] = temp;
            temp = blue[left];
            blue[left] = blue[right];
            blue[right] = temp;
        }
        EnumeratedColorMap cmap = new EnumeratedColorMap(red, green, blue);
        double[] vals = new double[]{-500.0, -400.0, -300.0, -200.0, -100.0, -80.0, -60.0, -40.0, -20.0, -10.0, -9.0, -8.0, -7.0, -6.0, -5.0, -4.0, -3.0, -2.0, -1.0, 0.0};
        cmap.setEnumeratedValues(vals);
        return cmap;
    }

    public static EnumeratedColorMap createWaveAmpMap2() {
        int[] red = new int[45];
        int[] green = new int[45];
        int[] blue = new int[45];
        red[0] = 0;
        green[0] = 255;
        blue[0] = 255;
        red[1] = 6;
        green[1] = 231;
        blue[1] = 255;
        red[2] = 12;
        green[2] = 207;
        blue[2] = 255;
        red[3] = 18;
        green[3] = 184;
        blue[3] = 255;
        red[4] = 24;
        green[4] = 160;
        blue[4] = 255;
        red[5] = 30;
        green[5] = 136;
        blue[5] = 255;
        red[6] = 35;
        green[6] = 113;
        blue[6] = 255;
        red[7] = 41;
        green[7] = 89;
        blue[7] = 255;
        red[8] = 47;
        green[8] = 65;
        blue[8] = 255;
        red[9] = 48;
        green[9] = 48;
        blue[9] = 255;
        red[10] = 75;
        green[10] = 75;
        blue[10] = 255;
        red[11] = 80;
        green[11] = 80;
        blue[11] = 255;
        red[12] = 90;
        green[12] = 90;
        blue[12] = 255;
        red[13] = 100;
        green[13] = 100;
        blue[13] = 255;
        red[14] = 110;
        green[14] = 110;
        blue[14] = 255;
        red[15] = 120;
        green[15] = 120;
        blue[15] = 255;
        red[16] = 130;
        green[16] = 130;
        blue[16] = 255;
        red[17] = 140;
        green[17] = 140;
        blue[17] = 255;
        red[18] = 160;
        green[18] = 160;
        blue[18] = 255;
        red[19] = 180;
        green[19] = 180;
        blue[19] = 255;
        red[20] = 210;
        green[20] = 210;
        blue[20] = 255;
        red[21] = 255;
        green[21] = 255;
        blue[21] = 255;
        red[22] = 255;
        green[22] = 255;
        blue[22] = 255;
        red[23] = 255;
        green[23] = 230;
        blue[23] = 230;
        red[24] = 255;
        green[24] = 210;
        blue[24] = 210;
        red[25] = 255;
        green[25] = 180;
        blue[25] = 180;
        red[26] = 255;
        green[26] = 160;
        blue[26] = 160;
        red[27] = 255;
        green[27] = 140;
        blue[27] = 140;
        red[28] = 255;
        green[28] = 130;
        blue[28] = 130;
        red[29] = 255;
        green[29] = 120;
        blue[29] = 120;
        red[30] = 255;
        green[30] = 110;
        blue[30] = 110;
        red[31] = 255;
        green[31] = 100;
        blue[31] = 100;
        red[32] = 255;
        green[32] = 90;
        blue[32] = 90;
        red[33] = 255;
        green[33] = 80;
        blue[33] = 80;
        red[34] = 255;
        green[34] = 75;
        blue[34] = 75;
        red[35] = 255;
        green[35] = 58;
        blue[35] = 58;
        red[36] = 255;
        green[36] = 65;
        blue[36] = 47;
        red[37] = 255;
        green[37] = 89;
        blue[37] = 41;
        red[38] = 255;
        green[38] = 113;
        blue[38] = 35;
        red[39] = 255;
        green[39] = 136;
        blue[39] = 30;
        red[40] = 255;
        green[40] = 160;
        blue[40] = 24;
        red[41] = 255;
        green[41] = 184;
        blue[41] = 18;
        red[42] = 255;
        green[42] = 207;
        blue[42] = 12;
        red[43] = 255;
        green[43] = 231;
        blue[43] = 6;
        red[44] = 255;
        green[44] = 255;
        blue[44] = 0;
        EnumeratedColorMap cmap = new EnumeratedColorMap(red, green, blue);
        double[] vals = new double[]{-1000.0, -900.0, -800.0, -700.0, -600.0, -500.0, -400.0, -325.0, -250.0, -200.0, -150.0, -100.0, -50.0, -45.0, -40.0, -35.0, -30.0, -25.0, -20.0, -15.0, -10.0, -5.0, 0.0, 5.0, 10.0, 15.0, 20.0, 25.0, 30.0, 35.0, 40.0, 45.0, 50.0, 100.0, 150.0, 200.0, 250.0, 325.0, 400.0, 500.0, 600.0, 700.0, 800.0, 900.0, 1000.0};
        cmap.setEnumeratedValues(vals);
        return cmap;
    }

    public static EnumeratedColorMap getDefaultSIFTColorMap() {
        double[] dvals = new double[]{0.0, 0.1, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 20.0, 40.0, 60.0, 80.0, 100.0, 200.0, 300.0, 400.0, 500.0};
        int[] red = new int[]{204, 255, 92, 112, 133, 153, 173, 194, 214, 235, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
        int[] blue = new int[]{204, 255, 204, 179, 153, 128, 102, 77, 51, 26, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        int[] green = new int[]{204, 255, 173, 184, 194, 204, 214, 224, 235, 245, 255, 230, 204, 179, 153, 128, 102, 77, 51, 26};
        int[] alpha = new int[]{255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255};
        Color[] clr = new Color[red.length];
        for (int i = 0; i < clr.length; ++i) {
            clr[i] = new Color(red[i], green[i], blue[i], alpha[i]);
        }
        EnumeratedColorMap cmap = new EnumeratedColorMap(clr);
        cmap.setEnumeratedValues(dvals);
        return cmap;
    }

    public static EnumeratedColorMap getTopographyPalm_Springs_5ColorMap() {
        double[] dv = new double[]{0.001, 0.01, 5.0, 10.0, 15.0, 20.0, 25.0, 50.0, 75.0, 100.0, 200.0, 300.0, 400.0, 500.0, 600.0, 700.0, 800.0, 900.0, 1000.0, 1500.0, 2000.0, 2500.0, 3000.0, 3500.0, 4000.0};
        int[] red = new int[]{222, 212, 204, 201, 194, 189, 184, 176, 171, 171, 176, 181, 189, 194, 199, 204, 204, 204, 204, 187, 160, 119, 105, 78, 53};
        int[] green = new int[]{202, 185, 171, 163, 152, 142, 133, 123, 116, 117, 125, 133, 144, 153, 162, 172, 177, 182, 196, 194, 179, 158, 150, 135, 122};
        int[] blue = new int[]{131, 116, 104, 91, 76, 60, 46, 32, 14, 9, 23, 38, 55, 72, 90, 102, 102, 102, 102, 87, 66, 40, 32, 18, 6};
        Color[] clr = new Color[red.length];
        for (int i = 0; i < clr.length; ++i) {
            clr[i] = i == 0 ? new Color(red[i], green[i], blue[i], 0) : new Color(red[i], green[i], blue[i], 255);
        }
        EnumeratedColorMap cmap = new EnumeratedColorMap(clr);
        cmap.setEnumeratedValues(dv);
        return cmap;
    }

    public static EnumeratedColorMap createLandColorMap() {
        double[] dv = new double[]{0.001, 0.01, 5.0, 10.0, 25.0, 50.0, 100.0, 200.0, 400.0, 600.0, 800.0, 1000.0, 2000.0, 3000.0, 4000.0, 5000.0, 6000.0};
        int[] red = new int[]{255, 194, 158, 137, 102, 67, 76, 97, 117, 130, 142, 153, 164, 176, 187, 198, 209};
        int[] green = new int[]{255, 168, 162, 156, 142, 128, 115, 101, 88, 97, 113, 128, 144, 160, 176, 191, 207};
        int[] blue = new int[]{191, 72, 0, 0, 0, 0, 1, 2, 3, 22, 47, 72, 97, 121, 146, 171, 196};
        Color[] clr = new Color[red.length];
        for (int i = 0; i < clr.length; ++i) {
            clr[i] = i == 0 ? new Color(red[i], green[i], blue[i], 0) : new Color(red[i], green[i], blue[i], 255);
        }
        EnumeratedColorMap cmap = new EnumeratedColorMap(clr);
        cmap.setEnumeratedValues(dv);
        return cmap;
    }

    public static EnumeratedColorMap createNewWaveAmpMap() {
        int[] red = new int[]{10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 22, 32, 43, 53, 64, 75, 85, 96, 106, 117, 140, 163, 187, 210, 255, 255, 252, 253, 253, 254, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 214, 173, 133, 92, 51};
        int[] green = new int[]{36, 34, 31, 29, 26, 24, 21, 19, 16, 14, 11, 28, 45, 62, 79, 96, 112, 129, 146, 163, 180, 192, 205, 217, 229, 255, 255, 252, 253, 253, 254, 255, 238, 221, 204, 186, 169, 152, 135, 118, 101, 84, 67, 51, 34, 17, 0, 0, 0, 0, 0, 0};
        int[] blue = new int[]{106, 121, 136, 151, 166, 180, 195, 210, 225, 240, 255, 255, 254, 253, 253, 253, 252, 251, 251, 251, 250, 250, 250, 250, 250, 255, 255, 188, 141, 94, 47, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        double[] vals = new double[]{-500.0, -400.0, -350.0, -300.0, -250.0, -200.0, -150.0, -100.0, -90.0, -80.0, -70.0, -60.0, -50.0, -40.0, -30.0, -20.0, -10.0, -9.0, -8.0, -7.0, -6.0, -5.0, -4.0, -3.0, -2.0, -1.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 20.0, 30.0, 40.0, 50.0, 60.0, 70.0, 80.0, 90.0, 100.0, 150.0, 200.0, 250.0, 300.0, 350.0, 400.0, 500.0};
        EnumeratedColorMap cmap = new EnumeratedColorMap(red, green, blue);
        cmap.setEnumeratedValues(vals);
        return cmap;
    }

    public static EnumeratedColorMap createRedBlueMap() {
        int[] red = new int[]{10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 22, 32, 43, 53, 64, 75, 85, 96, 106, 117, 140, 163, 187, 210, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 219, 183, 146, 110, 74};
        int[] green = new int[]{36, 34, 31, 29, 26, 24, 21, 19, 16, 14, 11, 28, 45, 62, 79, 96, 112, 129, 146, 163, 180, 192, 205, 217, 229, 255, 255, 204, 188, 171, 155, 139, 130, 120, 111, 102, 93, 83, 74, 65, 56, 46, 37, 28, 19, 9, 0, 0, 0, 0, 0, 0};
        int[] blue = new int[]{106, 121, 136, 151, 166, 180, 195, 210, 225, 240, 255, 255, 254, 253, 253, 253, 252, 251, 251, 251, 250, 250, 250, 250, 250, 255, 255, 204, 188, 171, 155, 139, 130, 120, 111, 102, 93, 83, 74, 65, 56, 46, 37, 28, 19, 9, 0, 0, 0, 0, 0, 0};
        double[] vals = new double[]{-500.0, -400.0, -350.0, -300.0, -250.0, -200.0, -150.0, -100.0, -90.0, -80.0, -70.0, -60.0, -50.0, -40.0, -30.0, -20.0, -10.0, -9.0, -8.0, -7.0, -6.0, -5.0, -4.0, -3.0, -2.0, -1.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 20.0, 30.0, 40.0, 50.0, 60.0, 70.0, 80.0, 90.0, 100.0, 150.0, 200.0, 250.0, 300.0, 350.0, 400.0, 500.0};
        EnumeratedColorMap cmap = new EnumeratedColorMap(red, green, blue);
        cmap.setEnumeratedValues(vals);
        return cmap;
    }

    public static EnumeratedColorMap createRedBlueMap51() {
        int[] red = new int[]{10, 10, 10, 10, 10, 11, 11, 11, 11, 11, 11, 22, 32, 43, 53, 64, 75, 85, 96, 106, 117, 140, 163, 187, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 219, 183, 146, 110, 74};
        int[] green = new int[]{36, 34, 31, 29, 26, 24, 21, 19, 16, 14, 11, 28, 45, 62, 79, 96, 112, 129, 146, 163, 180, 192, 205, 217, 255, 255, 188, 171, 155, 139, 130, 120, 111, 102, 93, 83, 74, 65, 56, 46, 37, 28, 19, 9, 0, 0, 0, 0, 0, 0};
        int[] blue = new int[]{106, 121, 136, 151, 166, 180, 195, 210, 225, 240, 255, 255, 254, 253, 253, 253, 252, 251, 251, 251, 250, 250, 250, 250, 255, 255, 188, 171, 155, 139, 130, 120, 111, 102, 93, 83, 74, 65, 56, 46, 37, 28, 19, 9, 0, 0, 0, 0, 0, 0};
        double[] vals = new double[]{-500.0, -400.0, -350.0, -300.0, -250.0, -200.0, -150.0, -100.0, -90.0, -80.0, -70.0, -60.0, -50.0, -40.0, -30.0, -20.0, -10.0, -9.0, -8.0, -7.0, -6.0, -5.0, -4.0, -3.0, -2.0, 0.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0, 10.0, 20.0, 30.0, 40.0, 50.0, 60.0, 70.0, 80.0, 90.0, 100.0, 150.0, 200.0, 250.0, 300.0, 350.0, 400.0, 500.0};
        EnumeratedColorMap cmap = new EnumeratedColorMap(red, green, blue);
        cmap.setEnumeratedValues(vals);
        return cmap;
    }

    public static EnumeratedColorMap createRedBlueMap31() {
        int[] red = new int[]{10, 10, 10, 11, 11, 11, 32, 53, 75, 96, 117, 140, 163, 187, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 219, 146, 74};
        int[] green = new int[]{36, 31, 26, 21, 16, 11, 45, 79, 112, 146, 180, 192, 205, 217, 255, 255, 188, 171, 155, 139, 120, 102, 83, 65, 46, 28, 9, 0, 0, 0};
        int[] blue = new int[]{106, 136, 166, 195, 225, 255, 254, 253, 252, 251, 250, 250, 250, 250, 255, 255, 188, 171, 155, 139, 120, 102, 83, 65, 46, 28, 9, 0, 0, 0};
        double[] vals = new double[]{-500.0, -350.0, -250.0, -150.0, -90.0, -70.0, -50.0, -30.0, -10.0, -8.0, -6.0, -5.0, -4.0, -3.0, -2.0, 0.0, 2.0, 3.0, 4.0, 5.0, 6.0, 8.0, 10.0, 30.0, 50.0, 70.0, 90.0, 150.0, 250.0, 350.0, 500.0};
        EnumeratedColorMap cmap = new EnumeratedColorMap(red, green, blue);
        cmap.setEnumeratedValues(vals);
        return cmap;
    }

    public static EnumeratedColorMap createWaveAmpMap() {
        int[] red = new int[44];
        int[] green = new int[44];
        int[] blue = new int[44];
        red[0] = 0;
        green[0] = 255;
        blue[0] = 255;
        red[1] = 0;
        green[1] = 231;
        blue[1] = 242;
        red[2] = 0;
        green[2] = 207;
        blue[2] = 229;
        red[3] = 0;
        green[3] = 184;
        blue[3] = 215;
        red[4] = 0;
        green[4] = 160;
        blue[4] = 202;
        red[5] = 0;
        green[5] = 136;
        blue[5] = 188;
        red[6] = 0;
        green[6] = 113;
        blue[6] = 174;
        red[7] = 0;
        green[7] = 89;
        blue[7] = 161;
        red[8] = 0;
        green[8] = 0;
        blue[8] = 147;
        red[9] = 0;
        green[9] = 0;
        blue[9] = 165;
        red[10] = 0;
        green[10] = 0;
        blue[10] = 183;
        red[11] = 0;
        green[11] = 0;
        blue[11] = 201;
        red[12] = 0;
        green[12] = 0;
        blue[12] = 219;
        red[13] = 0;
        green[13] = 0;
        blue[13] = 237;
        red[14] = 0;
        green[14] = 0;
        blue[14] = 255;
        red[15] = 36;
        green[15] = 36;
        blue[15] = 255;
        red[16] = 75;
        green[16] = 75;
        blue[16] = 255;
        red[17] = 111;
        green[17] = 111;
        blue[17] = 255;
        red[18] = 147;
        green[18] = 147;
        blue[18] = 255;
        red[19] = 183;
        green[19] = 183;
        blue[19] = 255;
        red[20] = 216;
        green[20] = 219;
        blue[20] = 255;
        red[21] = 255;
        green[21] = 255;
        blue[21] = 255;
        red[22] = 255;
        green[22] = 255;
        blue[22] = 255;
        red[23] = 255;
        green[23] = 219;
        blue[23] = 219;
        red[24] = 255;
        green[24] = 182;
        blue[24] = 182;
        red[25] = 255;
        green[25] = 146;
        blue[25] = 146;
        red[26] = 255;
        green[26] = 109;
        blue[26] = 109;
        red[27] = 255;
        green[27] = 73;
        blue[27] = 73;
        red[28] = 255;
        green[28] = 36;
        blue[28] = 36;
        red[29] = 255;
        green[29] = 0;
        blue[29] = 0;
        red[30] = 245;
        green[30] = 0;
        blue[30] = 0;
        red[31] = 234;
        green[31] = 0;
        blue[31] = 0;
        red[32] = 224;
        green[32] = 0;
        blue[32] = 0;
        red[33] = 214;
        green[33] = 0;
        blue[33] = 0;
        red[34] = 203;
        green[34] = 0;
        blue[34] = 0;
        red[35] = 193;
        green[35] = 0;
        blue[35] = 0;
        red[36] = 201;
        green[36] = 31;
        blue[36] = 0;
        red[37] = 209;
        green[37] = 63;
        blue[37] = 0;
        red[38] = 216;
        green[38] = 95;
        blue[38] = 0;
        red[39] = 224;
        green[39] = 127;
        blue[39] = 0;
        red[40] = 232;
        green[40] = 159;
        blue[40] = 0;
        red[41] = 240;
        green[41] = 191;
        blue[41] = 0;
        red[42] = 247;
        green[42] = 223;
        blue[42] = 0;
        red[43] = 255;
        green[43] = 255;
        blue[43] = 0;
        EnumeratedColorMap cmap = new EnumeratedColorMap(red, green, blue);
        double[] vals = new double[]{-500.0, -400.0, -350.0, -300.0, -250.0, -200.0, -150.0, -100.0, -90.0, -80.0, -70.0, -60.0, -50.0, -45.0, -40.0, -35.0, -30.0, -25.0, -20.0, -15.0, -10.0, -5.0, 0.0, 5.0, 10.0, 15.0, 20.0, 25.0, 30.0, 35.0, 40.0, 45.0, 50.0, 60.0, 70.0, 80.0, 90.0, 100.0, 150.0, 200.0, 250.0, 300.0, 350.0, 400.0, 500.0};
        cmap.setEnumeratedValues(vals);
        return cmap;
    }

    public static EnumeratedColorMap createAccentMap() {
        int[] red = new int[44];
        int[] green = new int[44];
        int[] blue = new int[44];
        red[0] = 0;
        green[0] = 255;
        blue[0] = 255;
        red[1] = 0;
        green[1] = 231;
        blue[1] = 242;
        red[2] = 0;
        green[2] = 207;
        blue[2] = 229;
        red[3] = 0;
        green[3] = 184;
        blue[3] = 215;
        red[4] = 0;
        green[4] = 160;
        blue[4] = 202;
        red[5] = 0;
        green[5] = 136;
        blue[5] = 188;
        red[6] = 0;
        green[6] = 113;
        blue[6] = 174;
        red[7] = 0;
        green[7] = 89;
        blue[7] = 161;
        red[8] = 0;
        green[8] = 0;
        blue[8] = 147;
        red[9] = 0;
        green[9] = 0;
        blue[9] = 165;
        red[10] = 0;
        green[10] = 0;
        blue[10] = 183;
        red[11] = 0;
        green[11] = 0;
        blue[11] = 201;
        red[12] = 0;
        green[12] = 0;
        blue[12] = 219;
        red[13] = 0;
        green[13] = 0;
        blue[13] = 237;
        red[14] = 0;
        green[14] = 0;
        blue[14] = 255;
        red[15] = 36;
        green[15] = 36;
        blue[15] = 255;
        red[16] = 75;
        green[16] = 75;
        blue[16] = 255;
        red[17] = 111;
        green[17] = 111;
        blue[17] = 255;
        red[18] = 147;
        green[18] = 147;
        blue[18] = 255;
        red[19] = 183;
        green[19] = 183;
        blue[19] = 255;
        red[20] = 216;
        green[20] = 219;
        blue[20] = 255;
        red[21] = 255;
        green[21] = 255;
        blue[21] = 255;
        red[22] = 255;
        green[22] = 255;
        blue[22] = 255;
        red[23] = 255;
        green[23] = 219;
        blue[23] = 219;
        red[24] = 255;
        green[24] = 182;
        blue[24] = 182;
        red[25] = 255;
        green[25] = 146;
        blue[25] = 146;
        red[26] = 255;
        green[26] = 109;
        blue[26] = 109;
        red[27] = 255;
        green[27] = 73;
        blue[27] = 73;
        red[28] = 255;
        green[28] = 36;
        blue[28] = 36;
        red[29] = 255;
        green[29] = 0;
        blue[29] = 0;
        red[30] = 245;
        green[30] = 0;
        blue[30] = 0;
        red[31] = 234;
        green[31] = 0;
        blue[31] = 0;
        red[32] = 224;
        green[32] = 0;
        blue[32] = 0;
        red[33] = 214;
        green[33] = 0;
        blue[33] = 0;
        red[34] = 203;
        green[34] = 0;
        blue[34] = 0;
        red[35] = 193;
        green[35] = 0;
        blue[35] = 0;
        red[36] = 201;
        green[36] = 31;
        blue[36] = 0;
        red[37] = 209;
        green[37] = 63;
        blue[37] = 0;
        red[38] = 216;
        green[38] = 95;
        blue[38] = 0;
        red[39] = 224;
        green[39] = 127;
        blue[39] = 0;
        red[40] = 232;
        green[40] = 159;
        blue[40] = 0;
        red[41] = 240;
        green[41] = 191;
        blue[41] = 0;
        red[42] = 247;
        green[42] = 223;
        blue[42] = 0;
        red[43] = 255;
        green[43] = 255;
        blue[43] = 0;
        EnumeratedColorMap cmap = new EnumeratedColorMap(red, green, blue);
        double[] vals = new double[]{-1000.0, -900.0, -800.0, -700.0, -600.0, -500.0, -400.0, -300.0, -200.0, -100.0, -50.0, -20.0, -10.0, -5.0, -2.0, -1.0, -0.5, -0.2, -0.1, -0.05, -0.02, -0.01, 0.0, 0.01, 0.02, 0.05, 0.1, 0.2, 0.5, 1.0, 2.0, 5.0, 10.0, 20.0, 50.0, 100.0, 200.0, 300.0, 400.0, 500.0, 600.0, 700.0, 800.0, 900.0, 1000.0};
        cmap.setEnumeratedValues(vals);
        return cmap;
    }

    public static EnumeratedColorMap createAccentMap4() {
        int[] red = new int[44];
        int[] green = new int[44];
        int[] blue = new int[44];
        red[0] = 0;
        green[0] = 255;
        blue[0] = 255;
        red[1] = 0;
        green[1] = 231;
        blue[1] = 242;
        red[2] = 0;
        green[2] = 207;
        blue[2] = 229;
        red[3] = 0;
        green[3] = 184;
        blue[3] = 215;
        red[4] = 0;
        green[4] = 160;
        blue[4] = 202;
        red[5] = 0;
        green[5] = 136;
        blue[5] = 188;
        red[6] = 0;
        green[6] = 113;
        blue[6] = 174;
        red[7] = 0;
        green[7] = 89;
        blue[7] = 161;
        red[8] = 0;
        green[8] = 0;
        blue[8] = 147;
        red[9] = 0;
        green[9] = 0;
        blue[9] = 165;
        red[10] = 0;
        green[10] = 0;
        blue[10] = 183;
        red[11] = 0;
        green[11] = 0;
        blue[11] = 201;
        red[12] = 0;
        green[12] = 0;
        blue[12] = 219;
        red[13] = 0;
        green[13] = 0;
        blue[13] = 237;
        red[14] = 0;
        green[14] = 0;
        blue[14] = 255;
        red[15] = 36;
        green[15] = 36;
        blue[15] = 255;
        red[16] = 75;
        green[16] = 75;
        blue[16] = 255;
        red[17] = 111;
        green[17] = 111;
        blue[17] = 255;
        red[18] = 147;
        green[18] = 147;
        blue[18] = 255;
        red[19] = 183;
        green[19] = 183;
        blue[19] = 255;
        red[20] = 216;
        green[20] = 219;
        blue[20] = 255;
        red[21] = 255;
        green[21] = 255;
        blue[21] = 255;
        red[22] = 255;
        green[22] = 255;
        blue[22] = 255;
        red[23] = 255;
        green[23] = 235;
        blue[23] = 235;
        red[24] = 255;
        green[24] = 225;
        blue[24] = 225;
        red[25] = 255;
        green[25] = 205;
        blue[25] = 205;
        red[26] = 255;
        green[26] = 185;
        blue[26] = 185;
        red[27] = 255;
        green[27] = 165;
        blue[27] = 165;
        red[28] = 255;
        green[28] = 145;
        blue[28] = 145;
        red[29] = 255;
        green[29] = 125;
        blue[29] = 125;
        red[30] = 255;
        green[30] = 105;
        blue[30] = 105;
        red[31] = 255;
        green[31] = 85;
        blue[31] = 85;
        red[32] = 255;
        green[32] = 65;
        blue[32] = 65;
        red[33] = 255;
        green[33] = 45;
        blue[33] = 45;
        red[34] = 255;
        green[34] = 25;
        blue[34] = 25;
        red[35] = 255;
        green[35] = 5;
        blue[35] = 5;
        red[36] = 255;
        green[36] = 31;
        blue[36] = 0;
        red[37] = 255;
        green[37] = 63;
        blue[37] = 0;
        red[38] = 255;
        green[38] = 95;
        blue[38] = 0;
        red[39] = 255;
        green[39] = 127;
        blue[39] = 0;
        red[40] = 255;
        green[40] = 159;
        blue[40] = 0;
        red[41] = 255;
        green[41] = 191;
        blue[41] = 0;
        red[42] = 255;
        green[42] = 223;
        blue[42] = 0;
        red[43] = 255;
        green[43] = 255;
        blue[43] = 0;
        EnumeratedColorMap cmap = new EnumeratedColorMap(red, green, blue);
        double[] vals = new double[]{-1000.0, -900.0, -800.0, -700.0, -600.0, -500.0, -400.0, -300.0, -200.0, -100.0, -50.0, -20.0, -10.0, -5.0, -2.0, -1.0, -0.5, -0.2, -0.1, -0.05, -0.02, -0.01, 0.0, 0.01, 0.02, 0.05, 0.1, 0.2, 0.5, 1.0, 2.0, 5.0, 10.0, 20.0, 50.0, 100.0, 200.0, 300.0, 400.0, 500.0, 600.0, 700.0, 800.0, 900.0, 1000.0};
        cmap.setEnumeratedValues(vals);
        return cmap;
    }

    public static EnumeratedColorMap createAccentMap3() {
        int[] red = new int[45];
        int[] green = new int[45];
        int[] blue = new int[45];
        red[0] = 0;
        green[0] = 255;
        blue[0] = 255;
        red[1] = 6;
        green[1] = 231;
        blue[1] = 255;
        red[2] = 12;
        green[2] = 207;
        blue[2] = 255;
        red[3] = 18;
        green[3] = 184;
        blue[3] = 255;
        red[4] = 24;
        green[4] = 160;
        blue[4] = 255;
        red[5] = 30;
        green[5] = 136;
        blue[5] = 255;
        red[6] = 35;
        green[6] = 113;
        blue[6] = 255;
        red[7] = 41;
        green[7] = 89;
        blue[7] = 255;
        red[8] = 47;
        green[8] = 65;
        blue[8] = 255;
        red[9] = 48;
        green[9] = 48;
        blue[9] = 255;
        red[10] = 75;
        green[10] = 75;
        blue[10] = 255;
        red[11] = 80;
        green[11] = 80;
        blue[11] = 255;
        red[12] = 90;
        green[12] = 90;
        blue[12] = 255;
        red[13] = 100;
        green[13] = 100;
        blue[13] = 255;
        red[14] = 110;
        green[14] = 110;
        blue[14] = 255;
        red[15] = 120;
        green[15] = 120;
        blue[15] = 255;
        red[16] = 130;
        green[16] = 130;
        blue[16] = 255;
        red[17] = 140;
        green[17] = 140;
        blue[17] = 255;
        red[18] = 160;
        green[18] = 160;
        blue[18] = 255;
        red[19] = 180;
        green[19] = 180;
        blue[19] = 255;
        red[20] = 210;
        green[20] = 210;
        blue[20] = 255;
        red[21] = 255;
        green[21] = 255;
        blue[21] = 255;
        red[22] = 255;
        green[22] = 255;
        blue[22] = 255;
        red[23] = 255;
        green[23] = 230;
        blue[23] = 230;
        red[24] = 255;
        green[24] = 210;
        blue[24] = 210;
        red[25] = 255;
        green[25] = 180;
        blue[25] = 180;
        red[26] = 255;
        green[26] = 160;
        blue[26] = 160;
        red[27] = 255;
        green[27] = 140;
        blue[27] = 140;
        red[28] = 255;
        green[28] = 130;
        blue[28] = 130;
        red[29] = 255;
        green[29] = 120;
        blue[29] = 120;
        red[30] = 255;
        green[30] = 110;
        blue[30] = 110;
        red[31] = 255;
        green[31] = 100;
        blue[31] = 100;
        red[32] = 255;
        green[32] = 90;
        blue[32] = 90;
        red[33] = 255;
        green[33] = 80;
        blue[33] = 80;
        red[34] = 255;
        green[34] = 75;
        blue[34] = 75;
        red[35] = 255;
        green[35] = 58;
        blue[35] = 58;
        red[36] = 255;
        green[36] = 65;
        blue[36] = 47;
        red[37] = 255;
        green[37] = 89;
        blue[37] = 41;
        red[38] = 255;
        green[38] = 113;
        blue[38] = 35;
        red[39] = 255;
        green[39] = 136;
        blue[39] = 30;
        red[40] = 255;
        green[40] = 160;
        blue[40] = 24;
        red[41] = 255;
        green[41] = 184;
        blue[41] = 18;
        red[42] = 255;
        green[42] = 207;
        blue[42] = 12;
        red[43] = 255;
        green[43] = 231;
        blue[43] = 6;
        red[44] = 255;
        green[44] = 255;
        blue[44] = 0;
        EnumeratedColorMap cmap = new EnumeratedColorMap(red, green, blue);
        double[] vals = new double[]{-1000.0, -900.0, -800.0, -700.0, -600.0, -500.0, -400.0, -300.0, -200.0, -100.0, -50.0, -20.0, -10.0, -5.0, -2.0, -1.0, -0.5, -0.2, -0.1, -0.05, -0.02, -0.01, 0.0, 0.01, 0.02, 0.05, 0.1, 0.2, 0.5, 1.0, 2.0, 5.0, 10.0, 20.0, 50.0, 100.0, 200.0, 300.0, 400.0, 500.0, 600.0, 700.0, 800.0, 900.0, 1000.0};
        cmap.setEnumeratedValues(vals);
        return cmap;
    }

    public static EnumeratedColorMap createAccentMap2() {
        int i;
        int[] red = new int[128];
        int[] green = new int[128];
        int[] blue = new int[128];
        for (i = 0; i < 64; ++i) {
            red[i] = 40;
            green[i] = 40;
            blue[i] = (int)(20.0 + 2.8125 * (double)i);
        }
        for (i = 64; i < 128; ++i) {
            red[i] = (int)(20.0 + 3.125 * (double)(i - 64));
            green[i] = 0;
            blue[i] = 0;
        }
        EnumeratedColorMap cmap = new EnumeratedColorMap(red, green, blue);
        double[] vals = new double[129];
        vals[0] = -20.0;
        for (int i2 = 1; i2 < vals.length; ++i2) {
            vals[i2] = vals[i2 - 1] + 0.3125;
        }
        cmap.setEnumeratedValues(vals);
        return cmap;
    }

    public static EnumeratedColorMap createMapCyanToMagenta() {
        float[] fred = new float[]{0.064f, 0.067f, 0.07f, 0.073f, 0.076f, 0.08f, 0.085f, 0.089f, 0.095f, 0.101f, 0.108f, 0.115f, 0.124f, 0.134f, 0.146f, 0.161f, 0.177f, 0.198f, 0.222f, 0.253f, 0.29f, 0.335f, 0.389f, 0.451f, 0.516f, 0.58f, 0.638f, 0.688f, 0.729f, 0.763f, 0.79f, 0.813f, 0.831f, 0.847f, 0.86f, 0.871f, 0.88f, 0.889f, 0.896f, 0.902f, 0.908f, 0.913f, 0.918f, 0.922f};
        float[] fgreen = new float[]{0.819f, 0.808f, 0.797f, 0.785f, 0.773f, 0.76f, 0.747f, 0.734f, 0.719f, 0.704f, 0.688f, 0.671f, 0.654f, 0.635f, 0.614f, 0.592f, 0.568f, 0.541f, 0.51f, 0.474f, 0.431f, 0.374f, 0.284f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f};
        int[] red = new int[44];
        int[] green = new int[44];
        int[] blue = new int[44];
        for (int i = 0; i < 41; ++i) {
            red[i] = Math.round(fred[i] * 255.0f);
            green[i] = Math.round(fgreen[i] * 255.0f);
            blue[i] = 255;
        }
        red[41] = 255;
        green[41] = 0;
        blue[41] = 0;
        red[42] = 255;
        green[42] = 137;
        blue[42] = 0;
        red[43] = 255;
        green[43] = 255;
        blue[43] = 0;
        EnumeratedColorMap cmap = new EnumeratedColorMap(red, green, blue);
        double[] vals = new double[]{-1000.0, -900.0, -800.0, -700.0, -600.0, -500.0, -400.0, -325.0, -250.0, -200.0, -150.0, -100.0, -50.0, -45.0, -40.0, -35.0, -30.0, -25.0, -20.0, -15.0, -10.0, -5.0, 0.0, 5.0, 10.0, 15.0, 20.0, 25.0, 30.0, 35.0, 40.0, 45.0, 50.0, 100.0, 150.0, 200.0, 250.0, 325.0, 400.0, 500.0, 600.0, 700.0, 800.0, 900.0, 1000.0};
        cmap.setEnumeratedValues(vals);
        return cmap;
    }

    public static EnumeratedColorMap createFlameMap(double[] vals) {
        int numColors = vals.length - 1;
        if (numColors > 256) {
            SiftShare.log.warning("Too many colors requested of ColorMaps.createFlameMap (256 max)");
            return ColorMaps.createMapCyanToMagenta();
        }
        float[] fred = new float[256];
        float[] fblue = new float[256];
        float[] fgreen = new float[256];
        fred[0] = 0.0f;
        fred[1] = 0.0f;
        fred[2] = 0.0f;
        fred[3] = 0.0f;
        fred[4] = 0.0f;
        fred[5] = 0.0f;
        fred[6] = 0.0f;
        fred[7] = 0.0f;
        fred[8] = 0.0f;
        fred[9] = 0.0f;
        fred[10] = 0.0f;
        fred[11] = 0.0f;
        fred[12] = 0.0f;
        fred[13] = 0.0f;
        fred[14] = 0.0f;
        fred[15] = 0.0f;
        fred[16] = 0.0f;
        fred[17] = 0.0f;
        fred[18] = 0.0f;
        fred[19] = 0.0f;
        fred[20] = 0.0f;
        fred[21] = 0.0f;
        fred[22] = 0.0f;
        fred[23] = 0.0f;
        fred[24] = 0.0f;
        fred[25] = 0.0f;
        fred[26] = 0.0f;
        fred[27] = 0.0f;
        fred[28] = 0.0f;
        fred[29] = 0.0f;
        fred[30] = 0.0f;
        fred[31] = 0.0f;
        fred[32] = 0.0f;
        fred[33] = 0.0f;
        fred[34] = 0.0f;
        fred[35] = 0.0f;
        fred[36] = 0.0f;
        fred[37] = 0.0f;
        fred[38] = 0.0f;
        fred[39] = 0.0f;
        fred[40] = 0.0f;
        fred[41] = 0.0f;
        fred[42] = 0.0f;
        fred[43] = 0.0f;
        fred[44] = 0.0f;
        fred[45] = 0.0f;
        fred[46] = 0.0f;
        fred[47] = 0.0f;
        fred[48] = 0.0f;
        fred[49] = 0.0f;
        fred[50] = 0.0f;
        fred[51] = 0.0f;
        fred[52] = 0.0f;
        fred[53] = 0.0f;
        fred[54] = 0.0f;
        fred[55] = 0.0f;
        fred[56] = 0.0f;
        fred[57] = 0.0f;
        fred[58] = 0.0f;
        fred[59] = 0.0f;
        fred[60] = 0.0f;
        fred[61] = 0.0f;
        fred[62] = 0.0f;
        fred[63] = 0.0f;
        fred[64] = 0.0f;
        fred[65] = 0.0f;
        fred[66] = 0.0f;
        fred[67] = 0.0f;
        fred[68] = 0.0f;
        fred[69] = 0.0f;
        fred[70] = 0.0f;
        fred[71] = 0.0f;
        fred[72] = 0.0f;
        fred[73] = 0.0f;
        fred[74] = 0.0f;
        fred[75] = 0.0f;
        fred[76] = 0.0f;
        fred[77] = 0.0f;
        fred[78] = 0.0f;
        fred[79] = 0.0f;
        fred[80] = 0.0f;
        fred[81] = 0.0f;
        fred[82] = 0.0f;
        fred[83] = 0.0f;
        fred[84] = 0.0f;
        fred[85] = 0.0f;
        fred[86] = 0.0f;
        fred[87] = 0.0f;
        fred[88] = 0.0f;
        fred[89] = 0.0f;
        fred[90] = 0.0f;
        fred[91] = 0.0f;
        fred[92] = 0.0f;
        fred[93] = 0.0f;
        fred[94] = 0.0f;
        fred[95] = 0.0f;
        fred[96] = 0.0f;
        fred[97] = 0.0f;
        fred[98] = 0.0f;
        fred[99] = 0.0f;
        fred[100] = 0.0f;
        fred[101] = 0.0f;
        fred[102] = 0.0f;
        fred[103] = 0.0f;
        fred[104] = 0.0f;
        fred[105] = 0.0f;
        fred[106] = 0.0f;
        fred[107] = 0.0f;
        fred[108] = 0.0f;
        fred[109] = 0.0f;
        fred[110] = 0.0f;
        fred[111] = 0.0f;
        fred[112] = 0.0f;
        fred[113] = 0.0f;
        fred[114] = 0.0f;
        fred[115] = 0.0f;
        fred[116] = 0.0f;
        fred[117] = 0.0f;
        fred[118] = 0.0f;
        fred[119] = 0.0f;
        fred[120] = 0.0f;
        fred[121] = 0.0f;
        fred[122] = 0.0f;
        fred[123] = 0.0f;
        fred[124] = 0.0f;
        fred[125] = 0.0f;
        fred[126] = 0.0f;
        fred[127] = 1.0f;
        fred[128] = 1.0f;
        fred[129] = 0.598f;
        fred[130] = 0.63f;
        fred[131] = 0.651f;
        fred[132] = 0.668f;
        fred[133] = 0.681f;
        fred[134] = 0.693f;
        fred[135] = 0.703f;
        fred[136] = 0.712f;
        fred[137] = 0.72f;
        fred[138] = 0.727f;
        fred[139] = 0.734f;
        fred[140] = 0.74f;
        fred[141] = 0.745f;
        fred[142] = 0.751f;
        fred[143] = 0.756f;
        fred[144] = 0.76f;
        fred[145] = 0.765f;
        fred[146] = 0.769f;
        fred[147] = 0.773f;
        fred[148] = 0.777f;
        fred[149] = 0.781f;
        fred[150] = 0.784f;
        fred[151] = 0.788f;
        fred[152] = 0.791f;
        fred[153] = 0.794f;
        fred[154] = 0.797f;
        fred[155] = 0.8f;
        fred[156] = 0.803f;
        fred[157] = 0.806f;
        fred[158] = 0.809f;
        fred[159] = 0.811f;
        fred[160] = 0.814f;
        fred[161] = 0.816f;
        fred[162] = 0.819f;
        fred[163] = 0.821f;
        fred[164] = 0.823f;
        fred[165] = 0.826f;
        fred[166] = 0.828f;
        fred[167] = 0.83f;
        fred[168] = 0.832f;
        fred[169] = 0.834f;
        fred[170] = 0.836f;
        fred[171] = 0.838f;
        fred[172] = 0.84f;
        fred[173] = 0.842f;
        fred[174] = 0.844f;
        fred[175] = 0.845f;
        fred[176] = 0.847f;
        fred[177] = 0.849f;
        fred[178] = 0.851f;
        fred[179] = 0.852f;
        fred[180] = 0.854f;
        fred[181] = 0.855f;
        fred[182] = 0.857f;
        fred[183] = 0.859f;
        fred[184] = 0.86f;
        fred[185] = 0.862f;
        fred[186] = 0.863f;
        fred[187] = 0.865f;
        fred[188] = 0.866f;
        fred[189] = 0.867f;
        fred[190] = 0.869f;
        fred[191] = 0.87f;
        fred[192] = 0.872f;
        fred[193] = 0.873f;
        fred[194] = 0.874f;
        fred[195] = 0.876f;
        fred[196] = 0.877f;
        fred[197] = 0.878f;
        fred[198] = 0.879f;
        fred[199] = 0.881f;
        fred[200] = 0.882f;
        fred[201] = 0.883f;
        fred[202] = 0.884f;
        fred[203] = 0.885f;
        fred[204] = 0.887f;
        fred[205] = 0.888f;
        fred[206] = 0.889f;
        fred[207] = 0.89f;
        fred[208] = 0.891f;
        fred[209] = 0.892f;
        fred[210] = 0.893f;
        fred[211] = 0.894f;
        fred[212] = 0.895f;
        fred[213] = 0.896f;
        fred[214] = 0.898f;
        fred[215] = 0.899f;
        fred[216] = 0.9f;
        fred[217] = 0.901f;
        fred[218] = 0.902f;
        fred[219] = 0.903f;
        fred[220] = 0.904f;
        fred[221] = 0.905f;
        fred[222] = 0.906f;
        fred[223] = 0.906f;
        fred[224] = 0.907f;
        fred[225] = 0.908f;
        fred[226] = 0.909f;
        fred[227] = 0.91f;
        fred[228] = 0.911f;
        fred[229] = 0.912f;
        fred[230] = 0.913f;
        fred[231] = 0.914f;
        fred[232] = 0.915f;
        fred[233] = 0.916f;
        fred[234] = 0.916f;
        fred[235] = 0.917f;
        fred[236] = 0.918f;
        fred[237] = 0.919f;
        fred[238] = 0.92f;
        fred[239] = 0.921f;
        fred[240] = 0.921f;
        fred[241] = 0.922f;
        fred[242] = 0.923f;
        fred[243] = 0.924f;
        fred[244] = 0.925f;
        fred[245] = 0.925f;
        fred[246] = 0.926f;
        fred[247] = 0.927f;
        fred[248] = 0.928f;
        fred[249] = 0.929f;
        fred[250] = 0.929f;
        fred[251] = 0.93f;
        fred[252] = 0.931f;
        fred[253] = 0.932f;
        fred[254] = 0.932f;
        fred[255] = 0.933f;
        fgreen[0] = 0.884f;
        fgreen[1] = 0.883f;
        fgreen[2] = 0.882f;
        fgreen[3] = 0.88f;
        fgreen[4] = 0.879f;
        fgreen[5] = 0.878f;
        fgreen[6] = 0.876f;
        fgreen[7] = 0.875f;
        fgreen[8] = 0.874f;
        fgreen[9] = 0.872f;
        fgreen[10] = 0.871f;
        fgreen[11] = 0.869f;
        fgreen[12] = 0.868f;
        fgreen[13] = 0.866f;
        fgreen[14] = 0.864f;
        fgreen[15] = 0.863f;
        fgreen[16] = 0.861f;
        fgreen[17] = 0.859f;
        fgreen[18] = 0.858f;
        fgreen[19] = 0.856f;
        fgreen[20] = 0.854f;
        fgreen[21] = 0.852f;
        fgreen[22] = 0.85f;
        fgreen[23] = 0.848f;
        fgreen[24] = 0.846f;
        fgreen[25] = 0.844f;
        fgreen[26] = 0.842f;
        fgreen[27] = 0.84f;
        fgreen[28] = 0.837f;
        fgreen[29] = 0.835f;
        fgreen[30] = 0.833f;
        fgreen[31] = 0.83f;
        fgreen[32] = 0.828f;
        fgreen[33] = 0.825f;
        fgreen[34] = 0.822f;
        fgreen[35] = 0.82f;
        fgreen[36] = 0.817f;
        fgreen[37] = 0.814f;
        fgreen[38] = 0.811f;
        fgreen[39] = 0.808f;
        fgreen[40] = 0.805f;
        fgreen[41] = 0.801f;
        fgreen[42] = 0.798f;
        fgreen[43] = 0.795f;
        fgreen[44] = 0.791f;
        fgreen[45] = 0.788f;
        fgreen[46] = 0.784f;
        fgreen[47] = 0.78f;
        fgreen[48] = 0.776f;
        fgreen[49] = 0.772f;
        fgreen[50] = 0.768f;
        fgreen[51] = 0.763f;
        fgreen[52] = 0.759f;
        fgreen[53] = 0.754f;
        fgreen[54] = 0.749f;
        fgreen[55] = 0.745f;
        fgreen[56] = 0.74f;
        fgreen[57] = 0.734f;
        fgreen[58] = 0.729f;
        fgreen[59] = 0.723f;
        fgreen[60] = 0.718f;
        fgreen[61] = 0.712f;
        fgreen[62] = 0.706f;
        fgreen[63] = 0.7f;
        fgreen[64] = 0.693f;
        fgreen[65] = 0.687f;
        fgreen[66] = 0.68f;
        fgreen[67] = 0.673f;
        fgreen[68] = 0.666f;
        fgreen[69] = 0.659f;
        fgreen[70] = 0.651f;
        fgreen[71] = 0.643f;
        fgreen[72] = 0.635f;
        fgreen[73] = 0.627f;
        fgreen[74] = 0.619f;
        fgreen[75] = 0.611f;
        fgreen[76] = 0.602f;
        fgreen[77] = 0.593f;
        fgreen[78] = 0.585f;
        fgreen[79] = 0.576f;
        fgreen[80] = 0.566f;
        fgreen[81] = 0.557f;
        fgreen[82] = 0.548f;
        fgreen[83] = 0.538f;
        fgreen[84] = 0.529f;
        fgreen[85] = 0.519f;
        fgreen[86] = 0.51f;
        fgreen[87] = 0.5f;
        fgreen[88] = 0.49f;
        fgreen[89] = 0.481f;
        fgreen[90] = 0.471f;
        fgreen[91] = 0.462f;
        fgreen[92] = 0.452f;
        fgreen[93] = 0.443f;
        fgreen[94] = 0.434f;
        fgreen[95] = 0.425f;
        fgreen[96] = 0.416f;
        fgreen[97] = 0.407f;
        fgreen[98] = 0.398f;
        fgreen[99] = 0.389f;
        fgreen[100] = 0.381f;
        fgreen[101] = 0.373f;
        fgreen[102] = 0.365f;
        fgreen[103] = 0.357f;
        fgreen[104] = 0.349f;
        fgreen[105] = 0.342f;
        fgreen[106] = 0.334f;
        fgreen[107] = 0.327f;
        fgreen[108] = 0.32f;
        fgreen[109] = 0.313f;
        fgreen[110] = 0.307f;
        fgreen[111] = 0.3f;
        fgreen[112] = 0.294f;
        fgreen[113] = 0.288f;
        fgreen[114] = 0.282f;
        fgreen[115] = 0.277f;
        fgreen[116] = 0.271f;
        fgreen[117] = 0.266f;
        fgreen[118] = 0.261f;
        fgreen[119] = 0.255f;
        fgreen[120] = 0.251f;
        fgreen[121] = 0.246f;
        fgreen[122] = 0.241f;
        fgreen[123] = 0.237f;
        fgreen[124] = 0.232f;
        fgreen[125] = 0.0f;
        fgreen[126] = 0.0f;
        fgreen[127] = 1.0f;
        fgreen[128] = 1.0f;
        fgreen[129] = 0.083f;
        fgreen[130] = 0.086f;
        fgreen[131] = 0.088f;
        fgreen[132] = 0.09f;
        fgreen[133] = 0.093f;
        fgreen[134] = 0.095f;
        fgreen[135] = 0.098f;
        fgreen[136] = 0.1f;
        fgreen[137] = 0.103f;
        fgreen[138] = 0.106f;
        fgreen[139] = 0.108f;
        fgreen[140] = 0.111f;
        fgreen[141] = 0.114f;
        fgreen[142] = 0.117f;
        fgreen[143] = 0.12f;
        fgreen[144] = 0.123f;
        fgreen[145] = 0.126f;
        fgreen[146] = 0.129f;
        fgreen[147] = 0.132f;
        fgreen[148] = 0.135f;
        fgreen[149] = 0.138f;
        fgreen[150] = 0.142f;
        fgreen[151] = 0.145f;
        fgreen[152] = 0.149f;
        fgreen[153] = 0.152f;
        fgreen[154] = 0.155f;
        fgreen[155] = 0.159f;
        fgreen[156] = 0.163f;
        fgreen[157] = 0.166f;
        fgreen[158] = 0.17f;
        fgreen[159] = 0.174f;
        fgreen[160] = 0.178f;
        fgreen[161] = 0.182f;
        fgreen[162] = 0.186f;
        fgreen[163] = 0.19f;
        fgreen[164] = 0.194f;
        fgreen[165] = 0.198f;
        fgreen[166] = 0.202f;
        fgreen[167] = 0.206f;
        fgreen[168] = 0.211f;
        fgreen[169] = 0.215f;
        fgreen[170] = 0.22f;
        fgreen[171] = 0.224f;
        fgreen[172] = 0.229f;
        fgreen[173] = 0.233f;
        fgreen[174] = 0.238f;
        fgreen[175] = 0.243f;
        fgreen[176] = 0.248f;
        fgreen[177] = 0.253f;
        fgreen[178] = 0.258f;
        fgreen[179] = 0.263f;
        fgreen[180] = 0.268f;
        fgreen[181] = 0.273f;
        fgreen[182] = 0.278f;
        fgreen[183] = 0.284f;
        fgreen[184] = 0.289f;
        fgreen[185] = 0.295f;
        fgreen[186] = 0.3f;
        fgreen[187] = 0.306f;
        fgreen[188] = 0.311f;
        fgreen[189] = 0.317f;
        fgreen[190] = 0.323f;
        fgreen[191] = 0.329f;
        fgreen[192] = 0.335f;
        fgreen[193] = 0.341f;
        fgreen[194] = 0.347f;
        fgreen[195] = 0.353f;
        fgreen[196] = 0.36f;
        fgreen[197] = 0.366f;
        fgreen[198] = 0.373f;
        fgreen[199] = 0.379f;
        fgreen[200] = 0.386f;
        fgreen[201] = 0.393f;
        fgreen[202] = 0.399f;
        fgreen[203] = 0.406f;
        fgreen[204] = 0.413f;
        fgreen[205] = 0.42f;
        fgreen[206] = 0.427f;
        fgreen[207] = 0.434f;
        fgreen[208] = 0.442f;
        fgreen[209] = 0.449f;
        fgreen[210] = 0.457f;
        fgreen[211] = 0.464f;
        fgreen[212] = 0.472f;
        fgreen[213] = 0.479f;
        fgreen[214] = 0.487f;
        fgreen[215] = 0.495f;
        fgreen[216] = 0.503f;
        fgreen[217] = 0.511f;
        fgreen[218] = 0.519f;
        fgreen[219] = 0.528f;
        fgreen[220] = 0.536f;
        fgreen[221] = 0.544f;
        fgreen[222] = 0.553f;
        fgreen[223] = 0.561f;
        fgreen[224] = 0.57f;
        fgreen[225] = 0.579f;
        fgreen[226] = 0.588f;
        fgreen[227] = 0.597f;
        fgreen[228] = 0.606f;
        fgreen[229] = 0.615f;
        fgreen[230] = 0.624f;
        fgreen[231] = 0.634f;
        fgreen[232] = 0.643f;
        fgreen[233] = 0.653f;
        fgreen[234] = 0.662f;
        fgreen[235] = 0.672f;
        fgreen[236] = 0.682f;
        fgreen[237] = 0.692f;
        fgreen[238] = 0.702f;
        fgreen[239] = 0.712f;
        fgreen[240] = 0.722f;
        fgreen[241] = 0.733f;
        fgreen[242] = 0.743f;
        fgreen[243] = 0.754f;
        fgreen[244] = 0.765f;
        fgreen[245] = 0.775f;
        fgreen[246] = 0.786f;
        fgreen[247] = 0.797f;
        fgreen[248] = 0.808f;
        fgreen[249] = 0.82f;
        fgreen[250] = 0.831f;
        fgreen[251] = 0.842f;
        fgreen[252] = 0.854f;
        fgreen[253] = 0.865f;
        fgreen[254] = 0.877f;
        fgreen[255] = 0.889f;
        fblue[0] = 1.0f;
        fblue[1] = 1.0f;
        fblue[2] = 1.0f;
        fblue[3] = 1.0f;
        fblue[4] = 1.0f;
        fblue[5] = 1.0f;
        fblue[6] = 1.0f;
        fblue[7] = 1.0f;
        fblue[8] = 1.0f;
        fblue[9] = 1.0f;
        fblue[10] = 1.0f;
        fblue[11] = 1.0f;
        fblue[12] = 1.0f;
        fblue[13] = 1.0f;
        fblue[14] = 1.0f;
        fblue[15] = 1.0f;
        fblue[16] = 1.0f;
        fblue[17] = 1.0f;
        fblue[18] = 1.0f;
        fblue[19] = 1.0f;
        fblue[20] = 1.0f;
        fblue[21] = 1.0f;
        fblue[22] = 1.0f;
        fblue[23] = 1.0f;
        fblue[24] = 1.0f;
        fblue[25] = 1.0f;
        fblue[26] = 1.0f;
        fblue[27] = 1.0f;
        fblue[28] = 1.0f;
        fblue[29] = 1.0f;
        fblue[30] = 1.0f;
        fblue[31] = 1.0f;
        fblue[32] = 1.0f;
        fblue[33] = 1.0f;
        fblue[34] = 1.0f;
        fblue[35] = 1.0f;
        fblue[36] = 1.0f;
        fblue[37] = 1.0f;
        fblue[38] = 1.0f;
        fblue[39] = 1.0f;
        fblue[40] = 1.0f;
        fblue[41] = 1.0f;
        fblue[42] = 1.0f;
        fblue[43] = 1.0f;
        fblue[44] = 1.0f;
        fblue[45] = 1.0f;
        fblue[46] = 1.0f;
        fblue[47] = 1.0f;
        fblue[48] = 1.0f;
        fblue[49] = 1.0f;
        fblue[50] = 1.0f;
        fblue[51] = 0.999f;
        fblue[52] = 0.997f;
        fblue[53] = 0.996f;
        fblue[54] = 0.995f;
        fblue[55] = 0.993f;
        fblue[56] = 0.992f;
        fblue[57] = 0.99f;
        fblue[58] = 0.989f;
        fblue[59] = 0.987f;
        fblue[60] = 0.986f;
        fblue[61] = 0.984f;
        fblue[62] = 0.983f;
        fblue[63] = 0.981f;
        fblue[64] = 0.98f;
        fblue[65] = 0.978f;
        fblue[66] = 0.976f;
        fblue[67] = 0.975f;
        fblue[68] = 0.973f;
        fblue[69] = 0.971f;
        fblue[70] = 0.969f;
        fblue[71] = 0.968f;
        fblue[72] = 0.966f;
        fblue[73] = 0.964f;
        fblue[74] = 0.962f;
        fblue[75] = 0.96f;
        fblue[76] = 0.958f;
        fblue[77] = 0.956f;
        fblue[78] = 0.954f;
        fblue[79] = 0.952f;
        fblue[80] = 0.95f;
        fblue[81] = 0.948f;
        fblue[82] = 0.946f;
        fblue[83] = 0.944f;
        fblue[84] = 0.941f;
        fblue[85] = 0.939f;
        fblue[86] = 0.937f;
        fblue[87] = 0.934f;
        fblue[88] = 0.932f;
        fblue[89] = 0.929f;
        fblue[90] = 0.927f;
        fblue[91] = 0.924f;
        fblue[92] = 0.921f;
        fblue[93] = 0.918f;
        fblue[94] = 0.915f;
        fblue[95] = 0.912f;
        fblue[96] = 0.909f;
        fblue[97] = 0.906f;
        fblue[98] = 0.903f;
        fblue[99] = 0.9f;
        fblue[100] = 0.896f;
        fblue[101] = 0.892f;
        fblue[102] = 0.889f;
        fblue[103] = 0.885f;
        fblue[104] = 0.88f;
        fblue[105] = 0.876f;
        fblue[106] = 0.872f;
        fblue[107] = 0.867f;
        fblue[108] = 0.862f;
        fblue[109] = 0.857f;
        fblue[110] = 0.851f;
        fblue[111] = 0.846f;
        fblue[112] = 0.839f;
        fblue[113] = 0.833f;
        fblue[114] = 0.825f;
        fblue[115] = 0.818f;
        fblue[116] = 0.809f;
        fblue[117] = 0.8f;
        fblue[118] = 0.789f;
        fblue[119] = 0.777f;
        fblue[120] = 0.763f;
        fblue[121] = 0.746f;
        fblue[122] = 0.725f;
        fblue[123] = 0.696f;
        fblue[124] = 0.65f;
        fblue[125] = 0.0f;
        fblue[126] = 0.0f;
        fblue[127] = 1.0f;
        fblue[128] = 1.0f;
        fblue[129] = 0.0f;
        fblue[130] = 0.0f;
        fblue[131] = 0.0f;
        fblue[132] = 0.0f;
        fblue[133] = 0.0f;
        fblue[134] = 0.0f;
        fblue[135] = 0.0f;
        fblue[136] = 0.0f;
        fblue[137] = 0.0f;
        fblue[138] = 0.0f;
        fblue[139] = 0.0f;
        fblue[140] = 0.0f;
        fblue[141] = 0.0f;
        fblue[142] = 0.0f;
        fblue[143] = 0.0f;
        fblue[144] = 0.0f;
        fblue[145] = 0.0f;
        fblue[146] = 0.0f;
        fblue[147] = 0.0f;
        fblue[148] = 0.0f;
        fblue[149] = 0.0f;
        fblue[150] = 0.0f;
        fblue[151] = 0.0f;
        fblue[152] = 0.0f;
        fblue[153] = 0.0f;
        fblue[154] = 0.0f;
        fblue[155] = 0.0f;
        fblue[156] = 0.0f;
        fblue[157] = 0.0f;
        fblue[158] = 0.0f;
        fblue[159] = 0.0f;
        fblue[160] = 0.0f;
        fblue[161] = 0.0f;
        fblue[162] = 0.0f;
        fblue[163] = 0.0f;
        fblue[164] = 0.0f;
        fblue[165] = 0.0f;
        fblue[166] = 0.0f;
        fblue[167] = 0.0f;
        fblue[168] = 0.0f;
        fblue[169] = 0.0f;
        fblue[170] = 0.0f;
        fblue[171] = 0.0f;
        fblue[172] = 0.0f;
        fblue[173] = 0.0f;
        fblue[174] = 0.0f;
        fblue[175] = 0.0f;
        fblue[176] = 0.0f;
        fblue[177] = 0.0f;
        fblue[178] = 0.0f;
        fblue[179] = 0.0f;
        fblue[180] = 0.0f;
        fblue[181] = 0.0f;
        fblue[182] = 0.0f;
        fblue[183] = 0.0f;
        fblue[184] = 0.0f;
        fblue[185] = 0.0f;
        fblue[186] = 0.0f;
        fblue[187] = 0.0f;
        fblue[188] = 0.0f;
        fblue[189] = 0.0f;
        fblue[190] = 0.0f;
        fblue[191] = 0.0f;
        fblue[192] = 0.0f;
        fblue[193] = 0.0f;
        fblue[194] = 0.0f;
        fblue[195] = 0.0f;
        fblue[196] = 0.0f;
        fblue[197] = 0.0f;
        fblue[198] = 0.0f;
        fblue[199] = 0.0f;
        fblue[200] = 0.0f;
        fblue[201] = 0.0f;
        fblue[202] = 0.0f;
        fblue[203] = 0.0f;
        fblue[204] = 0.0f;
        fblue[205] = 0.0f;
        fblue[206] = 0.0f;
        fblue[207] = 0.0f;
        fblue[208] = 0.0f;
        fblue[209] = 0.0f;
        fblue[210] = 0.0f;
        fblue[211] = 0.0f;
        fblue[212] = 0.0f;
        fblue[213] = 0.0f;
        fblue[214] = 0.0f;
        fblue[215] = 0.0f;
        fblue[216] = 0.0f;
        fblue[217] = 0.0f;
        fblue[218] = 0.0f;
        fblue[219] = 0.0f;
        fblue[220] = 0.0f;
        fblue[221] = 0.0f;
        fblue[222] = 0.0f;
        fblue[223] = 0.0f;
        fblue[224] = 0.0f;
        fblue[225] = 0.0f;
        fblue[226] = 0.0f;
        fblue[227] = 0.0f;
        fblue[228] = 0.0f;
        fblue[229] = 0.0f;
        fblue[230] = 0.0f;
        fblue[231] = 0.0f;
        fblue[232] = 0.0f;
        fblue[233] = 0.0f;
        fblue[234] = 0.0f;
        fblue[235] = 0.0f;
        fblue[236] = 0.0f;
        fblue[237] = 0.0f;
        fblue[238] = 0.0f;
        fblue[239] = 0.0f;
        fblue[240] = 0.0f;
        fblue[241] = 0.0f;
        fblue[242] = 0.0f;
        fblue[243] = 0.0f;
        fblue[244] = 0.0f;
        fblue[245] = 0.0f;
        fblue[246] = 0.0f;
        fblue[247] = 0.0f;
        fblue[248] = 0.0f;
        fblue[249] = 0.0f;
        fblue[250] = 0.0f;
        fblue[251] = 0.0f;
        fblue[252] = 0.0f;
        fblue[253] = 0.0f;
        fblue[254] = 0.0f;
        fblue[255] = 0.0f;
        int[] red = new int[numColors];
        int[] green = new int[numColors];
        int[] blue = new int[numColors];
        for (int i = 0; i < numColors; ++i) {
            red[i] = Math.round(fred[Math.round((float)i * 255.0f / (float)numColors)] * 255.0f);
            green[i] = Math.round(fgreen[Math.round((float)i * 255.0f / (float)numColors)] * 255.0f);
            blue[i] = Math.round(fblue[Math.round((float)i * 255.0f / (float)numColors)] * 255.0f);
        }
        EnumeratedColorMap cmap = new EnumeratedColorMap(red, green, blue);
        cmap.setEnumeratedValues(vals);
        return cmap;
    }

    public static EnumeratedColorMap createRachelMap() {
        int[] red = new int[128];
        int[] green = new int[128];
        int[] blue = new int[128];
        red[0] = 10;
        green[0] = 10;
        blue[0] = 10;
        red[1] = 20;
        green[1] = 20;
        blue[1] = 20;
        red[2] = 30;
        green[2] = 30;
        blue[2] = 30;
        red[3] = 0;
        green[3] = 0;
        blue[3] = 129;
        red[4] = 0;
        green[4] = 0;
        blue[4] = 133;
        red[5] = 0;
        green[5] = 0;
        blue[5] = 136;
        red[6] = 0;
        green[6] = 0;
        blue[6] = 139;
        red[7] = 0;
        green[7] = 0;
        blue[7] = 142;
        red[8] = 0;
        green[8] = 0;
        blue[8] = 145;
        red[9] = 0;
        green[9] = 0;
        blue[9] = 147;
        red[10] = 0;
        green[10] = 0;
        blue[10] = 150;
        red[11] = 0;
        green[11] = 0;
        blue[11] = 152;
        red[12] = 0;
        green[12] = 0;
        blue[12] = 155;
        red[13] = 0;
        green[13] = 0;
        blue[13] = 157;
        red[14] = 0;
        green[14] = 0;
        blue[14] = 159;
        red[15] = 0;
        green[15] = 0;
        blue[15] = 161;
        red[16] = 0;
        green[16] = 0;
        blue[16] = 164;
        red[17] = 0;
        green[17] = 0;
        blue[17] = 166;
        red[18] = 0;
        green[18] = 0;
        blue[18] = 168;
        red[19] = 0;
        green[19] = 0;
        blue[19] = 169;
        red[20] = 0;
        green[20] = 0;
        blue[20] = 171;
        red[21] = 0;
        green[21] = 0;
        blue[21] = 173;
        red[22] = 0;
        green[22] = 0;
        blue[22] = 175;
        red[23] = 0;
        green[23] = 0;
        blue[23] = 177;
        red[24] = 0;
        green[24] = 0;
        blue[24] = 178;
        red[25] = 0;
        green[25] = 0;
        blue[25] = 180;
        red[26] = 0;
        green[26] = 0;
        blue[26] = 182;
        red[27] = 0;
        green[27] = 0;
        blue[27] = 183;
        red[28] = 0;
        green[28] = 0;
        blue[28] = 185;
        red[29] = 0;
        green[29] = 0;
        blue[29] = 186;
        red[30] = 0;
        green[30] = 0;
        blue[30] = 188;
        red[31] = 0;
        green[31] = 0;
        blue[31] = 189;
        red[32] = 0;
        green[32] = 0;
        blue[32] = 191;
        red[33] = 0;
        green[33] = 0;
        blue[33] = 192;
        red[34] = 0;
        green[34] = 0;
        blue[34] = 194;
        red[35] = 0;
        green[35] = 0;
        blue[35] = 195;
        red[36] = 0;
        green[36] = 0;
        blue[36] = 196;
        red[37] = 0;
        green[37] = 0;
        blue[37] = 198;
        red[38] = 0;
        green[38] = 0;
        blue[38] = 199;
        red[39] = 0;
        green[39] = 0;
        blue[39] = 200;
        red[40] = 0;
        green[40] = 0;
        blue[40] = 201;
        red[41] = 0;
        green[41] = 0;
        blue[41] = 203;
        red[42] = 0;
        green[42] = 0;
        blue[42] = 204;
        red[43] = 0;
        green[43] = 0;
        blue[43] = 205;
        red[44] = 0;
        green[44] = 0;
        blue[44] = 206;
        red[45] = 0;
        green[45] = 0;
        blue[45] = 208;
        red[46] = 0;
        green[46] = 1;
        blue[46] = 209;
        red[47] = 0;
        green[47] = 2;
        blue[47] = 210;
        red[48] = 0;
        green[48] = 3;
        blue[48] = 211;
        red[49] = 0;
        green[49] = 6;
        blue[49] = 212;
        red[50] = 0;
        green[50] = 9;
        blue[50] = 213;
        red[51] = 0;
        green[51] = 15;
        blue[51] = 214;
        red[52] = 0;
        green[52] = 24;
        blue[52] = 215;
        red[53] = 0;
        green[53] = 36;
        blue[53] = 217;
        red[54] = 0;
        green[54] = 52;
        blue[54] = 218;
        red[55] = 0;
        green[55] = 73;
        blue[55] = 219;
        red[56] = 0;
        green[56] = 97;
        blue[56] = 220;
        red[57] = 0;
        green[57] = 125;
        blue[57] = 221;
        red[58] = 0;
        green[58] = 155;
        blue[58] = 222;
        red[59] = 0;
        green[59] = 185;
        blue[59] = 223;
        red[60] = 0;
        green[60] = 212;
        blue[60] = 224;
        red[61] = 0;
        green[61] = 234;
        blue[61] = 225;
        red[62] = 0;
        green[62] = 249;
        blue[62] = 226;
        red[63] = 0;
        green[63] = 255;
        blue[63] = 227;
        red[64] = 100;
        green[64] = 0;
        blue[64] = 0;
        red[65] = 122;
        green[65] = 0;
        blue[65] = 0;
        red[66] = 135;
        green[66] = 0;
        blue[66] = 0;
        red[67] = 146;
        green[67] = 0;
        blue[67] = 0;
        red[68] = 162;
        green[68] = 0;
        blue[68] = 0;
        red[69] = 166;
        green[69] = 0;
        blue[69] = 0;
        red[70] = 171;
        green[70] = 0;
        blue[70] = 0;
        red[71] = 174;
        green[71] = 0;
        blue[71] = 0;
        red[72] = 179;
        green[72] = 0;
        blue[72] = 0;
        red[73] = 172;
        green[73] = 0;
        blue[73] = 0;
        red[74] = 185;
        green[74] = 0;
        blue[74] = 0;
        red[75] = 188;
        green[75] = 0;
        blue[75] = 0;
        red[76] = 191;
        green[76] = 0;
        blue[76] = 0;
        red[77] = 194;
        green[77] = 0;
        blue[77] = 0;
        red[78] = 196;
        green[78] = 0;
        blue[78] = 0;
        red[79] = 198;
        green[79] = 0;
        blue[79] = 0;
        red[80] = 200;
        green[80] = 0;
        blue[80] = 0;
        red[81] = 202;
        green[81] = 0;
        blue[81] = 0;
        red[82] = 204;
        green[82] = 0;
        blue[82] = 0;
        red[83] = 206;
        green[83] = 0;
        blue[83] = 0;
        red[84] = 208;
        green[84] = 0;
        blue[84] = 0;
        red[85] = 210;
        green[85] = 0;
        blue[85] = 0;
        red[86] = 212;
        green[86] = 0;
        blue[86] = 0;
        red[87] = 213;
        green[87] = 0;
        blue[87] = 0;
        red[88] = 215;
        green[88] = 0;
        blue[88] = 0;
        red[89] = 216;
        green[89] = 0;
        blue[89] = 0;
        red[90] = 218;
        green[90] = 0;
        blue[90] = 0;
        red[91] = 219;
        green[91] = 0;
        blue[91] = 0;
        red[92] = 221;
        green[92] = 0;
        blue[92] = 0;
        red[93] = 221;
        green[93] = 0;
        blue[93] = 0;
        red[94] = 224;
        green[94] = 0;
        blue[94] = 0;
        red[95] = 226;
        green[95] = 0;
        blue[95] = 0;
        red[96] = 227;
        green[96] = 0;
        blue[96] = 0;
        red[97] = 228;
        green[97] = 0;
        blue[97] = 0;
        red[98] = 229;
        green[98] = 0;
        blue[98] = 0;
        red[99] = 230;
        green[99] = 0;
        blue[99] = 0;
        red[100] = 232;
        green[100] = 0;
        blue[100] = 0;
        red[101] = 233;
        green[101] = 0;
        blue[101] = 0;
        red[102] = 234;
        green[102] = 0;
        blue[102] = 0;
        red[103] = 235;
        green[103] = 0;
        blue[103] = 0;
        red[104] = 236;
        green[104] = 0;
        blue[104] = 0;
        red[105] = 237;
        green[105] = 0;
        blue[105] = 0;
        red[106] = 238;
        green[106] = 0;
        blue[106] = 0;
        red[107] = 239;
        green[107] = 0;
        blue[107] = 0;
        red[108] = 241;
        green[108] = 1;
        blue[108] = 0;
        red[109] = 242;
        green[109] = 1;
        blue[109] = 0;
        red[110] = 243;
        green[110] = 2;
        blue[110] = 0;
        red[111] = 244;
        green[111] = 4;
        blue[111] = 0;
        red[112] = 245;
        green[112] = 6;
        blue[112] = 0;
        red[113] = 246;
        green[113] = 11;
        blue[113] = 0;
        red[114] = 247;
        green[114] = 17;
        blue[114] = 0;
        red[115] = 247;
        green[115] = 27;
        blue[115] = 0;
        red[116] = 248;
        green[116] = 40;
        blue[116] = 0;
        red[117] = 249;
        green[117] = 60;
        blue[117] = 0;
        red[118] = 250;
        green[118] = 79;
        blue[118] = 0;
        red[119] = 251;
        green[119] = 100;
        blue[119] = 0;
        red[120] = 252;
        green[120] = 134;
        blue[120] = 0;
        red[121] = 253;
        green[121] = 160;
        blue[121] = 0;
        red[122] = 254;
        green[122] = 195;
        blue[122] = 0;
        red[123] = 254;
        green[123] = 220;
        blue[123] = 0;
        red[124] = 255;
        green[124] = 241;
        blue[124] = 0;
        red[125] = 255;
        green[125] = 248;
        blue[125] = 0;
        red[126] = 255;
        green[126] = 252;
        blue[126] = 0;
        red[127] = 255;
        green[127] = 255;
        blue[127] = 0;
        EnumeratedColorMap cmap = new EnumeratedColorMap(red, green, blue);
        double[] vals = new double[129];
        vals[0] = -20.0;
        for (int i = 1; i < vals.length; ++i) {
            vals[i] = vals[i - 1] + 0.3125;
        }
        cmap.setEnumeratedValues(vals);
        return cmap;
    }

    public static EnumeratedColorMap createRachelMapMedium() {
        int[] red = new int[160];
        int[] green = new int[160];
        int[] blue = new int[160];
        red[0] = 255;
        green[0] = 255;
        blue[0] = 255;
        red[1] = 0;
        green[1] = 255;
        blue[1] = 255;
        red[2] = 34;
        green[2] = 255;
        blue[2] = 119;
        red[3] = 255;
        green[3] = 255;
        blue[3] = 14;
        red[4] = 255;
        green[4] = 227;
        blue[4] = 0;
        red[5] = 255;
        green[5] = 200;
        blue[5] = 0;
        red[6] = 255;
        green[6] = 173;
        blue[6] = 0;
        red[7] = 255;
        green[7] = 158;
        blue[7] = 0;
        red[8] = 255;
        green[8] = 147;
        blue[8] = 0;
        red[9] = 255;
        green[9] = 136;
        blue[9] = 0;
        red[10] = 255;
        green[10] = 124;
        blue[10] = 0;
        red[11] = 255;
        green[11] = 113;
        blue[11] = 0;
        red[12] = 255;
        green[12] = 102;
        blue[12] = 0;
        red[13] = 255;
        green[13] = 91;
        blue[13] = 0;
        red[14] = 255;
        green[14] = 80;
        blue[14] = 0;
        red[15] = 255;
        green[15] = 69;
        blue[15] = 0;
        red[16] = 255;
        green[16] = 58;
        blue[16] = 0;
        red[17] = 255;
        green[17] = 47;
        blue[17] = 0;
        red[18] = 255;
        green[18] = 36;
        blue[18] = 0;
        red[19] = 255;
        green[19] = 24;
        blue[19] = 0;
        red[20] = 255;
        green[20] = 13;
        blue[20] = 0;
        red[21] = 255;
        green[21] = 2;
        blue[21] = 0;
        red[22] = 249;
        green[22] = 0;
        blue[22] = 0;
        red[23] = 241;
        green[23] = 0;
        blue[23] = 0;
        red[24] = 233;
        green[24] = 0;
        blue[24] = 0;
        red[25] = 226;
        green[25] = 0;
        blue[25] = 0;
        red[26] = 218;
        green[26] = 0;
        blue[26] = 0;
        red[27] = 210;
        green[27] = 0;
        blue[27] = 0;
        red[28] = 202;
        green[28] = 0;
        blue[28] = 0;
        red[29] = 195;
        green[29] = 0;
        blue[29] = 0;
        red[30] = 187;
        green[30] = 0;
        blue[30] = 0;
        red[31] = 179;
        green[31] = 0;
        blue[31] = 0;
        red[32] = 171;
        green[32] = 0;
        blue[32] = 0;
        red[33] = 164;
        green[33] = 0;
        blue[33] = 0;
        red[34] = 156;
        green[34] = 0;
        blue[34] = 0;
        red[35] = 148;
        green[35] = 0;
        blue[35] = 0;
        red[36] = 141;
        green[36] = 0;
        blue[36] = 0;
        red[37] = 133;
        green[37] = 0;
        blue[37] = 0;
        red[38] = 129;
        green[38] = 0;
        blue[38] = 3;
        red[39] = 136;
        green[39] = 0;
        blue[39] = 18;
        red[40] = 143;
        green[40] = 0;
        blue[40] = 32;
        red[41] = 151;
        green[41] = 0;
        blue[41] = 47;
        red[42] = 158;
        green[42] = 0;
        blue[42] = 61;
        red[43] = 165;
        green[43] = 0;
        blue[43] = 76;
        red[44] = 173;
        green[44] = 0;
        blue[44] = 91;
        red[45] = 180;
        green[45] = 0;
        blue[45] = 105;
        red[46] = 187;
        green[46] = 0;
        blue[46] = 120;
        red[47] = 194;
        green[47] = 0;
        blue[47] = 134;
        red[48] = 202;
        green[48] = 0;
        blue[48] = 149;
        red[49] = 204;
        green[49] = 0;
        blue[49] = 161;
        red[50] = 204;
        green[50] = 0;
        blue[50] = 172;
        red[51] = 204;
        green[51] = 0;
        blue[51] = 184;
        red[52] = 204;
        green[52] = 0;
        blue[52] = 195;
        red[53] = 200;
        green[53] = 0;
        blue[53] = 204;
        red[54] = 187;
        green[54] = 3;
        blue[54] = 208;
        red[55] = 174;
        green[55] = 5;
        blue[55] = 212;
        red[56] = 161;
        green[56] = 8;
        blue[56] = 216;
        red[57] = 148;
        green[57] = 10;
        blue[57] = 220;
        red[58] = 135;
        green[58] = 13;
        blue[58] = 224;
        red[59] = 122;
        green[59] = 16;
        blue[59] = 228;
        red[60] = 120;
        green[60] = 14;
        blue[60] = 219;
        red[61] = 119;
        green[61] = 13;
        blue[61] = 211;
        red[62] = 118;
        green[62] = 12;
        blue[62] = 203;
        red[63] = 117;
        green[63] = 11;
        blue[63] = 195;
        red[64] = 116;
        green[64] = 10;
        blue[64] = 187;
        red[65] = 115;
        green[65] = 9;
        blue[65] = 179;
        red[66] = 114;
        green[66] = 8;
        blue[66] = 171;
        red[67] = 113;
        green[67] = 7;
        blue[67] = 162;
        red[68] = 112;
        green[68] = 6;
        blue[68] = 154;
        red[69] = 111;
        green[69] = 5;
        blue[69] = 146;
        red[70] = 110;
        green[70] = 4;
        blue[70] = 138;
        red[71] = 109;
        green[71] = 3;
        blue[71] = 130;
        red[72] = 108;
        green[72] = 2;
        blue[72] = 122;
        red[73] = 106;
        green[73] = 1;
        blue[73] = 114;
        red[74] = 105;
        green[74] = 0;
        blue[74] = 105;
        red[75] = 106;
        green[75] = 3;
        blue[75] = 106;
        red[76] = 107;
        green[76] = 7;
        blue[76] = 107;
        red[77] = 107;
        green[77] = 11;
        blue[77] = 107;
        red[78] = 108;
        green[78] = 15;
        blue[78] = 108;
        red[79] = 108;
        green[79] = 19;
        blue[79] = 108;
        red[80] = 109;
        green[80] = 23;
        blue[80] = 109;
        red[81] = 110;
        green[81] = 26;
        blue[81] = 110;
        red[82] = 110;
        green[82] = 30;
        blue[82] = 110;
        red[83] = 111;
        green[83] = 34;
        blue[83] = 111;
        red[84] = 112;
        green[84] = 38;
        blue[84] = 112;
        red[85] = 112;
        green[85] = 42;
        blue[85] = 112;
        red[86] = 113;
        green[86] = 46;
        blue[86] = 113;
        red[87] = 113;
        green[87] = 50;
        blue[87] = 113;
        red[88] = 114;
        green[88] = 53;
        blue[88] = 114;
        red[89] = 115;
        green[89] = 57;
        blue[89] = 115;
        red[90] = 115;
        green[90] = 61;
        blue[90] = 115;
        red[91] = 116;
        green[91] = 65;
        blue[91] = 116;
        red[92] = 116;
        green[92] = 69;
        blue[92] = 116;
        red[93] = 117;
        green[93] = 73;
        blue[93] = 117;
        red[94] = 118;
        green[94] = 76;
        blue[94] = 118;
        red[95] = 118;
        green[95] = 80;
        blue[95] = 118;
        red[96] = 119;
        green[96] = 84;
        blue[96] = 119;
        red[97] = 120;
        green[97] = 88;
        blue[97] = 120;
        red[98] = 120;
        green[98] = 92;
        blue[98] = 120;
        red[99] = 121;
        green[99] = 96;
        blue[99] = 121;
        red[100] = 121;
        green[100] = 100;
        blue[100] = 121;
        red[101] = 122;
        green[101] = 103;
        blue[101] = 122;
        red[102] = 123;
        green[102] = 107;
        blue[102] = 123;
        red[103] = 123;
        green[103] = 111;
        blue[103] = 123;
        red[104] = 124;
        green[104] = 115;
        blue[104] = 124;
        red[105] = 124;
        green[105] = 119;
        blue[105] = 124;
        red[106] = 125;
        green[106] = 123;
        blue[106] = 125;
        red[107] = 125;
        green[107] = 125;
        blue[107] = 125;
        red[108] = 123;
        green[108] = 123;
        blue[108] = 123;
        red[109] = 120;
        green[109] = 120;
        blue[109] = 120;
        red[110] = 118;
        green[110] = 118;
        blue[110] = 118;
        red[111] = 115;
        green[111] = 115;
        blue[111] = 115;
        red[112] = 113;
        green[112] = 113;
        blue[112] = 113;
        red[113] = 111;
        green[113] = 111;
        blue[113] = 111;
        red[114] = 108;
        green[114] = 108;
        blue[114] = 108;
        red[115] = 106;
        green[115] = 106;
        blue[115] = 106;
        red[116] = 104;
        green[116] = 104;
        blue[116] = 104;
        red[117] = 101;
        green[117] = 101;
        blue[117] = 101;
        red[118] = 99;
        green[118] = 99;
        blue[118] = 99;
        red[119] = 96;
        green[119] = 96;
        blue[119] = 96;
        red[120] = 94;
        green[120] = 94;
        blue[120] = 94;
        red[121] = 92;
        green[121] = 92;
        blue[121] = 92;
        red[122] = 89;
        green[122] = 89;
        blue[122] = 89;
        red[123] = 87;
        green[123] = 87;
        blue[123] = 87;
        red[124] = 84;
        green[124] = 84;
        blue[124] = 84;
        red[125] = 82;
        green[125] = 82;
        blue[125] = 82;
        red[126] = 80;
        green[126] = 80;
        blue[126] = 80;
        red[127] = 77;
        green[127] = 77;
        blue[127] = 77;
        red[128] = 75;
        green[128] = 75;
        blue[128] = 75;
        red[129] = 73;
        green[129] = 73;
        blue[129] = 73;
        red[130] = 70;
        green[130] = 70;
        blue[130] = 70;
        red[131] = 68;
        green[131] = 68;
        blue[131] = 68;
        red[132] = 65;
        green[132] = 65;
        blue[132] = 65;
        red[133] = 63;
        green[133] = 63;
        blue[133] = 63;
        red[134] = 61;
        green[134] = 61;
        blue[134] = 61;
        red[135] = 58;
        green[135] = 58;
        blue[135] = 58;
        red[136] = 56;
        green[136] = 56;
        blue[136] = 56;
        red[137] = 54;
        green[137] = 54;
        blue[137] = 54;
        red[138] = 51;
        green[138] = 51;
        blue[138] = 51;
        red[139] = 49;
        green[139] = 49;
        blue[139] = 49;
        red[140] = 46;
        green[140] = 46;
        blue[140] = 46;
        red[141] = 44;
        green[141] = 44;
        blue[141] = 44;
        red[142] = 42;
        green[142] = 42;
        blue[142] = 42;
        red[143] = 39;
        green[143] = 39;
        blue[143] = 39;
        red[144] = 37;
        green[144] = 37;
        blue[144] = 37;
        red[145] = 35;
        green[145] = 35;
        blue[145] = 35;
        red[146] = 32;
        green[146] = 32;
        blue[146] = 32;
        red[147] = 30;
        green[147] = 30;
        blue[147] = 30;
        red[148] = 27;
        green[148] = 27;
        blue[148] = 27;
        red[149] = 25;
        green[149] = 25;
        blue[149] = 25;
        red[150] = 23;
        green[150] = 23;
        blue[150] = 23;
        red[151] = 20;
        green[151] = 20;
        blue[151] = 20;
        red[152] = 18;
        green[152] = 18;
        blue[152] = 18;
        red[153] = 16;
        green[153] = 16;
        blue[153] = 16;
        red[154] = 13;
        green[154] = 13;
        blue[154] = 13;
        red[155] = 11;
        green[155] = 11;
        blue[155] = 11;
        red[156] = 8;
        green[156] = 8;
        blue[156] = 8;
        red[157] = 6;
        green[157] = 6;
        blue[157] = 6;
        red[158] = 4;
        green[158] = 4;
        blue[158] = 4;
        red[159] = 1;
        green[159] = 1;
        blue[159] = 1;
        EnumeratedColorMap cmap = new EnumeratedColorMap(red, green, blue);
        double[] vals = new double[160];
        vals[0] = 0.0;
        for (int i = 1; i < vals.length; ++i) {
            vals[i] = vals[i - 1] + 3.125;
        }
        cmap.setEnumeratedValues(vals);
        return cmap;
    }

    public static EnumeratedColorMap createRachelMapLarge() {
        int[] red = new int[320];
        int[] green = new int[320];
        int[] blue = new int[320];
        red[0] = 255;
        green[0] = 255;
        blue[0] = 255;
        red[1] = 0;
        green[1] = 255;
        blue[1] = 255;
        red[2] = 17;
        green[2] = 255;
        blue[2] = 187;
        red[3] = 51;
        green[3] = 255;
        blue[3] = 51;
        red[4] = 187;
        green[4] = 255;
        blue[4] = 17;
        red[5] = 221;
        green[5] = 255;
        blue[5] = 8;
        red[6] = 255;
        green[6] = 255;
        blue[6] = 0;
        red[7] = 255;
        green[7] = 241;
        blue[7] = 0;
        red[8] = 255;
        green[8] = 227;
        blue[8] = 0;
        red[9] = 255;
        green[9] = 214;
        blue[9] = 0;
        red[10] = 255;
        green[10] = 200;
        blue[10] = 0;
        red[11] = 255;
        green[11] = 186;
        blue[11] = 0;
        red[12] = 255;
        green[12] = 173;
        blue[12] = 0;
        red[13] = 255;
        green[13] = 163;
        blue[13] = 0;
        red[14] = 255;
        green[14] = 158;
        blue[14] = 0;
        red[15] = 255;
        green[15] = 152;
        blue[15] = 0;
        red[16] = 255;
        green[16] = 147;
        blue[16] = 0;
        red[17] = 255;
        green[17] = 141;
        blue[17] = 0;
        red[18] = 255;
        green[18] = 136;
        blue[18] = 0;
        red[19] = 255;
        green[19] = 130;
        blue[19] = 0;
        red[20] = 255;
        green[20] = 124;
        blue[20] = 0;
        red[21] = 255;
        green[21] = 119;
        blue[21] = 0;
        red[22] = 255;
        green[22] = 113;
        blue[22] = 0;
        red[23] = 255;
        green[23] = 108;
        blue[23] = 0;
        red[24] = 255;
        green[24] = 102;
        blue[24] = 0;
        red[25] = 255;
        green[25] = 97;
        blue[25] = 0;
        red[26] = 255;
        green[26] = 91;
        blue[26] = 0;
        red[27] = 255;
        green[27] = 86;
        blue[27] = 0;
        red[28] = 255;
        green[28] = 80;
        blue[28] = 0;
        red[29] = 255;
        green[29] = 74;
        blue[29] = 0;
        red[30] = 255;
        green[30] = 69;
        blue[30] = 0;
        red[31] = 255;
        green[31] = 63;
        blue[31] = 0;
        red[32] = 255;
        green[32] = 58;
        blue[32] = 0;
        red[33] = 255;
        green[33] = 52;
        blue[33] = 0;
        red[34] = 255;
        green[34] = 47;
        blue[34] = 0;
        red[35] = 255;
        green[35] = 41;
        blue[35] = 0;
        red[36] = 255;
        green[36] = 36;
        blue[36] = 0;
        red[37] = 255;
        green[37] = 30;
        blue[37] = 0;
        red[38] = 255;
        green[38] = 24;
        blue[38] = 0;
        red[39] = 255;
        green[39] = 19;
        blue[39] = 0;
        red[40] = 255;
        green[40] = 13;
        blue[40] = 0;
        red[41] = 255;
        green[41] = 8;
        blue[41] = 0;
        red[42] = 255;
        green[42] = 2;
        blue[42] = 0;
        red[43] = 253;
        green[43] = 0;
        blue[43] = 0;
        red[44] = 249;
        green[44] = 0;
        blue[44] = 0;
        red[45] = 245;
        green[45] = 0;
        blue[45] = 0;
        red[46] = 241;
        green[46] = 0;
        blue[46] = 0;
        red[47] = 237;
        green[47] = 0;
        blue[47] = 0;
        red[48] = 233;
        green[48] = 0;
        blue[48] = 0;
        red[49] = 229;
        green[49] = 0;
        blue[49] = 0;
        red[50] = 226;
        green[50] = 0;
        blue[50] = 0;
        red[51] = 222;
        green[51] = 0;
        blue[51] = 0;
        red[52] = 218;
        green[52] = 0;
        blue[52] = 0;
        red[53] = 214;
        green[53] = 0;
        blue[53] = 0;
        red[54] = 210;
        green[54] = 0;
        blue[54] = 0;
        red[55] = 206;
        green[55] = 0;
        blue[55] = 0;
        red[56] = 202;
        green[56] = 0;
        blue[56] = 0;
        red[57] = 198;
        green[57] = 0;
        blue[57] = 0;
        red[58] = 195;
        green[58] = 0;
        blue[58] = 0;
        red[59] = 191;
        green[59] = 0;
        blue[59] = 0;
        red[60] = 187;
        green[60] = 0;
        blue[60] = 0;
        red[61] = 183;
        green[61] = 0;
        blue[61] = 0;
        red[62] = 179;
        green[62] = 0;
        blue[62] = 0;
        red[63] = 175;
        green[63] = 0;
        blue[63] = 0;
        red[64] = 171;
        green[64] = 0;
        blue[64] = 0;
        red[65] = 168;
        green[65] = 0;
        blue[65] = 0;
        red[66] = 164;
        green[66] = 0;
        blue[66] = 0;
        red[67] = 160;
        green[67] = 0;
        blue[67] = 0;
        red[68] = 156;
        green[68] = 0;
        blue[68] = 0;
        red[69] = 152;
        green[69] = 0;
        blue[69] = 0;
        red[70] = 148;
        green[70] = 0;
        blue[70] = 0;
        red[71] = 144;
        green[71] = 0;
        blue[71] = 0;
        red[72] = 141;
        green[72] = 0;
        blue[72] = 0;
        red[73] = 137;
        green[73] = 0;
        blue[73] = 0;
        red[74] = 133;
        green[74] = 0;
        blue[74] = 0;
        red[75] = 129;
        green[75] = 0;
        blue[75] = 0;
        red[76] = 129;
        green[76] = 0;
        blue[76] = 3;
        red[77] = 132;
        green[77] = 0;
        blue[77] = 10;
        red[78] = 136;
        green[78] = 0;
        blue[78] = 18;
        red[79] = 140;
        green[79] = 0;
        blue[79] = 25;
        red[80] = 143;
        green[80] = 0;
        blue[80] = 32;
        red[81] = 147;
        green[81] = 0;
        blue[81] = 40;
        red[82] = 151;
        green[82] = 0;
        blue[82] = 47;
        red[83] = 154;
        green[83] = 0;
        blue[83] = 54;
        red[84] = 158;
        green[84] = 0;
        blue[84] = 61;
        red[85] = 162;
        green[85] = 0;
        blue[85] = 69;
        red[86] = 165;
        green[86] = 0;
        blue[86] = 76;
        red[87] = 169;
        green[87] = 0;
        blue[87] = 83;
        red[88] = 173;
        green[88] = 0;
        blue[88] = 91;
        red[89] = 176;
        green[89] = 0;
        blue[89] = 98;
        red[90] = 180;
        green[90] = 0;
        blue[90] = 105;
        red[91] = 183;
        green[91] = 0;
        blue[91] = 112;
        red[92] = 187;
        green[92] = 0;
        blue[92] = 120;
        red[93] = 191;
        green[93] = 0;
        blue[93] = 127;
        red[94] = 194;
        green[94] = 0;
        blue[94] = 134;
        red[95] = 198;
        green[95] = 0;
        blue[95] = 142;
        red[96] = 202;
        green[96] = 0;
        blue[96] = 149;
        red[97] = 204;
        green[97] = 0;
        blue[97] = 155;
        red[98] = 204;
        green[98] = 0;
        blue[98] = 161;
        red[99] = 204;
        green[99] = 0;
        blue[99] = 167;
        red[100] = 204;
        green[100] = 0;
        blue[100] = 172;
        red[101] = 204;
        green[101] = 0;
        blue[101] = 178;
        red[102] = 204;
        green[102] = 0;
        blue[102] = 184;
        red[103] = 204;
        green[103] = 0;
        blue[103] = 189;
        red[104] = 204;
        green[104] = 0;
        blue[104] = 195;
        red[105] = 204;
        green[105] = 0;
        blue[105] = 201;
        red[106] = 200;
        green[106] = 0;
        blue[106] = 204;
        red[107] = 194;
        green[107] = 1;
        blue[107] = 206;
        red[108] = 187;
        green[108] = 3;
        blue[108] = 208;
        red[109] = 181;
        green[109] = 4;
        blue[109] = 210;
        red[110] = 174;
        green[110] = 5;
        blue[110] = 212;
        red[111] = 167;
        green[111] = 7;
        blue[111] = 214;
        red[112] = 161;
        green[112] = 8;
        blue[112] = 216;
        red[113] = 154;
        green[113] = 9;
        blue[113] = 218;
        red[114] = 148;
        green[114] = 10;
        blue[114] = 220;
        red[115] = 141;
        green[115] = 12;
        blue[115] = 222;
        red[116] = 135;
        green[116] = 13;
        blue[116] = 224;
        red[117] = 128;
        green[117] = 14;
        blue[117] = 226;
        red[118] = 122;
        green[118] = 16;
        blue[118] = 228;
        red[119] = 121;
        green[119] = 15;
        blue[119] = 223;
        red[120] = 120;
        green[120] = 14;
        blue[120] = 219;
        red[121] = 120;
        green[121] = 14;
        blue[121] = 215;
        red[122] = 119;
        green[122] = 13;
        blue[122] = 211;
        red[123] = 119;
        green[123] = 13;
        blue[123] = 207;
        red[124] = 118;
        green[124] = 12;
        blue[124] = 203;
        red[125] = 118;
        green[125] = 12;
        blue[125] = 199;
        red[126] = 117;
        green[126] = 11;
        blue[126] = 195;
        red[127] = 117;
        green[127] = 11;
        blue[127] = 191;
        red[128] = 116;
        green[128] = 10;
        blue[128] = 187;
        red[129] = 116;
        green[129] = 10;
        blue[129] = 183;
        red[130] = 115;
        green[130] = 9;
        blue[130] = 179;
        red[131] = 115;
        green[131] = 9;
        blue[131] = 175;
        red[132] = 114;
        green[132] = 8;
        blue[132] = 171;
        red[133] = 113;
        green[133] = 8;
        blue[133] = 166;
        red[134] = 113;
        green[134] = 7;
        blue[134] = 162;
        red[135] = 112;
        green[135] = 6;
        blue[135] = 158;
        red[136] = 112;
        green[136] = 6;
        blue[136] = 154;
        red[137] = 111;
        green[137] = 5;
        blue[137] = 150;
        red[138] = 111;
        green[138] = 5;
        blue[138] = 146;
        red[139] = 110;
        green[139] = 4;
        blue[139] = 142;
        red[140] = 110;
        green[140] = 4;
        blue[140] = 138;
        red[141] = 109;
        green[141] = 3;
        blue[141] = 134;
        red[142] = 109;
        green[142] = 3;
        blue[142] = 130;
        red[143] = 108;
        green[143] = 2;
        blue[143] = 126;
        red[144] = 108;
        green[144] = 2;
        blue[144] = 122;
        red[145] = 107;
        green[145] = 1;
        blue[145] = 118;
        red[146] = 106;
        green[146] = 1;
        blue[146] = 114;
        red[147] = 106;
        green[147] = 0;
        blue[147] = 109;
        red[148] = 105;
        green[148] = 0;
        blue[148] = 105;
        red[149] = 106;
        green[149] = 1;
        blue[149] = 106;
        red[150] = 106;
        green[150] = 3;
        blue[150] = 106;
        red[151] = 106;
        green[151] = 5;
        blue[151] = 106;
        red[152] = 107;
        green[152] = 7;
        blue[152] = 107;
        red[153] = 107;
        green[153] = 9;
        blue[153] = 107;
        red[154] = 107;
        green[154] = 11;
        blue[154] = 107;
        red[155] = 108;
        green[155] = 13;
        blue[155] = 108;
        red[156] = 108;
        green[156] = 15;
        blue[156] = 108;
        red[157] = 108;
        green[157] = 17;
        blue[157] = 108;
        red[158] = 108;
        green[158] = 19;
        blue[158] = 108;
        red[159] = 109;
        green[159] = 21;
        blue[159] = 109;
        red[160] = 109;
        green[160] = 23;
        blue[160] = 109;
        red[161] = 109;
        green[161] = 25;
        blue[161] = 109;
        red[162] = 110;
        green[162] = 26;
        blue[162] = 110;
        red[163] = 110;
        green[163] = 28;
        blue[163] = 110;
        red[164] = 110;
        green[164] = 30;
        blue[164] = 110;
        red[165] = 111;
        green[165] = 32;
        blue[165] = 111;
        red[166] = 111;
        green[166] = 34;
        blue[166] = 111;
        red[167] = 111;
        green[167] = 36;
        blue[167] = 111;
        red[168] = 112;
        green[168] = 38;
        blue[168] = 112;
        red[169] = 112;
        green[169] = 40;
        blue[169] = 112;
        red[170] = 112;
        green[170] = 42;
        blue[170] = 112;
        red[171] = 112;
        green[171] = 44;
        blue[171] = 112;
        red[172] = 113;
        green[172] = 46;
        blue[172] = 113;
        red[173] = 113;
        green[173] = 48;
        blue[173] = 113;
        red[174] = 113;
        green[174] = 50;
        blue[174] = 113;
        red[175] = 114;
        green[175] = 51;
        blue[175] = 114;
        red[176] = 114;
        green[176] = 53;
        blue[176] = 114;
        red[177] = 114;
        green[177] = 55;
        blue[177] = 114;
        red[178] = 115;
        green[178] = 57;
        blue[178] = 115;
        red[179] = 115;
        green[179] = 59;
        blue[179] = 115;
        red[180] = 115;
        green[180] = 61;
        blue[180] = 115;
        red[181] = 116;
        green[181] = 63;
        blue[181] = 116;
        red[182] = 116;
        green[182] = 65;
        blue[182] = 116;
        red[183] = 116;
        green[183] = 67;
        blue[183] = 116;
        red[184] = 116;
        green[184] = 69;
        blue[184] = 116;
        red[185] = 117;
        green[185] = 71;
        blue[185] = 117;
        red[186] = 117;
        green[186] = 73;
        blue[186] = 117;
        red[187] = 117;
        green[187] = 75;
        blue[187] = 117;
        red[188] = 118;
        green[188] = 76;
        blue[188] = 118;
        red[189] = 118;
        green[189] = 78;
        blue[189] = 118;
        red[190] = 118;
        green[190] = 80;
        blue[190] = 118;
        red[191] = 119;
        green[191] = 82;
        blue[191] = 119;
        red[192] = 119;
        green[192] = 84;
        blue[192] = 119;
        red[193] = 119;
        green[193] = 86;
        blue[193] = 119;
        red[194] = 120;
        green[194] = 88;
        blue[194] = 120;
        red[195] = 120;
        green[195] = 90;
        blue[195] = 120;
        red[196] = 120;
        green[196] = 92;
        blue[196] = 120;
        red[197] = 120;
        green[197] = 94;
        blue[197] = 120;
        red[198] = 121;
        green[198] = 96;
        blue[198] = 121;
        red[199] = 121;
        green[199] = 98;
        blue[199] = 121;
        red[200] = 121;
        green[200] = 100;
        blue[200] = 121;
        red[201] = 122;
        green[201] = 101;
        blue[201] = 122;
        red[202] = 122;
        green[202] = 103;
        blue[202] = 122;
        red[203] = 122;
        green[203] = 105;
        blue[203] = 122;
        red[204] = 123;
        green[204] = 107;
        blue[204] = 123;
        red[205] = 123;
        green[205] = 109;
        blue[205] = 123;
        red[206] = 123;
        green[206] = 111;
        blue[206] = 123;
        red[207] = 124;
        green[207] = 113;
        blue[207] = 124;
        red[208] = 124;
        green[208] = 115;
        blue[208] = 124;
        red[209] = 124;
        green[209] = 117;
        blue[209] = 124;
        red[210] = 124;
        green[210] = 119;
        blue[210] = 124;
        red[211] = 125;
        green[211] = 121;
        blue[211] = 125;
        red[212] = 125;
        green[212] = 123;
        blue[212] = 125;
        red[213] = 125;
        green[213] = 125;
        blue[213] = 125;
        red[214] = 125;
        green[214] = 125;
        blue[214] = 125;
        red[215] = 124;
        green[215] = 124;
        blue[215] = 124;
        red[216] = 123;
        green[216] = 123;
        blue[216] = 123;
        red[217] = 121;
        green[217] = 121;
        blue[217] = 121;
        red[218] = 120;
        green[218] = 120;
        blue[218] = 120;
        red[219] = 119;
        green[219] = 119;
        blue[219] = 119;
        red[220] = 118;
        green[220] = 118;
        blue[220] = 118;
        red[221] = 117;
        green[221] = 117;
        blue[221] = 117;
        red[222] = 115;
        green[222] = 115;
        blue[222] = 115;
        red[223] = 114;
        green[223] = 114;
        blue[223] = 114;
        red[224] = 113;
        green[224] = 113;
        blue[224] = 113;
        red[225] = 112;
        green[225] = 112;
        blue[225] = 112;
        red[226] = 111;
        green[226] = 111;
        blue[226] = 111;
        red[227] = 109;
        green[227] = 109;
        blue[227] = 109;
        red[228] = 108;
        green[228] = 108;
        blue[228] = 108;
        red[229] = 107;
        green[229] = 107;
        blue[229] = 107;
        red[230] = 106;
        green[230] = 106;
        blue[230] = 106;
        red[231] = 105;
        green[231] = 105;
        blue[231] = 105;
        red[232] = 104;
        green[232] = 104;
        blue[232] = 104;
        red[233] = 102;
        green[233] = 102;
        blue[233] = 102;
        red[234] = 101;
        green[234] = 101;
        blue[234] = 101;
        red[235] = 100;
        green[235] = 100;
        blue[235] = 100;
        red[236] = 99;
        green[236] = 99;
        blue[236] = 99;
        red[237] = 98;
        green[237] = 98;
        blue[237] = 98;
        red[238] = 96;
        green[238] = 96;
        blue[238] = 96;
        red[239] = 95;
        green[239] = 95;
        blue[239] = 95;
        red[240] = 94;
        green[240] = 94;
        blue[240] = 94;
        red[241] = 93;
        green[241] = 93;
        blue[241] = 93;
        red[242] = 92;
        green[242] = 92;
        blue[242] = 92;
        red[243] = 90;
        green[243] = 90;
        blue[243] = 90;
        red[244] = 89;
        green[244] = 89;
        blue[244] = 89;
        red[245] = 88;
        green[245] = 88;
        blue[245] = 88;
        red[246] = 87;
        green[246] = 87;
        blue[246] = 87;
        red[247] = 86;
        green[247] = 86;
        blue[247] = 86;
        red[248] = 84;
        green[248] = 84;
        blue[248] = 84;
        red[249] = 83;
        green[249] = 83;
        blue[249] = 83;
        red[250] = 82;
        green[250] = 82;
        blue[250] = 82;
        red[251] = 81;
        green[251] = 81;
        blue[251] = 81;
        red[252] = 80;
        green[252] = 80;
        blue[252] = 80;
        red[253] = 79;
        green[253] = 79;
        blue[253] = 79;
        red[254] = 77;
        green[254] = 77;
        blue[254] = 77;
        red[255] = 76;
        green[255] = 76;
        blue[255] = 76;
        red[256] = 75;
        green[256] = 75;
        blue[256] = 75;
        red[257] = 74;
        green[257] = 74;
        blue[257] = 74;
        red[258] = 73;
        green[258] = 73;
        blue[258] = 73;
        red[259] = 71;
        green[259] = 71;
        blue[259] = 71;
        red[260] = 70;
        green[260] = 70;
        blue[260] = 70;
        red[261] = 69;
        green[261] = 69;
        blue[261] = 69;
        red[262] = 68;
        green[262] = 68;
        blue[262] = 68;
        red[263] = 67;
        green[263] = 67;
        blue[263] = 67;
        red[264] = 65;
        green[264] = 65;
        blue[264] = 65;
        red[265] = 64;
        green[265] = 64;
        blue[265] = 64;
        red[266] = 63;
        green[266] = 63;
        blue[266] = 63;
        red[267] = 62;
        green[267] = 62;
        blue[267] = 62;
        red[268] = 61;
        green[268] = 61;
        blue[268] = 61;
        red[269] = 60;
        green[269] = 60;
        blue[269] = 60;
        red[270] = 58;
        green[270] = 58;
        blue[270] = 58;
        red[271] = 57;
        green[271] = 57;
        blue[271] = 57;
        red[272] = 56;
        green[272] = 56;
        blue[272] = 56;
        red[273] = 55;
        green[273] = 55;
        blue[273] = 55;
        red[274] = 54;
        green[274] = 54;
        blue[274] = 54;
        red[275] = 52;
        green[275] = 52;
        blue[275] = 52;
        red[276] = 51;
        green[276] = 51;
        blue[276] = 51;
        red[277] = 50;
        green[277] = 50;
        blue[277] = 50;
        red[278] = 49;
        green[278] = 49;
        blue[278] = 49;
        red[279] = 48;
        green[279] = 48;
        blue[279] = 48;
        red[280] = 46;
        green[280] = 46;
        blue[280] = 46;
        red[281] = 45;
        green[281] = 45;
        blue[281] = 45;
        red[282] = 44;
        green[282] = 44;
        blue[282] = 44;
        red[283] = 43;
        green[283] = 43;
        blue[283] = 43;
        red[284] = 42;
        green[284] = 42;
        blue[284] = 42;
        red[285] = 41;
        green[285] = 41;
        blue[285] = 41;
        red[286] = 39;
        green[286] = 39;
        blue[286] = 39;
        red[287] = 38;
        green[287] = 38;
        blue[287] = 38;
        red[288] = 37;
        green[288] = 37;
        blue[288] = 37;
        red[289] = 36;
        green[289] = 36;
        blue[289] = 36;
        red[290] = 35;
        green[290] = 35;
        blue[290] = 35;
        red[291] = 33;
        green[291] = 33;
        blue[291] = 33;
        red[292] = 32;
        green[292] = 32;
        blue[292] = 32;
        red[293] = 31;
        green[293] = 31;
        blue[293] = 31;
        red[294] = 30;
        green[294] = 30;
        blue[294] = 30;
        red[295] = 29;
        green[295] = 29;
        blue[295] = 29;
        red[296] = 27;
        green[296] = 27;
        blue[296] = 27;
        red[297] = 26;
        green[297] = 26;
        blue[297] = 26;
        red[298] = 25;
        green[298] = 25;
        blue[298] = 25;
        red[299] = 24;
        green[299] = 24;
        blue[299] = 24;
        red[300] = 23;
        green[300] = 23;
        blue[300] = 23;
        red[301] = 21;
        green[301] = 21;
        blue[301] = 21;
        red[302] = 20;
        green[302] = 20;
        blue[302] = 20;
        red[303] = 19;
        green[303] = 19;
        blue[303] = 19;
        red[304] = 18;
        green[304] = 18;
        blue[304] = 18;
        red[305] = 17;
        green[305] = 17;
        blue[305] = 17;
        red[306] = 16;
        green[306] = 16;
        blue[306] = 16;
        red[307] = 14;
        green[307] = 14;
        blue[307] = 14;
        red[308] = 13;
        green[308] = 13;
        blue[308] = 13;
        red[309] = 12;
        green[309] = 12;
        blue[309] = 12;
        red[310] = 11;
        green[310] = 11;
        blue[310] = 11;
        red[311] = 10;
        green[311] = 10;
        blue[311] = 10;
        red[312] = 8;
        green[312] = 8;
        blue[312] = 8;
        red[313] = 7;
        green[313] = 7;
        blue[313] = 7;
        red[314] = 6;
        green[314] = 6;
        blue[314] = 6;
        red[315] = 5;
        green[315] = 5;
        blue[315] = 5;
        red[316] = 4;
        green[316] = 4;
        blue[316] = 4;
        red[317] = 2;
        green[317] = 2;
        blue[317] = 2;
        red[318] = 1;
        green[318] = 1;
        blue[318] = 1;
        red[319] = 0;
        green[319] = 0;
        blue[319] = 0;
        EnumeratedColorMap cmap = new EnumeratedColorMap(red, green, blue);
        double[] vals = new double[320];
        vals[0] = 0.0;
        for (int i = 1; i < vals.length; ++i) {
            vals[i] = vals[i - 1] + 1.5625;
        }
        cmap.setEnumeratedValues(vals);
        return cmap;
    }

    public static EnumeratedColorMap createRachelMapOrig() {
        int[] red = new int[128];
        int[] green = new int[128];
        int[] blue = new int[128];
        red[0] = 0;
        green[0] = 0;
        blue[0] = 117;
        red[1] = 0;
        green[1] = 0;
        blue[1] = 122;
        red[2] = 0;
        green[2] = 0;
        blue[2] = 125;
        red[3] = 0;
        green[3] = 0;
        blue[3] = 129;
        red[4] = 0;
        green[4] = 0;
        blue[4] = 133;
        red[5] = 0;
        green[5] = 0;
        blue[5] = 136;
        red[6] = 0;
        green[6] = 0;
        blue[6] = 139;
        red[7] = 0;
        green[7] = 0;
        blue[7] = 142;
        red[8] = 0;
        green[8] = 0;
        blue[8] = 145;
        red[9] = 0;
        green[9] = 0;
        blue[9] = 147;
        red[10] = 0;
        green[10] = 0;
        blue[10] = 150;
        red[11] = 0;
        green[11] = 0;
        blue[11] = 152;
        red[12] = 0;
        green[12] = 0;
        blue[12] = 155;
        red[13] = 0;
        green[13] = 0;
        blue[13] = 157;
        red[14] = 0;
        green[14] = 0;
        blue[14] = 159;
        red[15] = 0;
        green[15] = 0;
        blue[15] = 161;
        red[16] = 0;
        green[16] = 0;
        blue[16] = 164;
        red[17] = 0;
        green[17] = 0;
        blue[17] = 166;
        red[18] = 0;
        green[18] = 0;
        blue[18] = 168;
        red[19] = 0;
        green[19] = 0;
        blue[19] = 169;
        red[20] = 0;
        green[20] = 0;
        blue[20] = 171;
        red[21] = 0;
        green[21] = 0;
        blue[21] = 173;
        red[22] = 0;
        green[22] = 0;
        blue[22] = 175;
        red[23] = 0;
        green[23] = 0;
        blue[23] = 177;
        red[24] = 0;
        green[24] = 0;
        blue[24] = 178;
        red[25] = 0;
        green[25] = 0;
        blue[25] = 180;
        red[26] = 0;
        green[26] = 0;
        blue[26] = 182;
        red[27] = 0;
        green[27] = 0;
        blue[27] = 183;
        red[28] = 0;
        green[28] = 0;
        blue[28] = 185;
        red[29] = 0;
        green[29] = 0;
        blue[29] = 186;
        red[30] = 0;
        green[30] = 0;
        blue[30] = 188;
        red[31] = 0;
        green[31] = 0;
        blue[31] = 189;
        red[32] = 0;
        green[32] = 0;
        blue[32] = 191;
        red[33] = 0;
        green[33] = 0;
        blue[33] = 192;
        red[34] = 0;
        green[34] = 0;
        blue[34] = 194;
        red[35] = 0;
        green[35] = 0;
        blue[35] = 195;
        red[36] = 0;
        green[36] = 0;
        blue[36] = 196;
        red[37] = 0;
        green[37] = 0;
        blue[37] = 198;
        red[38] = 0;
        green[38] = 0;
        blue[38] = 199;
        red[39] = 0;
        green[39] = 0;
        blue[39] = 200;
        red[40] = 0;
        green[40] = 0;
        blue[40] = 201;
        red[41] = 0;
        green[41] = 0;
        blue[41] = 203;
        red[42] = 0;
        green[42] = 0;
        blue[42] = 204;
        red[43] = 0;
        green[43] = 0;
        blue[43] = 205;
        red[44] = 0;
        green[44] = 0;
        blue[44] = 206;
        red[45] = 0;
        green[45] = 0;
        blue[45] = 208;
        red[46] = 0;
        green[46] = 1;
        blue[46] = 209;
        red[47] = 0;
        green[47] = 2;
        blue[47] = 210;
        red[48] = 0;
        green[48] = 3;
        blue[48] = 211;
        red[49] = 0;
        green[49] = 6;
        blue[49] = 212;
        red[50] = 0;
        green[50] = 9;
        blue[50] = 213;
        red[51] = 0;
        green[51] = 15;
        blue[51] = 214;
        red[52] = 0;
        green[52] = 24;
        blue[52] = 215;
        red[53] = 0;
        green[53] = 36;
        blue[53] = 217;
        red[54] = 0;
        green[54] = 52;
        blue[54] = 218;
        red[55] = 0;
        green[55] = 73;
        blue[55] = 219;
        red[56] = 0;
        green[56] = 97;
        blue[56] = 220;
        red[57] = 0;
        green[57] = 125;
        blue[57] = 221;
        red[58] = 0;
        green[58] = 155;
        blue[58] = 222;
        red[59] = 0;
        green[59] = 185;
        blue[59] = 223;
        red[60] = 0;
        green[60] = 212;
        blue[60] = 224;
        red[61] = 0;
        green[61] = 234;
        blue[61] = 225;
        red[62] = 0;
        green[62] = 249;
        blue[62] = 226;
        red[63] = 0;
        green[63] = 255;
        blue[63] = 227;
        red[64] = 255;
        green[64] = 255;
        blue[64] = 0;
        red[65] = 255;
        green[65] = 241;
        blue[65] = 0;
        red[66] = 254;
        green[66] = 195;
        blue[66] = 0;
        red[67] = 252;
        green[67] = 134;
        blue[67] = 0;
        red[68] = 250;
        green[68] = 79;
        blue[68] = 0;
        red[69] = 248;
        green[69] = 40;
        blue[69] = 0;
        red[70] = 247;
        green[70] = 17;
        blue[70] = 0;
        red[71] = 245;
        green[71] = 6;
        blue[71] = 0;
        red[72] = 243;
        green[72] = 2;
        blue[72] = 0;
        red[73] = 241;
        green[73] = 1;
        blue[73] = 0;
        red[74] = 239;
        green[74] = 0;
        blue[74] = 0;
        red[75] = 236;
        green[75] = 0;
        blue[75] = 0;
        red[76] = 234;
        green[76] = 0;
        blue[76] = 0;
        red[77] = 232;
        green[77] = 0;
        blue[77] = 0;
        red[78] = 229;
        green[78] = 0;
        blue[78] = 0;
        red[79] = 227;
        green[79] = 0;
        blue[79] = 0;
        red[80] = 224;
        green[80] = 0;
        blue[80] = 0;
        red[81] = 221;
        green[81] = 0;
        blue[81] = 0;
        red[82] = 218;
        green[82] = 0;
        blue[82] = 0;
        red[83] = 215;
        green[83] = 0;
        blue[83] = 0;
        red[84] = 212;
        green[84] = 0;
        blue[84] = 0;
        red[85] = 208;
        green[85] = 0;
        blue[85] = 0;
        red[86] = 204;
        green[86] = 0;
        blue[86] = 0;
        red[87] = 200;
        green[87] = 0;
        blue[87] = 0;
        red[88] = 196;
        green[88] = 0;
        blue[88] = 0;
        red[89] = 191;
        green[89] = 0;
        blue[89] = 0;
        red[90] = 185;
        green[90] = 0;
        blue[90] = 0;
        red[91] = 179;
        green[91] = 0;
        blue[91] = 0;
        red[92] = 171;
        green[92] = 0;
        blue[92] = 0;
        red[93] = 162;
        green[93] = 0;
        blue[93] = 0;
        red[94] = 151;
        green[94] = 0;
        blue[94] = 0;
        red[95] = 134;
        green[95] = 0;
        blue[95] = 0;
        red[96] = 255;
        green[96] = 0;
        blue[96] = 255;
        red[97] = 255;
        green[97] = 0;
        blue[97] = 254;
        red[98] = 254;
        green[98] = 0;
        blue[98] = 252;
        red[99] = 252;
        green[99] = 0;
        blue[99] = 250;
        red[100] = 250;
        green[100] = 0;
        blue[100] = 249;
        red[101] = 248;
        green[101] = 0;
        blue[101] = 247;
        red[102] = 247;
        green[102] = 0;
        blue[102] = 245;
        red[103] = 245;
        green[103] = 0;
        blue[103] = 243;
        red[104] = 243;
        green[104] = 0;
        blue[104] = 241;
        red[105] = 241;
        green[105] = 0;
        blue[105] = 239;
        red[106] = 239;
        green[106] = 0;
        blue[106] = 237;
        red[107] = 236;
        green[107] = 0;
        blue[107] = 234;
        red[108] = 234;
        green[108] = 0;
        blue[108] = 232;
        red[109] = 232;
        green[109] = 0;
        blue[109] = 230;
        red[110] = 229;
        green[110] = 0;
        blue[110] = 227;
        red[111] = 227;
        green[111] = 0;
        blue[111] = 224;
        red[112] = 224;
        green[112] = 0;
        blue[112] = 221;
        red[113] = 221;
        green[113] = 0;
        blue[113] = 218;
        red[114] = 218;
        green[114] = 0;
        blue[114] = 215;
        red[115] = 215;
        green[115] = 0;
        blue[115] = 212;
        red[116] = 212;
        green[116] = 0;
        blue[116] = 208;
        red[117] = 208;
        green[117] = 1;
        blue[117] = 205;
        red[118] = 204;
        green[118] = 3;
        blue[118] = 200;
        red[119] = 200;
        green[119] = 9;
        blue[119] = 196;
        red[120] = 196;
        green[120] = 20;
        blue[120] = 191;
        red[121] = 191;
        green[121] = 40;
        blue[121] = 185;
        red[122] = 185;
        green[122] = 73;
        blue[122] = 179;
        red[123] = 179;
        green[123] = 118;
        blue[123] = 172;
        red[124] = 171;
        green[124] = 169;
        blue[124] = 163;
        red[125] = 162;
        green[125] = 217;
        blue[125] = 152;
        red[126] = 151;
        green[126] = 248;
        blue[126] = 135;
        red[127] = 134;
        green[127] = 254;
        blue[127] = 102;
        EnumeratedColorMap cmap = new EnumeratedColorMap(red, green, blue);
        double[] vals = new double[129];
        vals[0] = -20.0;
        for (int i = 1; i < vals.length; ++i) {
            vals[i] = vals[i - 1] + 0.3125;
        }
        cmap.setEnumeratedValues(vals);
        return cmap;
    }

    public static EnumeratedColorMap createMapCyanToMagenta2() {
        int i;
        int[] red = new int[45];
        int[] green = new int[45];
        int[] blue = new int[45];
        float factor = 1.0f;
        for (i = 0; i < 20; ++i) {
            red[i] = 0;
            factor = 12.75f * (float)Math.sin((double)i / 20.0 * Math.PI / 2.0);
            green[i] = Math.round(255.0f - factor * (float)i);
            blue[i] = 255;
        }
        for (i = 20; i < 40; ++i) {
            factor = 12.75f * (float)Math.sin((double)i / 40.0 * Math.PI / 2.0);
            red[i] = Math.round(0.0f + factor * (float)(i - 20));
            green[i] = 0;
            blue[i] = 255;
        }
        red[40] = 255;
        green[40] = 0;
        blue[40] = 255;
        red[41] = 255;
        green[41] = 0;
        blue[41] = 137;
        red[42] = 255;
        green[42] = 0;
        blue[42] = 0;
        red[43] = 255;
        green[43] = 137;
        blue[43] = 0;
        red[44] = 255;
        green[44] = 255;
        blue[44] = 0;
        EnumeratedColorMap cmap = new EnumeratedColorMap(red, green, blue);
        double[] vals = new double[]{-1000.0, -900.0, -800.0, -700.0, -600.0, -500.0, -400.0, -325.0, -250.0, -200.0, -150.0, -100.0, -50.0, -45.0, -40.0, -35.0, -30.0, -25.0, -20.0, -15.0, -10.0, -5.0, 0.0, 5.0, 10.0, 15.0, 20.0, 25.0, 30.0, 35.0, 40.0, 45.0, 50.0, 100.0, 150.0, 200.0, 250.0, 325.0, 400.0, 500.0, 600.0, 700.0, 800.0, 900.0, 1000.0};
        cmap.setEnumeratedValues(vals);
        return cmap;
    }

    public static ColorMap createSeaMap(Range2D datar) {
        int[] red = new int[]{10, 9, 8, 6, 5, 4, 3, 1, 0, 20, 40, 61, 81, 101, 121, 155};
        int[] green = new int[]{36, 32, 27, 23, 18, 14, 9, 5, 0, 37, 74, 111, 148, 185, 222, 235};
        int[] blue = new int[]{106, 125, 143, 162, 180, 199, 218, 236, 255, 255, 255, 255, 255, 255, 255, 255};
        IndexedColorMap cmap = new IndexedColorMap(red, green, blue);
        cmap.setTransform(new LinearTransform(0.0, (double)red.length, datar.start, datar.end));
        return cmap;
    }

    public static ColorMap createLandMap(Range2D datar) {
        int[] red = new int[]{0, 59, 118, 178, 181, 183, 186, 188, 191, 191, 191};
        int[] green = new int[]{127, 144, 161, 178, 163, 147, 132, 117, 101, 140, 178};
        int[] blue = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 83, 166};
        IndexedColorMap cmap = new IndexedColorMap(red, green, blue);
        cmap.setTransform(new LinearTransform(0.0, (double)red.length, datar.start, datar.end));
        return cmap;
    }

    public static ColorMap createLandSeaMap(Range2D datar) {
        int[] red = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 59, 118, 178, 181, 183, 186, 188, 191, 191, 191};
        int[] green = new int[]{0, 0, 0, 0, 0, 43, 85, 127, 170, 212, 255, 127, 144, 161, 178, 163, 147, 132, 117, 101, 140, 178};
        int[] blue = new int[]{64, 127, 169, 212, 255, 255, 255, 255, 255, 255, 255, 0, 0, 0, 0, 0, 0, 0, 0, 0, 83, 166};
        IndexedColorMap cmap = new IndexedColorMap(red, green, blue);
        cmap.setTransform(new LinearTransform(0.0, (double)red.length, datar.start, datar.end));
        return cmap;
    }

    public static ColorMap createColorMap(Range2D datar) {
        int[] red = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 7, 23, 39, 55, 71, 87, 103, 119, 135, 151, 167, 183, 199, 215, 231, 247, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 246, 228, 211, 193, 175, 158, 140};
        int[] green = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 11, 27, 43, 59, 75, 91, 107, 123, 139, 155, 171, 187, 203, 219, 235, 251, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 231, 215, 199, 183, 167, 151, 135, 119, 103, 87, 71, 55, 39, 23, 7, 0, 0, 0, 0, 0, 0, 0};
        int[] blue = new int[]{0, 143, 159, 175, 191, 207, 223, 239, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 255, 247, 231, 215, 199, 183, 167, 151, 135, 119, 103, 87, 71, 55, 39, 23, 7, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        IndexedColorMap cmap = new IndexedColorMap(red, green, blue);
        cmap.setTransform(new LinearTransform(0.0, (double)red.length, datar.start, datar.end));
        return cmap;
    }

    public static Range2D normalizeLandRange(Range2D zr) {
        double[] ranges;
        for (double r : ranges = new double[]{50.0, 100.0, 500.0, 1000.0, 2500.0, 5000.0, 10000.0}) {
            if (!(zr.end <= r)) continue;
            return new Range2D(0.0, r, r / 10.0);
        }
        return new Range2D(0.0, 10000.0, 1000.0);
    }

    public static Range2D normalizeBathymetryRange(Range2D zr) {
        double[] ranges;
        for (double r : ranges = new double[]{-50.0, -100.0, -500.0, -1000.0, -2500.0, -5000.0, -10000.0}) {
            if (!(zr.start >= r)) continue;
            return new Range2D(r, 0.0, Math.abs(r) / 10.0);
        }
        return new Range2D(-10000.0, 0.0, 1000.0);
    }

    public static ContourLevels getBathymetryContourLevels(Range2D zr) {
        Range2D cr = ColorMaps.normalizeBathymetryRange(zr);
        ContourLevels cl = ContourLevels.getDefault(cr);
        ArrayList<Double> addLevels = ColorMaps.getAdditionalLevels(cr.delta);
        for (double l : addLevels) {
            cl.addLevel(-1.0 * l);
        }
        return cl;
    }

    public static ContourLevels getLandContourLevels(Range2D zr) {
        Range2D cr = ColorMaps.normalizeLandRange(zr);
        ContourLevels cl = ContourLevels.getDefault(cr);
        ArrayList<Double> addLevels = ColorMaps.getAdditionalLevels(cr.delta);
        for (double l : addLevels) {
            cl.addLevel(l);
        }
        return cl;
    }

    public static ArrayList<Double> getAdditionalLevels(double delta) {
        ArrayList<Double> addLevels = new ArrayList<Double>();
        switch ((int)delta) {
            case 10: {
                addLevels.add(1.0);
                addLevels.add(2.0);
                break;
            }
            case 50: {
                addLevels.add(5.0);
                break;
            }
            case 100: {
                addLevels.add(10.0);
                addLevels.add(5.0);
                break;
            }
            case 250: {
                addLevels.add(50.0);
                addLevels.add(25.0);
                addLevels.add(10.0);
                break;
            }
            case 500: {
                addLevels.add(125.0);
                addLevels.add(50.0);
                addLevels.add(25.0);
                break;
            }
            case 1000: {
                addLevels.add(100.0);
                addLevels.add(50.0);
                addLevels.add(25.0);
                break;
            }
            case 2000: {
                addLevels.add(500.0);
                addLevels.add(100.0);
                addLevels.add(50.0);
            }
        }
        return addLevels;
    }
}

