/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.tsunami.cmi.CMIUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;

public class ComMITBackEnd {
    public static final int PORT = 4414;
    private ServerSocket serverSocket = null;
    private Socket clientSocket = null;
    private CBEListenerThread CBElistener = null;
    private CBEResponseThread CBEresponse = null;

    public ComMITBackEnd() {
        InetAddress addr;
        boolean foundBE = false;
        try {
            addr = InetAddress.getLocalHost();
            this.clientSocket = new Socket(addr, 4414);
            foundBE = true;
            System.out.println("Found existing CBE...");
        }
        catch (UnknownHostException ex) {
            ex.printStackTrace();
        }
        catch (IOException ex) {
            foundBE = false;
            System.out.println("Starting new CBE...");
        }
        if (!foundBE) {
            this.launchCBE();
            try {
                addr = InetAddress.getLocalHost();
                this.clientSocket = new Socket(addr, 4414);
                foundBE = true;
                System.out.println("Connected to CBE...");
            }
            catch (UnknownHostException uhe) {
                uhe.printStackTrace();
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
            }
        }
    }

    private void launchCBE() {
        try {
            this.serverSocket = new ServerSocket(4414);
        }
        catch (IOException e) {
            System.err.println("Could not listen on port: 4414");
            e.printStackTrace();
        }
        this.CBElistener = new CBEListenerThread();
        this.CBElistener.start();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (this.serverSocket == null) {
            this.launchCBE();
        }
    }

    public void killCBE() {
        System.out.println("killing CBE...");
        this.queryClient("die");
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        try {
            System.out.println("closing clientSocket...");
            this.clientSocket.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public String checkMOST() {
        return this.queryClient("chking MOST");
    }

    public boolean MOSTRunning() {
        boolean isRunning = true;
        String response = this.queryClient("running");
        if (response.length() == 0) {
            isRunning = false;
        }
        return isRunning;
    }

    private String queryClient(String query) {
        StringBuffer sb = new StringBuffer();
        try {
            PrintWriter out = new PrintWriter(this.clientSocket.getOutputStream(), true);
            BufferedReader in = new BufferedReader(new InputStreamReader(this.clientSocket.getInputStream()));
            System.out.println("in ComMIT, sent: " + query);
            out.println(query);
            String inputLine = in.readLine();
            if (inputLine != null) {
                System.out.println("in ComMIT, rec'd: " + inputLine);
                sb.append(inputLine);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return sb.toString();
    }

    public static void main(String[] args) {
    }

    public class CBEResponseThread
    extends Thread {
        private Socket socket;
        private boolean terminated;

        public CBEResponseThread(Socket socket) {
            super("CBEResponseThread");
            this.socket = null;
            this.terminated = false;
            this.socket = socket;
        }

        public void setTerminated(boolean term) {
            this.terminated = term;
        }

        @Override
        public void run() {
            try {
                PrintWriter out = new PrintWriter(this.socket.getOutputStream(), true);
                BufferedReader in = new BufferedReader(new InputStreamReader(this.socket.getInputStream()));
                String outputLine = "";
                while (!this.terminated) {
                    String inputLine = in.readLine();
                    if (inputLine == null) continue;
                    System.out.println("in CBEResponseThread, from ComMIT, rec'd: " + inputLine);
                    if (inputLine.equals("chking MOST")) {
                        outputLine = "hello";
                    } else if (inputLine.equals("running")) {
                        String name = CMIUtil.currentSiteInfo.getName();
                        if (name != null) {
                            outputLine = name;
                        }
                    } else if (inputLine.equals("die")) {
                        ComMITBackEnd.this.CBElistener.setListening(false);
                        this.terminated = true;
                        outputLine = "dying...";
                    }
                    System.out.println("in CBEResponseThread, from CBE, sent: " + outputLine);
                    out.println(outputLine);
                }
                System.out.println("CBEResponseThread: terminated");
                out.close();
                in.close();
                this.socket.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public class CBEListenerThread
    extends Thread {
        private boolean listening = true;

        public void setListening(boolean l) {
            this.listening = l;
        }

        @Override
        public void run() {
            while (this.listening) {
                try {
                    ComMITBackEnd.this.CBEresponse = new CBEResponseThread(ComMITBackEnd.this.serverSocket.accept());
                    ComMITBackEnd.this.CBEresponse.start();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
            System.out.println("CBEListenerThread: not listening");
            try {
                ComMITBackEnd.this.serverSocket.close();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
    }
}

