/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.tsunami.cmi.CMIUtil;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;

public final class ComMITServerSelector
extends JDialog {
    private String selectedServerAddress;
    private String altServerAddr = "";
    private boolean workOffline = false;
    private static String defaultMessage = null;
    public static final String PRIMARY_COMMIT_SERVER = "https://sift.pmel.noaa.gov/ComMIT";
    public static final String DEFAULT_TRAINING_SERVER = "http://192.168.1.10:8080/ComMIT";
    public static final String COMMIT_SERVER_SOURCE_FLAG = "(default server)";
    private JRadioButton alternateServerRadioButton;
    private JButton cancelButton;
    private JCheckBox offlineCheckBox;
    private JButton okButton;
    private JRadioButton primaryServerRadioButton;
    private ButtonGroup serverButtonGroup;
    private JLabel textLabel;
    private JRadioButton trainingServerRadioButton;
    private JTextField urlTextField;

    public ComMITServerSelector(Dialog parent, String currentServer, boolean workOffline) {
        super(parent, true);
        this.doInit(currentServer, workOffline);
    }

    public ComMITServerSelector(Frame parent, String currentServer, boolean workOffline) {
        super(parent, true);
        this.doInit(currentServer, workOffline);
    }

    private void doInit(String currentServer, boolean workOffline) {
        this.selectedServerAddress = currentServer;
        if (this.selectedServerAddress == null) {
            this.selectedServerAddress = PRIMARY_COMMIT_SERVER;
        }
        this.workOffline = workOffline;
        this.initComponents();
        CMIUtil.installEscapeCloseOperation(this);
    }

    public String getSelectedServerAddress() {
        return this.selectedServerAddress;
    }

    public boolean getWorkOffline() {
        return this.workOffline;
    }

    public void setErrorMode(boolean err) {
        if (err) {
            if (defaultMessage == null) {
                defaultMessage = this.textLabel.getText();
            }
            this.textLabel.setText("<html>Could not connect to the current ComMIT server.<p>" + defaultMessage);
        } else if (defaultMessage != null) {
            this.textLabel.setText(defaultMessage);
        }
    }

    private void initComponents() {
        this.serverButtonGroup = new ButtonGroup();
        this.textLabel = new JLabel();
        this.primaryServerRadioButton = new JRadioButton();
        this.trainingServerRadioButton = new JRadioButton();
        this.alternateServerRadioButton = new JRadioButton();
        JLabel jLabel1 = new JLabel();
        this.urlTextField = new JTextField();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.offlineCheckBox = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("ComMIT Server Selection");
        this.setModal(true);
        this.setResizable(false);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent evt) {
                ComMITServerSelector.this.formComponentShown(evt);
            }
        });
        this.textLabel.setText("Please select a server:");
        this.serverButtonGroup.add(this.primaryServerRadioButton);
        this.primaryServerRadioButton.setText("Primary ComMIT server");
        this.primaryServerRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ComMITServerSelector.this.primaryServerRadioButtonActionPerformed(evt);
            }
        });
        this.serverButtonGroup.add(this.trainingServerRadioButton);
        this.trainingServerRadioButton.setText("Local training server");
        this.trainingServerRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ComMITServerSelector.this.trainingServerRadioButtonActionPerformed(evt);
            }
        });
        this.serverButtonGroup.add(this.alternateServerRadioButton);
        this.alternateServerRadioButton.setText("Alternate server:");
        this.alternateServerRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ComMITServerSelector.this.alternateServerRadioButtonActionPerformed(evt);
            }
        });
        jLabel1.setText("URL:");
        this.urlTextField.setEnabled(false);
        this.urlTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                ComMITServerSelector.this.urlTextFieldFocusLost(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ComMITServerSelector.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ComMITServerSelector.this.cancelButtonActionPerformed(evt);
            }
        });
        this.offlineCheckBox.setText("Work Offline");
        this.offlineCheckBox.setSelected(this.workOffline);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(this.primaryServerRadioButton).add(this.trainingServerRadioButton).add(this.alternateServerRadioButton).add(layout.createSequentialGroup().add(jLabel1).addPreferredGap(0).add(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().add(this.offlineCheckBox).addPreferredGap(0, 48, Short.MAX_VALUE).add(this.okButton).addPreferredGap(1).add(this.cancelButton)).add(this.urlTextField, -1, 292, Short.MAX_VALUE))).add(this.textLabel, -1, 331, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().addContainerGap().add(this.textLabel, -1, -1, Short.MAX_VALUE).add(12, 12, 12).add(this.primaryServerRadioButton).addPreferredGap(0).add(this.trainingServerRadioButton).addPreferredGap(0).add(this.alternateServerRadioButton).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.urlTextField, -2, -1, -2).add(jLabel1)).addPreferredGap(1).add(layout.createParallelGroup(3).add(this.offlineCheckBox).add(this.okButton).add(this.cancelButton)).addContainerGap()));
        this.pack();
    }

    private void trainingServerRadioButtonActionPerformed(ActionEvent evt) {
        this.urlTextField.setText(DEFAULT_TRAINING_SERVER);
        this.urlTextField.setEnabled(false);
    }

    private void primaryServerRadioButtonActionPerformed(ActionEvent evt) {
        this.urlTextField.setText(PRIMARY_COMMIT_SERVER);
        this.urlTextField.setEnabled(false);
    }

    private void formComponentShown(ComponentEvent evt) {
        this.urlTextField.setText(this.selectedServerAddress);
        if (this.selectedServerAddress.equals(PRIMARY_COMMIT_SERVER)) {
            this.primaryServerRadioButton.doClick();
        } else if (this.selectedServerAddress.equals(DEFAULT_TRAINING_SERVER)) {
            this.trainingServerRadioButton.doClick();
        } else {
            this.altServerAddr = this.selectedServerAddress;
            this.alternateServerRadioButton.doClick();
        }
        this.pack();
    }

    private void urlTextFieldFocusLost(FocusEvent evt) {
        if (this.alternateServerRadioButton.isSelected()) {
            this.altServerAddr = this.urlTextField.getText();
        }
    }

    private void alternateServerRadioButtonActionPerformed(ActionEvent evt) {
        this.urlTextField.setText(this.altServerAddr);
        this.urlTextField.setEnabled(true);
        this.urlTextField.requestFocusInWindow();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.selectedServerAddress = null;
        this.dispose();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.selectedServerAddress = this.urlTextField.getText();
        this.workOffline = this.offlineCheckBox.isSelected();
        this.dispose();
    }
}

