/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.tsunami.cmi.BathyGrid;
import gov.noaa.tsunami.cmi.CMIUtil;
import gov.noaa.tsunami.cmi.MOSTMaxGrid;
import gov.noaa.tsunami.cmi.SiftShare;
import gov.noaa.tsunami.cmi.SiteInfo;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileNameExtensionFilter;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFileWriteable;
import ucar.nc2.dt.grid.GeoGrid;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.geotiff.GeoTiffCWM;

public class CompositeMaxDialog
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private int returnStatus = 0;
    private ArrayList<SiteInfo> modelRuns = new ArrayList();
    private ArrayList<String> sourceList = new ArrayList();
    private DefaultListModel listModel = new DefaultListModel();
    private JList list = new JList(this.listModel);
    private ButtonGroup buttonGroup1;
    private JButton cancelButton;
    private JRadioButton flowDepthButton;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JRadioButton maxAmpButton;
    private JButton okButton;

    public CompositeMaxDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.list.setSelectionMode(2);
        this.list.setSelectedIndex(0);
        this.list.setVisibleRowCount(10);
        this.list.setCellRenderer(new MyListCellRenderer());
        this.initComponents();
        CMIUtil.installEscapeCloseOperation(this);
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.cancelButton = new JButton();
        this.okButton = new JButton();
        this.jPanel1 = new JPanel();
        this.jScrollPane1 = new JScrollPane(this.list);
        this.jLabel1 = new JLabel();
        this.flowDepthButton = new JRadioButton();
        this.maxAmpButton = new JRadioButton();
        this.setTitle("Create Composite Maximum Wave Amp File");
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CompositeMaxDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CompositeMaxDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jLabel1.setText("Select Model Runs to create composite file from:");
        this.buttonGroup1.add(this.flowDepthButton);
        this.flowDepthButton.setSelected(true);
        this.flowDepthButton.setText("Maximum Flow Depth (default)");
        this.buttonGroup1.add(this.maxAmpButton);
        this.maxAmpButton.setText("Maximum Wave Amplitude");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jLabel1).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.flowDepthButton).addComponent(this.maxAmpButton)).addGap(0, 0, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.flowDepthButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.maxAmpButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 350, Short.MAX_VALUE).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 748, Short.MAX_VALUE).addComponent(this.okButton).addGap(18, 18, 18).addComponent(this.cancelButton)).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton).addComponent(this.okButton)).addContainerGap()));
        this.pack();
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doCancel();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.createComposite();
    }

    public void addModelRuns(ArrayList<SiteInfo> mRuns) {
        this.modelRuns.clear();
        this.listModel.clear();
        this.sourceList.clear();
        SiftShare.log.info("\n\nStarting Create Composite dialog\n\n");
        for (SiteInfo si : mRuns) {
            for (String s : si.getSourceNames()) {
                SiftShare.log.info("model: " + si.getName() + " source: " + s);
                this.modelRuns.add(si);
                this.sourceList.add(s);
                this.listModel.addElement(String.format("%-20s : %-70s : %s : %s", si.getName(), si.getDirName(), s, si.getSourceAndSlip(s)));
            }
        }
    }

    private double[] getMaxOrFlowDepth(SiteInfo site, MOSTMaxGrid sg) {
        double[] grid = sg.getZArray();
        if (this.maxAmpButton.isSelected()) {
            return grid;
        }
        BathyGrid cgrid = null;
        try {
            cgrid = site.getBathyGrid(3);
            double[] bath = cgrid.getZArray();
            File defFile = new File(site.getDirName(), "deformc.dat");
            double[] defbath = new double[bath.length];
            if (defFile.exists()) {
                try {
                    BathyGrid defBathyGrid = new BathyGrid(defFile, true);
                    defbath = defBathyGrid.getZArray();
                }
                catch (IOException ex) {
                    SiftShare.log.log(Level.WARNING, "Error reading deform.dat bathy file to calc flow depth, using bathy grid", ex);
                    for (int i = 0; i < bath.length; ++i) {
                        defbath[i] = bath[i];
                    }
                }
            } else {
                SiftShare.log.fine("No deformc.dat file found");
                for (int i = 0; i < bath.length; ++i) {
                    defbath[i] = bath[i];
                }
            }
            if (grid.length == defbath.length && defbath.length == bath.length) {
                int nLon = sg.getXSize();
                int nLat = sg.getYSize();
                if (sg.isImage()) {
                    for (int j = 0; j < nLon; ++j) {
                        for (int i = 0; i < nLat; ++i) {
                            if (!Double.isNaN(grid[j * nLat + i])) {
                                grid[j * nLat + i] = grid[j * nLat + i] - 100.0 * defbath[j * nLat + (nLat - i - 1)];
                            }
                            if (!(bath[j * nLat + (nLat - i - 1)] < 0.0)) continue;
                            grid[j * nLat + i] = Double.NaN;
                        }
                    }
                } else {
                    for (int j = 0; j < nLon; ++j) {
                        for (int i = 0; i < nLat; ++i) {
                            if (!Double.isNaN(grid[j * nLat + i])) {
                                grid[j * nLat + i] = grid[j * nLat + i] - 100.0 * defbath[j * nLat + i];
                            }
                            if (!(bath[j * nLat + i] < 0.0)) continue;
                            grid[j * nLat + i] = Double.NaN;
                        }
                    }
                }
            }
        }
        catch (IOException ioe) {
            SiftShare.log.log(Level.SEVERE, "can't read C-grid", ioe);
            JOptionPane.showMessageDialog(this, "Can't read bathymetry for model run : " + site, "Error", 0);
            return grid;
        }
        return grid;
    }

    public String getSuggestedFilename() {
        ArrayList<SiteInfo> sites = new ArrayList<SiteInfo>();
        int[] indx = this.list.getSelectedIndices();
        for (int i = 0; i < indx.length; ++i) {
            sites.add(this.modelRuns.get(indx[i]));
        }
        String fn = ((SiteInfo)sites.get(0)).getName();
        for (int i = 1; i < sites.size(); ++i) {
            fn = CompositeMaxDialog.longestCommonSubstring(fn, ((SiteInfo)sites.get(i)).getName());
        }
        return fn;
    }

    private static String longestCommonSubstring(String string1, String string2) {
        int sindx = 0;
        int eindx = 0;
        for (int i = 0; i < string1.length(); ++i) {
            for (int j = 0; j < string2.length(); ++j) {
                int x = 0;
                while (string1.charAt(i + x) == string2.charAt(j + x) && i + ++x < string1.length() && j + x < string2.length()) {
                }
                if (x <= eindx) continue;
                eindx = x;
                sindx = i;
            }
        }
        return string1.substring(sindx, sindx + eindx);
    }

    private void createComposite() {
        int[] selected = this.list.getSelectedIndices();
        if (selected.length == 0) {
            return;
        }
        MOSTMaxGrid maxGrid = new MOSTMaxGrid();
        MOSTMaxGrid compGrid = new MOSTMaxGrid();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < selected.length; ++i) {
            sb.append(this.modelRuns.get(selected[i]));
            sb.append(" : ");
            sb.append(this.sourceList.get(selected[i]));
            sb.append("\n");
        }
        SiftShare.log.info("Creating composite from these sites/sources: \n" + sb.toString());
        SiteInfo firstSI = this.modelRuns.get(selected[0]);
        File siftOutputFile = new File(firstSI.getSiteDirectory(), firstSI.getName() + "_" + this.sourceList.get(selected[0]) + "_sift.nc");
        compGrid.readData(siftOutputFile.getPath(), "max_amp_c");
        double[] compArray = this.getMaxOrFlowDepth(firstSI, compGrid);
        int compLength = compArray.length;
        for (int i = 1; i < selected.length; ++i) {
            SiteInfo si = this.modelRuns.get(selected[i]);
            String source = this.sourceList.get(selected[i]);
            siftOutputFile = new File(si.getSiteDirectory(), si.getName() + "_" + this.sourceList.get(selected[i]) + "_sift.nc");
            maxGrid.readData(siftOutputFile.getPath(), "max_amp_c");
            if (!maxGrid.getXRange().equals(compGrid.getXRange()) || !maxGrid.getYRange().equals(compGrid.getYRange())) {
                SiftShare.log.warning("Grid extents for " + firstSI + " and " + si + " are different");
                JOptionPane.showMessageDialog(this, "Model Run: " + si + " not on same grid as Model Run: " + firstSI + "\nPlease Select Model Runs on the same grid for a Composite Maximum.", "Error: different grids used", 0);
                return;
            }
            double[] maxArray = this.getMaxOrFlowDepth(si, maxGrid);
            if (maxArray.length != compLength) {
                SiftShare.log.warning("Array sizes for max_amp_c for " + firstSI + " and " + si + " are different.");
                JOptionPane.showMessageDialog(this, "Model Run: " + si + " not on same grid as Model Run: " + firstSI + "\nPlease Select Model Runs on the same grid for a Composite Maximum.", "Error: different grids used", 0);
                return;
            }
            for (int k = 0; k < compLength; ++k) {
                if (Double.isNaN(maxArray[k])) continue;
                compArray[k] = Double.isNaN(compArray[k]) ? maxArray[k] : (maxArray[k] > compArray[k] ? maxArray[k] : compArray[k]);
            }
        }
        JFileChooser chooser = new JFileChooser(CMIUtil.workingDirName);
        chooser.setDialogTitle("Save as Composite as GeoTIFF Raster (.tif)");
        chooser.setFileFilter(new FileNameExtensionFilter("GIS GeoTiff files", ".tif"));
        String filename = this.getSuggestedFilename();
        filename = this.flowDepthButton.isSelected() ? filename + "_composite_flowdepth.tif" : filename + "_composite_maxamp.tif";
        File f = new File(CMIUtil.workingDirName, filename);
        chooser.setSelectedFile(f);
        int result = chooser.showSaveDialog(this);
        if (result == 0) {
            int overwrite;
            if (chooser.getSelectedFile().exists() && (overwrite = JOptionPane.showConfirmDialog(this, "File exists, overwrite?", "File exists", 1)) != 0) {
                return;
            }
            String varName = "";
            String longName = "";
            if (this.flowDepthButton.isSelected()) {
                varName = "flow_depth";
                longName = "Flow Depth";
            } else {
                varName = "max_amp_c";
                longName = "Maximum Wave Amplitude";
            }
            try {
                int i;
                filename = chooser.getSelectedFile().getPath();
                String fn = filename.replaceAll(".tif", ".nc");
                NetcdfFileWriteable ncout = NetcdfFileWriteable.createNew(fn);
                Dimension londim = ncout.addDimension("lon", compGrid.getXSize());
                Dimension latdim = ncout.addDimension("lat", compGrid.getYSize());
                ncout.addVariable("lon", DataType.DOUBLE, new Dimension[]{londim});
                ncout.addVariableAttribute("lon", "long_name", "longitude");
                ncout.addVariableAttribute("lon", "units", "degrees_east");
                ncout.addVariable("lat", DataType.DOUBLE, new Dimension[]{latdim});
                ncout.addVariableAttribute("lat", "long_name", "latitude");
                ncout.addVariableAttribute("lat", "units", "degrees_north");
                ncout.addVariable(varName, DataType.DOUBLE, new Dimension[]{latdim, londim});
                ncout.addVariableAttribute(varName, "long_name", longName);
                ncout.addVariableAttribute(varName, "units", "CENTIMETERS");
                ncout.addVariableAttribute(varName, "missing_value", Double.NaN);
                ncout.addVariableAttribute(varName, "_FillValue", Double.NaN);
                ncout.addVariableAttribute(varName, "grid_mapping", "crs");
                ncout.addVariable("crs", DataType.INT, new Dimension[0]);
                ncout.addVariableAttribute("crs", "grid_mapping_name", "latitude_longitude");
                ncout.addVariableAttribute("crs", "longitude_of_prime_meridian", 0.0);
                ncout.addVariableAttribute("crs", "semi_major_axis", 6378137.0);
                ncout.addVariableAttribute("crs", "inverse_flattening", 298.257223563);
                ncout.addVariableAttribute("crs", "crs_wkt", "GEOGCS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]]");
                ncout.addVariableAttribute("crs", "spatial_ref", "GEOGCS[\"WGS 84\",DATUM[\"WGS_1984\",SPHEROID[\"WGS 84\",6378137,298.257223563,AUTHORITY[\"EPSG\",\"7030\"]],AUTHORITY[\"EPSG\",\"6326\"]],PRIMEM[\"Greenwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORITY[\"EPSG\",\"4326\"]]");
                ncout.addGlobalAttribute("title", "MOST composite maximum file");
                ncout.create();
                double[] nxloc = compGrid.getXArray();
                boolean decLon = false;
                for (i = 0; i < nxloc.length; ++i) {
                    if (!(nxloc[i] > 180.0)) continue;
                    decLon = true;
                    break;
                }
                if (decLon) {
                    i = 0;
                    while (i < nxloc.length) {
                        int n = i++;
                        nxloc[n] = nxloc[n] - 360.0;
                    }
                }
                try {
                    ncout.write("lon", Array.factory(nxloc));
                    ncout.write("lat", Array.factory(compGrid.getYArray()));
                    ArrayDouble.D2 add2 = new ArrayDouble.D2(compGrid.getYSize(), compGrid.getXSize());
                    for (int i2 = 0; i2 < compGrid.getXSize(); ++i2) {
                        for (int j = 0; j < compGrid.getYSize(); ++j) {
                            if (Double.isNaN(compArray[i2 * compGrid.getYSize() + j])) {
                                add2.set(j, i2, Double.NaN);
                                continue;
                            }
                            add2.set(j, i2, compArray[i2 * compGrid.getYSize() + j]);
                        }
                    }
                    ncout.write(varName, add2);
                    ncout.flush();
                    ncout.close();
                }
                catch (InvalidRangeException ire) {
                    throw new IOException(ire);
                }
                GridDataset gridDs = GridDataset.open(fn);
                GeoGrid g = gridDs.findGridByName(varName);
                GeoTiffCWM gtw = new GeoTiffCWM(filename);
                SiftShare.log.info("Saving composite GeoTIFF... grid: " + g.getInfo() + " to file: " + filename);
                try {
                    gtw.writeGrid(gridDs, g, g.readYXData(0, 0), false);
                }
                catch (IllegalArgumentException iae) {
                    throw new IOException(iae);
                }
                gtw.close();
                gridDs.close();
            }
            catch (IOException ex) {
                JOptionPane.showConfirmDialog(this, "Error creating file.\nNon-constant grid spacing not supported.", "Error creating GIS file", 2, 0);
                SiftShare.log.log(Level.SEVERE, null, ex);
            }
            this.returnStatus = 1;
            this.setVisible(false);
        }
    }

    private void doCancel() {
        this.returnStatus = 0;
        this.setVisible(false);
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(CompositeMaxDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(CompositeMaxDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(CompositeMaxDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(CompositeMaxDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                CompositeMaxDialog dialog = new CompositeMaxDialog((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    class MyListCellRenderer
    extends DefaultListCellRenderer {
        JLabel label;
        Font font = new Font("Courier", 0, 14);

        MyListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            this.label = (JLabel)super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            this.label.setFont(this.font);
            return this.label;
        }
    }
}

