/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.tsunami.cmi.CMIUtil;
import gov.noaa.tsunami.cmi.SiftShare;
import gov.noaa.tsunami.cmi.SiteInfo;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;

public class CopySiteDialog
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private int returnStatus = 0;
    private final ArrayList<SiteInfo> openSites;
    private SiteInfo siteCreated;
    private ArrayList<String> siteNames;
    private JButton cancelButton;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JComboBox modelRunComboBox;
    private JTextField newNameTextField;
    private JButton okButton;

    public CopySiteDialog(Frame parent, ArrayList<SiteInfo> sites) {
        super(parent, true);
        this.initComponents();
        this.setLocationRelativeTo(parent);
        this.openSites = sites;
        this.siteNames = new ArrayList();
        for (SiteInfo si : this.openSites) {
            this.siteNames.add(si.getName());
        }
        DefaultComboBoxModel<SiteInfo> cbm = new DefaultComboBoxModel<SiteInfo>();
        for (SiteInfo s : this.openSites) {
            cbm.addElement(s);
        }
        this.modelRunComboBox.setModel(cbm);
        CMIUtil.installEscapeCloseOperation(this);
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void initComponents() {
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.modelRunComboBox = new JComboBox();
        this.jLabel1 = new JLabel();
        this.newNameTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                CopySiteDialog.this.closeDialog(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CopySiteDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CopySiteDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.modelRunComboBox.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.modelRunComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                CopySiteDialog.this.modelRunComboBoxActionPerformed(evt);
            }
        });
        this.jLabel1.setFont(new Font("Dialog", 0, 14));
        this.jLabel1.setText("Choose Model Run to Copy:");
        this.newNameTextField.setText("jTextField1");
        this.jLabel2.setFont(new Font("Dialog", 0, 14));
        this.jLabel2.setText("Choose new Model Run name:");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(jPanel1Layout.createParallelGroup(1).add(2, this.modelRunComboBox, 0, 366, Short.MAX_VALUE).add(2, this.jLabel1, -1, 366, Short.MAX_VALUE).add(this.newNameTextField, -1, 366, Short.MAX_VALUE).add(this.jLabel2)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(this.jLabel1).addPreferredGap(0).add(this.modelRunComboBox, -2, -1, -2).addPreferredGap(0, 26, Short.MAX_VALUE).add(this.jLabel2).addPreferredGap(0).add(this.newNameTextField, -2, -1, -2).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(2).add(1, this.jPanel1, -1, -1, Short.MAX_VALUE).add(layout.createSequentialGroup().add(this.okButton, -2, 67, -2).addPreferredGap(0).add(this.cancelButton))).addContainerGap()));
        layout.linkSize(new Component[]{this.cancelButton, this.okButton}, 1);
        layout.setVerticalGroup(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().addContainerGap().add(this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(0).add(layout.createParallelGroup(3).add(this.cancelButton).add(this.okButton)).addContainerGap()));
        this.pack();
    }

    private void modelRunComboBoxActionPerformed(ActionEvent evt) {
        SiteInfo si = (SiteInfo)this.modelRunComboBox.getSelectedItem();
        if (si != null) {
            String basename = si.getName();
            int idx = basename.indexOf("_ver");
            if (idx > 1) {
                basename = basename.substring(0, basename.indexOf("_ver"));
            }
            String newSiteName = new String(basename);
            int count = 0;
            while (this.siteNames.contains(newSiteName)) {
                newSiteName = String.format("%s_ver%d", basename, ++count);
            }
            this.newNameTextField.setText(newSiteName);
        }
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        SiteInfo si = (SiteInfo)this.modelRunComboBox.getSelectedItem();
        String newsite = this.newNameTextField.getText();
        String string = newsite = newsite == null ? "" : newsite.trim();
        if (newsite.length() == 0) {
            JOptionPane.showMessageDialog(this, "Please enter a new site name.");
            return;
        }
        SiftShare.log.info("copying site: " + si.getSiteDirectory() + " to new site: " + newsite);
        this.setCursor(new Cursor(3));
        try {
            this.siteCreated = SiteInfo.copySite(si, new File(CMIUtil.workingDirName), newsite);
        }
        catch (IOException ex) {
            this.setCursor(new Cursor(0));
            JOptionPane.showMessageDialog(this, ex.getMessage(), "Error Copying " + si.getName(), 0);
            return;
        }
        this.returnStatus = 1;
        this.setCursor(new Cursor(0));
        this.setVisible(false);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doCancel();
    }

    private void closeDialog(WindowEvent evt) {
        this.doCancel();
    }

    public void setSelectedSite(SiteInfo currentSite) {
        this.modelRunComboBox.setSelectedItem(currentSite);
    }

    private void doCancel() {
        this.returnStatus = 0;
        this.setVisible(false);
    }

    public SiteInfo getNewSite() {
        return this.siteCreated;
    }
}

