/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.tsunami.cmi.EnumeratedColorMap;
import java.awt.Color;

public class CurrentsColormap
extends EnumeratedColorMap {
    private int[] band1 = new int[]{Color.HSBtoRGB(0.5833333f, 1.0f, 0.5f), Color.HSBtoRGB(0.33333334f, 1.0f, 1.0f)};
    private int[] band2 = new int[]{Color.HSBtoRGB(0.16666667f, 1.0f, 1.0f), Color.HSBtoRGB(0.083333336f, 1.0f, 1.0f)};
    private int[] band3 = new int[]{Color.HSBtoRGB(0.0f, 0.25f, 1.0f), Color.HSBtoRGB(0.0f, 1.0f, 1.0f)};
    private int[] band4 = new int[]{Color.HSBtoRGB(0.8333333f, 1.0f, 1.0f), Color.HSBtoRGB(0.8333333f, 0.85f, 0.4f)};
    private int[] band5 = new int[]{Color.HSBtoRGB(0.8333333f, 0.85f, 0.4f)};
    private double sub3 = 3.0;
    private double sub6 = 6.0;
    private double sub9 = 9.0;
    private double super12 = 12.0;
    private double[] mVals = new double[]{0.0, 3.0, 6.0, 9.0, 12.0};
    private Color[] cols = new Color[]{new Color(this.band1[0]), new Color(this.band2[0]), new Color(this.band3[0]), new Color(this.band4[0]), new Color(this.band5[0]), new Color(this.band1[1]), new Color(this.band2[1]), new Color(this.band3[1]), new Color(this.band4[1])};

    public CurrentsColormap(int[] red, int[] green, int[] blue) {
        super(red, green, blue);
        int i = 1;
        while (Double.compare(this.sub3, 3.0) == 0) {
            this.sub3 = 3.0 - Double.longBitsToDouble(0x10000000000000L * (long)i);
            ++i;
        }
        i = 1;
        while (Double.compare(this.sub6, 6.0) == 0) {
            this.sub6 = 6.0 - Double.longBitsToDouble(0x10000000000000L * (long)i);
            ++i;
        }
        i = 1;
        while (Double.compare(this.sub9, 9.0) == 0) {
            this.sub9 = 9.0 - Double.longBitsToDouble(0x10000000000000L * (long)i);
            ++i;
        }
        i = 1;
        while (Double.compare(this.super12, 12.0) == 0) {
            this.super12 = 12.0 + Double.longBitsToDouble(0x10000000000000L * (long)i);
            ++i;
        }
    }

    @Override
    public Color getColor(double val) {
        int c = this.band5[0];
        float frac = 0.0f;
        if (val <= 0.0) {
            return Color.WHITE;
        }
        if (val > 0.0 && val < this.sub3) {
            frac = (float)(val / this.sub3);
            c = CurrentsColormap.interpolateColors(this.band1[0], this.band1[1], frac);
        }
        if (val >= 3.0 && val < this.sub6) {
            frac = (float)((val - 3.0) / (this.sub6 - 3.0));
            c = CurrentsColormap.interpolateColors(this.band2[0], this.band2[1], frac);
        }
        if (val >= 6.0 && val < this.sub9) {
            frac = (float)((val - 6.0) / (this.sub9 - 6.0));
            c = CurrentsColormap.interpolateColors(this.band3[0], this.band3[1], frac);
        }
        if (val >= 9.0 && val < this.super12) {
            frac = (float)((val - 9.0) / (this.super12 - 9.0));
            c = CurrentsColormap.interpolateColors(this.band4[0], this.band4[1], frac);
        }
        return new Color(c);
    }

    public static int interpolateColors(int c1, int c2, float frac) {
        return (Math.max(0, Math.min(255, Math.round((float)(c1 >>> 24 & 0xFF) * (1.0f - frac) + (float)(c2 >>> 24 & 0xFF) * frac))) & 0xFF) << 24 | (Math.max(0, Math.min(255, Math.round((float)(c1 >>> 16 & 0xFF) * (1.0f - frac) + (float)(c2 >>> 16 & 0xFF) * frac))) & 0xFF) << 16 | (Math.max(0, Math.min(255, Math.round((float)(c1 >>> 8 & 0xFF) * (1.0f - frac) + (float)(c2 >>> 8 & 0xFF) * frac))) & 0xFF) << 8 | Math.max(0, Math.min(255, Math.round((float)(c1 & 0xFF) * (1.0f - frac) + (float)(c2 & 0xFF) * frac))) & 0xFF;
    }

    @Override
    public Color getColor(int i) {
        return this.cols[i];
    }

    @Override
    public int getNumLevels() {
        return this.mVals.length;
    }

    @Override
    public double getBaseLevel() {
        return this.mVals[0];
    }

    @Override
    public double getEndLevel() {
        return this.mVals[this.mVals.length - 1];
    }

    @Override
    public double getDoubleValue(int i) {
        return this.mVals[i];
    }

    @Override
    public double[] getValues() {
        return this.mVals;
    }
}

