/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.tsunami.cmi.CMIUtil;
import gov.noaa.tsunami.cmi.ModelRunComboBoxRenderer;
import gov.noaa.tsunami.cmi.SiftShare;
import gov.noaa.tsunami.cmi.SiteInfo;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import org.jdesktop.layout.GroupLayout;

public class DeleteSiteDialog
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private int returnStatus = 0;
    private final ArrayList<SiteInfo> openSites;
    private SiteInfo deletedSite;
    private JButton cancelButton;
    private JComboBox modelRunComboBox;
    private JButton okButton;

    public DeleteSiteDialog(Frame parent, ArrayList<SiteInfo> sites) {
        super(parent, true);
        this.initComponents();
        this.setLocationRelativeTo(parent);
        this.openSites = sites;
        DefaultComboBoxModel<SiteInfo> cbm = new DefaultComboBoxModel<SiteInfo>();
        for (SiteInfo s : this.openSites) {
            cbm.addElement(s);
        }
        this.modelRunComboBox.setModel(cbm);
        CMIUtil.installEscapeCloseOperation(this);
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void initComponents() {
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.modelRunComboBox = new JComboBox();
        JLabel jLabel1 = new JLabel();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent evt) {
                DeleteSiteDialog.this.closeDialog(evt);
            }
        });
        this.okButton.setText("OK");
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DeleteSiteDialog.this.okButtonActionPerformed(evt);
            }
        });
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DeleteSiteDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.modelRunComboBox.setRenderer(new ModelRunComboBoxRenderer());
        jLabel1.setFont(new Font("Dialog", 0, 14));
        jLabel1.setText("Choose Model Run to delete:");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(layout.createSequentialGroup().add(jLabel1, -1, 232, Short.MAX_VALUE).add(64, 64, 64)).add(layout.createSequentialGroup().add(21, 21, 21).add(layout.createParallelGroup(2).add(layout.createSequentialGroup().add(this.okButton, -2, 67, -2).addPreferredGap(1).add(this.cancelButton)).add(this.modelRunComboBox, -2, 258, -2)).addContainerGap()))));
        layout.linkSize(new Component[]{this.cancelButton, this.okButton}, 1);
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(jLabel1).addPreferredGap(1).add(this.modelRunComboBox, -2, -1, -2).addPreferredGap(1).add(layout.createParallelGroup(3).add(this.cancelButton).add(this.okButton)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void okButtonActionPerformed(ActionEvent evt) {
        this.doClose(1);
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doClose(0);
    }

    private void closeDialog(WindowEvent evt) {
        this.doClose(0);
    }

    void setSelectedSite(SiteInfo currentSite) {
        this.modelRunComboBox.setSelectedItem(currentSite);
    }

    private void doClose(int retStatus) {
        SiftShare siftShare;
        this.returnStatus = retStatus;
        SiftShare siftShare2 = siftShare = this.getParent() instanceof SiftShare ? (SiftShare)this.getParent() : null;
        if (this.returnStatus == 1) {
            SiteInfo si = (SiteInfo)this.modelRunComboBox.getSelectedItem();
            int result = JOptionPane.showConfirmDialog(this, String.format("This action will delete the %s Model Run, including\nall files in the subdirectory: \n%s\nThis action cannot be undone.", si.getName(), si.getSiteDirectory().getPath()), "Delete model run", 2);
            if (result == 0 && (siftShare == null || siftShare.closeSite(si, true))) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                if (!DeleteSiteDialog.deleteDir(new File(si.getDirName()))) {
                    JOptionPane.showMessageDialog(this, "Could not delete subdirectory " + si.getDirName(), "Error", 0);
                }
                this.setCursor(Cursor.getDefaultCursor());
            }
            this.deletedSite = si;
        }
        this.setVisible(false);
    }

    public static boolean deleteDir(File dir) {
        if (dir.isDirectory()) {
            String[] children = dir.list();
            for (int i = 0; i < children.length; ++i) {
                boolean success = DeleteSiteDialog.deleteDir(new File(dir, children[i]));
                if (success) continue;
                SiftShare.log.warning("failed to delete file: " + dir.getAbsolutePath() + File.separator + children[i]);
                return false;
            }
        }
        return dir.delete();
    }

    public SiteInfo getDeletedSite() {
        return this.deletedSite;
    }
}

