/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.tsunami.cmi.SiftShare;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.event.EventListenerList;

public class DirectoryMonitor
implements Runnable {
    private Map<String, Long> currentFiles = new HashMap<String, Long>();
    private Map<String, Long> lastFiles = new HashMap<String, Long>();
    private File directory;
    private String directoryPath;
    private EventListenerList listenerList = new EventListenerList();
    public static int serNum = 0;
    public int mySerNum;

    public DirectoryMonitor(File directory, int pollingIntervalSeconds, ActionListener al) throws IllegalArgumentException {
        if (!directory.exists()) {
            throw new IllegalArgumentException("Directory, " + directory.getPath() + " does not exist");
        }
        try {
            this.directoryPath = directory.getCanonicalPath();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Directory, " + directory.getPath() + " can't be read");
        }
        this.directory = directory;
        if (al != null) {
            this.addActionListener(al);
        }
        this.getModifiedTimes();
        this.mySerNum = ++serNum;
    }

    public DirectoryMonitor(File directory) throws IllegalArgumentException {
        this(directory, 10, null);
    }

    @Override
    public void run() {
        this.checkFiles();
    }

    public File getDirectory() {
        return this.directory;
    }

    private void getModifiedTimes() {
        File[] files;
        this.lastFiles.clear();
        this.lastFiles.putAll(this.currentFiles);
        this.currentFiles.clear();
        for (File f : files = this.directory.listFiles()) {
            this.currentFiles.put(f.getName(), f.lastModified());
        }
    }

    private void checkFiles() {
        if (Thread.interrupted()) {
            SiftShare.log.info("Stopping Monitor... my serial number is: " + this.mySerNum);
            return;
        }
        this.getModifiedTimes();
        for (String fileName : this.currentFiles.keySet()) {
            Long prevModified;
            Long lastModified = this.currentFiles.get(fileName);
            if (!this.lastFiles.containsKey(fileName)) {
                this.fireActionPerformed("added," + this.directoryPath + "," + fileName);
                continue;
            }
            if (!this.lastFiles.containsKey(fileName) || (prevModified = this.lastFiles.get(fileName)).compareTo(lastModified) == 0) continue;
            this.fireActionPerformed("changed," + this.directoryPath + "," + fileName);
        }
        for (String fileName : this.lastFiles.keySet()) {
            if (this.currentFiles.containsKey(fileName)) continue;
            this.fireActionPerformed("deleted," + this.directoryPath + "," + fileName);
        }
    }

    public void addActionListener(ActionListener l) {
        this.listenerList.add(ActionListener.class, l);
    }

    public void removeActionListener(ActionListener l) {
        this.listenerList.remove(ActionListener.class, l);
    }

    protected void fireActionPerformed(String command) {
        Object[] listeners = this.listenerList.getListenerList();
        ActionEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != ActionListener.class) continue;
            if (e == null) {
                String actionCommand = command;
                e = new ActionEvent(this, 1001, actionCommand);
            }
            ((ActionListener)listeners[i + 1]).actionPerformed(e);
        }
    }

    public static void main(String[] args) {
        DirectoryMonitor dm = new DirectoryMonitor(new File("/home/onda/cmoore/ComMIT/prop"));
        Thread dmt = new Thread(dm);
        dmt.start();
        try {
            Thread.sleep(240000L);
        }
        catch (InterruptedException ex) {
            ex.printStackTrace();
        }
    }
}

