/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.tsunami.cmi.CMIUtil;
import gov.noaa.tsunami.cmi.SiftShare;
import gov.noaa.tsunami.cmi.macosx.JAnimatingProgressBar;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFormattedTextField;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.NumberFormatter;
import org.jdesktop.layout.GroupLayout;

public class DownloadGridDialog
extends JDialog {
    public static final int RET_CANCEL = 0;
    public static final int RET_OK = 1;
    private int returnStatus = 2;
    File downloadGridFile = null;
    DecimalFormat dfxxxx = new DecimalFormat("0.0000");
    CloseMeWorker closeMeWorker;
    private JButton cancelButton;
    private JButton downloadButton;
    private JFormattedTextField eastFormattedTextField;
    private JTextField fileNameTextField;
    private JLabel jLabel1;
    private JLabel jLabel10;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JLabel jLabel8;
    private JLabel jLabel9;
    private JPanel jPanel1;
    private JFormattedTextField northFormattedTextField;
    private JAnimatingProgressBar progressBar;
    private JFormattedTextField resolutionDegTextField;
    private JFormattedTextField resolutionMinTextField;
    private JFormattedTextField resolutionSecTextField;
    private JFormattedTextField southFormattedTextField;
    private JFormattedTextField westFormattedTextField;

    public DownloadGridDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        CMIUtil.installEscapeCloseOperation(this);
        this.progressBar.setString("Set File Name and Grid Resolution, then Download");
        this.progressBar.setStringPainted(true);
        this.progressBar.setAnimating(false);
        this.fileNameTextField.requestFocusInWindow();
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.westFormattedTextField = new JFormattedTextField();
        this.eastFormattedTextField = new JFormattedTextField();
        this.northFormattedTextField = new JFormattedTextField();
        this.southFormattedTextField = new JFormattedTextField();
        this.resolutionDegTextField = new JFormattedTextField();
        this.jLabel1 = new JLabel();
        this.fileNameTextField = new JTextField();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.resolutionMinTextField = new JFormattedTextField();
        this.resolutionSecTextField = new JFormattedTextField();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel9 = new JLabel();
        this.jLabel10 = new JLabel();
        this.cancelButton = new JButton();
        this.downloadButton = new JButton();
        this.progressBar = new JAnimatingProgressBar();
        this.setTitle("Download Grid from ComMIT Server");
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosed(WindowEvent evt) {
                DownloadGridDialog.this.formWindowClosed(evt);
            }
        });
        this.westFormattedTextField.setColumns(8);
        this.westFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#,##0.0000"))));
        this.westFormattedTextField.setHorizontalAlignment(0);
        this.westFormattedTextField.setText("122.0000");
        this.westFormattedTextField.setToolTipText("West extent (degrees longitude)");
        this.eastFormattedTextField.setColumns(8);
        this.eastFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#,##0.0000"))));
        this.eastFormattedTextField.setHorizontalAlignment(0);
        this.eastFormattedTextField.setText("124.5678");
        this.eastFormattedTextField.setToolTipText("East extent (degrees longitude)");
        this.northFormattedTextField.setColumns(8);
        this.northFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("##0.0000"))));
        this.northFormattedTextField.setHorizontalAlignment(0);
        this.northFormattedTextField.setText("30.0000");
        this.northFormattedTextField.setToolTipText("North extent (degrees latitude)");
        this.southFormattedTextField.setColumns(8);
        this.southFormattedTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#,##0.0000"))));
        this.southFormattedTextField.setHorizontalAlignment(0);
        this.southFormattedTextField.setText("-12.503");
        this.southFormattedTextField.setToolTipText("South extent (degrees latitude)");
        this.resolutionDegTextField.setColumns(6);
        this.resolutionDegTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#,##0.0000"))));
        this.resolutionDegTextField.setHorizontalAlignment(0);
        this.resolutionDegTextField.setText("0.03333");
        this.resolutionDegTextField.setFocusLostBehavior(0);
        this.resolutionDegTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DownloadGridDialog.this.resolutionDegTextFieldActionPerformed(evt);
            }
        });
        this.resolutionDegTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                DownloadGridDialog.this.resolutionDegTextFieldFocusLost(evt);
            }
        });
        this.jLabel1.setText("Grid Resolution:");
        this.fileNameTextField.setText("gridA.most");
        this.jLabel2.setText("File Name:");
        this.jLabel3.setText("(degrees)");
        this.jLabel4.setText("(arcmin)");
        this.jLabel5.setText("(arcsec)");
        this.resolutionMinTextField.setColumns(6);
        this.resolutionMinTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#,##0.0000"))));
        this.resolutionMinTextField.setHorizontalAlignment(0);
        this.resolutionMinTextField.setText("2.0");
        this.resolutionMinTextField.setFocusLostBehavior(0);
        this.resolutionMinTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DownloadGridDialog.this.resolutionMinTextFieldActionPerformed(evt);
            }
        });
        this.resolutionMinTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                DownloadGridDialog.this.resolutionMinTextFieldFocusLost(evt);
            }
        });
        this.resolutionSecTextField.setColumns(6);
        this.resolutionSecTextField.setFormatterFactory(new DefaultFormatterFactory(new NumberFormatter(new DecimalFormat("#,##0.0"))));
        this.resolutionSecTextField.setHorizontalAlignment(0);
        this.resolutionSecTextField.setFocusLostBehavior(0);
        this.resolutionSecTextField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DownloadGridDialog.this.resolutionSecTextFieldActionPerformed(evt);
            }
        });
        this.resolutionSecTextField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent evt) {
                DownloadGridDialog.this.resolutionSecTextFieldFocusLost(evt);
            }
        });
        this.jLabel6.setText("Grid Extents:");
        this.jLabel7.setText("N");
        this.jLabel8.setText("S");
        this.jLabel9.setText("E");
        this.jLabel10.setText("W");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(this.jLabel2).addPreferredGap(0).add(this.fileNameTextField, -1, 492, Short.MAX_VALUE)).add(jPanel1Layout.createSequentialGroup().add(this.jLabel1).addPreferredGap(0).add(this.resolutionDegTextField, -2, 73, -2).addPreferredGap(0).add(this.jLabel3).add(18, 18, 18).add(this.resolutionMinTextField, -2, 77, -2).addPreferredGap(0).add(this.jLabel4).add(18, 18, 18).add(this.resolutionSecTextField, -2, 77, -2).addPreferredGap(0).add(this.jLabel5)))).add(jPanel1Layout.createSequentialGroup().add(39, 39, 39).add(this.jLabel6).add(33, 33, 33).add(this.westFormattedTextField, -2, -1, -2).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(1).add(this.southFormattedTextField, -2, -1, -2).add(this.northFormattedTextField, -2, -1, -2).add(this.jLabel10)).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().add(this.eastFormattedTextField, -2, -1, -2).addPreferredGap(0).add(this.jLabel9)).add(2, jPanel1Layout.createSequentialGroup().add(jPanel1Layout.createParallelGroup(1).add(this.jLabel7).add(this.jLabel8)).add(117, 117, 117))))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(1).add(jPanel1Layout.createSequentialGroup().addContainerGap().add(jPanel1Layout.createParallelGroup(3).add(this.jLabel7).add(this.northFormattedTextField, -2, -1, -2)).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(3).add(this.westFormattedTextField, -2, -1, -2).add(this.jLabel6).add(this.eastFormattedTextField, -2, -1, -2).add(this.jLabel9).add(this.jLabel10)).add(10, 10, 10).add(jPanel1Layout.createParallelGroup(3).add(this.jLabel8).add(this.southFormattedTextField, -2, -1, -2)).add(24, 24, 24).add(jPanel1Layout.createParallelGroup(3).add(this.jLabel1).add(this.resolutionDegTextField, -2, -1, -2).add(this.jLabel3).add(this.resolutionMinTextField, -2, -1, -2).add(this.jLabel4).add(this.resolutionSecTextField, -2, -1, -2).add(this.jLabel5)).addPreferredGap(0).add(jPanel1Layout.createParallelGroup(3).add(this.jLabel2).add(this.fileNameTextField, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.cancelButton.setText("Cancel");
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DownloadGridDialog.this.cancelButtonActionPerformed(evt);
            }
        });
        this.downloadButton.setText("Download");
        this.downloadButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                DownloadGridDialog.this.downloadButtonActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(2, layout.createSequentialGroup().add(this.progressBar, -1, 389, Short.MAX_VALUE).add(18, 18, 18).add(this.cancelButton).addPreferredGap(1).add(this.downloadButton)).add(2, this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(this.jPanel1, -2, -1, -2).add(18, 18, 18).add(layout.createParallelGroup(1).add(this.progressBar, -2, -1, -2).add(layout.createParallelGroup(3).add(this.cancelButton).add(this.downloadButton))).addContainerGap()));
        this.pack();
    }

    private void downloadButtonActionPerformed(ActionEvent evt) {
        int numPoints = this.checkNumberGridpointsRequested();
        if (numPoints <= 160000) {
            this.downloadGrid();
        } else if (numPoints > 160000 && numPoints < 300000) {
            int result = JOptionPane.showConfirmDialog(this, "Size of requested grid is greater than\n160,000 (400x400) points - you requested: " + numPoints + " points.\nConsider decreasing selected region, or decreasing Resolution\nContinue with download?", "Large Grid Requested", 2);
            if (result == 0) {
                this.downloadGrid();
            }
        } else {
            JOptionPane.showMessageDialog(this, "Size of requested grid is greater than\n160,000 (400x400) points - you requested: " + numPoints + " points.\nSelect a small region, or decrease the Resolution.", "Error: Grid Too Large", 0);
        }
    }

    private void cancelButtonActionPerformed(ActionEvent evt) {
        this.doCancel();
    }

    private void resolutionDegTextFieldActionPerformed(ActionEvent evt) {
        double deg = ((Number)this.resolutionDegTextField.getValue()).doubleValue();
        this.resolutionMinTextField.setValue(deg * 60.0);
        this.resolutionSecTextField.setValue(deg * 3600.0);
    }

    private void resolutionMinTextFieldActionPerformed(ActionEvent evt) {
        double min = ((Number)this.resolutionMinTextField.getValue()).doubleValue();
        this.resolutionDegTextField.setValue(min / 60.0);
        this.resolutionSecTextField.setValue(min * 60.0);
    }

    private void resolutionSecTextFieldActionPerformed(ActionEvent evt) {
        double sec = ((Number)this.resolutionSecTextField.getValue()).doubleValue();
        this.resolutionDegTextField.setValue(sec / 3600.0);
        this.resolutionMinTextField.setValue(sec / 60.0);
    }

    private void formWindowClosed(WindowEvent evt) {
        this.doCancel();
    }

    private void resolutionDegTextFieldFocusLost(FocusEvent evt) {
        try {
            this.resolutionDegTextField.commitEdit();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        double deg = ((Number)this.resolutionDegTextField.getValue()).doubleValue();
        this.resolutionDegTextField.setValue(deg);
        this.resolutionMinTextField.setValue(deg * 60.0);
        this.resolutionSecTextField.setValue(deg * 3600.0);
    }

    private void resolutionMinTextFieldFocusLost(FocusEvent evt) {
        try {
            this.resolutionMinTextField.commitEdit();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        double min = ((Number)this.resolutionMinTextField.getValue()).doubleValue();
        this.resolutionMinTextField.setValue(min);
        this.resolutionDegTextField.setValue(min / 60.0);
        this.resolutionSecTextField.setValue(min * 60.0);
    }

    private void resolutionSecTextFieldFocusLost(FocusEvent evt) {
        try {
            this.resolutionSecTextField.commitEdit();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        double sec = ((Number)this.resolutionSecTextField.getValue()).doubleValue();
        this.resolutionSecTextField.setValue(sec);
        this.resolutionDegTextField.setValue(sec / 3600.0);
        this.resolutionMinTextField.setValue(sec / 60.0);
    }

    public void downloadGrid() {
        StringBuffer urlsb = new StringBuffer(CMIUtil.commitServerAddress + "/bathymetry/create.most?");
        urlsb.append("xmin=" + this.dfxxxx.format(((Number)this.westFormattedTextField.getValue()).doubleValue()));
        urlsb.append("&xmax=" + this.dfxxxx.format(((Number)this.eastFormattedTextField.getValue()).doubleValue()));
        urlsb.append("&ymin=" + this.dfxxxx.format(((Number)this.southFormattedTextField.getValue()).doubleValue()));
        urlsb.append("&ymax=" + this.dfxxxx.format(((Number)this.northFormattedTextField.getValue()).doubleValue()));
        urlsb.append("&cellsize=" + this.dfxxxx.format(((Number)this.resolutionDegTextField.getValue()).doubleValue()));
        this.downloadGridFile = new File(CMIUtil.gridsDirName, this.fileNameTextField.getText());
        Thread downloadThread = new Thread(new downloadWorker(urlsb.toString()));
        this.closeMeWorker = new CloseMeWorker();
        downloadThread.start();
    }

    public File getDownloadedGrid() {
        return this.downloadGridFile;
    }

    public void setFileName(String name) {
        this.fileNameTextField.setText(name);
    }

    public void setSuggestedResArcMin(double res) {
        this.resolutionMinTextField.setValue(res);
        this.resolutionMinTextFieldActionPerformed(new ActionEvent(this, 1, "update"));
    }

    public void setNorthExtent(double northLat) {
        this.northFormattedTextField.setValue(northLat);
    }

    public void setSouthExtent(double southLat) {
        this.southFormattedTextField.setValue(southLat);
    }

    public void setWestExtent(double westLon) {
        this.westFormattedTextField.setValue(westLon);
    }

    public void setEastExtent(double eastLon) {
        this.eastFormattedTextField.setValue(eastLon);
    }

    public int checkNumberGridpointsRequested() {
        int result = 0;
        double north = ((Number)this.northFormattedTextField.getValue()).doubleValue();
        double south = ((Number)this.southFormattedTextField.getValue()).doubleValue();
        double west = ((Number)this.westFormattedTextField.getValue()).doubleValue();
        double east = ((Number)this.eastFormattedTextField.getValue()).doubleValue();
        double res = ((Number)this.resolutionDegTextField.getValue()).doubleValue();
        int ny = (int)(Math.abs(north - south) / res);
        int nx = (int)(Math.abs(east - west) / res);
        result = nx * ny;
        SiftShare.log.info("Downloading Grid, number of points: " + result);
        return result;
    }

    public int getReturnStatus() {
        return this.returnStatus;
    }

    private void doCancel() {
        this.returnStatus = 0;
        this.setVisible(false);
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                DownloadGridDialog dialog = new DownloadGridDialog((Frame)new JFrame(), true);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }

    private class downloadWorker
    implements Runnable {
        String urlString;

        public downloadWorker(String urlString) {
            this.urlString = urlString;
        }

        @Override
        public void run() {
            SiftShare.log.info("downloading grid, URL: " + this.urlString);
            try {
                URL url = new URL(this.urlString);
                HttpURLConnection con = null;
                int responseCode = 202;
                int percent = 0;
                DownloadGridDialog.this.progressBar.setString("Contacting ComMIT Server");
                DownloadGridDialog.this.progressBar.setAnimating(true);
                DownloadGridDialog.this.progressBar.setMinimum(0);
                DownloadGridDialog.this.progressBar.setMaximum(100);
                con = (HttpURLConnection)url.openConnection();
                responseCode = con.getResponseCode();
                while (responseCode == 202) {
                    InputStream is = con.getInputStream();
                    BufferedReader br = new BufferedReader(new InputStreamReader(is));
                    String inputLine = br.readLine();
                    SiftShare.log.info(inputLine);
                    String[] inputArray = inputLine.split("\\s+");
                    try {
                        percent = Integer.parseInt(inputArray[0]);
                        DownloadGridDialog.this.progressBar.setString("Creating grid: " + percent + " % done");
                        DownloadGridDialog.this.progressBar.setValue(percent);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    br.close();
                    if (DownloadGridDialog.this.returnStatus == 0) {
                        return;
                    }
                    try {
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    con = (HttpURLConnection)url.openConnection();
                    responseCode = con.getResponseCode();
                }
                if (responseCode == 200) {
                    int c;
                    int len = con.getContentLength();
                    if (len != -1) {
                        DownloadGridDialog.this.progressBar.setMaximum(len);
                    } else {
                        DownloadGridDialog.this.progressBar.setMaximum(10000);
                    }
                    DownloadGridDialog.this.progressBar.setAnimating(false);
                    DownloadGridDialog.this.progressBar.setMinimum(0);
                    DownloadGridDialog.this.progressBar.setString("Downloading grid...");
                    InputStream is = con.getInputStream();
                    FileOutputStream out = new FileOutputStream(DownloadGridDialog.this.downloadGridFile);
                    int nread = 0;
                    while ((c = is.read()) != -1) {
                        if (c > 0) {
                            DownloadGridDialog.this.progressBar.setValue(nread += c);
                        }
                        if (DownloadGridDialog.this.returnStatus == 0) {
                            is.close();
                            out.close();
                            DownloadGridDialog.this.downloadGridFile.delete();
                            return;
                        }
                        out.write(c);
                    }
                    is.close();
                    out.close();
                }
            }
            catch (MalformedURLException ex) {
                SiftShare.log.log(Level.SEVERE, "bad url downloading grid", ex);
            }
            catch (IOException ioe) {
                SiftShare.log.log(Level.WARNING, "problem downloading grid", ioe);
            }
            SwingUtilities.invokeLater(DownloadGridDialog.this.closeMeWorker);
        }
    }

    private class CloseMeWorker
    implements Runnable {
        private CloseMeWorker() {
        }

        @Override
        public void run() {
            DownloadGridDialog.this.returnStatus = 1;
            DownloadGridDialog.this.setVisible(false);
        }
    }
}

