/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.pmel.sgt.IndexedColorMap;
import java.awt.Color;

public class EnumeratedColorMap
extends IndexedColorMap {
    private double[] mVals;

    public EnumeratedColorMap(int[] red, int[] green, int[] blue) {
        super(red, green, blue);
        this.mVals = new double[red.length + 1];
    }

    public EnumeratedColorMap(float[] red, float[] green, float[] blue) {
        super(red, green, blue);
        this.mVals = new double[red.length + 1];
    }

    public EnumeratedColorMap(Color[] colors) {
        super(colors);
        this.mVals = new double[colors.length + 1];
    }

    public void setEnumeratedValues(double[] vals) {
        this.mVals = vals;
    }

    @Override
    public Color getColor(double val) {
        if (val < this.mVals[0]) {
            return this.getColorByIndex(0);
        }
        for (int i = 0; i < this.mVals.length - 1; ++i) {
            if (!(val >= this.mVals[i]) || !(val < this.mVals[i + 1])) continue;
            return this.getColorByIndex(i);
        }
        return this.getColorByIndex(this.mVals.length - 2);
    }

    public Color getColor(int i) {
        return this.colors_[i];
    }

    public int getNumLevels() {
        return this.mVals.length;
    }

    public double getBaseLevel() {
        return this.mVals[0];
    }

    public double getEndLevel() {
        return this.mVals[this.mVals.length - 1];
    }

    public double getDoubleValue(int i) {
        return this.mVals[i];
    }

    public double[] getValues() {
        return this.mVals;
    }
}

