/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.pmel.sgt.SGLabel;
import gov.noaa.pmel.sgt.dm.AbstractData;
import gov.noaa.pmel.sgt.dm.SGTData;
import gov.noaa.pmel.sgt.dm.SGTLine;
import gov.noaa.pmel.sgt.dm.SGTMetaData;
import gov.noaa.pmel.util.GeoDate;
import gov.noaa.pmel.util.GeoDateArray;
import gov.noaa.pmel.util.SoTRange;
import gov.noaa.tsunami.cmi.SiftShare;
import java.io.File;
import java.util.Arrays;

public class GaugeLine
extends AbstractData
implements SGTLine {
    private final SGTMetaData xMeta_ = new SGTMetaData("Time since event", "hours");
    private final SGTMetaData yMeta_ = new SGTMetaData("Gauge amplitude", "cm");
    private SoTRange.Double xRange_;
    private SoTRange.Double yRange_;
    double[] times;
    double[] heights;
    private final String title_;
    private final String id_;
    private File dataFile;

    public GaugeLine() {
        this("gauge", "Timeseries");
    }

    public GaugeLine(String id, String title) {
        this.title_ = title;
        this.id_ = id;
        this.xTime_ = false;
        this.yTime_ = false;
        this.dynamic_ = false;
        this.setEmptyData();
    }

    public GaugeLine(GaugeLine inLine) {
        this("gauge", "Timeseries");
        if (inLine != null) {
            this.setData(Arrays.copyOf(inLine.getXArray(), inLine.getXArray().length), Arrays.copyOf(inLine.getYArray(), inLine.getYArray().length));
            this.setFile(inLine.getFile());
        }
    }

    public final void setEmptyData() {
        this.xRange_ = new SoTRange.Double(0.0, 1.0);
        this.yRange_ = new SoTRange.Double(-1.0, 1.0);
        this.times = new double[]{0.0};
        this.heights = new double[]{0.0};
        this.fireChange(1);
    }

    public boolean hasData() {
        return this.heights.length > 0;
    }

    public void setData(double[] times, double[] heights) {
        if (times == null || heights == null) {
            this.setEmptyData();
            return;
        }
        this.times = times;
        this.heights = heights;
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < heights.length; ++i) {
            if (heights[i] < min) {
                min = heights[i];
            }
            if (!(heights[i] > max)) continue;
            max = heights[i];
        }
        this.xRange_ = new SoTRange.Double(times[0], times[times.length - 1]);
        this.yRange_ = new SoTRange.Double(min, max);
        SiftShare.log.fine("Tide gauge time range: " + this.getXRange() + ". height range: " + this.getYRange());
        this.fireChange(times.length);
    }

    public double getMax() {
        return this.yRange_.end;
    }

    public double getMin() {
        return this.yRange_.start;
    }

    private void fireChange(int length) {
        String property = this.isDynamic() ? "dynamicDataModified" : "dataModified";
        this.changes_.firePropertyChange(property, new Integer(0), new Integer(length));
    }

    public void setFile(File f) {
        this.dataFile = f;
    }

    public File getFile() {
        return this.dataFile;
    }

    public double getEndTime() {
        return this.times[this.times.length - 1];
    }

    @Override
    public double[] getXArray() {
        return this.times;
    }

    @Override
    public double[] getYArray() {
        return this.heights;
    }

    @Override
    public GeoDate[] getTimeArray() {
        return null;
    }

    @Override
    public GeoDateArray getGeoDateArray() {
        return null;
    }

    @Override
    public double[] getAssociatedData() {
        return null;
    }

    @Override
    public boolean hasAssociatedData() {
        return false;
    }

    @Override
    public String getTitle() {
        return this.title_;
    }

    @Override
    public SGLabel getKeyTitle() {
        return null;
    }

    @Override
    public String getId() {
        return this.id_;
    }

    @Override
    public SGTData copy() {
        return null;
    }

    @Override
    public boolean isXTime() {
        return false;
    }

    @Override
    public boolean isYTime() {
        return false;
    }

    @Override
    public SGTMetaData getXMetaData() {
        return this.xMeta_;
    }

    @Override
    public SGTMetaData getYMetaData() {
        return this.yMeta_;
    }

    @Override
    public SoTRange getXRange() {
        return this.xRange_.copy();
    }

    @Override
    public SoTRange getYRange() {
        return this.yRange_.copy();
    }
}

