/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.pmel.sgt.dm.AbstractData;
import gov.noaa.pmel.sgt.dm.SGTGrid;
import gov.noaa.pmel.sgt.dm.SGTMetaData;
import gov.noaa.pmel.util.GeoDate;
import gov.noaa.pmel.util.GeoDateArray;
import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.SoTRange;
import gov.noaa.pmel.util.SoTValue;
import gov.noaa.tsunami.cmi.SiftShare;
import java.awt.geom.Point2D;
import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.logging.Level;

public abstract class GeoGrid2D
extends AbstractData
implements SGTGrid {
    protected double[] lons = null;
    protected double[] lats = null;
    protected double[] grid = new double[]{Double.NaN};
    protected int nLon = 0;
    protected int nLat = 0;
    protected String fileName = null;
    protected boolean xTime_ = false;
    protected boolean yTime_ = false;
    protected Range2D zRange_ = null;
    protected Range2D lonRes = null;
    protected Range2D latRes = null;
    protected double cutoffRes = 0.01;
    protected SGTMetaData xMetaData_ = new SGTMetaData("Longitude", "degrees");
    protected SGTMetaData yMetaData_ = new SGTMetaData("Latitude", "degrees");
    protected SGTMetaData zMetaData_ = null;
    protected boolean flipLat = false;
    private static DecimalFormat dfxx = new DecimalFormat("0.00");

    public void clearData() {
        Arrays.fill(this.grid, Double.NaN);
    }

    public void flipLat() {
        if (this.lats[1] < this.lats[0]) {
            SiftShare.log.warning("MOST Grid latitude in image format (top-down), flipping");
            this.flipLat = true;
            int left = 0;
            for (int right = this.lats.length - 1; left < right; ++left, --right) {
                double temp = this.lats[left];
                this.lats[left] = this.lats[right];
                this.lats[right] = temp;
            }
        }
        if (this.yRange_ == null) {
            return;
        }
        if (this.yRange_.getStart().getDouble() > this.yRange_.getEnd().getDouble()) {
            this.yRange_.flipStartAndEnd();
        }
    }

    public void forceLons0360() {
        if (this.lons[0] < 0.0) {
            int i = 0;
            while (i < this.lons.length) {
                int n = i++;
                this.lons[n] = this.lons[n] + 360.0;
            }
        }
        this.xRange_ = GeoGrid2D.getRange(this.lons);
    }

    public void forceLonsMinus180to180() {
        if (this.lons[this.nLon - 1] > 180.0) {
            int i = 0;
            while (i < this.lons.length) {
                int n = i++;
                this.lons[n] = this.lons[n] - 360.0;
            }
        }
        this.xRange_ = GeoGrid2D.getRange(this.lons);
    }

    public void normalizeLons() {
        block5: {
            int i;
            int jumps = 0;
            int jumpIndx = 0;
            for (i = 1; i < this.nLon; ++i) {
                if (!(this.lons[i] < this.lons[i - 1])) continue;
                ++jumps;
                jumpIndx = i;
            }
            if (jumps != true) break block5;
            if (this.lons[this.nLon - 1] < 0.0) {
                SiftShare.log.log(Level.INFO, "Detected dateline seam, changing to 0<lon<360, file: " + this.fileName);
                i = jumpIndx;
                while (i < this.nLon) {
                    int n = i++;
                    this.lons[n] = this.lons[n] + 360.0;
                }
            } else {
                SiftShare.log.log(Level.INFO, "Detected Greenwich seam, changing to -180<lon<180, file: " + this.fileName);
                i = 0;
                while (i < jumpIndx) {
                    int n = i++;
                    this.lons[n] = this.lons[n] - 360.0;
                }
            }
        }
    }

    public static SoTRange getRange(double[] coords) {
        double[] deltas = new double[]{0.001, 0.002, 0.005, 0.01, 0.02, 0.05, 0.1, 0.2, 0.5, 1.0, 2.0, 5.0, 10.0, 20.0, 50.0};
        double xdelta = Double.NaN;
        for (double d : deltas) {
            double numticks = Math.abs(coords[coords.length - 1] - coords[0]) / d;
            if (!(4.0 < numticks) || !(numticks <= 9.0)) continue;
            xdelta = d;
            break;
        }
        return new SoTRange.Double(coords[0], coords[coords.length - 1], xdelta);
    }

    public static int getClosestIndex(double[] coords, double val) {
        int idx = 0;
        double didx = Double.MAX_VALUE;
        for (int i = 0; i < coords.length; ++i) {
            double d = Math.abs(coords[i] - val);
            if (!(d < didx)) continue;
            idx = i;
            didx = d;
        }
        return idx;
    }

    public boolean isRegular() {
        return this.isLonRegular() && this.isLatRegular();
    }

    public boolean isLonRegular() {
        this.getLonResolution();
        return this.lonRes.delta < this.cutoffRes * (this.lonRes.end + this.lonRes.start) / 2.0;
    }

    public Range2D getLonResolution() {
        if (this.lonRes == null) {
            this.lonRes = GeoGrid2D.getResolution(this.lons);
        }
        return this.lonRes;
    }

    public boolean isLatRegular() {
        this.getLatResolution();
        return this.latRes.delta < this.cutoffRes * (this.latRes.end + this.latRes.start) / 2.0;
    }

    public Range2D getLatResolution() {
        if (this.latRes == null) {
            this.latRes = GeoGrid2D.getResolution(this.lats);
        }
        return this.latRes;
    }

    public double getMeanResolution() {
        this.getLatResolution();
        this.getLonResolution();
        return (this.latRes.start + this.latRes.end + this.lonRes.start + this.lonRes.end) / 4.0;
    }

    public static Range2D getResolution(double[] coords) {
        if (coords == null) {
            return null;
        }
        double dxmin = Double.MAX_VALUE;
        double dxmax = Double.MIN_VALUE;
        for (int i = 1; i < coords.length; ++i) {
            double dx = Math.abs(coords[i] - coords[i - 1]);
            dxmin = dx < dxmin ? dx : dxmin;
            dxmax = dx > dxmax ? dx : dxmax;
        }
        return new Range2D(dxmin, dxmax, dxmax - dxmin);
    }

    public static String getResLabel(double res) {
        String reslabel = "";
        reslabel = dfxx.format(res) + " deg";
        if (res < 1.0) {
            reslabel = dfxx.format(res *= 60.0) + " arcmin";
        }
        if (res < 1.0) {
            reslabel = dfxx.format(res *= 60.0) + " arcsec";
        }
        return reslabel;
    }

    public Range2D getLatResolutionMeters() {
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int j = 0; j < this.lats.length - 1; ++j) {
            double d = Math.abs(this.lats[j + 1] - this.lats[j]) * 111320.0;
            if (d < min) {
                min = d;
            }
            if (!(d > max)) continue;
            max = d;
        }
        return new Range2D(min, max);
    }

    public Range2D getLonResolutionMeters() {
        double min = Double.POSITIVE_INFINITY;
        double max = Double.NEGATIVE_INFINITY;
        for (int j = 0; j < this.lats.length - 1; ++j) {
            for (int i = 0; i < this.lons.length - 1; ++i) {
                double d = Math.abs(this.lons[i + 1] - this.lons[i]) * Math.cos(Math.PI / 180 * this.lats[j]) * 111320.0;
                if (d < min) {
                    min = d;
                }
                if (!(d > max)) continue;
                max = d;
            }
        }
        return new Range2D(min, max);
    }

    public Point2D.Double[] getGridBox() {
        Point2D.Double[] Pt = new Point2D.Double[]{new Point2D.Double(this.lons[0], this.lats[0]), new Point2D.Double(this.lons[this.lons.length - 1], this.lats[0]), new Point2D.Double(this.lons[this.lons.length - 1], this.lats[this.lats.length - 1]), new Point2D.Double(this.lons[0], this.lats[this.lats.length - 1])};
        return Pt;
    }

    public boolean contains(double x, double y) {
        return this.lons[0] <= x && this.lons[this.lons.length - 1] >= x && this.lats[0] <= y && this.lats[this.lats.length - 1] >= y;
    }

    public boolean contains(GeoGrid2D innerGrid) {
        return this.getMinLat() < innerGrid.getMinLat() && this.getMaxLat() > innerGrid.getMaxLat() && this.getMinLon() < innerGrid.getMinLon() && this.getMaxLon() > innerGrid.getMaxLon();
    }

    public double getMinLat() {
        return Math.min(this.lats[0], this.lats[this.lats.length - 1]);
    }

    public double getMaxLat() {
        return Math.max(this.lats[0], this.lats[this.lats.length - 1]);
    }

    public double getMinLon() {
        return Math.min(this.lons[0], this.lons[this.lons.length - 1]);
    }

    public double getMaxLon() {
        return Math.max(this.lons[0], this.lons[this.lons.length - 1]);
    }

    @Override
    public String getId() {
        this.id_ = this.fileName;
        return this.fileName;
    }

    @Override
    public double[] getXArray() {
        return this.lons;
    }

    @Override
    public int getXSize() {
        return this.nLon;
    }

    @Override
    public double[] getYArray() {
        return this.lats;
    }

    @Override
    public int getYSize() {
        return this.nLat;
    }

    @Override
    public double[] getZArray() {
        return this.grid;
    }

    @Override
    public Range2D getZRange() {
        return this.zRange_;
    }

    @Override
    public GeoDate[] getTimeArray() {
        return null;
    }

    @Override
    public GeoDateArray getGeoDateArray() {
        return null;
    }

    @Override
    public int getTSize() {
        return 0;
    }

    @Override
    public SGTMetaData getZMetaData() {
        return this.zMetaData_;
    }

    @Override
    public SGTGrid getAssociatedData() {
        return null;
    }

    @Override
    public boolean hasAssociatedData() {
        return false;
    }

    @Override
    public boolean hasXEdges() {
        return false;
    }

    @Override
    public double[] getXEdges() {
        return null;
    }

    @Override
    public SoTRange getXEdgesRange() {
        return null;
    }

    @Override
    public boolean hasYEdges() {
        return false;
    }

    @Override
    public double[] getYEdges() {
        return null;
    }

    @Override
    public SoTRange getYEdgesRange() {
        return null;
    }

    @Override
    public GeoDate[] getTimeEdges() {
        return null;
    }

    @Override
    public GeoDateArray getGeoDateArrayEdges() {
        return null;
    }

    @Override
    public double getValueAt(SoTValue x, SoTValue y) {
        return this.getValueAt(x.getDouble(), y.getDouble());
    }

    public double getValueAt(double lon, double lat) {
        if (this.lons == null) {
            return Double.NaN;
        }
        this.getZArray();
        if (this.grid.length != this.nLon * this.nLat) {
            return Double.NaN;
        }
        return this.getValueAtIndex(GeoGrid2D.getClosestIndex(this.lons, lon), GeoGrid2D.getClosestIndex(this.lats, lat));
    }

    private double getValueAtIndex(int i, int j) {
        return this.grid[this.nLat * i + j];
    }
}

