/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.pmel.util.Range2D;
import gov.noaa.pmel.util.SoTRange;
import gov.noaa.tsunami.cmi.BathyGrid;
import gov.noaa.tsunami.cmi.SiftShare;
import gov.noaa.tsunami.cmi.SiteInfo;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.logging.Level;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.jdesktop.layout.GroupLayout;

public class GridInfoFrame
extends JFrame {
    public static final double epsilon = 1.0E-4;
    private SiteInfo siteInfo;
    private DecimalFormat dfxxxx = new DecimalFormat("0.0000");
    private DecimalFormat dfx = new DecimalFormat("0.0");
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JScrollPane jScrollPane3;
    private JTextArea jTextArea1;
    private JTextArea jTextArea2;
    private JTextArea jTextArea3;

    public GridInfoFrame(SiteInfo site) {
        this.siteInfo = site;
        this.initComponents();
        WindowAdapter l = new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                GridInfoFrame.this.closeFrame();
            }
        };
        this.addWindowListener(l);
        this.jLabel1.setText("Grid Info for Model Run: " + site.getName());
        this.jTextArea1.setFont(Font.getFont("Monospaced"));
        this.jTextArea2.setFont(Font.getFont("Monospaced"));
        this.jTextArea3.setFont(Font.getFont("Monospaced"));
        this.jTextArea1.setText(this.getGridInfo(1));
        this.jTextArea2.setText(this.getGridInfo(2));
        this.jTextArea3.setText(this.getGridInfo(3));
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.jLabel3 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jTextArea2 = new JTextArea();
        this.jLabel4 = new JLabel();
        this.jScrollPane3 = new JScrollPane();
        this.jTextArea3 = new JTextArea();
        this.jButton1 = new JButton();
        this.setDefaultCloseOperation(0);
        this.setTitle("Grid Information");
        this.jLabel1.setFont(new Font("Tahoma", 1, 14));
        this.jLabel1.setHorizontalAlignment(0);
        this.jLabel1.setText("Grid Information");
        this.jLabel2.setFont(new Font("Tahoma", 0, 14));
        this.jLabel2.setText("A-Grid:");
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(5);
        this.jScrollPane1.setViewportView(this.jTextArea1);
        this.jLabel3.setFont(new Font("Tahoma", 0, 14));
        this.jLabel3.setText("B-Grid:");
        this.jTextArea2.setColumns(20);
        this.jTextArea2.setRows(5);
        this.jScrollPane2.setViewportView(this.jTextArea2);
        this.jLabel4.setFont(new Font("Tahoma", 0, 14));
        this.jLabel4.setText("C-Grid:");
        this.jTextArea3.setColumns(20);
        this.jTextArea3.setRows(5);
        this.jScrollPane3.setViewportView(this.jTextArea3);
        this.jButton1.setText("Close");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GridInfoFrame.this.jButton1ActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(layout.createParallelGroup(1).add(2, this.jScrollPane3, -1, 755, Short.MAX_VALUE).add(this.jScrollPane2, -1, 755, Short.MAX_VALUE).add(this.jScrollPane1, -1, 755, Short.MAX_VALUE).add(this.jLabel1, -1, 755, Short.MAX_VALUE).add(this.jLabel2).add(this.jLabel3).add(this.jLabel4).add(2, this.jButton1)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(1).add(layout.createSequentialGroup().addContainerGap().add(this.jLabel1).addPreferredGap(0).add(this.jLabel2).addPreferredGap(0).add(this.jScrollPane1, -1, 195, Short.MAX_VALUE).add(18, 18, 18).add(this.jLabel3).addPreferredGap(0).add(this.jScrollPane2, -1, 194, Short.MAX_VALUE).add(18, 18, 18).add(this.jLabel4).addPreferredGap(0).add(this.jScrollPane3, -1, 194, Short.MAX_VALUE).addPreferredGap(1).add(this.jButton1).addContainerGap()));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.closeFrame();
    }

    protected String getGridInfo(int gridid) {
        StringBuffer result = new StringBuffer();
        BathyGrid grid = null;
        try {
            grid = this.siteInfo.getBathyGrid(gridid);
        }
        catch (IOException ex) {
            SiftShare.log.log(Level.WARNING, "Error accessing grid in GridInfoFrame.getGridInfo ", ex);
            return "Error: " + ex.getMessage();
        }
        try {
            result.append("Filename: " + grid.getGridFile().getCanonicalPath() + "\n");
        }
        catch (IOException ex) {
            result.append("Filename: " + grid.getGridFile().toString() + "\n");
        }
        result.append("Dimensions: " + grid.getXSize() + " x-points (lon) by " + grid.getYSize() + " y-points (lat)\n\n");
        SoTRange range = grid.getYRange();
        Range2D deltas = grid.getLatResolutionMeters();
        Range2D deltasd = grid.getLatResolution();
        result.append("Latitude extent: " + this.dfxxxx.format(range.getStart().getDouble()) + " to " + this.dfxxxx.format(range.getEnd().getDouble()) + " degrees\n");
        if (grid.isLatRegular()) {
            result.append("Latitude spacing even, resolution: " + BathyGrid.getResLabel(deltasd.start) + " (" + this.dfx.format(deltas.start) + " meters)\n");
        } else {
            result.append("Latitude spacing uneven, resolution min: " + BathyGrid.getResLabel(deltasd.start) + " (" + this.dfxxxx.format(deltas.start) + " meters), max: " + BathyGrid.getResLabel(deltasd.end) + " (" + this.dfx.format(deltas.end) + " meters)\n");
        }
        range = grid.getXRange();
        deltas = grid.getLonResolutionMeters();
        deltasd = grid.getLonResolution();
        result.append("\nLongitude extent: " + this.dfxxxx.format(range.getStart().getDouble()) + " to " + this.dfxxxx.format(range.getEnd().getDouble()) + " degrees\n");
        if (grid.isLonRegular()) {
            result.append("Longitude spacing even, resolution: " + BathyGrid.getResLabel(deltasd.start) + " (" + this.dfxxxx.format(deltas.start) + " meters)\n");
        } else {
            result.append("Longitude spacing uneven, resolution min: " + BathyGrid.getResLabel(deltasd.start) + " (" + this.dfxxxx.format(deltas.start) + " meters), max: " + BathyGrid.getResLabel(deltasd.end) + " (" + this.dfx.format(deltas.end) + " meters)\n");
        }
        Range2D zrange = grid.getZRange();
        result.append("\nMaximum depth: " + this.dfx.format(zrange.start) + " meters     ");
        result.append("Maximum height: " + this.dfx.format(zrange.end) + " meters\n");
        result.append(String.format("Maximum timestep (CFL condition): %.2f seconds, at grid point i=%d j=%d  depth=%.1f meters", grid.getMaxTimeStep(), grid.getMaxTimeStepX(), grid.getMaxTimeStepY(), grid.getMaxTimeStepDepth()));
        return result.toString();
    }

    public void closeFrame() {
        this.setVisible(false);
        this.dispose();
    }
}

