/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class GridSelectorPanel
extends JPanel {
    private int lastSelection;
    private JRadioButton aGridButton;
    private JRadioButton bGridButton;
    private JRadioButton cGridButton;
    private Box.Filler filler1;
    private JLabel jLabel1;

    public GridSelectorPanel() {
        this.initComponents();
        this.setSelectedGrid(1);
    }

    private void initComponents() {
        ButtonGroup gridButtonGroup = new ButtonGroup();
        this.filler1 = new Box.Filler(new Dimension(4, 1), new Dimension(4, 1), new Dimension(4, 1));
        this.jLabel1 = new JLabel();
        this.aGridButton = new JRadioButton();
        this.bGridButton = new JRadioButton();
        this.cGridButton = new JRadioButton();
        this.setMaximumSize(new Dimension(203, 35));
        this.setMinimumSize(new Dimension(185, 35));
        this.setLayout(new BoxLayout(this, 2));
        this.add(this.filler1);
        this.jLabel1.setFont(this.jLabel1.getFont());
        this.jLabel1.setText("Grid: ");
        this.add(this.jLabel1);
        gridButtonGroup.add(this.aGridButton);
        this.aGridButton.setFont(this.aGridButton.getFont());
        this.aGridButton.setSelected(true);
        this.aGridButton.setText("A");
        this.aGridButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GridSelectorPanel.this.aGridButtonActionPerformed(evt);
            }
        });
        this.add(this.aGridButton);
        gridButtonGroup.add(this.bGridButton);
        this.bGridButton.setFont(this.bGridButton.getFont());
        this.bGridButton.setText("B");
        this.bGridButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GridSelectorPanel.this.bGridButtonActionPerformed(evt);
            }
        });
        this.add(this.bGridButton);
        gridButtonGroup.add(this.cGridButton);
        this.cGridButton.setFont(this.cGridButton.getFont());
        this.cGridButton.setText("C");
        this.cGridButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                GridSelectorPanel.this.cGridButtonActionPerformed(evt);
            }
        });
        this.add(this.cGridButton);
    }

    private void aGridButtonActionPerformed(ActionEvent evt) {
        this.setSelectedGrid(1);
    }

    private void bGridButtonActionPerformed(ActionEvent evt) {
        this.setSelectedGrid(2);
    }

    private void cGridButtonActionPerformed(ActionEvent evt) {
        this.setSelectedGrid(3);
    }

    public void setSelectedGrid(int gridCode) {
        JRadioButton btn;
        int gc = Character.toLowerCase(gridCode);
        switch (gc) {
            case 1: {
                btn = this.aGridButton;
                break;
            }
            case 2: {
                btn = this.bGridButton;
                break;
            }
            case 3: {
                btn = this.cGridButton;
                break;
            }
            default: {
                throw new IllegalArgumentException("expected AGRID, BGRID, or CGRID");
            }
        }
        btn.setSelected(true);
        if (this.lastSelection != gc) {
            int old = this.lastSelection;
            this.lastSelection = gc;
            this.firePropertyChange("selectedGrid", old, this.lastSelection);
        }
    }

    public int getSelectedGrid() {
        if (this.aGridButton.isSelected()) {
            return 1;
        }
        if (this.bGridButton.isSelected()) {
            return 2;
        }
        if (this.cGridButton.isSelected()) {
            return 3;
        }
        return 1;
    }

    @Override
    public void setEnabled(boolean enabled) {
        this.aGridButton.setEnabled(enabled);
        this.bGridButton.setEnabled(enabled);
        this.cGridButton.setEnabled(enabled);
        super.setEnabled(enabled);
    }
}

