/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.tsunami.cmi.CMIUtil;
import gov.noaa.tsunami.cmi.ModelEvent;
import gov.noaa.tsunami.cmi.ModelListener;
import gov.noaa.tsunami.cmi.ModelRunner;
import gov.noaa.tsunami.cmi.SiftShare;
import gov.noaa.tsunami.cmi.SiteInfo;
import gov.noaa.tsunami.websift.propdb.PropagationDatabase;
import gov.noaa.tsunami.websift.propdb.SourceCombo;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.Queue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileNameExtensionFilter;

public class HazardDialog
extends JDialog
implements ModelListener {
    private ArrayList<SiteInfo> hazSites = new ArrayList();
    private DefaultComboBoxModel<SiteInfo> cbm = new DefaultComboBoxModel();
    private LinkedHashSet<SourceCombo> sourceSet = new LinkedHashSet();
    private static final PropagationDatabase propdb = PropagationDatabase.getInstance();
    private Queue<SiteInfo> runQueue = new LinkedList<SiteInfo>();
    private SiftShare comMIT;
    private boolean running = false;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JButton loadSourcesButton;
    private JComboBox<SiteInfo> modelRunComboBox;
    private JButton runButton;
    private JLabel statusLabel;

    public HazardDialog(Frame parent, boolean modal, SiftShare ss) {
        super(parent, modal);
        this.comMIT = ss;
        ss.getOpenSites().forEach(s -> this.cbm.addElement((SiteInfo)s));
        this.initComponents();
        this.cbm.setSelectedItem(CMIUtil.currentSiteInfo);
        this.setLocationRelativeTo(parent);
        CMIUtil.installEscapeCloseOperation(this);
        this.runButton.setEnabled(false);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.runButton = new JButton();
        this.modelRunComboBox = new JComboBox();
        this.jLabel1 = new JLabel();
        this.loadSourcesButton = new JButton();
        this.statusLabel = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Hazard Assessment");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 916, Short.MAX_VALUE));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGap(0, 595, Short.MAX_VALUE));
        this.runButton.setText("Run");
        this.runButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HazardDialog.this.runButtonActionPerformed(evt);
            }
        });
        this.modelRunComboBox.setModel(this.cbm);
        this.jLabel1.setText("Choose Model: ");
        this.loadSourcesButton.setText("Load Sources");
        this.loadSourcesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                HazardDialog.this.loadSourcesButtonActionPerformed(evt);
            }
        });
        this.statusLabel.setText("Choose a Model and Sources and press \"Run\"");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.statusLabel).addGroup(layout.createSequentialGroup().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.modelRunComboBox, -2, 263, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.loadSourcesButton).addGap(18, 18, 18).addComponent(this.runButton))).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.modelRunComboBox, -2, -1, -2).addComponent(this.runButton).addComponent(this.jLabel1).addComponent(this.loadSourcesButton)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addGap(25, 25, 25).addComponent(this.statusLabel).addContainerGap()));
        this.pack();
    }

    private void loadSourcesButtonActionPerformed(ActionEvent evt) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setCurrentDirectory(new File(System.getProperty("user.home")));
        FileNameExtensionFilter xmlFilter = new FileNameExtensionFilter("xml files (*.xml)", "xml");
        fileChooser.addChoosableFileFilter(xmlFilter);
        fileChooser.setFileFilter(xmlFilter);
        fileChooser.setSelectedFile(new File("assessment.xml"));
        int retrival = fileChooser.showOpenDialog(this);
        if (retrival == 0) {
            this.parseSources(fileChooser.getSelectedFile());
        }
    }

    private void runButtonActionPerformed(ActionEvent evt) {
        if (this.running) {
            this.comMIT.removeModelListener(this);
            ModelRunner mr = this.comMIT.getModelRunner();
            if (mr != null && mr.isRunning()) {
                mr.stop();
            }
            this.runButton.setText("Run");
            this.running = false;
        } else if (this.cbm.getSize() == 0 || this.sourceSet.size() == 0) {
            JOptionPane.showMessageDialog(this, "Please select a Model and Load Sources from TsuCAT xml file before running", "Error running Hazard Assessment", 0);
        } else {
            this.runAssessment();
        }
    }

    private void runAssessment() {
        this.runButton.setText("Cancel");
        this.running = true;
        this.statusLabel.setText("Copying chosen model for each run...");
        SiteInfo baseSiteInfo = (SiteInfo)this.cbm.getSelectedItem();
        this.hazSites.clear();
        Iterator it = this.sourceSet.iterator();
        int count = 1;
        File scratchDir = new File(CMIUtil.workingDirName);
        while (it.hasNext()) {
            SourceCombo sc = (SourceCombo)it.next();
            String newSiteName = String.format("%s_src%02d", baseSiteInfo.getName(), count);
            SiteInfo si = null;
            try {
                si = new SiteInfo(new File(scratchDir, newSiteName));
            }
            catch (IOException ioe) {
                SiftShare.log.info("Found existing site, using for Hazard runs");
            }
            if (si == null) {
                try {
                    si = SiteInfo.copySite(baseSiteInfo, scratchDir, newSiteName);
                }
                catch (IOException ioe) {
                    SiftShare.log.log(Level.WARNING, "Can't create Hazard model runs", ioe);
                }
            }
            if (si == null) continue;
            si.setSourceNamesAndSlips(sc.getSourceNames());
            this.hazSites.add(si);
            this.comMIT.setCurrentSite(si);
            ++count;
        }
        if (count < 1) {
            this.statusLabel.setText("Could not run assessment - check Model and Sources");
            return;
        }
        this.runQueue.clear();
        for (SiteInfo si : this.hazSites) {
            this.runQueue.add(si);
        }
        this.runOne();
    }

    private void runOne() {
        SiteInfo si = this.runQueue.poll();
        this.comMIT.removeModelListener(this);
        if (si == null) {
            this.statusLabel.setText("Assessment complete: no more models to run.");
        } else if (si.getTimestepsAvailable() < si.getNumberOutputTimesteps()) {
            this.statusLabel.setText("Running site: " + si.getName());
            ModelRunner mr = this.comMIT.getModelRunner();
            if (mr != null && mr.isRunning()) {
                mr.stop();
            }
            this.comMIT.setCurrentSite(si);
            this.comMIT.startStopModelProcess();
            this.comMIT.addModelListener(this);
        } else {
            this.runOne();
        }
    }

    private void parseSources(File f) {
        Charset charset = Charset.forName("US-ASCII");
        try (BufferedReader reader = Files.newBufferedReader(Paths.get(f.getPath(), new String[0]), charset);){
            String line = null;
            this.sourceSet.clear();
            while ((line = reader.readLine()) != null) {
                int idx = line.indexOf("<inversion>");
                if (idx == -1) continue;
                String inv = line.substring(idx + 11, line.indexOf("</inversion>"));
                SourceCombo sc = propdb.getSourceCombo(inv);
                if (sc != null && sc.getNumberOfSources() > 0) {
                    this.sourceSet.add(sc);
                    continue;
                }
                SiftShare.log.warning("bad inversion in Hazard sources xml file: " + inv);
            }
        }
        catch (IOException e) {
            SiftShare.log.log(Level.WARNING, "error parsing Hazard sources xml file", e);
        }
        if (this.sourceSet.size() > 0) {
            this.statusLabel.setText(this.sourceSet.size() + " sources loaded, press \"Run\" to run...");
            this.runButton.setEnabled(true);
        } else {
            this.statusLabel.setText("Please re-load valid TsuCAT sources XML file");
        }
    }

    @Override
    public void modelStarted(ModelEvent me) {
    }

    @Override
    public void modelStopped(ModelEvent me) {
        this.runOne();
    }

    @Override
    public void modelUpdate(ModelEvent me) {
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(HazardDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(HazardDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(HazardDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(HazardDialog.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                HazardDialog dialog = new HazardDialog((Frame)new JFrame(), true, null);
                dialog.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                });
                dialog.setVisible(true);
            }
        });
    }
}

