/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.tsunami.cmi.SiftShare;
import java.util.Arrays;
import java.util.logging.Logger;

public class LPfilter {
    private static double[] a = new double[]{0.0, 0.0, 0.0};
    private static double[] b = new double[]{0.0, 0.0};
    private static Logger log = Logger.getLogger("gov.noaa.tsunami");

    public LPfilter(Logger l) {
        log = l;
    }

    public static double[] filter(double[] xin, double[] time, double T, boolean pad) {
        double[] xout = new double[]{};
        if (time.length < 5 || xin.length < 5) {
            SiftShare.log.warning("Not enough tide gauge data to LP filter");
            return xout;
        }
        if (time[2] < time[1]) {
            time = LPfilter.swap(time);
            xin = LPfilter.swap(xin);
        }
        double[] t = new double[time.length];
        for (int i = 0; i < t.length; ++i) {
            t[i] = time[i] * 60.0;
        }
        T *= 60.0;
        double[] difft = new double[t.length - 1];
        for (int i = 0; i < difft.length; ++i) {
            difft[i] = t[i + 1] - t[i];
        }
        double dt = LPfilter.mode(difft);
        log.info("filter sample interval: " + dt + " minutes.");
        LPfilter.setWeights(dt, T);
        int tsize = (int)Math.round(Math.abs(t[t.length - 1] - t[0]) / dt);
        double[] tinterp = new double[tsize];
        tinterp[0] = t[0];
        for (int i = 1; i < tinterp.length; ++i) {
            tinterp[i] = tinterp[i - 1] + dt;
        }
        double[] xinterp = LPfilter.interpLinear(t, xin, tinterp);
        xout = LPfilter.dofilt(LPfilter.swap(xinterp));
        xout = LPfilter.dofilt(LPfilter.swap(xinterp));
        xout = LPfilter.interpLinear(tinterp, xout, t);
        double perc = 100.0 * (double)time.length / (double)tinterp.length;
        log.info("percent good data: " + perc);
        return xout;
    }

    public static double[] swap(double[] x) {
        for (int i = 0; i < x.length / 2; ++i) {
            double tmp = x[i];
            x[i] = x[x.length - 1 - i];
            x[x.length - 1 - i] = tmp;
        }
        return x;
    }

    public static double mode(double[] n) {
        Arrays.sort(n);
        int count2 = 0;
        int count1 = 0;
        double pupular1 = 0.0;
        double popular2 = 0.0;
        double epsilon = 1.0E-14;
        for (int i = 0; i < n.length; ++i) {
            pupular1 = n[i];
            count1 = 1;
            for (int j = i + 1; j < n.length; ++j) {
                if (!(Math.abs(pupular1 - n[j]) < epsilon)) continue;
                ++count1;
            }
            if (count1 > count2) {
                popular2 = pupular1;
                count2 = count1;
                continue;
            }
            if (count1 != count2) continue;
            popular2 = Math.min(popular2, pupular1);
        }
        return popular2;
    }

    private static void setWeights(double dt, double T) {
        double w = Math.tan(Math.PI * dt / T);
        double c = 1.0 + 2.0 * Math.cos(0.7853981633974483) * w + w * w;
        LPfilter.a[0] = w * w / c;
        LPfilter.a[1] = 2.0 * a[0];
        LPfilter.a[2] = a[0];
        LPfilter.b[0] = 2.0 * (w * w - 1.0) / c;
        LPfilter.b[1] = (1.0 - 2.0 * Math.cos(0.7853981633974483) * w + w * w) / c;
        SiftShare.log.fine("LPFilter Weights, a: " + a[0] + " " + a[1] + " " + a[2] + ", b: " + b[0] + " " + b[1]);
    }

    public static final double[] interpLinear(double[] x, double[] y, double[] xi) throws IllegalArgumentException {
        if (x.length != y.length) {
            throw new IllegalArgumentException("X and Y must be the same length");
        }
        if (x.length == 1) {
            throw new IllegalArgumentException("X must contain more than one value");
        }
        double[] dx = new double[x.length - 1];
        double[] dy = new double[x.length - 1];
        double[] slope = new double[x.length - 1];
        double[] intercept = new double[x.length - 1];
        for (int i = 0; i < x.length - 1; ++i) {
            dx[i] = x[i + 1] - x[i];
            if (dx[i] == 0.0) {
                throw new IllegalArgumentException("X must be montotonic. A duplicate x-value was found");
            }
            if (dx[i] < 0.0) {
                throw new IllegalArgumentException("X must be sorted");
            }
            dy[i] = y[i + 1] - y[i];
            slope[i] = dy[i] / dx[i];
            intercept[i] = y[i] - x[i] * slope[i];
        }
        double[] yi = new double[xi.length];
        for (int i = 0; i < xi.length; ++i) {
            if (xi[i] > x[x.length - 1] || xi[i] < x[0]) {
                yi[i] = Double.NaN;
                continue;
            }
            int loc = Arrays.binarySearch(x, xi[i]);
            if (loc < -1) {
                loc = -loc - 2;
                yi[i] = slope[loc] * xi[i] + intercept[loc];
                continue;
            }
            yi[i] = y[loc];
        }
        return yi;
    }

    public static double[] dofilt(double[] x) {
        double[] y = new double[x.length];
        for (int k = 2; k < x.length; ++k) {
            y[k] = a[0] * x[k] + a[1] * x[k - 1] + a[2] * x[k - 2] - b[0] * y[k - 1] - b[1] * y[k - 2];
        }
        return y;
    }

    public static void main(String[] args) {
        double[] junk = new double[]{1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0, 9.0};
        junk = LPfilter.swap(junk);
        for (int i = 0; i < junk.length; ++i) {
            System.out.println("junk[" + i + "]= " + junk[i]);
        }
    }
}

