/*
 * Decompiled with CFR 0.152.
 */
package gov.noaa.tsunami.cmi;

import gov.noaa.tsunami.cmi.CMIUtil;
import gov.noaa.tsunami.cmi.ModelEvent;
import gov.noaa.tsunami.cmi.ModelListener;
import gov.noaa.tsunami.cmi.SiftShare;
import gov.noaa.tsunami.cmi.SiteInfo;
import gov.noaa.tsunami.cmi.SwingWorker;
import gov.noaa.tsunami.tools.AltCompression;
import gov.noaa.tsunami.tools.decode.NioSDecode;
import gov.noaa.tsunami.websift.events.SeismicEvent;
import gov.noaa.tsunami.websift.propdb.SourceCombo;
import gov.noaa.tsunami.websift.propdb.UnitSource;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.UnknownHostException;
import java.nio.channels.Channel;
import java.nio.channels.Channels;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import javax.swing.SwingUtilities;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayFloat;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriteable;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.util.CancelTask;

public final class LinCombModule {
    private String errorMessage;
    private final SourceCombo croppedSC = new SourceCombo();
    private boolean firstSource;
    private boolean deformationAvailable;
    private int nLat;
    private int nLon;
    private int nTime;
    private final NetcdfFileWriteable[] ncOutFiles = new NetcdfFileWriteable[3];
    private int istart;
    private int iend;
    private int isize;
    private int jstart;
    private int jend;
    private int jsize;
    private int tstart;
    private int tend;
    private int tsize;
    private String[][] inFileNames;
    private float[] weights;
    private boolean cancelled = false;
    private double[] lons;
    private double[] lats;
    private double[] times;
    private Dimension[] defdimsarray;
    private double[] gridlons;
    private double[] gridlats;
    private final MyCancelTask myCancelTask = new MyCancelTask();
    private int gistart;
    private int giend;
    private int gisize;
    private int gjstart;
    private int gjend;
    private int gjsize;
    private static final String[] varName = new String[]{"HA", "UA", "VA"};
    private static final String[] varNameLower = new String[]{"ha", "ua", "va"};
    private static final String[] lcUnits = new String[]{"centimeters", "centimeters/second", "centimeters/second"};
    private static final String[] lcLongName = new String[]{"Wave Amplitude", "Velocity Component along Longitude", "Velocity Component along Latitude"};
    private static final float missing_value = -1.0E34f;
    private static final String[] lcVarName = new String[]{"ha_lc", "ua_lc", "va_lc"};
    private final SiteInfo site;
    private final SourceCombo sources;
    private final Iterable<ModelListener> listeners;

    public LinCombModule(SiteInfo site, SourceCombo sources, Iterable<ModelListener> listeners) {
        this.site = site;
        this.sources = sources;
        this.listeners = listeners;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void cancel() {
        this.cancelled = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLinCoUpToDate(String snas) {
        boolean retval = false;
        NetcdfFile ncf = null;
        try {
            String linCoFilename = this.site.getFullLincoFilename();
            ncf = NetcdfFile.open(linCoFilename);
            Attribute att = ncf.findGlobalAttribute("inversion");
            if (att != null && att.getStringValue().equals(snas) && new File(linCoFilename.replaceAll("h.nc", "u.nc")).isFile() && new File(linCoFilename.replaceAll("h.nc", "v.nc")).isFile()) {
                retval = true;
            }
        }
        catch (IOException ignore) {
            SiftShare.log.info("linco file not found, not up to date");
        }
        finally {
            if (ncf != null) {
                try {
                    ncf.close();
                }
                catch (IOException iOException) {}
            }
        }
        return retval;
    }

    private String downloadCompressedSourceFiles(UnitSource source, String fileName, Point2D.Double[] cropExtent) throws IOException, LinCombException {
        String msg = "downloading compressed source " + source.getName();
        this.notifyListeners("  " + msg + ":", msg);
        CompressedFileDownloadWorker[] dlworkers = new CompressedFileDownloadWorker[varName.length];
        for (int varNum = 0; varNum < varName.length; ++varNum) {
            File outFile = new File(this.site.getSiteDirectory(), String.format("%s_comp_%s.nc", source.getName(), varNameLower[varNum]));
            if (outFile.isFile()) {
                SiftShare.log.log(Level.INFO, "Compressed source file {0} already exists, not downloading.", outFile);
                continue;
            }
            String urls = fileName.replaceAll("ha\\.nc", varNameLower[varNum] + ".nc") + "?ymin=" + cropExtent[0].y + "&ymax=" + cropExtent[2].y + "&xmin=" + cropExtent[0].x + "&xmax=" + cropExtent[2].x + "&global=" + (CMIUtil.propGlobal ? "true" : "false");
            SiftShare.log.log(Level.FINE, "Downloading from: {0}", urls);
            URL url = new URL(urls);
            dlworkers[varNum] = new CompressedFileDownloadWorker(url, outFile, varName[varNum]);
            dlworkers[varNum].start();
        }
        for (CompressedFileDownloadWorker w : dlworkers) {
            if (w == null) continue;
            w.get();
            if (w.exception != null) {
                throw w.exception;
            }
            if (!w.isCancelled) continue;
            throw new CancelledException();
        }
        this.notifyListeners("\n", null);
        fileName = this.site.getSiteDirectory() + File.separator + source.getName() + "_comp_ha.nc";
        return fileName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadCompressedFile(URL url, File outFile) throws IOException, CancelledException {
        AbstractInterruptibleChannel outch = null;
        Channel inch = null;
        File tmpFile = null;
        SiftShare.log.fine("downloading file url: " + url);
        try {
            long read;
            InputStream fis;
            if (url.getProtocol().toLowerCase().startsWith("http")) {
                HttpURLConnection httpc = (HttpURLConnection)url.openConnection();
                if (httpc.getResponseCode() >= 400) {
                    InputStream errstream = httpc.getErrorStream();
                    if (errstream != null) {
                        BufferedReader br = new BufferedReader(new InputStreamReader(httpc.getErrorStream()));
                        String errstr = br.readLine();
                        throw new IOException(errstr);
                    }
                } else if (httpc.getResponseCode() >= 300) {
                    InputStream errstream;
                    SiftShare.log.warning("Found reference to ComMITServer with http protocol!");
                    String loc = httpc.getHeaderField("Location");
                    url = new URL(loc);
                    httpc.disconnect();
                    httpc = (HttpURLConnection)url.openConnection();
                    if (httpc.getResponseCode() >= 400 && (errstream = httpc.getErrorStream()) != null) {
                        BufferedReader br = new BufferedReader(new InputStreamReader(httpc.getErrorStream()));
                        String errstr = br.readLine();
                        throw new IOException(errstr);
                    }
                }
                fis = httpc.getInputStream();
            } else {
                fis = url.openStream();
            }
            if (this.cancelled) {
                throw new CancelledException();
            }
            SiftShare.log.log(Level.INFO, "Downloading compressed source {0} to local file {1}", new Object[]{url, outFile});
            tmpFile = File.createTempFile(outFile.getName(), "tmp", this.site.getSiteDirectory());
            outch = new FileOutputStream(tmpFile).getChannel();
            inch = Channels.newChannel(fis);
            long pos = 0L;
            do {
                read = ((FileChannel)outch).transferFrom((ReadableByteChannel)inch, pos, 131072L);
                pos += read;
            } while (read >= 131072L);
        }
        finally {
            if (inch != null) {
                inch.close();
            }
            if (outch != null) {
                outch.close();
            }
        }
        if (tmpFile != null && tmpFile.canRead()) {
            tmpFile.renameTo(outFile);
        }
    }

    private ArrayFloat.D3 decodeCompressedSource(Variable var, NetcdfDataset nc) throws IOException, InvalidRangeException {
        var.getDimension(0).setUnlimited(false);
        Attribute qatt = nc.findGlobalAttribute("Quantization");
        boolean dynamic = qatt.isString();
        Number quant = 0.0;
        if (!dynamic) {
            quant = qatt.getNumericValue();
        }
        ArrayFloat.D3 vfd3 = new ArrayFloat.D3(this.tsize, this.jsize, this.isize);
        for (int t = 0; t < this.tsize; ++t) {
            for (int j = 0; j < this.jsize; ++j) {
                for (int i = 0; i < this.isize; ++i) {
                    vfd3.set(t, j, i, 0.0f);
                }
            }
        }
        int[][] start = (int[][])nc.findVariable("start").read().copyToNDJavaArray();
        int[][] end = (int[][])nc.findVariable("end").read().copyToNDJavaArray();
        int[][] start_time = null;
        int[] origin = new int[1];
        int[] shape = new int[1];
        float[] data = null;
        if (dynamic) {
            SiftShare.log.fine("Decompressing dynamic source.");
        } else {
            SiftShare.log.fine("Decompressing standard source.");
            start_time = (int[][])nc.findVariable("start_time").read().copyToNDJavaArray();
        }
        int stime = 0;
        int endidx = 0;
        try {
            for (int j = 0; j < this.jsize; ++j) {
                for (int i = 0; i < this.isize; ++i) {
                    int t;
                    origin[0] = start[j + this.jstart][i + this.istart];
                    shape[0] = end[j + this.jstart][i + this.istart] - origin[0] + 1;
                    if (origin[0] == -1) {
                        for (int t2 = 0; t2 < this.tsize; ++t2) {
                            vfd3.set(t2, j, i, 0.0f);
                        }
                        continue;
                    }
                    byte[] store = (byte[])var.read(origin, shape).copyTo1DJavaArray();
                    if (store.length > 0) {
                        if (dynamic) {
                            data = AltCompression.decode(store);
                        } else {
                            data = NioSDecode.decode(store, quant.floatValue());
                            stime = start_time[j + this.jstart][i + this.istart];
                        }
                        endidx = stime + data.length;
                        if (endidx > this.tsize) {
                            endidx = this.tsize;
                        }
                        if (origin[0] >= 0) {
                            for (t = stime; t < endidx; ++t) {
                                vfd3.set(t, j, i, data[t - stime]);
                            }
                            continue;
                        }
                        for (t = 0; t < this.tsize; ++t) {
                            vfd3.set(t, j, i, 0.0f);
                        }
                        continue;
                    }
                    for (t = 0; t < this.tsize; ++t) {
                        vfd3.set(t, j, i, 0.0f);
                    }
                }
            }
        }
        catch (Exception ex) {
            SiftShare.log.log(Level.SEVERE, "Exception decoding compressed file ", ex);
            throw new IOException("NetCDF file is not a valid compressed source file");
        }
        return vfd3;
    }

    private NetcdfDataset openNetcdf(String fileName) throws IOException {
        return NetcdfDataset.acquireDataset(fileName, this.myCancelTask);
    }

    private static Variable findNcVariable(NetcdfFile ncfile, String varName) throws IOException {
        Variable rv = ncfile.findVariable(varName);
        if (rv == null && (rv = ncfile.findVariable(varName.toLowerCase())) == null) {
            throw new IOException("Required variable " + varName + " not found in source file");
        }
        return rv;
    }

    private static Dimension findNcDimension(NetcdfFile ncfile, String dimName) throws IOException {
        Dimension rv = ncfile.findDimension(dimName);
        if (rv == null && (rv = ncfile.findDimension(dimName.toLowerCase())) == null) {
            throw new IOException("Required dimension " + dimName + " not found in source file");
        }
        return rv;
    }

    public static VariableDS defVariableInFile(NetcdfDataset ncfile) {
        VariableDS defvar = null;
        defvar = (VariableDS)ncfile.findVariable("deformation");
        if (defvar == null) {
            if (defvar == null) {
                defvar = (VariableDS)ncfile.findVariable("DEFORMATION");
            }
            if (defvar == null) {
                defvar = (VariableDS)ncfile.findVariable("deflc");
            }
            if (defvar == null) {
                defvar = (VariableDS)ncfile.findVariable("DEFLC");
            }
        }
        return defvar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UnitSource cropSource(UnitSource source, Point2D.Double[] cropExtent) throws IOException, LinCombException {
        String msg;
        boolean isCompressedSource;
        String fileName = source.getFileName();
        SiftShare.log.info("source: " + source.getFileName());
        NetcdfDataset nc = null;
        double[] gsourceLons = new double[]{0.0};
        double[] gsourceLats = new double[]{0.0};
        boolean bl = isCompressedSource = fileName.indexOf("compressed") != -1 && fileName.startsWith("http");
        if (isCompressedSource) {
            fileName = this.downloadCompressedSourceFiles(source, fileName, cropExtent);
        }
        if (this.firstSource) {
            int j;
            int i;
            VariableDS defvar;
            this.firstSource = false;
            this.notifyListeners("  reading Lat/Lon/Time arrays...\n", "reading Lat/Lon/Time arrays...");
            nc = this.openNetcdf(fileName);
            Variable lonVar = LinCombModule.findNcVariable(nc, "LON");
            double[] sourceLons = (double[])((ArrayDouble.D1)lonVar.read()).copyTo1DJavaArray();
            Variable latVar = LinCombModule.findNcVariable(nc, "LAT");
            double[] sourceLats = (double[])((ArrayDouble.D1)latVar.read()).copyTo1DJavaArray();
            if (sourceLons[0] < 0.0 && cropExtent[2].x > 180.0) {
                int i2 = 0;
                while (i2 < sourceLons.length) {
                    int n = i2++;
                    sourceLons[n] = sourceLons[n] + 360.0;
                }
            }
            boolean bl2 = this.deformationAvailable = (defvar = LinCombModule.defVariableInFile(nc)) != null;
            if (this.deformationAvailable) {
                ArrayFloat.D1 arr;
                lonVar = LinCombModule.findNcVariable(nc, "grid_lon");
                if (lonVar.getDataType() == DataType.DOUBLE) {
                    gsourceLons = (double[])lonVar.read().copyTo1DJavaArray();
                } else {
                    arr = (ArrayFloat.D1)lonVar.read();
                    gsourceLons = new double[(int)lonVar.getSize()];
                    for (i = 0; i < gsourceLons.length; ++i) {
                        gsourceLons[i] = arr.get(i);
                    }
                }
                latVar = LinCombModule.findNcVariable(nc, "grid_lat");
                if (latVar.getDataType() == DataType.DOUBLE) {
                    gsourceLats = (double[])latVar.read().copyTo1DJavaArray();
                } else {
                    arr = (ArrayFloat.D1)latVar.read();
                    gsourceLats = new double[(int)latVar.getSize()];
                    for (i = 0; i < gsourceLats.length; ++i) {
                        gsourceLats[i] = arr.get(i);
                    }
                }
                if (gsourceLons[0] < 0.0 && cropExtent[2].x > 180.0) {
                    int i3 = 0;
                    while (i3 < gsourceLons.length) {
                        int n = i3++;
                        gsourceLons[n] = gsourceLons[n] + 360.0;
                    }
                }
            }
            SiftShare.log.log(Level.INFO, "Extent indicies: Model: {0} - {1}  Source: [{2}, {3}]-[{4}, {5}]", new Object[]{cropExtent[0].toString(), cropExtent[2].toString(), sourceLons[0], sourceLats[0], sourceLons[sourceLons.length - 1], sourceLats[sourceLats.length - 1]});
            if (sourceLats.length <= 2 || sourceLons.length <= 2 || cropExtent[0].x < sourceLons[1] || cropExtent[0].y < sourceLats[1] || cropExtent[2].x > sourceLons[sourceLons.length - 2] || cropExtent[2].y > sourceLats[sourceLats.length - 2]) {
                throw new LinCombException("The propagation grid for source " + source.getName() + " does not overlap the model grids.");
            }
            if (this.cancelled) {
                throw new CancelledException();
            }
            Variable timeVar = LinCombModule.findNcVariable(nc, "TIME");
            this.times = (double[])timeVar.read().copyTo1DJavaArray();
            msg = "finding Latitude/Longitude indices...";
            this.notifyListeners("  " + msg + "\n", msg);
            this.nLon = sourceLons.length;
            this.nLat = sourceLats.length;
            this.nTime = this.times.length;
            this.tsize = 0;
            this.tend = 0;
            this.tstart = 0;
            this.jsize = 0;
            this.jend = 0;
            this.jstart = 0;
            this.isize = 0;
            this.iend = 0;
            this.istart = 0;
            this.tend = this.nTime;
            this.tsize = this.tend - this.tstart;
            while (sourceLons[this.istart] < cropExtent[0].x) {
                ++this.istart;
            }
            this.iend = this.istart = this.istart >= 2 ? this.istart - 2 : 0;
            while (sourceLons[this.iend] < cropExtent[2].x) {
                ++this.iend;
            }
            int n = this.iend = this.iend < sourceLons.length - 2 ? this.iend + 1 : sourceLons.length - 1;
            while (sourceLats[this.jstart] < cropExtent[0].y) {
                ++this.jstart;
            }
            this.jend = this.jstart = this.jstart > 2 ? this.jstart - 2 : 0;
            while (sourceLats[this.jend] < cropExtent[2].y) {
                ++this.jend;
            }
            this.jend = this.jend < sourceLats.length - 2 ? this.jend + 1 : sourceLats.length - 1;
            this.isize = this.iend - this.istart + 1;
            this.jsize = this.jend - this.jstart + 1;
            SiftShare.log.log(Level.FINE, "axis indices: istart: {0} iend: {1} isize: {2}  nLon: {3}\n   jstart: {4} jend: {5} jsize: {6}  nLat: {7}\n   tstart: {8} tend: {9} tsize: {10}  nTime: {11}\n   latA.get(jstart): {12}  lat.get(jend): {13}\n   sourceLons[istart]: {14} sourceLons[iend]: {15}", new Object[]{this.istart, this.iend, this.isize, this.nLon, this.jstart, this.jend, this.jsize, this.nLat, this.tstart, this.tend, this.tsize, this.nTime, sourceLats[this.jstart], sourceLats[this.jend], sourceLons[this.istart], sourceLons[this.iend]});
            this.lons = new double[this.isize];
            for (i = 0; i < this.isize; ++i) {
                this.lons[i] = sourceLons[this.istart + i];
            }
            this.lats = new double[this.jsize];
            for (j = 0; j < this.jsize; ++j) {
                this.lats[j] = sourceLats[this.jstart + j];
            }
            if (this.cancelled) {
                throw new CancelledException();
            }
            if (this.deformationAvailable) {
                this.gjsize = 0;
                this.gjend = 0;
                this.gjstart = 0;
                this.gisize = 0;
                this.giend = 0;
                this.gistart = 0;
                while (gsourceLons[this.gistart] < cropExtent[0].x) {
                    ++this.gistart;
                }
                this.giend = this.gistart = this.gistart >= 2 ? this.gistart - 2 : 0;
                while (gsourceLons[this.giend] < cropExtent[2].x) {
                    ++this.giend;
                }
                int n2 = this.giend = this.giend < gsourceLons.length - 2 ? this.giend + 1 : gsourceLons.length - 1;
                while (gsourceLats[this.gjstart] < cropExtent[0].y) {
                    ++this.gjstart;
                }
                this.gjend = this.gjstart = this.gjstart > 2 ? this.gjstart - 2 : 0;
                while (gsourceLats[this.gjend] < cropExtent[2].y) {
                    ++this.gjend;
                }
                this.gjend = this.gjend < gsourceLats.length - 2 ? this.gjend + 1 : gsourceLats.length - 1;
                this.gisize = this.giend - this.gistart + 1;
                this.gjsize = this.gjend - this.gjstart + 1;
                this.gridlons = new double[this.gisize];
                for (i = 0; i < this.gisize; ++i) {
                    this.gridlons[i] = gsourceLons[this.gistart + i];
                }
                this.gridlats = new double[this.gjsize];
                for (j = 0; j < this.gjsize; ++j) {
                    this.gridlats[j] = gsourceLats[this.gjstart + j];
                }
            }
        } else {
            nc = this.openNetcdf(fileName);
            if (LinCombModule.findNcDimension(nc, "LON").getLength() != this.nLon || LinCombModule.findNcDimension(nc, "LAT").getLength() != this.nLat) {
                throw new LinCombException("The source files are not all on the same propagation grid");
            }
            Dimension dim = LinCombModule.findNcDimension(nc, "TIME");
            if (dim.getLength() != this.nTime) {
                throw new LinCombException("The source files are not all on the same propagation grid (time axis mismatch)");
            }
            VariableDS defvar = LinCombModule.defVariableInFile(nc);
            boolean bl3 = this.deformationAvailable = defvar != null;
        }
        if (this.cancelled) {
            throw new CancelledException();
        }
        String verb = isCompressedSource ? "uncompressing" : "downloading";
        msg = String.format("%s source %s", verb, source.getName());
        this.notifyListeners("  " + msg + ":", msg);
        try {
            for (int vi = 0; vi < varName.length; ++vi) {
                this.notifyListeners(" " + varName[vi], null);
                if (nc == null) {
                    nc = this.openNetcdf(fileName.replaceAll("ha.nc", varNameLower[vi] + ".nc"));
                }
                try {
                    this.downloadFile(nc, vi, source.getName());
                }
                finally {
                    if (nc != null) {
                        nc.close();
                    }
                }
                if (this.cancelled) {
                    throw new CancelledException();
                }
                nc = null;
            }
        }
        finally {
            this.notifyListeners("\n", null);
        }
        source.setCroppedFileName(source.getName() + "ha.nc");
        this.updateInfoSZFile(source);
        return source;
    }

    private void updateInfoSZFile(UnitSource s) {
        try {
            FileWriter fw = new FileWriter(new File(this.site.getSiteDirectory(), "info_sz.dat"), true);
            fw.write(s.getName() + ", ");
            fw.write(s.getFileName() + ", ");
            fw.write(CMIUtil.dfxxxx.format(s.getLongitude()) + ", ");
            fw.write(CMIUtil.dfxxxx.format(s.getLatitude()) + ", ");
            fw.write(CMIUtil.dfxxxx.format(s.getSlip()) + ", ");
            fw.write(CMIUtil.dfxx.format(s.getStrike()) + ", ");
            fw.write(CMIUtil.dfxx.format(s.getDip()) + ", ");
            fw.write(CMIUtil.dfxx.format(s.getDepth()) + ", ");
            fw.write(CMIUtil.dfxx.format(s.getLength()) + ", ");
            fw.write(CMIUtil.dfxx.format(s.getWidth()) + ", ");
            fw.write(CMIUtil.dfxx.format(s.getRake()) + ", ");
            fw.write("c\n");
            fw.flush();
            fw.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private void downloadFile(NetcdfDataset nc, int varNum, String sName) throws IOException, CancelledException {
        boolean result = false;
        VariableDS defvar = null;
        ArrayFloat.D3 vfd3 = null;
        try (NetcdfFileWriteable ncout = NetcdfFileWriteable.createNew(this.site.getSiteDirectory() + File.separator + sName + varNameLower[varNum] + ".nc");){
            int[] origin;
            SiftShare.log.fine("\nDownloading/decompressing:\n netcdf: " + nc.getLocation() + "\n varNum: " + varNum + "\n to file: " + ncout.getLocation());
            Dimension londim = ncout.addDimension("LON", this.isize);
            Dimension latdim = ncout.addDimension("LAT", this.jsize);
            Dimension timedim = ncout.addUnlimitedDimension("TIME");
            Dimension[] dim3 = new Dimension[]{timedim, latdim, londim};
            ncout.addVariable("LON", DataType.DOUBLE, Arrays.asList(londim));
            ncout.addVariableAttribute("LON", "units", "degrees_east");
            ncout.addVariableAttribute("LON", "point_spacing", "even");
            ncout.addVariable("LAT", DataType.DOUBLE, Arrays.asList(latdim));
            ncout.addVariableAttribute("LAT", "units", "degrees_north");
            ncout.addVariableAttribute("LAT", "point_spacing", "uneven");
            if (this.deformationAvailable && varNum == 0 && (defvar = LinCombModule.defVariableInFile(nc)) != null) {
                this.defdimsarray = new Dimension[2];
                Dimension glondim = ncout.addDimension("grid_lon", this.gisize);
                Dimension glatdim = ncout.addDimension("grid_lat", this.gjsize);
                this.defdimsarray[0] = glatdim;
                this.defdimsarray[1] = glondim;
                ncout.addVariable("grid_lon", DataType.DOUBLE, new Dimension[]{glondim});
                ncout.addVariableAttribute("grid_lon", "long_name", "Grid Longitude");
                ncout.addVariableAttribute("grid_lon", "units", "degrees_east");
                ncout.addVariable("grid_lat", DataType.DOUBLE, new Dimension[]{glatdim});
                ncout.addVariableAttribute("grid_lat", "long_name", "Grid Latitude");
                ncout.addVariableAttribute("grid_lat", "units", "degrees_north");
                ncout.addVariable("deformation", DataType.FLOAT, this.defdimsarray);
                ncout.addVariableAttribute("deformation", "long_name", "Grid Deformation");
                ncout.addVariableAttribute("deformation", "units", "meters");
                ncout.addVariableAttribute("deformation", "missing_value", Float.valueOf(-1.0E34f));
            }
            ncout.addVariable("TIME", DataType.DOUBLE, Arrays.asList(timedim));
            ncout.addVariableAttribute("TIME", "units", "seconds");
            ncout.addVariable(varName[varNum], DataType.FLOAT, Arrays.asList(dim3));
            ncout.addVariableAttribute(varName[varNum], "units", lcUnits[varNum]);
            ncout.addVariableAttribute(varName[varNum], "long_name", lcLongName[varNum]);
            ncout.addVariableAttribute(varName[varNum], "missing_value", Float.valueOf(-1.0E34f));
            ncout.addVariableAttribute(varName[varNum], "_FillValue", Float.valueOf(-1.0E34f));
            List<Attribute> gatts = nc.getGlobalAttributes();
            for (Attribute gatt : gatts) {
                ncout.addGlobalAttribute(gatt);
            }
            ncout.addGlobalAttribute("croppedfrom", nc.getLocation());
            ncout.create();
            ncout.write("LON", Array.factory(this.lons));
            ncout.write("LAT", Array.factory(this.lats));
            if (this.deformationAvailable && varNum == 0) {
                ncout.write("grid_lon", Array.factory(this.gridlons));
                ncout.write("grid_lat", Array.factory(this.gridlats));
                origin = new int[]{this.gjstart, this.gistart};
                int[] shape = new int[]{this.gjsize, this.gisize};
                ncout.write("deformation", (ArrayFloat.D2)defvar.read(origin, shape));
            }
            ncout.write("TIME", Array.factory(this.times));
            Variable var = nc.findVariable(varName[varNum]);
            if (var == null) {
                var = nc.findVariable(varNameLower[varNum]);
            }
            if (var.getRank() == 1) {
                vfd3 = this.decodeCompressedSource(var, nc);
                ncout.write(varName[varNum], vfd3);
            } else {
                origin = new int[]{0, this.jstart, this.istart};
                int[] outorigin = new int[]{0, 0, 0};
                int[] shape = new int[]{1, this.jsize, this.isize};
                int i = 0;
                while (i < this.tsize) {
                    origin[0] = i;
                    outorigin[0] = i++;
                    vfd3 = (ArrayFloat.D3)var.read(origin, shape);
                    ncout.write(varName[varNum], outorigin, vfd3);
                    if (!this.cancelled) continue;
                    throw new CancelledException();
                }
            }
            ncout.flush();
            result = true;
        }
    }

    private void weightSources(SourceCombo sc) throws IOException, LinCombException {
        Vector<UnitSource> sources = sc.getSources();
        int numScs = sc.getNumberOfSources();
        this.inFileNames = new String[varName.length][numScs];
        String filename = "test";
        NetcdfDataset[][] ncInFiles = new NetcdfDataset[varName.length][numScs];
        Variable[][] dataVar = new Variable[varName.length][numScs];
        this.weights = new float[numScs];
        for (int icNum = 0; icNum < varName.length; ++icNum) {
            for (int n = 0; n < numScs; ++n) {
                if (this.cancelled) {
                    throw new CancelledException();
                }
                UnitSource aSource = sources.get(n);
                this.weights[n] = (float)aSource.getAlpha();
                filename = aSource.getFileName();
                if (filename.indexOf(File.separator) == -1) {
                    filename = this.site.getSiteDirectory() + File.separator + filename;
                }
                filename = filename.replaceAll("ha\\.nc", varNameLower[icNum] + ".nc");
                SiftShare.log.log(Level.INFO, String.format("filename: %s weight: %2.5f", filename, Float.valueOf(this.weights[n])));
                this.inFileNames[icNum][n] = filename;
                ncInFiles[icNum][n] = NetcdfDataset.acquireDataset(this.inFileNames[icNum][n], null);
                dataVar[icNum][n] = ncInFiles[icNum][n].findVariable(varName[icNum]);
            }
        }
        ArrayFloat.D3 lcArray = new ArrayFloat.D3(this.tsize, this.jsize, this.isize);
        ArrayFloat.D3 holdArray = new ArrayFloat.D3(this.tsize, this.jsize, this.isize);
        ArrayFloat.D2 deflcArray = null;
        ArrayFloat.D2 defholdArray = null;
        if (this.deformationAvailable) {
            deflcArray = new ArrayFloat.D2(this.gridlats.length, this.gridlons.length);
            defholdArray = new ArrayFloat.D2(this.gridlats.length, this.gridlons.length);
            MAMath.setDouble(deflcArray, 0.0);
        }
        for (int icNum = 0; icNum < 3; ++icNum) {
            if (this.cancelled) {
                throw new CancelledException();
            }
            MAMath.setDouble(lcArray, 0.0);
            this.createLinCoFile(icNum, sc);
            for (int n = 0; n < numScs; ++n) {
                float holder;
                int i;
                int j;
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException ex) {
                    throw new CancelledException();
                }
                holdArray = (ArrayFloat.D3)dataVar[icNum][n].read();
                for (int t = 0; t < this.tsize; ++t) {
                    for (j = 0; j < this.jsize; ++j) {
                        for (i = 0; i < this.isize; ++i) {
                            holder = holdArray.get(t, j, i);
                            if (!(holder > -1.0E34f)) continue;
                            holder = lcArray.get(t, j, i) + this.weights[n] * holder;
                            lcArray.set(t, j, i, holder);
                        }
                    }
                }
                if (this.deformationAvailable && icNum == 0) {
                    VariableDS v = LinCombModule.defVariableInFile(ncInFiles[icNum][n]);
                    if (v == null) {
                        SiftShare.log.warning("no deformation variable in file: " + ncInFiles[icNum][n].getLocation());
                        this.deformationAvailable = false;
                        this.defdimsarray = null;
                        break;
                    }
                    defholdArray = (ArrayFloat.D2)v.read();
                    for (j = 0; j < this.gridlats.length; ++j) {
                        for (i = 0; i < this.gridlons.length; ++i) {
                            holder = defholdArray.get(j, i);
                            holder = deflcArray.get(j, i) + this.weights[n] * holder;
                            deflcArray.set(j, i, holder);
                        }
                    }
                }
                ncInFiles[icNum][n].close();
            }
            try {
                if (this.deformationAvailable && icNum == 0) {
                    this.ncOutFiles[icNum].write("deflc", deflcArray);
                }
                this.ncOutFiles[icNum].write(lcVarName[icNum], lcArray);
                this.ncOutFiles[icNum].flush();
            }
            catch (InvalidRangeException ex) {
                throw new IOException(ex.getMessage());
            }
            this.ncOutFiles[icNum].close();
        }
    }

    private void createLinCoFile(int icNum, SourceCombo sc) throws IOException {
        String outFileName = this.site.getFullLincoFilename();
        if (icNum == 1) {
            outFileName = outFileName.replaceAll("h.nc", "u.nc");
        }
        if (icNum == 2) {
            outFileName = outFileName.replaceAll("h.nc", "v.nc");
        }
        SiftShare.log.info("creating linco file: " + outFileName);
        this.notifyListeners("  Initializing output file: " + outFileName + "\n", null);
        this.ncOutFiles[icNum] = NetcdfFileWriteable.createNew(outFileName);
        Dimension lonDim = this.ncOutFiles[icNum].addDimension("lon", this.isize);
        Dimension latDim = this.ncOutFiles[icNum].addDimension("lat", this.jsize);
        Dimension timeDim = this.ncOutFiles[icNum].addUnlimitedDimension("time");
        Dimension[] dim3 = new Dimension[]{timeDim, latDim, lonDim};
        this.ncOutFiles[icNum].addVariable("lon", DataType.DOUBLE, new Dimension[]{lonDim});
        this.ncOutFiles[icNum].addVariableAttribute("lon", "units", "degrees_east");
        this.ncOutFiles[icNum].addVariableAttribute("lon", "point_spacing", "even");
        this.ncOutFiles[icNum].addVariable("lat", DataType.DOUBLE, new Dimension[]{latDim});
        this.ncOutFiles[icNum].addVariableAttribute("lat", "units", "degrees_north");
        this.ncOutFiles[icNum].addVariableAttribute("lat", "point_spacing", "uneven");
        if (this.deformationAvailable && icNum == 0) {
            for (int i = this.defdimsarray.length - 1; i >= 0; --i) {
                this.defdimsarray[i] = this.ncOutFiles[icNum].addDimension(this.defdimsarray[i].getName(), this.defdimsarray[i].getLength());
                this.ncOutFiles[icNum].addVariable(this.defdimsarray[i].getName(), DataType.DOUBLE, new Dimension[]{this.defdimsarray[i]});
            }
            this.ncOutFiles[icNum].addVariable("deflc", DataType.FLOAT, this.defdimsarray);
        }
        this.ncOutFiles[icNum].addVariable("time", DataType.DOUBLE, new Dimension[]{timeDim});
        if (this.site.getSourceScenario() != null) {
            if (this.site.getSourceScenario().getSeismicEvent() != null) {
                SeismicEvent event = this.site.getSourceScenario().getSeismicEvent();
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                this.ncOutFiles[icNum].addVariableAttribute("time", "units", String.format("seconds since %s UTC", sdf.format(event.getDate())));
            }
        } else {
            this.ncOutFiles[icNum].addVariableAttribute("time", "units", "seconds since 1970-01-01 00:00:00 UTC");
        }
        this.ncOutFiles[icNum].addVariable(lcVarName[icNum], DataType.FLOAT, dim3);
        this.ncOutFiles[icNum].addVariableAttribute(lcVarName[icNum], "units", lcUnits[icNum]);
        this.ncOutFiles[icNum].addVariableAttribute(lcVarName[icNum], "long_name", lcLongName[icNum]);
        this.ncOutFiles[icNum].addVariableAttribute(lcVarName[icNum], "missing_value", Float.valueOf(-1.0E34f));
        this.ncOutFiles[icNum].addVariableAttribute(lcVarName[icNum], "_FillValue", Float.valueOf(-1.0E34f));
        SiftShare.log.info("writing global attributes:");
        this.ncOutFiles[icNum].addGlobalAttribute("title", "Linear Combination of files");
        this.ncOutFiles[icNum].addGlobalAttribute("history", "Created from propagation database using ComMIT");
        String hostname = "unknown";
        try {
            InetAddress addr = InetAddress.getLocalHost();
            hostname = addr.toString();
        }
        catch (UnknownHostException addr) {
            // empty catch block
        }
        this.ncOutFiles[icNum].addGlobalAttribute("hostname", hostname);
        String user = System.getProperty("user.name");
        this.ncOutFiles[icNum].addGlobalAttribute("username", user);
        this.ncOutFiles[icNum].addGlobalAttribute("model_run_directory", this.site.getSiteDirectory().getPath());
        Vector<UnitSource> sources = sc.getSources();
        for (int n = 0; n < sc.getNumberOfSources(); ++n) {
            UnitSource aSource = sources.get(n);
            this.ncOutFiles[icNum].addGlobalAttribute(aSource.getName() + "_slip", CMIUtil.dfxxxx.format(this.weights[n]));
        }
        this.ncOutFiles[icNum].addGlobalAttribute("inversion", sc.getSourceNames());
        this.ncOutFiles[icNum].create();
        SiftShare.log.info("linCo created");
        try {
            this.ncOutFiles[icNum].write("lon", Array.factory(this.lons));
            this.ncOutFiles[icNum].write("lat", Array.factory(this.lats));
            this.ncOutFiles[icNum].write("time", Array.factory(this.times));
            if (this.deformationAvailable && icNum == 0) {
                this.ncOutFiles[icNum].write("grid_lon", Array.factory(this.gridlons));
                this.ncOutFiles[icNum].write("grid_lat", Array.factory(this.gridlats));
            }
            File testf = new File(this.ncOutFiles[icNum].getLocation());
            SiftShare.log.info("linCo written out, size: " + testf.length() / 1024L + "k");
        }
        catch (InvalidRangeException ex) {
            throw new IOException(ex.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAxes(SourceCombo sc) throws IOException {
        boolean firstTime = true;
        for (UnitSource aSource : sc.getSources()) {
            String fn = this.site.getSiteDirectory() + File.separator + aSource.getFileName();
            try (NetcdfDataset axnc = this.openNetcdf(fn);){
                if (firstTime) {
                    Dimension glatdim;
                    firstTime = false;
                    this.isize = axnc.findDimension("LON").getLength();
                    this.jsize = axnc.findDimension("LAT").getLength();
                    this.tsize = axnc.findDimension("TIME").getLength();
                    this.lons = (double[])axnc.findVariable("LON").read().copyTo1DJavaArray();
                    this.lats = (double[])axnc.findVariable("LAT").read().copyTo1DJavaArray();
                    this.times = (double[])axnc.findVariable("TIME").read().copyTo1DJavaArray();
                    VariableDS defvar = LinCombModule.defVariableInFile(axnc);
                    boolean bl = this.deformationAvailable = defvar != null;
                    if (!this.deformationAvailable) continue;
                    SiftShare.log.info("found deformation while reading axes in first source in combo.");
                    Variable lonVar = LinCombModule.findNcVariable(axnc, "grid_lon");
                    if (lonVar.getDataType() == DataType.DOUBLE) {
                        this.gridlons = (double[])lonVar.read().copyTo1DJavaArray();
                    } else {
                        ArrayFloat.D1 arr = (ArrayFloat.D1)lonVar.read();
                        this.gridlons = new double[(int)lonVar.getSize()];
                        for (int i = 0; i < this.gridlons.length; ++i) {
                            this.gridlons[i] = arr.get(i);
                        }
                    }
                    Variable latVar = LinCombModule.findNcVariable(axnc, "grid_lat");
                    if (latVar.getDataType() == DataType.DOUBLE) {
                        this.gridlats = (double[])latVar.read().copyTo1DJavaArray();
                    } else {
                        ArrayFloat.D1 arr = (ArrayFloat.D1)latVar.read();
                        this.gridlats = new double[(int)latVar.getSize()];
                        for (int i = 0; i < this.gridlats.length; ++i) {
                            this.gridlats[i] = arr.get(i);
                        }
                    }
                    this.gisize = this.gridlons.length;
                    this.gjsize = this.gridlats.length;
                    this.defdimsarray = new Dimension[2];
                    Dimension glondim = new Dimension("grid_lon", this.gisize);
                    this.defdimsarray[0] = glatdim = new Dimension("grid_lat", this.gjsize);
                    this.defdimsarray[1] = glondim;
                    continue;
                }
                int newtsize = axnc.findDimension("TIME").getLength();
                if (newtsize >= this.tsize) continue;
                this.tsize = newtsize;
                this.times = (double[])axnc.findVariable("TIME").read().copyTo1DJavaArray();
            }
        }
        SiftShare.log.fine("isize: " + this.isize + " jsize: " + this.jsize + " tsize" + this.tsize);
    }

    public void createLinComb() throws LinCombException {
        Point2D.Double[] aExtent;
        this.cancelled = false;
        SiftShare.log.info("in LinCombModule.createLinComb()");
        if (this.sources.getNumberOfSources() < 1) {
            throw new LinCombException("You must select at least one source");
        }
        this.deformationAvailable = false;
        this.defdimsarray = null;
        this.croppedSC.clearSources();
        this.notifyListeners("Creating Initial Condition:\n", "Creating initial condition");
        try {
            aExtent = this.site.getBathyGrid(1).getGridBox();
        }
        catch (IOException ex) {
            SiftShare.log.log(Level.SEVERE, "I/O error reading A grid", ex);
            throw new LinCombException("I/O error reading A grid");
        }
        boolean hasCustom = false;
        boolean hasPropdb = false;
        String usOrigFilename = "";
        for (UnitSource unitSource : this.sources.getSources()) {
            if (unitSource.getName().startsWith("cu")) {
                hasCustom = true;
            }
            if ((usOrigFilename = unitSource.getOriginalFileName()) == null || !usOrigFilename.contains(CMIUtil.commitServerAddress)) continue;
            hasPropdb = true;
        }
        if (hasCustom && hasPropdb) {
            throw new LinCombException("Can't combine Custom Propagation runs with Database runs.");
        }
        this.firstSource = true;
        Vector<UnitSource> slist = this.sources.getSources();
        for (UnitSource aSource : slist) {
            UnitSource cropSrc = null;
            if (this.cancelled) {
                throw new CancelledException();
            }
            if (aSource.isCropped()) {
                cropSrc = aSource;
            }
            if (cropSrc == null) {
                try {
                    cropSrc = this.cropSource(aSource, aExtent);
                }
                catch (IOException ex) {
                    String[] vname = new String[]{"ha", "ua", "va"};
                    for (int i = 0; i < vname.length; ++i) {
                        File outFile = new File(this.site.getSiteDirectory(), String.format("%s_comp_%s.nc", aSource.getName(), vname[i]));
                        CMIUtil.deleteFile(outFile);
                        outFile = new File(this.site.getSiteDirectory(), String.format("%s%s.nc", aSource.getName(), vname[i]));
                        CMIUtil.deleteFile(outFile);
                    }
                    String msg = "I/O error retrieving source " + aSource.getName();
                    SiftShare.log.log(Level.SEVERE, msg, ex);
                    throw new LinCombException(msg + ":\n" + ex.getMessage() + "\nTry re-starting Model Run.");
                }
            }
            this.croppedSC.addSource(cropSrc);
        }
        try {
            if (this.firstSource) {
                this.readAxes(this.croppedSC);
            }
            this.notifyListeners("  applying weights for Initial Condition...\n", "Compiling initial condition...");
            this.weightSources(this.croppedSC);
        }
        catch (IOException iOException) {
            SiftShare.log.log(Level.SEVERE, "I/O error generating linear combination: ", iOException);
            throw new LinCombException("I/O error generating linear combination: " + iOException.getMessage());
        }
        this.site.setSourceNamesAndSlips(this.sources.getSourceNames());
        this.notifyListeners("Initial Condition created\nCreating Initial Condition Maximum Amplitude image\n\n", "Finding initial condition maximum amplitude");
    }

    private void notifyListeners(String logText, String message) {
        final ModelEvent event = new ModelEvent(this.site, 100);
        if (logText != null) {
            event.setLogText(logText);
        }
        if (message != null) {
            event.setMessage(message);
        }
        try {
            if (this.listeners != null) {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        for (ModelListener ml : LinCombModule.this.listeners) {
                            ml.modelUpdate(event);
                        }
                    }
                });
            }
        }
        catch (Exception ex) {
            SiftShare.log.log(Level.SEVERE, null, ex);
        }
    }

    public class CancelledException
    extends LinCombException {
        public CancelledException() {
            super("Cancelled", 202);
        }
    }

    public class LinCombException
    extends Exception {
        final int modelEventStatus;

        protected LinCombException(String message, int modelEventStatus) {
            super(message);
            this.modelEventStatus = modelEventStatus;
        }

        public LinCombException(String message) {
            this(message, 201);
        }

        public int getModelEventStatus() {
            return this.modelEventStatus;
        }
    }

    class MyCancelTask
    implements CancelTask {
        MyCancelTask() {
        }

        @Override
        public boolean isCancel() {
            return LinCombModule.this.cancelled;
        }

        @Override
        public void setError(String msg) {
            LinCombModule.this.errorMessage = LinCombModule.this.errorMessage + msg;
        }

        @Override
        public void setProgress(String msg, int i) {
            LinCombModule.this.errorMessage = LinCombModule.this.errorMessage + msg;
        }
    }

    private class CompressedFileDownloadWorker
    extends SwingWorker {
        private final File outFile;
        private final URL url;
        public IOException exception = null;
        private final String varName;

        public CompressedFileDownloadWorker(URL url, File outFile, String varName) {
            this.url = url;
            this.outFile = outFile;
            this.varName = varName;
        }

        @Override
        public Object construct() {
            try {
                LinCombModule.this.downloadCompressedFile(this.url, this.outFile);
            }
            catch (IOException ex) {
                this.exception = ex;
            }
            catch (CancelledException e) {
                this.cancel();
                return null;
            }
            if (this.varName != null) {
                LinCombModule.this.notifyListeners("  " + this.varName, null);
            }
            return this.outFile;
        }
    }
}

